/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.foundation.file.IDirectoryType;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreDirectoryType;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import java.util.ArrayList;
import java.util.List;

public final class Analyzers
extends SoftwareSystemFilesDirectory {
    public static final String DIR_NAME = "Analyzers";
    public static final String RELATIVE_PATH = "./Analyzers";

    public Analyzers(NamedElement parent) {
        super(parent, RELATIVE_PATH);
    }

    @Override
    public IDirectoryType getDirectoryType() {
        return CoreDirectoryType.ANALYZERS;
    }

    @Override
    public String getDescription() {
        return "Contains analyzer configurations";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnalyzerResult> getCurrentAnalyzerResults() {
        Analyzers analyzers = this;
        synchronized (analyzers) {
            ArrayList<AnalyzerResult> result = new ArrayList<AnalyzerResult>();
            for (Analyzer analyzer : this.getChildren(Analyzer.class)) {
                result.add(analyzer.getResult());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Analyzer getAnalyzer(IAnalyzerId id) {
        assert (id != null) : "Parameter 'id' of method 'getAnalyzer' must not be null";
        Analyzers analyzers = this;
        synchronized (analyzers) {
            for (Analyzer analyzer : this.getChildren(Analyzer.class)) {
                if (analyzer.getId() != id) continue;
                return analyzer;
            }
            assert (false) : "Analyzer not found: " + id;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NamedElement> getChildrenList() {
        ArrayList<NamedElement> result = new ArrayList<NamedElement>();
        Analyzers analyzers = this;
        synchronized (analyzers) {
            result.addAll(super.getChildrenList());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(NamedElement child) {
        Analyzers analyzers = this;
        synchronized (analyzers) {
            super.addChild(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(NamedElement child) {
        Analyzers analyzers = this;
        synchronized (analyzers) {
            super.removeChild(child);
        }
    }
}

