/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import java.util.ArrayList;
import java.util.List;

public final class AnalyzerResult
extends NamedElementContainer {
    public static final String NAME = "Result";
    private final MultipleValueMap<NamedElement, IMetricValue> m_metricCache = new MultipleValueMap();
    private final IAnalyzerId m_id;
    private AnalyzerState m_state = AnalyzerState.HAS_NOT_BEEN_RUN;
    private int m_numberOfRunningJobs = 0;
    private int m_frozen = 0;
    private String m_errorMessage;

    public AnalyzerResult(NamedElement parent, IAnalyzerId id) {
        super(parent);
        assert (id != null) : "Parameter 'id' of method 'AnalyzerResult' must not be null";
        this.m_id = id;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public String getPresentationName(boolean parentIsPresented) {
        return this.m_id.getPresentationName();
    }

    public IAnalyzerId getId() {
        return this.m_id;
    }

    public void freeze() {
        ++this.m_frozen;
    }

    public void unfreeze() {
        --this.m_frozen;
    }

    @Override
    public String getImageResourceName() {
        if (this.getId().getFeature() == SonargraphFeature.PLUGINS) {
            return "Plugin";
        }
        return "Analyzer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NamedElement> getChildrenList() {
        ArrayList<NamedElement> result = new ArrayList<NamedElement>();
        AnalyzerResult analyzerResult = this;
        synchronized (analyzerResult) {
            result.addAll(super.getChildrenList());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(NamedElement child) {
        AnalyzerResult analyzerResult = this;
        synchronized (analyzerResult) {
            super.addChild(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(NamedElement child) {
        AnalyzerResult analyzerResult = this;
        synchronized (analyzerResult) {
            super.removeChild(child);
        }
    }

    public synchronized void incrementNumberOfRunningJobs() {
        ++this.m_numberOfRunningJobs;
    }

    public synchronized void decrementNumberOfRunningJobs() {
        assert (this.m_numberOfRunningJobs > 0) : "'m_numberOfRunningJobs' of method 'decrementNumberOfRunningJobs' must be positive";
        if (--this.m_numberOfRunningJobs == 0) {
            this.notifyAll();
        }
    }

    public synchronized int getNumberOfRunningJobs() {
        return this.m_numberOfRunningJobs;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        assert (errorMessage != null && errorMessage.length() > 0) : "Parameter 'errorMessage' of method 'setErrorMessage' must not be empty";
        this.m_errorMessage = errorMessage;
        this.setState(AnalyzerState.ERROR);
    }

    public AnalyzerState getState() {
        return this.m_state;
    }

    public void setState(AnalyzerState state) {
        assert (state != null) : "Parameter 'state' of method 'setState' must not be null";
        if (this.m_state != state) {
            assert (this.m_frozen == 0) : "AnalyzerResult state changed for frozen result";
            this.m_state = state;
            if (this.m_state == AnalyzerState.HAS_NOT_BEEN_RUN) {
                this.m_errorMessage = null;
            }
        }
    }

    public void finished() {
        this.m_metricCache.clear();
        for (IMetricValue value : this.getChildrenRecursively(IMetricValue.class, new Class[0])) {
            this.m_metricCache.put((Object)value.getAssociatedElement(), (Object)value);
        }
        this.m_metricCache.compact();
    }

    public IMetricValue getMetricValue(NamedElement element, IMetricDescriptor md) {
        assert (element != null) : "Parameter 'element' of method 'getMetricValue' must not be null";
        assert (md != null) : "Parameter 'md' of method 'getMetricValue' must not be null";
        for (IMetricValue val : this.m_metricCache.get((Object)element)) {
            if (val.getMetricDescriptor() != md) continue;
            return val;
        }
        return null;
    }

    public boolean clear() {
        if (!this.m_metricCache.isEmpty() || this.hasChildren()) {
            this.m_metricCache.clear();
            this.forgetChildren(true);
            return true;
        }
        return false;
    }

    public void resetFrozen() {
        this.m_frozen = 0;
    }

    @Override
    public String toString() {
        return this.m_id + " [" + (Object)((Object)this.m_state) + "]";
    }
}

