/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurationCreator;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class AnalyzerIdImplementation {
    private static final IConfigurationCreator NULL_CONFIGURATION_CREATOR = new IConfigurationCreator(){

        @Override
        public AnalyzerConfiguration create(NamedElement parent, IAnalyzerId analyzerId) {
            return null;
        }

        @Override
        public String getImageResourceName() {
            return null;
        }
    };
    private final SonargraphFeature m_feature;
    private final String m_presentationName;
    private final String m_description;
    private final IConfigurationCreator m_configurationCreator;
    private final AnalyzerExecutionLevel m_executionLevel;
    private final AnalyzerGroup m_group;
    private final Set<AnalyzerGroup> m_affectedGroups;

    public AnalyzerIdImplementation(SonargraphFeature feature, String presentationName, String description, IConfigurationCreator configurationCreator, AnalyzerExecutionLevel level, AnalyzerGroup group, List<AnalyzerGroup> affectedGroups) {
        assert (feature != null) : "Parameter 'feature' of method 'AnalyzerIdImplementation' must not be null";
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'AnalyzerIdImplementation' must not be empty";
        assert (description != null && description.length() > 0) : "Parameter 'description' of method 'AnalyzerIdImplementation' must not be empty";
        assert (level != null) : "Parameter 'level' of method 'AnalyzerIdImplementation' must not be null";
        assert (group != null) : "Parameter 'group' of method 'AnalyzerIdImplementation' must not be null";
        assert (affectedGroups != null) : "Parameter 'affectedGroups' of method 'AnalyzerIdImplementation' must not be null";
        this.m_feature = feature;
        this.m_presentationName = presentationName;
        this.m_description = description;
        this.m_configurationCreator = configurationCreator == null ? NULL_CONFIGURATION_CREATOR : configurationCreator;
        this.m_executionLevel = level;
        this.m_group = group;
        this.m_affectedGroups = new LinkedHashSet<AnalyzerGroup>(1 + affectedGroups.size());
        this.m_affectedGroups.add(group);
        for (AnalyzerGroup next : affectedGroups) {
            boolean success = this.m_affectedGroups.add(next);
            assert (success) : "Duplicate group: " + (Object)((Object)next);
        }
    }

    public AnalyzerIdImplementation(SonargraphFeature feature, String presentationName, String description, IConfigurationCreator creator, AnalyzerExecutionLevel level, AnalyzerGroup group) {
        this(feature, presentationName, description, creator, level, group, Collections.emptyList());
    }

    public SonargraphFeature getFeature() {
        return this.m_feature;
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public boolean hasConfiguration() {
        return this.m_configurationCreator != NULL_CONFIGURATION_CREATOR;
    }

    public IConfigurationCreator getConfigurationCreator() {
        return this.m_configurationCreator;
    }

    public AnalyzerExecutionLevel getExecutionLevel() {
        return this.m_executionLevel;
    }

    public AnalyzerGroup getGroup() {
        return this.m_group;
    }

    public Set<AnalyzerGroup> getAffectedGroups() {
        return this.m_affectedGroups;
    }
}

