/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import java.util.HashMap;
import java.util.Map;

public abstract class AnalyzerConfigurationWithWarnings
extends AnalyzerConfiguration {
    private final Map<String, String> m_nameToWarning = new HashMap<String, String>();

    public AnalyzerConfigurationWithWarnings(NamedElement parent, IAnalyzerId analyzerId) {
        super(parent, analyzerId);
    }

    public AnalyzerConfigurationWithWarnings(AnalyzerConfigurationWithWarnings configuration) {
        super(configuration);
        this.m_nameToWarning.putAll(configuration.m_nameToWarning);
    }

    public void resetWarnings() {
        this.m_nameToWarning.clear();
    }

    @Override
    public void reset() {
        this.resetWarnings();
        super.reset();
    }

    public void setWarning(String identifyingPath, String warning) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'setWarning' must not be empty";
        assert (this.getValue(identifyingPath) != null) : "'identifyingPath' not found: " + identifyingPath;
        assert (warning != null && warning.length() > 0) : "Parameter 'warning' of method 'setWarning' must not be empty";
        this.m_nameToWarning.put(identifyingPath, warning);
    }

    public String getWarning(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getWarning' must not be empty";
        return this.m_nameToWarning.get(identifyingPath);
    }
}

