/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationWithWarnings;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractCheckedFilesConfiguration
extends AnalyzerConfigurationWithWarnings {
    public AbstractCheckedFilesConfiguration(NamedElement parent, IAnalyzerId analyzerId) {
        super(parent, analyzerId);
    }

    public AbstractCheckedFilesConfiguration(AbstractCheckedFilesConfiguration configuration) {
        super(configuration);
    }

    public List<String> getIdentifyingPaths() {
        Map<String, Object> valueMap = this.getValueMap();
        ArrayList<String> identifyingPaths = new ArrayList<String>(valueMap.size());
        for (String next : this.getValueMap().keySet()) {
            identifyingPaths.add(next);
        }
        return identifyingPaths;
    }

    public void addIdentifyingPath(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'addIdentifyingPath' must not be empty";
        assert (this.getValue(path) == null) : "Already present: " + path;
        this.addValue(path, "");
    }

    public void removeIdentifyingPath(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'removeIdentifyingPath' must not be empty";
        boolean removed = this.removeValue(path);
        assert (removed) : "Not present: " + path;
    }

    public void setIdentifyingPaths(List<String> paths) {
        assert (paths != null) : "Parameter 'paths' of method 'setIdentifyingPaths' must not be null";
        this.reset();
        for (String nextPath : paths) {
            this.setValue(nextPath, "");
        }
    }

    public boolean isChecked(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'isChecked' must not be empty";
        return this.isDefined(identifyingPath);
    }

    public boolean replaceIfPresent(String oldIdentifyingPath, String newIdentifyingPath) {
        assert (oldIdentifyingPath != null && oldIdentifyingPath.length() > 0) : "Parameter 'oldIdentifyingPath' of method 'replaceIfPresent' must not be empty";
        assert (newIdentifyingPath != null && newIdentifyingPath.length() > 0) : "Parameter 'newIdentifyingPath' of method 'replaceIfPresent' must not be empty";
        if (this.removeValue(oldIdentifyingPath)) {
            this.setValue(newIdentifyingPath, "");
            return true;
        }
        return false;
    }
}

