/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.Attribute;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.AttributeReference;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.IDataEntry;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.SequenceAttribute;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.SizeAttribute;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TreeMapData {
    private final List<IDataEntry[]> m_dataRecords = new ArrayList<IDataEntry[]>();
    private final List<Attribute> m_attributes;
    private final List<AttributeReference> m_attributeReferences;

    public TreeMapData(List<SequenceAttribute> hierarchyAttributes, SizeAttribute sizeAttribute) {
        assert (hierarchyAttributes != null && !hierarchyAttributes.isEmpty()) : "Parameter 'hierarchyAttributes' of method 'TreeMapData' must not be empty";
        assert (sizeAttribute != null) : "Parameter 'sizeAttribute' of method 'TreeMapData' must not be null";
        this.m_attributes = new ArrayList<Attribute>(hierarchyAttributes.size() + 1);
        this.m_attributes.addAll(hierarchyAttributes);
        this.m_attributes.add(sizeAttribute);
        this.m_attributeReferences = new ArrayList<AttributeReference>(hierarchyAttributes.size());
        THashSet names = new THashSet();
        int index = 0;
        for (Attribute next : this.m_attributes) {
            boolean success = names.add(next.getName());
            assert (success) : "Attribute with same name already added: " + next;
            this.m_attributeReferences.add(new AttributeReference(next, index));
            ++index;
        }
    }

    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.m_attributes);
    }

    public void addDataRecord(IDataEntry ... data) {
        assert (data != null && data.length == this.m_attributeReferences.size()) : "Parameter 'data' of method 'addDataRecord' must not be empty and must contain " + this.m_attributeReferences.size() + " values";
        int i2 = 0;
        for (AttributeReference next : this.m_attributeReferences) {
            IDataEntry dataAtIndex = data[i2];
            next.getDefinition().checkDataEntry(dataAtIndex);
            ++i2;
        }
        this.m_dataRecords.add(data);
    }

    public void reset() {
        this.m_dataRecords.clear();
    }

    public boolean hasDataRecords() {
        return !this.m_dataRecords.isEmpty();
    }

    List<IDataEntry[]> getDataRecords() {
        return Collections.unmodifiableList(this.m_dataRecords);
    }

    AttributeReference getAttributeReference(Attribute attribute) {
        assert (attribute != null) : "Parameter 'attribute' of method 'getAttributeReference' must not be null";
        for (AttributeReference next : this.m_attributeReferences) {
            if (!next.getDefinition().equals(attribute)) continue;
            return next;
        }
        return null;
    }

    public String toString() {
        if (!this.hasDataRecords()) {
            return "<empty>";
        }
        StringBuilder builder = new StringBuilder("Data records (");
        builder.append(this.m_dataRecords.size()).append("):");
        int i2 = 1;
        for (IDataEntry[] nextDataRecord : this.m_dataRecords) {
            builder.append("\n<").append(i2).append("> ");
            IDataEntry[] iDataEntryArray = nextDataRecord;
            int n2 = nextDataRecord.length;
            int n3 = 0;
            while (n3 < n2) {
                IDataEntry nextEntry = iDataEntryArray[n3];
                builder.append(nextEntry).append(" ");
                ++n3;
            }
            ++i2;
        }
        return builder.toString();
    }
}

