/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.IDataEntry;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TreeMap<E, D>
extends TreeMapNode<E, D> {
    private final List<TreeMapNode<E, D>> m_children = new ArrayList<TreeMapNode<E, D>>(500);
    private final String m_name;
    private float m_size;

    TreeMap(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'TreeMap' must not be empty";
        this.m_name = name;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public String getKind() {
        return "Treemap";
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    void incrementSize(float inc) {
        assert (inc > 0.0f) : "'inc' must be greater than 0";
        this.m_size += inc;
    }

    @Override
    public float getSize() {
        return this.m_size;
    }

    @Override
    public TreeMapNode<E, D> getParent() {
        return null;
    }

    @Override
    public List<TreeMapNode<E, D>> getParents() {
        return Collections.emptyList();
    }

    @Override
    protected void addChild(TreeMapNode<E, D> node) {
        assert (node != null) : "Parameter 'node' of method 'addChild' must not be null";
        this.m_children.add(node);
    }

    @Override
    public List<TreeMapNode<E, D>> getChildren() {
        return Collections.unmodifiableList(this.m_children);
    }

    @Override
    public boolean hasChildren() {
        return !this.m_children.isEmpty();
    }

    @Override
    void finishModification() {
        ((ArrayList)this.m_children).trimToSize();
    }

    @Override
    boolean matches(IDataEntry[] dataRecord, int index) {
        return true;
    }

    private void processChildren(TreeMapNode<E, D> node, StringBuilder builder, int level) {
        assert (node != null) : "Parameter 'node' of method 'processChildren' must not be null";
        assert (builder != null) : "Parameter 'builder' of method 'processChildren' must not be null";
        assert (level > 0) : "Invalid level: " + level;
        List<TreeMapNode<E, D>> children = node.getChildren();
        if (!children.isEmpty()) {
            for (TreeMapNode<E, D> nextChild : children) {
                builder.append("\n");
                int i2 = 0;
                while (i2 < level - 1) {
                    builder.append("--");
                    ++i2;
                }
                builder.append(i2 + 1).append(" ");
                builder.append(nextChild.toString());
                this.processChildren(nextChild, builder, level + 1);
            }
        }
    }

    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append(this);
        this.processChildren(this, builder, 1);
        return builder.toString();
    }
}

