/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.AttributeReference;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.DataEntry;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.IDataEntry;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.RecursiveDataEntry;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import java.util.ArrayList;
import java.util.List;

public abstract class SubdivisionNode<E, D>
extends TreeMapNode<E, D> {
    private final TreeMapNode<E, D> m_parent;
    private final AttributeReference m_attributeReference;
    private final String m_value;
    private float m_size;

    SubdivisionNode(TreeMapNode<E, D> parent, AttributeReference attribute, String value) {
        assert (parent != null) : "Parameter 'parent' of method 'SubdivisionNode' must not be null";
        assert (attribute != null) : "Parameter 'attribute' of method 'SubdivisionNode' must not be null";
        assert (value != null) : "Parameter 'value' of method 'SubdivisionNode' must not be null";
        this.m_parent = parent;
        this.m_attributeReference = attribute;
        this.m_value = value;
        parent.addChild(this);
    }

    @Override
    public final String getKind() {
        return this.m_attributeReference.getDefinition().getName();
    }

    @Override
    public final String getName() {
        return this.m_value;
    }

    @Override
    public final TreeMapNode<E, D> getParent() {
        return this.m_parent;
    }

    @Override
    public final List<TreeMapNode<E, D>> getParents() {
        ArrayList<TreeMapNode<TreeMapNode<E, D>, D>> parents = new ArrayList<TreeMapNode<TreeMapNode<E, D>, D>>();
        TreeMapNode<E, D> currentParent = this.m_parent;
        while (currentParent != null) {
            parents.add(currentParent);
            currentParent = currentParent.getParent();
        }
        parents.trimToSize();
        return parents;
    }

    public final String getValue() {
        return this.m_value;
    }

    final void incrementSize(float inc) {
        assert (inc > 0.0f) : "'inc' must be greater than 0";
        this.m_size += inc;
    }

    @Override
    public final float getSize() {
        return this.m_size;
    }

    @Override
    final boolean matches(IDataEntry[] dataRecord, int index) {
        assert (dataRecord != null && dataRecord.length > 0) : "Parameter 'dataRecord' of method 'matches' must not be empty";
        int indexInDataRecord = this.m_attributeReference.getIndexInDataRecord();
        assert (indexInDataRecord < dataRecord.length) : "Index out of range";
        IDataEntry dataEntry = dataRecord[indexInDataRecord];
        assert (dataEntry != null) : "'dataEntry' of method 'matches' must not be null";
        if (this.m_attributeReference.getDefinition().isRecursive()) {
            int useIndex;
            assert (dataEntry instanceof RecursiveDataEntry) : "Expected RecursiveDataEntry but was: " + dataEntry;
            String[] dataRecordEntry = ((RecursiveDataEntry)dataEntry).getValues();
            int n2 = useIndex = index == -1 ? dataRecordEntry.length - 1 : index;
            if (dataRecordEntry[useIndex].equals(this.m_value)) {
                return this.getParent().matches(dataRecord, useIndex - 1);
            }
        } else {
            assert (dataEntry instanceof DataEntry) : "Expected DataEntry but was: " + dataEntry;
            if (((DataEntry)dataEntry).getValue().equals(this.m_value)) {
                return this.getParent().matches(dataRecord, -1);
            }
        }
        return false;
    }
}

