/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.treemap;

abstract class AlignmentLine<E, D> {
    static final int SPACING = 2;
    private final int m_x;
    private final int m_y;
    private final int m_length;
    private int m_usedLength;

    AlignmentLine(int x2, int y2, int length) {
        assert (x2 >= 0) : "'x' must not be negative";
        assert (y2 >= 0) : "'y' must not be negative";
        assert (length > 0) : "'length' must not be negative";
        this.m_x = x2;
        this.m_y = y2;
        this.m_length = length;
    }

    final int getRelativeX() {
        return this.m_x;
    }

    final int getRelativeY() {
        return this.m_y;
    }

    protected final int getLength() {
        return this.m_length;
    }

    protected final int getUsedLength() {
        return this.m_usedLength;
    }

    protected final void incrementUsedLength(int inc) {
        this.m_usedLength += inc;
    }

    abstract Direction getDirection();

    public String toString() {
        return "[" + (Object)((Object)this.getDirection()) + "] " + this.m_x + "," + this.m_y + " | length/used: " + this.m_length + "/" + this.m_usedLength;
    }

    static enum Direction {
        VERTICAL,
        HORIZONTAL;

    }
}

