/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.sonargraph.core.foundation.common.graph.Adjacency;
import com.hello2morrow.sonargraph.core.foundation.common.graph.MinimizerPolyLogBarnesHut;
import com.hello2morrow.sonargraph.core.foundation.common.graph.PrecisionLocation;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public final class SpringEmbedderLayoutAlgorithm<V> {
    public Map<V, PrecisionLocation> layout(Adjacency<V> adjacency) {
        assert (adjacency != null) : "Parameter 'adjacency' of method 'layout' must not be null";
        assert (!adjacency.isEmpty()) : "'adjacency' must not be empty";
        THashMap locations = new THashMap(adjacency.size());
        ArrayList<V> nonIsolated = new ArrayList<V>(adjacency.mkAllNodesCopy());
        int nonIsolatedNodeCount = nonIsolated.size();
        if (nonIsolatedNodeCount > 0) {
            double diffY;
            float[][] attraction = new float[nonIsolatedNodeCount][nonIsolatedNodeCount];
            int i2 = 0;
            while (i2 < nonIsolatedNodeCount) {
                Object fromNode = nonIsolated.get(i2);
                Set<V> followerNodes = adjacency.getFollowerNodesRef(fromNode);
                if (followerNodes != null) {
                    for (V toNode : followerNodes) {
                        if (fromNode == toNode) continue;
                        int j2 = nonIsolated.indexOf(toNode);
                        float weight = adjacency.getWeight(fromNode, toNode);
                        float[] fArray = attraction[i2];
                        int n2 = j2;
                        fArray[n2] = fArray[n2] + weight;
                        float[] fArray2 = attraction[j2];
                        int n3 = i2;
                        fArray2[n3] = fArray2[n3] + weight;
                    }
                }
                ++i2;
            }
            float[][] position = new float[nonIsolatedNodeCount][3];
            Random random = new Random(-17L);
            int idx = 0;
            while (idx < nonIsolatedNodeCount) {
                position[idx][0] = random.nextInt(1000);
                position[idx][1] = random.nextInt(1000);
                ++idx;
            }
            MinimizerPolyLogBarnesHut minimizer = new MinimizerPolyLogBarnesHut(nonIsolatedNodeCount, attraction, position, 0.075f, 3.0f);
            minimizer.minimizeEnergy(100);
            float minX = Float.MAX_VALUE;
            float maxX = -minX;
            float minY = minX;
            float maxY = -minX;
            double minDist = minX;
            int i3 = 0;
            while (i3 < nonIsolatedNodeCount) {
                float x2 = position[i3][0];
                float y2 = position[i3][1];
                if (x2 < minX) {
                    minX = x2;
                }
                if (x2 > maxX) {
                    maxX = x2;
                }
                if (y2 < minY) {
                    minY = y2;
                }
                if (y2 > maxY) {
                    maxY = y2;
                }
                int j3 = 0;
                while (j3 < nonIsolatedNodeCount) {
                    float yj;
                    float xj;
                    double dist;
                    if (i3 != j3 && (dist = Math.sqrt((x2 - (xj = position[j3][0])) * (x2 - xj) + (y2 - (yj = position[j3][1])) * (y2 - yj))) != 0.0 && dist < minDist) {
                        minDist = dist;
                    }
                    ++j3;
                }
                ++i3;
            }
            double diffX = maxX - minX;
            if (diffX == 0.0) {
                diffX = 1.0;
            }
            if ((diffY = (double)(maxY - minY)) == 0.0) {
                diffY = 1.0;
            }
            double scaleFactor = Math.min(300.0 / diffX, 300.0 / diffY);
            scaleFactor = Math.max(1000.0 / diffX, scaleFactor);
            scaleFactor = Math.max(700.0 / diffY, scaleFactor);
            if (minDist != 0.0) {
                scaleFactor = Math.max(scaleFactor, 5.0 / minDist);
                scaleFactor = Math.min(scaleFactor, 50.0 / minDist);
            }
            int nonIsolatedIndex = 0;
            float unconnectedSpace = 100.0f;
            for (Object next : nonIsolated) {
                double x3 = 100.0 + scaleFactor * (double)(position[nonIsolatedIndex][0] - minX);
                double y3 = scaleFactor * (double)(position[nonIsolatedIndex][1] - minY);
                locations.put(next, new PrecisionLocation(x3, y3));
                ++nonIsolatedIndex;
            }
        }
        return locations;
    }
}

