/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.core.foundation.common.graph.DependencyCumulator;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IOutgoingDependencyCumulatorAdapter;
import java.util.BitSet;
import java.util.Collection;

public final class OutgoingDependencyCumulator
extends DependencyCumulator {
    public OutgoingDependencyCumulator(Collection<? extends INode<?>> nodes, IWorkerContext workerContext, IOutgoingDependencyCumulatorAdapter adapter) {
        super(nodes, workerContext, adapter);
        assert (adapter != null) : "Parameter 'adapter' of method 'OutgoingDependencyCumulator' must not be null";
        this.m_workerContext.beginBlockOfWork(this.m_numberOfNodes);
        int numberOfIncluded = 0;
        int index = 0;
        int ccd = 0;
        for (INode<?> nextNode : nodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            if (this.m_included.get(index)) {
                ++numberOfIncluded;
                BitSet reachable = this.m_reachable[index];
                if (reachable == null) {
                    reachable = new BitSet(this.m_numberOfNodes);
                    this.computeReachebleNodes(nextNode, index, reachable);
                    reachable.and(this.m_included);
                    this.m_reachable[index] = reachable;
                }
                int dependsUpon = reachable.cardinality();
                ccd += dependsUpon;
                this.m_cumulatedDependencies[index] = dependsUpon;
                adapter.setDependsUpon(nextNode, dependsUpon);
            }
            this.m_workerContext.workItemCompleted();
            ++index;
        }
        index = 0;
        for (INode<?> nextNode : nodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            if (this.m_included.get(index)) {
                int dependsUpon = this.m_cumulatedDependencies[index];
                adapter.setFanOut(nextNode, (float)(100.0 * (double)dependsUpon / (double)numberOfIncluded));
            }
            ++index;
        }
        if (this.m_workerContext.hasBeenCanceled()) {
            return;
        }
        adapter.setCumulativeComponentDependency(ccd);
        if (numberOfIncluded == 0) {
            adapter.setAverageComponentDependency(0.0f);
            adapter.setPropagationCost(0.0f);
        } else {
            float acd = (float)ccd / (float)numberOfIncluded;
            adapter.setAverageComponentDependency(acd);
            float racd = acd / (float)numberOfIncluded * 100.0f;
            adapter.setPropagationCost(racd);
        }
        double nccd = (double)ccd / ((double)(numberOfIncluded + 1) * (Math.log(numberOfIncluded + 1) / Math.log(2.0)) - (double)numberOfIncluded);
        adapter.setNormalizedCumulativeComponentDependency((float)nccd);
        this.m_workerContext.endStep();
    }

    @Override
    protected INode<?> getEndpoint(INode.IEdge edge) {
        return edge.getTo();
    }

    @Override
    protected Collection<? extends INode.IEdge> getEdges(INode<?> node) {
        return node.getOutgoingEdges();
    }
}

