/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Map;

abstract class NodeIndexBasedCalculator {
    private final Map<INode<?>, Integer> m_nodeToIndex = new THashMap();
    protected final IWorkerContext m_workerContext;
    protected final int m_numberOfNodes;

    NodeIndexBasedCalculator(Collection<? extends INode<?>> nodes, IWorkerContext workerContext, int numberOfSteps) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'DependencyCumulator' must not be empty";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'DependencyCumulator' must not be null";
        this.m_workerContext = workerContext;
        if (numberOfSteps > 0) {
            this.m_workerContext.setNumberOfSteps(numberOfSteps);
        }
        this.m_numberOfNodes = nodes.size();
        int index = 0;
        for (INode<?> nextNode : nodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            this.m_nodeToIndex.put(nextNode, index);
            ++index;
        }
    }

    protected final int getIndex(INode<?> node) {
        assert (node != null) : "Parameter 'node' of method 'getIndex' must not be null";
        Integer index = this.m_nodeToIndex.get(node);
        assert (index != null) : "Parameter 'index' of method 'getIndex' must not be null";
        return index;
    }
}

