/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

final class FeedbackArcSetNode
implements INode<INode<?>> {
    private final INode<?> m_node;
    private Map<FeedbackArcSetNode, Edge> m_out;
    private Map<FeedbackArcSetNode, Edge> m_in;
    private Map<FeedbackArcSetNode, Edge> m_originalIn;

    FeedbackArcSetNode(INode<?> node) {
        assert (node != null) : "Parameter 'node' of method 'FeedbackArcSetNode' must not be null";
        this.m_node = node;
    }

    int getTotalWeightOfUnderlyingOutgoingEdges() {
        int weight = 0;
        if (this.m_out != null) {
            for (Edge next : this.m_out.values()) {
                weight += next.getWeightOfUnderlyingEdge();
            }
        }
        return weight;
    }

    int getMinWeightOfUnderlyingOutgoingEdges() {
        int min = Integer.MAX_VALUE;
        if (this.m_out != null) {
            for (Edge next : this.m_out.values()) {
                min = Math.min(min, next.getWeightOfUnderlyingEdge());
            }
        }
        return min;
    }

    int getTotalWeightOfOutgoingEdges() {
        int weight = 0;
        if (this.m_out != null) {
            for (Edge next : this.m_out.values()) {
                weight += next.getWeight();
            }
        }
        return weight;
    }

    int getMinWeightOfOutgoingEdges() {
        int min = Integer.MAX_VALUE;
        if (this.m_out != null) {
            for (Edge next : this.m_out.values()) {
                min = Math.min(min, next.getWeight());
            }
        }
        return min;
    }

    @Override
    public INode<?> getUnderlyingObject() {
        return this.m_node;
    }

    @Override
    public String getName() {
        return this.m_node.getName();
    }

    private void addIncomingEdge(Edge edge) {
        assert (edge != null) : "Parameter 'edge' of method 'addIncomingEdge' must not be null";
        assert (edge.getTo() == this) : "Not an incoming edge : " + edge;
        if (this.m_in == null) {
            this.m_in = new THashMap();
        }
        this.m_in.put(edge.getFrom(), edge);
    }

    void addOutgoingEdge(Edge edge) {
        assert (edge != null) : "Parameter 'edge' of method 'addOutgoingEdge' must not be null";
        assert (edge.getFrom() == this) : "Not an outgoing edge: " + edge;
        if (this.m_out == null) {
            this.m_out = new THashMap();
        }
        this.m_out.put(edge.getTo(), edge);
        edge.getTo().addIncomingEdge(edge);
    }

    Edge addOutgoingEdge(FeedbackArcSetNode to, INode.IEdge underlyingEdge, int weight) {
        assert (to != null) : "Parameter 'to' of method 'addOutgoingEdge' must not be null";
        if (this.m_out == null) {
            this.m_out = new THashMap();
        }
        Edge edge = new Edge(this, to, underlyingEdge, weight);
        this.m_out.put(edge.getTo(), edge);
        edge.getTo().addIncomingEdge(edge);
        return edge;
    }

    private void removeIncomingEdge(Edge edge) {
        assert (edge != null) : "Parameter 'edge' of method 'removeIncomingEdge' must not be null";
        assert (this.m_in != null) : "'m_in' of method 'removeIncomingEdge' must not be null";
        Edge removed = this.m_in.remove(edge.getFrom());
        assert (removed != null) : "'removed' of method 'removeIncomingEdge' must not be null";
    }

    void removeOutgoingEdge(Edge edge) {
        assert (edge != null) : "Parameter 'edge' of method 'removeOutgoingEdge' must not be null";
        assert (this.m_out != null) : "'m_out' of method 'removeOutgoingEdge' must not be null";
        Edge removed = this.m_out.remove(edge.getTo());
        assert (removed != null) : "'removed' of method 'removeOutgoingEdge' must not be null";
        edge.getTo().removeIncomingEdge(edge);
    }

    boolean hasIncomingEdges() {
        return this.m_in != null && !this.m_in.isEmpty();
    }

    @Override
    public Collection<Edge> getIncomingEdges() {
        if (this.m_in != null) {
            return this.m_in.values();
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<Edge> getOutgoingEdges() {
        if (this.m_out != null) {
            return this.m_out.values();
        }
        return Collections.emptySet();
    }

    public Edge getOutgoingDependencyTo(FeedbackArcSetNode to) {
        assert (to != null) : "Parameter 'to' of method 'getOutgoingDependencyTo' must not be null";
        return this.m_out != null ? this.m_out.get(to) : null;
    }

    private void removeIncomingEdgeSimulated(Edge edge) {
        assert (edge != null) : "Parameter 'edge' of method 'removeIncomingEdgeSimulated' must not be null";
        if (this.m_originalIn == null) {
            assert (this.m_in != null) : "'m_in' of method 'removeIncomingEdgeSimulated' must not be null";
            this.m_originalIn = new THashMap(this.m_in);
        }
        this.removeIncomingEdge(edge);
    }

    void removeOutgoingEdgesSimulated() {
        if (this.m_out != null) {
            for (Map.Entry<FeedbackArcSetNode, Edge> nextEntry : this.m_out.entrySet()) {
                nextEntry.getKey().removeIncomingEdgeSimulated(nextEntry.getValue());
            }
        }
    }

    void resetSimulation() {
        if (this.m_originalIn != null) {
            this.m_in = this.m_originalIn;
            this.m_originalIn = null;
        }
    }

    public String toString() {
        return this.m_node.getName();
    }

    static final class Edge
    implements INode.IEdge {
        static final int REMOVE_EDGE_WEIGHT = -1;
        private final FeedbackArcSetNode m_from;
        private final FeedbackArcSetNode m_to;
        private final INode.IEdge m_underlyingEdge;
        private int m_weight;

        Edge(FeedbackArcSetNode from, FeedbackArcSetNode to, INode.IEdge underlyingEdge, int weight) {
            assert (from != null) : "Parameter 'from' of method 'Edge' must not be null";
            assert (to != null) : "Parameter 'to' of method 'Edge' must not be null";
            assert (underlyingEdge != null) : "Parameter 'underlyingEdge' of method 'Edge' must not be null";
            assert (weight == -1 || weight > 0) : "Parameter 'weight' of method 'Edge' must be greater than '0' or equal to: -1";
            this.m_from = from;
            this.m_to = to;
            this.m_underlyingEdge = underlyingEdge;
            this.m_weight = weight;
        }

        public FeedbackArcSetNode getFrom() {
            return this.m_from;
        }

        public FeedbackArcSetNode getTo() {
            return this.m_to;
        }

        INode.IEdge getUnderlyingEdge() {
            return this.m_underlyingEdge;
        }

        @Override
        public int getWeight() {
            return this.m_weight;
        }

        public int getWeightOfUnderlyingEdge() {
            return this.m_underlyingEdge.getWeight();
        }

        public String getNameOfUnderlyingFrom() {
            return this.m_underlyingEdge.getFrom().getName();
        }

        public String getNameOfUnderlyingTo() {
            return this.m_underlyingEdge.getTo().getName();
        }

        void setWeight(int weight) {
            assert (weight >= 0) : "'weight' must not be negative";
            assert (this.m_weight != -1) : "'weight' must not be changed - edge marked for removal";
            this.m_weight = weight;
        }

        public String toString() {
            return String.valueOf(this.m_from.getName()) + " -> " + this.m_to.getName() + " [" + this.m_weight + "/" + this.m_underlyingEdge.getWeight() + "] ";
        }
    }
}

