/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FeedbackArcSetInfo {
    private Map<INode.IEdge, Integer> m_removedEdgeToCyclicity;
    private Map<INode.IEdge, Integer> m_removedEdgeToCyclicNodes;
    private Map<INode.IEdge, Integer> m_removedEdgeToSumOfWeight;
    private Set<INode.IEdge> m_overdefinedEdges;
    private int m_cyclicNodes;
    private int m_cyclicity;
    private int m_outgoingEdgesOfCyclicNodes;
    private int m_weightOfOutgoingEdgesOfCyclicNodes;
    private int m_outgoingEdgesToBeRemoved;
    private int m_weightOfOutgoingEdgesToBeRemoved;

    FeedbackArcSetInfo() {
    }

    public int getNumberOfCyclicNodes() {
        return this.m_cyclicNodes;
    }

    void setCyclicNodes(int cyclicNodes) {
        this.m_cyclicNodes = cyclicNodes;
    }

    void setCyclicity(int cyclicity) {
        this.m_cyclicity = cyclicity;
    }

    public int getCyclicity() {
        return this.m_cyclicity;
    }

    public int getNumberOfEdges() {
        return this.m_outgoingEdgesOfCyclicNodes;
    }

    void setOutgoingEdgesOfCyclicNodes(int outgoingEdgesOfCyclicNodes) {
        this.m_outgoingEdgesOfCyclicNodes = outgoingEdgesOfCyclicNodes;
    }

    public int getWeightOfEdges() {
        return this.m_weightOfOutgoingEdgesOfCyclicNodes;
    }

    void setWeightOfOutgoingEdgesOfCyclicNodes(int weightOfOutgoingEdgesOfCyclicNodes) {
        this.m_weightOfOutgoingEdgesOfCyclicNodes = weightOfOutgoingEdgesOfCyclicNodes;
    }

    public int getNumberOfEdgesToRemove() {
        return this.m_outgoingEdgesToBeRemoved;
    }

    void setOutgoingEdgesToBeRemoved(int outgoingEdgesToBeRemoved) {
        this.m_outgoingEdgesToBeRemoved = outgoingEdgesToBeRemoved;
    }

    public int getWeightOfEdgesToRemove() {
        return this.m_weightOfOutgoingEdgesToBeRemoved;
    }

    void setWeightOfOutgoingEdgesToBeRemoved(int weightOfOutgoingEdgesToBeRemoved) {
        this.m_weightOfOutgoingEdgesToBeRemoved = weightOfOutgoingEdgesToBeRemoved;
    }

    public float getPercentOfEdgesToRemove() {
        if (this.m_outgoingEdgesOfCyclicNodes != 0 && this.m_outgoingEdgesToBeRemoved != 0) {
            assert (this.m_outgoingEdgesOfCyclicNodes >= this.m_outgoingEdgesToBeRemoved) : "Inconsistent info";
            return NumberUtility.getPercentage((int)this.m_outgoingEdgesToBeRemoved, (int)this.m_outgoingEdgesOfCyclicNodes);
        }
        return 0.0f;
    }

    public float getPercentOfWeightToRemove() {
        if (this.m_weightOfOutgoingEdgesOfCyclicNodes != 0 && this.m_weightOfOutgoingEdgesToBeRemoved != 0) {
            assert (this.m_weightOfOutgoingEdgesOfCyclicNodes >= this.m_weightOfOutgoingEdgesToBeRemoved) : "Inconsistent info";
            return NumberUtility.getPercentage((int)this.m_weightOfOutgoingEdgesToBeRemoved, (int)this.m_weightOfOutgoingEdgesOfCyclicNodes);
        }
        return 0.0f;
    }

    void setCyclicityPerEdge(Map<INode.IEdge, Integer> removedEdgeToCyclicity) {
        assert (removedEdgeToCyclicity != null) : "Parameter 'removedEdgeToCyclicity' of method 'setCyclicityPerEdge' must not be null";
        this.m_removedEdgeToCyclicity = removedEdgeToCyclicity;
    }

    public int getCyclicity(INode.IEdge edge) {
        assert (this.m_removedEdgeToCyclicity != null) : "'m_removedEdgeToCyclicity' of method 'getCyclicity' must not be null";
        assert (edge != null) : "Parameter 'edge' of method 'getCyclicity' must not be null";
        Integer cyclicity = this.m_removedEdgeToCyclicity.get(edge);
        assert (cyclicity != null) : "'cyclicity' of method 'getCyclicity' must not be null";
        return cyclicity;
    }

    void setCyclicNodesPerEdge(Map<INode.IEdge, Integer> removedEdgeToCyclicNodes) {
        assert (removedEdgeToCyclicNodes != null) : "Parameter 'removedEdgeToCyclicNodes' of method 'setCyclicNodesPerEdge' must not be null";
        this.m_removedEdgeToCyclicNodes = removedEdgeToCyclicNodes;
    }

    public int getNumberOfCyclicNodes(INode.IEdge edge) {
        assert (this.m_removedEdgeToCyclicNodes != null) : "'m_removedEdgeToCyclicNodes' of method 'getNumberOfCyclicNodes' must not be null";
        assert (edge != null) : "Parameter 'edge' of method 'getNumberOfCyclicNodes' must not be null";
        Integer numberOfCyclicNodes = this.m_removedEdgeToCyclicNodes.get(edge);
        assert (numberOfCyclicNodes != null) : "'numberOfCyclicNodes' of method 'getNumberOfCyclicNodes' must not be null";
        return numberOfCyclicNodes;
    }

    void setSumOfWeightPerEdge(Map<INode.IEdge, Integer> removedEdgeToSumOfWeight) {
        assert (removedEdgeToSumOfWeight != null) : "Parameter 'removedEdgeToSumOfWeight' of method 'setSumOfWeightPerEdge' must not be null";
        this.m_removedEdgeToSumOfWeight = removedEdgeToSumOfWeight;
    }

    public int getSumOfWeight(INode.IEdge edge) {
        assert (edge != null) : "Parameter 'edge' of method 'getSumOfWeight' must not be null";
        Integer sum = this.m_removedEdgeToSumOfWeight.get(edge);
        assert (sum != null) : "'sum' of method 'getSumOfWeight' must not be null";
        return sum;
    }

    public float getPercentOfSumOfWeight(INode.IEdge edge) {
        assert (edge != null) : "Parameter 'edge' of method 'getSumOfWeight' must not be null";
        Integer sum = this.m_removedEdgeToSumOfWeight.get(edge);
        assert (sum != null) : "'sum' of method 'getSumOfWeight' must not be null";
        return NumberUtility.getPercentage((int)sum, (int)this.m_weightOfOutgoingEdgesOfCyclicNodes);
    }

    void setOverdefinedEdges(Set<INode.IEdge> overdefinedEdges) {
        assert (overdefinedEdges != null) : "Parameter 'overdefinedEdges' of method 'setOverdefinedEdges' must not be null";
        this.m_overdefinedEdges = overdefinedEdges;
    }

    public boolean isEdgeOverDefined(INode.IEdge edge) {
        assert (edge != null) : "Parameter 'edge' of method 'isEdgeOverDefined' must not be null";
        assert (this.m_overdefinedEdges != null) : "'m_overdefinedEdges' of method 'isEdgeOverDefined' must not be null";
        return this.m_overdefinedEdges.contains(edge);
    }

    public List<INode.IEdge> getOverdefinedEdges() {
        assert (this.m_overdefinedEdges != null) : "'m_overdefinedEdges' of method 'getOverdefinedEdges' must not be null";
        return Collections.unmodifiableList(new ArrayList<INode.IEdge>(this.m_overdefinedEdges));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.m_cyclicNodes);
        builder.append(" cyclic nodes with ");
        builder.append(this.m_outgoingEdgesOfCyclicNodes);
        builder.append(" outgoing edges and ");
        builder.append(this.m_weightOfOutgoingEdgesOfCyclicNodes);
        builder.append(" total weight and a cyclicity of ");
        builder.append(this.m_cyclicity);
        builder.append(". ");
        builder.append(this.m_outgoingEdgesToBeRemoved);
        if (this.m_outgoingEdgesToBeRemoved > 1) {
            builder.append(" edges need to be removed (");
        } else {
            builder.append(" edge needs to be removed (");
        }
        builder.append(this.getPercentOfEdgesToRemove());
        builder.append("%) with a total weight of ");
        builder.append(this.m_weightOfOutgoingEdgesToBeRemoved);
        builder.append(" (");
        builder.append(this.getPercentOfWeightToRemove());
        builder.append("%).");
        return builder.toString();
    }
}

