/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

final class FeedbackArcSetCycleDetector {
    private final Set<FeedbackArcSetNode> m_nodes;
    private final IWorkerContext m_workerContext;

    FeedbackArcSetCycleDetector(Set<FeedbackArcSetNode> nodes, IWorkerContext workerContext) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'FeedbackArcSetCycleDetector' must not be empty";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'FeedbackArcSetCycleDetector' must not be null";
        this.m_nodes = nodes;
        this.m_workerContext = workerContext;
    }

    boolean hasCycles() {
        ArrayList<FeedbackArcSetNode> nodes = new ArrayList<FeedbackArcSetNode>(this.m_nodes);
        boolean nodesRemoved = false;
        do {
            Iterator iterator = nodes.iterator();
            nodesRemoved = false;
            while (iterator.hasNext()) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return false;
                }
                FeedbackArcSetNode nextNode = (FeedbackArcSetNode)iterator.next();
                if (nextNode.hasIncomingEdges()) continue;
                nextNode.removeOutgoingEdgesSimulated();
                iterator.remove();
                nodesRemoved = true;
            }
        } while (nodesRemoved && !nodes.isEmpty());
        for (FeedbackArcSetNode nextNode : this.m_nodes) {
            nextNode.resetSimulation();
        }
        return !nodes.isEmpty();
    }
}

