/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.core.foundation.common.graph.ICycleAndLevelAnalyzerAdapter;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class CycleAndLevelAnalyzer<T> {
    private final Map<T, Integer> m_nodeToGroupIndex = new THashMap();
    private final Map<Integer, Integer> m_groupToCycleIndex = new THashMap();
    private final ICycleAndLevelAnalyzerAdapter<T> m_adapter;
    private final IWorkerContext m_workerContext;
    private int m_acyclicNodeCount = -1;
    private int m_currentMaxCycleIndex = -1;

    private CycleAndLevelAnalyzer(ICycleAndLevelAnalyzerAdapter<T> adapter, Collection<T> nodes, boolean analyzeLevels, IWorkerContext workerContext) {
        assert (adapter != null) : "Parameter 'adapter' of method 'CycleAndLevelAnalyzer' must not be null";
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'CycleAndLevelAnalyzer' must not be empty";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'CycleAndLevelAnalyzer' must not be null";
        this.m_adapter = adapter;
        this.m_workerContext = workerContext;
        this.analyzeCyclicOrbits(nodes);
        if (analyzeLevels && this.m_acyclicNodeCount > 0) {
            this.calculateLevels(nodes);
        }
    }

    private int getCycleIndex(Integer groupIndex) {
        assert (groupIndex != null) : "Parameter 'groupIndex' of method 'getCycleIndex' must not be null";
        Integer cycleIndex = this.m_groupToCycleIndex.get(groupIndex);
        if (cycleIndex == null) {
            ++this.m_currentMaxCycleIndex;
            cycleIndex = this.m_currentMaxCycleIndex;
            this.m_groupToCycleIndex.put(groupIndex, cycleIndex);
        }
        return cycleIndex;
    }

    private void analyzeCyclicOrbits(Collection<T> nodes) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'analyzeCyclicOrbits' must not be empty";
        int groupIndex = 0;
        for (T nextNode : nodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            if (this.m_nodeToGroupIndex.containsKey(nextNode)) continue;
            Collection<T> in = this.m_adapter.getIncoming(nextNode);
            Collection<T> out = this.m_adapter.getOutgoing(nextNode);
            if (in.isEmpty() || out.isEmpty()) {
                this.m_nodeToGroupIndex.put(nextNode, groupIndex);
            } else {
                THashSet newToOrbitNodes = new THashSet();
                for (T nextOutgoing : out) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (this.m_nodeToGroupIndex.containsKey(nextOutgoing)) continue;
                    newToOrbitNodes.add(nextOutgoing);
                }
                THashSet newFromOrbitNodes = new THashSet();
                for (T nextIncoming : in) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (this.m_nodeToGroupIndex.containsKey(nextIncoming)) continue;
                    newFromOrbitNodes.add(nextIncoming);
                }
                THashSet reducedToOrbit = new THashSet();
                THashSet reducedFromOrbit = new THashSet();
                if (!newToOrbitNodes.isEmpty() && !newFromOrbitNodes.isEmpty()) {
                    this.completeReducedToOrbit(nextNode, (Set<T>)reducedToOrbit, (Set<T>)newToOrbitNodes);
                    this.completeReducedFromOrbit(nextNode, (Set<T>)reducedFromOrbit, (Set<T>)newFromOrbitNodes);
                }
                reducedToOrbit.retainAll((Collection<?>)reducedFromOrbit);
                if (reducedToOrbit.isEmpty() || reducedToOrbit.size() == 1) {
                    assert (!this.m_nodeToGroupIndex.containsKey(nextNode)) : "'groupIndex' must not be set twice: " + nextNode;
                    this.m_nodeToGroupIndex.put(nextNode, groupIndex);
                } else {
                    Iterator reducedToOrbitIter = reducedToOrbit.iterator();
                    while (reducedToOrbitIter.hasNext()) {
                        if (this.m_workerContext.hasBeenCanceled()) {
                            return;
                        }
                        Object cyclicGroupNode = reducedToOrbitIter.next();
                        assert (!this.m_nodeToGroupIndex.containsKey(cyclicGroupNode)) : "'groupIndex' must not be set twice: " + cyclicGroupNode;
                        Integer groupIndexAsInteger = groupIndex;
                        this.m_nodeToGroupIndex.put(cyclicGroupNode, groupIndexAsInteger);
                        this.m_adapter.setIsCyclic(cyclicGroupNode, this.getCycleIndex(groupIndexAsInteger));
                    }
                }
            }
            ++groupIndex;
        }
        this.m_acyclicNodeCount = groupIndex;
    }

    private void completeReducedToOrbit(T node, Set<T> currentOrbitNodes, Set<T> newOrbitNodes) {
        assert (node != null);
        assert (currentOrbitNodes != null) : "Parameter 'currentOrbitNodes' of method 'completeReducedToOrbit' must not be null";
        assert (newOrbitNodes != null) : "Parameter 'newOrbitNodes' of method 'completeReducedToOrbit' must not be null";
        currentOrbitNodes.addAll(newOrbitNodes);
        THashSet newestOrbitNodes = new THashSet();
        for (T newOrbitNode : newOrbitNodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            for (T nextOutgoing : this.m_adapter.getOutgoing(newOrbitNode)) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                if (this.m_nodeToGroupIndex.containsKey(nextOutgoing) || currentOrbitNodes.contains(nextOutgoing)) continue;
                newestOrbitNodes.add(nextOutgoing);
            }
        }
        if (!newestOrbitNodes.isEmpty()) {
            this.completeReducedToOrbit(node, currentOrbitNodes, (Set<T>)newestOrbitNodes);
        }
    }

    private void completeReducedFromOrbit(T node, Set<T> currentOrbitNodes, Set<T> newOrbitNodes) {
        assert (node != null);
        assert (currentOrbitNodes != null) : "Parameter 'currentOrbitNodes' of method 'completeReducedFromOrbit' must not be null";
        assert (newOrbitNodes != null) : "Parameter 'newOrbitNodes' of method 'completeReducedFromOrbit' must not be null";
        THashSet newestOrbitNodes = new THashSet();
        for (T newOrbitNode : newOrbitNodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            for (T nextIncoming : this.m_adapter.getIncoming(newOrbitNode)) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                if (this.m_nodeToGroupIndex.containsKey(nextIncoming) || currentOrbitNodes.contains(nextIncoming)) continue;
                newestOrbitNodes.add(nextIncoming);
            }
        }
        if (!newestOrbitNodes.isEmpty()) {
            currentOrbitNodes.addAll((Collection<T>)newestOrbitNodes);
            this.completeReducedFromOrbit(node, currentOrbitNodes, (Set<T>)newestOrbitNodes);
        }
    }

    private void calculateLevels(Collection<T> nodes) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'calculateLevels' must not be empty";
        AcyclicNode[] stronglyConnectedComponents = new AcyclicNode[this.m_acyclicNodeCount];
        int i2 = 0;
        while (i2 < stronglyConnectedComponents.length) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            stronglyConnectedComponents[i2] = new AcyclicNode(i2);
            ++i2;
        }
        for (T fromNode : nodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            Integer groupIndexFromNodeAsInteger = this.m_nodeToGroupIndex.get(fromNode);
            assert (groupIndexFromNodeAsInteger != null) : "'groupIndexFromNodeAsInteger' of method 'calculateLevels' must not be null for: " + fromNode;
            int groupIndexOfFromNode = groupIndexFromNodeAsInteger;
            AcyclicNode sccOfFromNode = stronglyConnectedComponents[groupIndexOfFromNode];
            for (T nextOutgoing : this.m_adapter.getOutgoing(fromNode)) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                Integer groupIndexToNodeAsInteger = this.m_nodeToGroupIndex.get(nextOutgoing);
                assert (groupIndexToNodeAsInteger != null) : "'groupIndexToNodeAsInteger' of method 'calculateLevels' must not be null for: " + nextOutgoing;
                int cycleGroupIndexOfToNode = groupIndexToNodeAsInteger;
                if (cycleGroupIndexOfToNode == groupIndexOfFromNode) continue;
                sccOfFromNode.addTo(cycleGroupIndexOfToNode);
                stronglyConnectedComponents[cycleGroupIndexOfToNode].addFrom(groupIndexOfFromNode);
            }
        }
        this.calculateCycleGroupLevelsBottomUp(stronglyConnectedComponents);
        for (T next : nodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            Integer groupIndex = this.m_nodeToGroupIndex.get(next);
            assert (groupIndex != null) : "'groupIndex' of method 'calculateLevels' must not be null";
            AcyclicNode scc = stronglyConnectedComponents[groupIndex];
            this.m_adapter.setLevel(next, scc.getLevel());
        }
    }

    private void calculateCycleGroupLevelsBottomUp(AcyclicNode[] acyclicNodes) {
        int level = 1;
        THashSet notYetMapped = new THashSet();
        int i2 = 0;
        while (i2 < acyclicNodes.length) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            notYetMapped.add(i2);
            ++i2;
        }
        THashSet alreadyMapped = new THashSet();
        while (!notYetMapped.isEmpty()) {
            int idx;
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            THashSet nodesOfNextLevel = new THashSet();
            Iterator iterator = notYetMapped.iterator();
            while (iterator.hasNext()) {
                idx = (Integer)iterator.next();
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                AcyclicNode fromNode = acyclicNodes[idx];
                if (!alreadyMapped.containsAll(fromNode.getTo())) continue;
                nodesOfNextLevel.add(idx);
            }
            iterator = nodesOfNextLevel.iterator();
            while (iterator.hasNext()) {
                idx = (Integer)iterator.next();
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                acyclicNodes[idx].setLevel(level);
                alreadyMapped.add(idx);
                notYetMapped.remove(idx);
            }
            ++level;
        }
    }

    public static <T> void process(ICycleAndLevelAnalyzerAdapter<T> adapter, Collection<? extends T> nodes, boolean analyzeLevels, IWorkerContext workerContext) {
        new CycleAndLevelAnalyzer<T>(adapter, nodes, analyzeLevels, workerContext);
    }

    static final class AcyclicNode {
        private final Set<Integer> m_tos = new THashSet();
        private final Set<Integer> m_froms = new THashSet();
        private final int m_index;
        private int m_level = -1;

        AcyclicNode(int index) {
            assert (index >= 0) : "'index' must be non-negative";
            this.m_index = index;
        }

        void addTo(int toIndex) {
            this.m_tos.add(toIndex);
        }

        void addFrom(int fromIndex) {
            this.m_froms.add(fromIndex);
        }

        Set<Integer> getTo() {
            return this.m_tos;
        }

        Set<Integer> getFrom() {
            return this.m_froms;
        }

        void setLevel(int level) {
            this.m_level = level;
        }

        int getLevel() {
            return this.m_level;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AcyclicNode)) {
                return false;
            }
            return this.m_index == ((AcyclicNode)obj).m_index;
        }

        public int hashCode() {
            return this.m_index;
        }
    }
}

