/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.core.foundation.common.graph.ICycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CycleAnalyzer {
    private static Logger LOGGER = LoggerFactory.getLogger(CycleAnalyzer.class);
    private final ICycleAnalyzerAdapter m_adapter;
    private final IWorkerContext m_workerContext;
    private int m_acyclicNodeCount = -1;

    private CycleAnalyzer(ICycleAnalyzerAdapter adapter, IWorkerContext workerContext) {
        assert (adapter != null) : "Parameter 'adapter' of method 'GraphAnalyzer' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'GraphAnalyzer' must not be null";
        this.m_adapter = adapter;
        this.m_workerContext = workerContext;
        if (adapter.calculateLevels()) {
            this.m_workerContext.setNumberOfSteps(2, new int[]{80, 20});
        } else {
            this.m_workerContext.setNumberOfSteps(1);
        }
        this.analyzeCyclicOrbits();
        this.m_workerContext.endStep();
        if (this.m_workerContext.hasBeenCanceled()) {
            return;
        }
        if (adapter.calculateLevels()) {
            if (this.m_acyclicNodeCount > 0) {
                this.calculateLevels();
            }
            this.m_workerContext.endStep();
        }
    }

    private boolean assertCycleGroupIndex() {
        for (INode<?> nextNode : this.m_adapter.getNodes()) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return true;
            }
            assert (this.m_adapter.getGroupIndex(nextNode) == -1) : "Cycle group must not be set: " + this.m_adapter.getGroupIndex(nextNode) + " - for: " + nextNode;
        }
        return true;
    }

    private void analyzeCyclicOrbits() {
        if (LOGGER.isTraceEnabled()) assert (this.assertCycleGroupIndex()) : "cycleGroupIndex problem for analyzer " + this.m_adapter.getClass().getCanonicalName();
        int groupIndex = 0;
        Collection<INode<?>> nodes = this.m_adapter.getNodes();
        this.m_workerContext.beginBlockOfWork(nodes.size());
        for (INode<?> nextNode : nodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            if (this.m_adapter.getGroupIndex(nextNode) == -1) {
                if (nextNode.getIncomingEdges().size() == 0 || nextNode.getOutgoingEdges().size() == 0) {
                    this.m_adapter.setGroupIndex(nextNode, groupIndex, false);
                } else {
                    THashSet newToOrbitNodes = new THashSet();
                    for (INode.IEdge outgoingEdge : nextNode.getOutgoingEdges()) {
                        if (this.m_workerContext.hasBeenCanceled()) {
                            return;
                        }
                        INode<?> toNode = outgoingEdge.getTo();
                        if (this.m_adapter.getGroupIndex(toNode) != -1) continue;
                        newToOrbitNodes.add(toNode);
                    }
                    THashSet newFromOrbitNodes = new THashSet();
                    for (INode.IEdge incomingEdge : nextNode.getIncomingEdges()) {
                        if (this.m_workerContext.hasBeenCanceled()) {
                            return;
                        }
                        INode<?> fromNode = incomingEdge.getFrom();
                        if (this.m_adapter.getGroupIndex(fromNode) != -1) continue;
                        newFromOrbitNodes.add(fromNode);
                    }
                    THashSet reducedToOrbit = new THashSet();
                    THashSet reducedFromOrbit = new THashSet();
                    if (!newToOrbitNodes.isEmpty() && !newFromOrbitNodes.isEmpty()) {
                        this.completeReducedToOrbit(nextNode, (Set<INode<?>>)reducedToOrbit, (Set<INode<?>>)newToOrbitNodes);
                        this.completeReducedFromOrbit(nextNode, (Set<INode<?>>)reducedFromOrbit, (Set<INode<?>>)newFromOrbitNodes);
                    }
                    reducedToOrbit.retainAll((Collection<?>)reducedFromOrbit);
                    if (reducedToOrbit.isEmpty() || reducedToOrbit.size() == 1) {
                        if (LOGGER.isTraceEnabled()) assert (this.m_adapter.getGroupIndex(nextNode) == -1) : "'groupIndex' must not be set twice: " + nextNode;
                        this.m_adapter.setGroupIndex(nextNode, groupIndex, false);
                    } else {
                        Iterator reducedToOrbitIter = reducedToOrbit.iterator();
                        while (reducedToOrbitIter.hasNext()) {
                            if (this.m_workerContext.hasBeenCanceled()) {
                                return;
                            }
                            INode cycleGroupNode = (INode)reducedToOrbitIter.next();
                            if (LOGGER.isTraceEnabled()) assert (this.m_adapter.getGroupIndex(cycleGroupNode) == -1) : "'groupIndex' must not be set twice: " + cycleGroupNode;
                            this.m_adapter.setGroupIndex(cycleGroupNode, groupIndex, true);
                        }
                        if (LOGGER.isTraceEnabled()) {
                            assert (this.m_adapter.getGroupIndex(nextNode) == groupIndex) : "m_adapter.getCycleGroup(nextNode) == cycleGroupIndex";
                            assert (this.m_adapter.isCyclic(nextNode));
                        }
                    }
                }
                ++groupIndex;
            }
            this.m_workerContext.workItemCompleted();
        }
        this.m_acyclicNodeCount = groupIndex;
    }

    private void completeReducedToOrbit(INode<?> node, Set<INode<?>> currentOrbitNodes, Set<INode<?>> newOrbitNodes) {
        assert (node != null);
        currentOrbitNodes.addAll(newOrbitNodes);
        THashSet newestOrbitNodes = new THashSet();
        for (INode<?> newOrbitNode : newOrbitNodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            for (INode.IEdge outgoingEdge : newOrbitNode.getOutgoingEdges()) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                INode<?> toNode = outgoingEdge.getTo();
                if (this.m_adapter.getGroupIndex(toNode) != -1 || currentOrbitNodes.contains(toNode)) continue;
                newestOrbitNodes.add(toNode);
            }
        }
        if (!newestOrbitNodes.isEmpty()) {
            this.completeReducedToOrbit(node, currentOrbitNodes, (Set<INode<?>>)newestOrbitNodes);
        }
    }

    private void completeReducedFromOrbit(INode<?> node, Set<INode<?>> currentOrbitNodes, Set<INode<?>> newOrbitNodes) {
        assert (node != null);
        THashSet newestOrbitNodes = new THashSet();
        for (INode<?> newOrbitNode : newOrbitNodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            for (INode.IEdge incomingEdge : newOrbitNode.getIncomingEdges()) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                INode<?> fromNode = incomingEdge.getFrom();
                if (this.m_adapter.getGroupIndex(fromNode) != -1 || currentOrbitNodes.contains(fromNode)) continue;
                newestOrbitNodes.add(fromNode);
            }
        }
        if (!newestOrbitNodes.isEmpty()) {
            currentOrbitNodes.addAll((Collection<INode<?>>)newestOrbitNodes);
            this.completeReducedFromOrbit(node, currentOrbitNodes, (Set<INode<?>>)newestOrbitNodes);
        }
    }

    private void calculateLevels() {
        AcyclicNode[] stronglyConnectedComponents = new AcyclicNode[this.m_acyclicNodeCount];
        int i2 = 0;
        while (i2 < stronglyConnectedComponents.length) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            stronglyConnectedComponents[i2] = new AcyclicNode(i2);
            ++i2;
        }
        Collection<INode<?>> nodes = this.m_adapter.getNodes();
        this.m_workerContext.beginBlockOfWork(nodes.size());
        for (INode<?> fromNode : nodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            int cycleGroupIndexOfFromNode = this.m_adapter.getGroupIndex(fromNode);
            AcyclicNode sccOfFromNode = stronglyConnectedComponents[cycleGroupIndexOfFromNode];
            for (INode.IEdge outgoingEdge : fromNode.getOutgoingEdges()) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                INode<?> toNode = outgoingEdge.getTo();
                int cycleGroupIndexOfToNode = this.m_adapter.getGroupIndex(toNode);
                assert (cycleGroupIndexOfToNode != -1) : "'cycleGroupIndexOfToNode' must be set: " + toNode;
                if (cycleGroupIndexOfToNode == cycleGroupIndexOfFromNode) continue;
                sccOfFromNode.addTo(cycleGroupIndexOfToNode);
                stronglyConnectedComponents[cycleGroupIndexOfToNode].addFrom(cycleGroupIndexOfFromNode);
            }
            this.m_workerContext.workItemCompleted();
        }
        if (LOGGER.isTraceEnabled()) assert (this.assertAcyclicGraphConsistence(stronglyConnectedComponents));
        this.calculateCycleGroupLevelsBottomUp(stronglyConnectedComponents);
        for (INode<?> node : nodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            int cycleGroupIndex = this.m_adapter.getGroupIndex(node);
            AcyclicNode scc = stronglyConnectedComponents[cycleGroupIndex];
            this.m_adapter.setLevel(node, scc.getLevel());
        }
    }

    private boolean assertAcyclicGraphConsistence(AcyclicNode[] acyclicNodes) {
        assert (acyclicNodes != null) : "'acyclicNodes' must not be null";
        int i2 = 0;
        while (i2 < acyclicNodes.length) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return true;
            }
            for (int fromIndex : acyclicNodes[i2].getFrom()) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return true;
                }
                assert (acyclicNodes[fromIndex].getTo().contains(i2));
            }
            for (int toIndex : acyclicNodes[i2].getTo()) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return true;
                }
                assert (acyclicNodes[toIndex].getFrom().contains(i2));
            }
            ++i2;
        }
        return true;
    }

    private void calculateCycleGroupLevelsBottomUp(AcyclicNode[] acyclicNodes) {
        int level = 1;
        THashSet notYetMapped = new THashSet();
        int i2 = 0;
        while (i2 < acyclicNodes.length) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            notYetMapped.add(i2);
            ++i2;
        }
        THashSet alreadyMapped = new THashSet();
        while (!notYetMapped.isEmpty()) {
            int idx;
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            THashSet nodesOfNextLevel = new THashSet();
            Iterator iterator = notYetMapped.iterator();
            while (iterator.hasNext()) {
                idx = (Integer)iterator.next();
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                AcyclicNode fromNode = acyclicNodes[idx];
                if (!alreadyMapped.containsAll(fromNode.getTo())) continue;
                nodesOfNextLevel.add(idx);
            }
            iterator = nodesOfNextLevel.iterator();
            while (iterator.hasNext()) {
                idx = (Integer)iterator.next();
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                acyclicNodes[idx].setLevel(level);
                alreadyMapped.add(idx);
                notYetMapped.remove(idx);
            }
            ++level;
        }
    }

    public static void compute(ICycleAnalyzerAdapter adapter, IWorkerContext workerContext) {
        assert (adapter != null) : "Parameter 'adapter' of method 'compute' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'compute' must not be null";
        new CycleAnalyzer(adapter, workerContext);
    }

    static final class AcyclicNode {
        private final Set<Integer> m_tos = new THashSet();
        private final Set<Integer> m_froms = new THashSet();
        private final int m_index;
        private int m_level = -1;

        AcyclicNode(int index) {
            assert (index >= 0) : "'index' must be non-negative";
            this.m_index = index;
        }

        void addTo(int toIndex) {
            this.m_tos.add(toIndex);
        }

        void addFrom(int fromIndex) {
            this.m_froms.add(fromIndex);
        }

        Set<Integer> getTo() {
            return this.m_tos;
        }

        Set<Integer> getFrom() {
            return this.m_froms;
        }

        void setLevel(int level) {
            this.m_level = level;
        }

        int getLevel() {
            return this.m_level;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AcyclicNode)) {
                return false;
            }
            return this.m_index == ((AcyclicNode)obj).m_index;
        }

        public int hashCode() {
            return this.m_index;
        }
    }
}

