/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IConnectedComponentComputerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.NodeIndexBasedCalculator;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class ConnectedComponentComputer
extends NodeIndexBasedCalculator {
    private final Set<List<INode<?>>> m_componentsToUnite = new THashSet();
    private final List<INode<?>>[] m_nodeIndexToComponent;

    public ConnectedComponentComputer(Collection<? extends INode<?>> nodes, IWorkerContext workerContext, IConnectedComponentComputerAdapter adapter) {
        super(nodes, workerContext, 0);
        assert (adapter != null) : "Parameter 'adapter' of method 'DependencyCumulator' must not be null";
        this.m_nodeIndexToComponent = new ArrayList[this.m_numberOfNodes];
        THashSet componentAggregator = new THashSet();
        for (INode<?> nextNode : nodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            this.compute(nextNode, null);
            if (!this.m_componentsToUnite.isEmpty()) {
                for (List<INode<?>> nextComponent : this.m_componentsToUnite) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    componentAggregator.addAll(nextComponent);
                }
                ArrayList combinedComponent = new ArrayList((Collection<INode<?>>)componentAggregator);
                for (INode iNode : combinedComponent) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    this.m_nodeIndexToComponent[this.getIndex(iNode)] = combinedComponent;
                }
                componentAggregator.clear();
            }
            this.m_componentsToUnite.clear();
        }
        THashSet components = new THashSet();
        List<INode<?>>[] listArray = this.m_nodeIndexToComponent;
        int n2 = this.m_nodeIndexToComponent.length;
        int n3 = 0;
        while (n3 < n2) {
            List<INode<?>> nextComponent = listArray[n3];
            components.add(nextComponent);
            ++n3;
        }
        adapter.components((Set<List<INode<?>>>)components);
    }

    private void compute(INode<?> node, List<INode<?>> currentComponent) {
        assert (node != null) : "Parameter 'node' of method 'compute' must not be null";
        int nodeIndex = this.getIndex(node);
        List<INode<?>> component = this.m_nodeIndexToComponent[nodeIndex];
        if (component != null) {
            if (currentComponent != component) {
                this.m_componentsToUnite.add(component);
            }
            return;
        }
        if (currentComponent == null) {
            currentComponent = new ArrayList();
            this.m_componentsToUnite.add(currentComponent);
        }
        currentComponent.add(node);
        this.m_nodeIndexToComponent[nodeIndex] = currentComponent;
        for (INode.IEdge nextEdge : node.getOutgoingEdges()) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            this.compute(nextEdge.getTo(), currentComponent);
        }
    }
}

