/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class Adjacency<V> {
    private final Map<V, Map<V, Integer>> m_adjacencyWithWeights = new LinkedHashMap<V, Map<V, Integer>>();

    public static <V> Adjacency<V> createRevertedAdjacency(Adjacency<V> adjacency) {
        assert (adjacency != null) : "Parameter 'adjacency' of method 'createRevertedAdjacency' must not be null";
        Adjacency<V> result = new Adjacency<V>();
        for (V n1 : adjacency.getStartNodesRef()) {
            Map<V, Integer> map = adjacency.getWeightMapRef(n1);
            for (Map.Entry<V, Integer> entry : map.entrySet()) {
                V n2 = entry.getKey();
                result.addEdge(n2, n1, entry.getValue());
            }
        }
        return result;
    }

    public boolean isEmpty() {
        return this.m_adjacencyWithWeights.isEmpty();
    }

    public int size() {
        return this.m_adjacencyWithWeights.size();
    }

    public void addEdge(V startVertex, V endVertex, int weight) {
        Integer currentWeight;
        assert (startVertex != null) : "Parameter 'startVertex' of method 'addEdge' must not be null";
        assert (endVertex != null) : "Parameter 'endVertex' of method 'addEdge' must not be null";
        assert (weight > 0) : "'weight' must be greater than 0";
        Map<Integer, Integer> weightMap = this.m_adjacencyWithWeights.get(startVertex);
        if (weightMap == null) {
            weightMap = new LinkedHashMap<V, Integer>(2);
            this.m_adjacencyWithWeights.put((Map<Integer, Integer>)startVertex, (Map<Map<Integer, Integer>, Integer>)weightMap);
        }
        if ((currentWeight = weightMap.get(endVertex)) == null) {
            weightMap.put((Integer)endVertex, weight);
        } else {
            weightMap.put((Integer)endVertex, weight + currentWeight);
        }
    }

    public Set<V> mkAllNodesCopy() {
        LinkedHashSet<V> result = new LinkedHashSet<V>(this.m_adjacencyWithWeights.keySet());
        for (Map<V, Integer> weightMap : this.m_adjacencyWithWeights.values()) {
            result.addAll(weightMap.keySet());
        }
        return result;
    }

    public Set<V> getStartNodesRef() {
        return this.m_adjacencyWithWeights.keySet();
    }

    public Set<V> getFollowerNodesRef(V v2) {
        Map<V, Integer> map = this.m_adjacencyWithWeights.get(v2);
        if (map == null) {
            return null;
        }
        return map.keySet();
    }

    public int getWeight(V v1, V v2) {
        Map<V, Integer> map = this.getWeightMapRef(v1);
        if (map == null) {
            return 0;
        }
        Integer weight = map.get(v2);
        if (weight == null) {
            return 0;
        }
        return weight;
    }

    public Map<V, Integer> getWeightMapRef(V v2) {
        return this.m_adjacencyWithWeights.get(v2);
    }
}

