/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.duplicatecode;

import com.hello2morrow.sonargraph.core.foundation.common.base.IFile;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.FileContent;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.LocationWithLogicalLineNumber;

final class PhysicalLocation
implements Comparable<PhysicalLocation> {
    private final FileContent m_fileContent;
    private final int m_physicalLineNumber;

    PhysicalLocation(FileContent fileContent, int physicalLineNumber) {
        this.m_fileContent = fileContent;
        this.m_physicalLineNumber = physicalLineNumber;
    }

    FileContent getFileContent() {
        return this.m_fileContent;
    }

    int getPhysicalLineNumber() {
        return this.m_physicalLineNumber;
    }

    @Override
    public int compareTo(PhysicalLocation loc) {
        String n2;
        String n1 = this.getFileContent().getFile().getAbsolutePath();
        int result = n1.compareTo(n2 = loc.getFileContent().getFile().getAbsolutePath());
        if (result != 0) {
            return result;
        }
        return this.getPhysicalLineNumber() - loc.getPhysicalLineNumber();
    }

    IFile getPath() {
        return this.m_fileContent.getFile();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof PhysicalLocation)) {
            return false;
        }
        return this.compareTo((PhysicalLocation)o2) == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_fileContent == null ? 0 : this.getFileContent().getFile().getAbsolutePath().hashCode());
        result = 31 * result + this.m_physicalLineNumber;
        return result;
    }

    public String toString() {
        return this.m_fileContent.getFile().getAbsolutePath() + "  from Line: " + this.m_physicalLineNumber;
    }

    public LocationWithLogicalLineNumber createLocationWithLogicalLineNumber() {
        return new LocationWithLogicalLineNumber(this.m_fileContent, this.m_physicalLineNumber, this.m_fileContent.createLogicalLineNumberForPhysical(this.m_physicalLineNumber));
    }
}

