/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.duplicatecode;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MatchingLinesOfTwoStrings {
    private final Object[] m_linesFirstString;
    private final Object[] m_linesSecondString;
    private Set<Integer> m_matchingLinesLeft;
    private Set<Integer> m_matchingLinesRight;
    private final Map<Integer, Integer> m_matchingLines;
    private final Map<String, String> m_LCSLines = new LinkedHashMap<String, String>();

    public MatchingLinesOfTwoStrings(List<String> linesFirstString, List<String> linesSecondString) {
        assert (linesFirstString != null) : "Parameter 'linesFirstOccurrence' of method 'MatchingLinesOfTwoStrings' must not be null";
        assert (linesSecondString != null) : "Parameter 'linesSecondOccurrence' of method 'MatchingLinesOfTwoStrings' must not be null";
        this.m_linesFirstString = linesFirstString.toArray();
        this.m_linesSecondString = linesSecondString.toArray();
        this.m_matchingLines = new HashMap<Integer, Integer>();
    }

    public void computeMatchingLines() {
        if (this.m_linesFirstString.length > 0 && this.m_linesSecondString.length > 0 && this.m_linesFirstString != this.m_linesSecondString) {
            this.m_matchingLinesLeft = new HashSet<Integer>();
            this.m_matchingLinesRight = new HashSet<Integer>();
            this.backtrack(this.LCSLength());
            for (Map.Entry<String, String> nextEntry : this.m_LCSLines.entrySet()) {
                String value = nextEntry.getValue();
                Integer leftLine = Integer.valueOf(value.split("\\|")[0]);
                Integer rightLine = Integer.valueOf(value.split("\\|")[1]);
                this.m_matchingLines.put(leftLine, rightLine);
                this.m_matchingLinesLeft.add(leftLine);
                this.m_matchingLinesRight.add(rightLine);
            }
        }
    }

    private int[][] LCSLength() {
        int M2 = this.m_linesFirstString.length;
        int N2 = this.m_linesSecondString.length;
        int[][] opt = new int[M2 + 1][N2 + 1];
        int i2 = M2 - 1;
        while (i2 >= 0) {
            int j2 = N2 - 1;
            while (j2 >= 0) {
                String first = (String)this.m_linesFirstString[i2];
                String second = (String)this.m_linesSecondString[j2];
                opt[i2][j2] = first.equals(second) ? opt[i2 + 1][j2 + 1] + 1 : Math.max(opt[i2 + 1][j2], opt[i2][j2 + 1]);
                --j2;
            }
            --i2;
        }
        return opt;
    }

    private void backtrack(int[][] opt) {
        int M2 = this.m_linesFirstString.length;
        int N2 = this.m_linesSecondString.length;
        int i2 = 0;
        int j2 = 0;
        while (i2 < M2 && j2 < N2) {
            String first = (String)this.m_linesFirstString[i2];
            String second = (String)this.m_linesSecondString[j2];
            if (first.equals(second)) {
                this.m_LCSLines.put(String.valueOf(first) + "|" + i2 + "|" + j2, String.valueOf(i2) + "|" + j2);
                ++i2;
                ++j2;
                continue;
            }
            if (opt[i2 + 1][j2] >= opt[i2][j2 + 1]) {
                ++i2;
                continue;
            }
            ++j2;
        }
    }

    public Set<Integer> getMatchingLinesLeft() {
        if (this.m_matchingLinesLeft == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_matchingLinesLeft);
    }

    public Set<Integer> getMatchingLinesRight() {
        if (this.m_matchingLinesRight == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_matchingLinesRight);
    }
}

