/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.duplicatecode;

import com.hello2morrow.foundation.persistence.IObjectReader;
import com.hello2morrow.foundation.persistence.IObjectWriter;
import com.hello2morrow.foundation.persistence.IPersistable;
import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.core.foundation.common.base.IFile;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateBlockInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DuplicateBlockInfoEQClass
implements IPersistable {
    private static final String LIST = "list";
    private final List<DuplicateBlockInfo> m_duplicateBlockInfos = new ArrayList<DuplicateBlockInfo>();

    public void writeAttributes(IObjectWriter writer) throws IOException {
        writer.writeOwnedObjects(LIST, this.m_duplicateBlockInfos.toArray(new IPersistable[this.m_duplicateBlockInfos.size()]));
    }

    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        DuplicateBlockInfo[] duplicateBlockInfoArray = (DuplicateBlockInfo[])reader.readOwnedObjects(LIST, DuplicateBlockInfo.class);
        int n2 = duplicateBlockInfoArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DuplicateBlockInfo obj = duplicateBlockInfoArray[n3];
            this.m_duplicateBlockInfos.add(obj);
            ++n3;
        }
    }

    public void add(DuplicateBlockInfo dbi) {
        assert (dbi != null) : "Parameter 'dbi' of method 'add' must not be null";
        this.m_duplicateBlockInfos.add(dbi);
    }

    public List<DuplicateBlockInfo> getElements() {
        return this.m_duplicateBlockInfos;
    }

    public int getLastLine(int startLineNo, IFile file) {
        DuplicateBlockInfo dbi = this.getDuplicateBlockInfo(startLineNo, file);
        assert (dbi != null) : "Duplicated block not found";
        return dbi.getMatchedLineCount() + dbi.getBlockBegin() - 1;
    }

    public DuplicateBlockInfo getDuplicateBlockInfo(int startLineNo, IFile file) {
        for (DuplicateBlockInfo dbi : this.m_duplicateBlockInfos) {
            if (dbi.getBlockBegin() != startLineNo || !dbi.getFile().getAbsolutePath().equals(file.getAbsolutePath())) continue;
            return dbi;
        }
        return null;
    }

    public String createDescription(int lineNumber, IFile file) {
        int toBeDescribed;
        DuplicateBlockInfo dbi = this.getDuplicateBlockInfo(lineNumber, file);
        assert (dbi != null) : "Duplicated block not found";
        int endLine = dbi.getMatchedLineCount() + dbi.getBlockBegin() - 1;
        StringBuilder sb = new StringBuilder();
        sb.append("Line " + dbi.getBlockBegin() + " to " + endLine + " of " + dbi.getFile().getAbsolutePath() + " is a duplicate of ");
        int yetToDescribe = toBeDescribed = this.m_duplicateBlockInfos.size() - 1;
        for (DuplicateBlockInfo dbi1 : this.m_duplicateBlockInfos) {
            if (dbi1 == dbi) continue;
            if (toBeDescribed != yetToDescribe) {
                if (yetToDescribe == 1) {
                    switch (toBeDescribed) {
                        case 2: {
                            sb.append(" and ");
                            break;
                        }
                        default: {
                            sb.append(", and ");
                            break;
                        }
                    }
                } else {
                    sb.append(", ");
                }
            }
            int endLine1 = dbi1.getMatchedLineCount() + dbi1.getBlockBegin() - 1;
            sb.append("line " + dbi1.getBlockBegin() + " to " + endLine1 + " of " + dbi1.getFile().getAbsolutePath());
            --yetToDescribe;
        }
        sb.append(".");
        return sb.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (DuplicateBlockInfo next : this.m_duplicateBlockInfos) {
            builder.append(this.createDescription(next.getBlockBegin(), next.getFile()));
        }
        return builder.toString();
    }

    public int getLineCount() {
        assert (this.m_duplicateBlockInfos.size() > 0) : "'m_duplicateBlockInfoList' of method 'getLineCount' must not be empty";
        DuplicateBlockInfo duplicateBlockInfo = this.m_duplicateBlockInfos.get(0);
        assert (duplicateBlockInfo != null) : "'duplicateBlockInfo' of method 'getLineCount' must not be null";
        return duplicateBlockInfo.getMatchedLineCount();
    }

    public int getLineCountWithoutIgnored() {
        assert (this.m_duplicateBlockInfos.size() > 0) : "'m_duplicateBlockInfoList' of method 'getLineCount' must not be empty";
        DuplicateBlockInfo duplicateBlockInfo = this.m_duplicateBlockInfos.get(0);
        assert (duplicateBlockInfo != null) : "'duplicateBlockInfo' of method 'getLineCount' must not be null";
        return duplicateBlockInfo.getLogicalMatchedLineCount();
    }
}

