/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.duplicatecode;

import com.hello2morrow.foundation.persistence.IObjectReader;
import com.hello2morrow.foundation.persistence.IObjectWriter;
import com.hello2morrow.foundation.persistence.IPersistable;
import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.foundation.text.IntBasedHash;
import com.hello2morrow.sonargraph.core.foundation.common.base.IFile;
import java.io.IOException;

public final class DuplicateBlockInfo
implements IPersistable {
    private static final String FILE = "file";
    private static final String MATCHED_LINE_COUNT = "matchedLineCount";
    private static final String BLOCK_BEGIN = "blockBegin";
    private static final String TOLERANCE = "tolerance";
    private static final String HASH = "hash";
    private static final String LOGICAL_MATCHED_LINE_COUNT = "logicalMatchedLineCount";
    private static final String LINE_HASH_CODES = "lineHashCodes";
    private IFile m_file;
    private int m_matchedLineCount;
    private int m_tolerance;
    private int m_blockBegin;
    private String m_hash;
    private int m_logicalMatchedLineCount;
    private IntBasedHash m_lineHashCodes;

    public DuplicateBlockInfo() {
    }

    public void writeAttributes(IObjectWriter writer) throws IOException {
        writer.writeObjectReference(FILE, (IPersistable)this.m_file);
        writer.writeInt(MATCHED_LINE_COUNT, this.m_matchedLineCount);
        writer.writeInt(TOLERANCE, this.m_tolerance);
        writer.writeInt(BLOCK_BEGIN, this.m_blockBegin);
        writer.writeString(HASH, this.m_hash);
        writer.writeInt(LOGICAL_MATCHED_LINE_COUNT, this.m_logicalMatchedLineCount);
        writer.writeIntArray(LINE_HASH_CODES, this.m_lineHashCodes.getArray());
    }

    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        reader.readObjectReference(FILE, IFile.class, f2 -> {
            IFile iFile = this.m_file = f2;
        });
        this.m_matchedLineCount = reader.readInt(MATCHED_LINE_COUNT);
        this.m_tolerance = reader.readInt(TOLERANCE);
        this.m_blockBegin = reader.readInt(BLOCK_BEGIN);
        this.m_hash = reader.readString(HASH);
        this.m_logicalMatchedLineCount = reader.readInt(LOGICAL_MATCHED_LINE_COUNT);
        int[] hashes = reader.readIntArray(LINE_HASH_CODES);
        if (hashes == null) {
            throw new RestoreException("Out of date: Missing hashes for duplicate code block info.");
        }
        this.m_lineHashCodes = new IntBasedHash(hashes);
    }

    public DuplicateBlockInfo(IFile file, int matchedLineCount, int tolerance, int blockBegin, int logicalMatchedLineCount) {
        assert (file != null) : "Parameter 'file' of method 'DuplicateBlockInfo' must not be null";
        this.m_file = file;
        this.m_matchedLineCount = matchedLineCount;
        this.m_tolerance = tolerance;
        this.m_blockBegin = blockBegin;
        this.m_logicalMatchedLineCount = logicalMatchedLineCount;
    }

    public int getMatchedLineCount() {
        return this.m_matchedLineCount;
    }

    public int getLogicalMatchedLineCount() {
        return this.m_logicalMatchedLineCount;
    }

    public int getTolerance() {
        return this.m_tolerance;
    }

    public IFile getFile() {
        return this.m_file;
    }

    public int getBlockBegin() {
        return this.m_blockBegin;
    }

    public int getBlockEnd() {
        return this.getMatchedLineCount() + this.getBlockBegin() - 1;
    }

    public void setHash(String hash, IntBasedHash intBasedHash) {
        assert (hash != null && hash.length() > 0) : "Parameter 'hash' of method 'setHash' must not be empty";
        assert (intBasedHash != null && intBasedHash.length() > 0) : "Parameter 'lineHashCodes' of method 'setHash' must not be empty";
        this.m_hash = hash;
        this.m_lineHashCodes = intBasedHash;
    }

    public String toString() {
        return "DuplicateBlockInfo [m_file=" + this.m_file + ", m_blockBegin=" + this.m_blockBegin + ", m_matchedLineCount=" + this.m_matchedLineCount + ", m_tolerance=" + this.m_tolerance + "]";
    }

    public String getHash() {
        assert (this.m_hash != null) : "'m_hash' of method 'getHash' must not be null";
        return this.m_hash;
    }

    public IntBasedHash getHashCodesRepresentingLines() {
        return this.m_lineHashCodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_blockBegin;
        result = 31 * result + (this.m_file == null ? 0 : this.m_file.hashCode());
        result = 31 * result + (this.m_hash == null ? 0 : this.m_hash.hashCode());
        result = 31 * result + this.m_logicalMatchedLineCount;
        result = 31 * result + this.m_matchedLineCount;
        result = 31 * result + this.m_tolerance;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DuplicateBlockInfo other = (DuplicateBlockInfo)obj;
        if (this.m_blockBegin != other.m_blockBegin) {
            return false;
        }
        if (this.m_file == null ? other.m_file != null : !this.m_file.equals(other.m_file)) {
            return false;
        }
        if (this.m_hash == null ? other.m_hash != null : !this.m_hash.equals(other.m_hash)) {
            return false;
        }
        if (this.m_logicalMatchedLineCount != other.m_logicalMatchedLineCount) {
            return false;
        }
        if (this.m_matchedLineCount != other.m_matchedLineCount) {
            return false;
        }
        return this.m_tolerance == other.m_tolerance;
    }
}

