/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.base;

import com.hello2morrow.foundation.utilities.IResult;
import com.hello2morrow.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ValidationResult
implements IResult {
    private final List<String> m_errors = new ArrayList<String>();
    private final List<String> m_warnings = new ArrayList<String>();
    private final boolean m_inputModified;

    public ValidationResult(boolean inputModified) {
        this.m_inputModified = inputModified;
    }

    public ValidationResult() {
        this(false);
    }

    public boolean isSuccess() {
        return this.m_errors == null || this.m_errors.isEmpty();
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public boolean inputModified() {
        return this.m_inputModified;
    }

    public void addError(String error) {
        assert (error != null && error.length() > 0) : "Parameter 'error' of method 'addError' must not be empty";
        this.m_errors.add(error);
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.m_errors);
    }

    public void addWarning(String warning) {
        assert (warning != null && warning.length() > 0) : "Parameter 'warning' of method 'addWarning' must not be empty";
        this.m_warnings.add(warning);
    }

    public List<String> getWarnings() {
        return Collections.unmodifiableList(this.m_warnings);
    }

    public boolean hasErrors() {
        return !this.m_errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.m_warnings.isEmpty();
    }

    public void addMessagesFrom(ValidationResult result) {
        assert (result != null) : "Parameter 'result' of method 'addMessagesFrom' must not be null";
        this.m_errors.addAll(result.getErrors());
        this.m_warnings.addAll(result.getWarnings());
    }

    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        for (String nextError : this.getErrors()) {
            builder.append("Error: ");
            builder.append(nextError);
            builder.append(StringUtility.LINE_SEPARATOR);
        }
        for (String nextWarning : this.getWarnings()) {
            builder.append("Warning: ");
            builder.append(nextWarning);
            builder.append(StringUtility.LINE_SEPARATOR);
        }
        if (builder.length() > 0) {
            builder.delete(builder.length() - StringUtility.LINE_SEPARATOR.length(), builder.length());
            return builder.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Validation result: ");
        if (this.isSuccess()) {
            builder.append("success");
        } else {
            builder.append("failure");
        }
        if (!this.m_errors.isEmpty()) {
            builder.append(" errors [" + this.m_errors.size() + "]");
        }
        if (!this.m_warnings.isEmpty()) {
            builder.append(" warnings [" + this.m_warnings.size() + "]");
        }
        for (String nextError : this.getErrors()) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append("Error: ");
            builder.append(nextError);
        }
        for (String nextWarning : this.getWarnings()) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append("Warning: ");
            builder.append(nextWarning);
        }
        return builder.toString();
    }
}

