/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.base;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TemplateUtility {
    public static String expandTemplate(String fileName, Map<String, Object> binding) throws Exception {
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'expandTemplate' must not be empty";
        assert (binding != null) : "Parameter 'binding' of method 'enclosing_method' must not be null";
        TFile file = new TFile(fileName);
        String templateText = FileUtility.getFileContent((TFile)file);
        return TemplateUtility.expandTemplateText(templateText, binding);
    }

    public static String expandTemplateText(String templateText, Map<String, ? extends Object> binding) throws Exception {
        if (templateText == null) {
            return null;
        }
        SimpleTemplateEngine engine = new SimpleTemplateEngine();
        Template template = engine.createTemplate(templateText);
        HashMap<String, ? extends Object> copyOfBinding = new HashMap<String, Object>(binding);
        String result = template.make(copyOfBinding).toString();
        return result.replaceAll("\\r", "");
    }

    public static List<String> expandTemplateToLines(String fileName, Map<String, Object> binding) throws Exception {
        String expandedTemplate = TemplateUtility.expandTemplate(fileName, binding);
        if (expandedTemplate == null) {
            return null;
        }
        return StringUtility.multiLineStringToList((String)expandedTemplate);
    }
}

