/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.base;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import de.schlichtherle.truezip.file.TFile;

public class StandardDirectoryValidator
implements IPathValidator {
    private Permission m_permission;

    public StandardDirectoryValidator(Permission permission) {
        assert (permission != null) : "Parameter 'permission' of method 'StandardDirectoryValidator' must not be null";
        this.m_permission = permission;
    }

    @Override
    public IPathValidator.PathType getType() {
        return IPathValidator.PathType.DIRECTORY;
    }

    @Override
    public ValidationResult isValid(TFile currentInput, TFile newInput) {
        ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
        if (newInput == null || newInput.getPath().isEmpty()) {
            result.addError("Must not be empty");
            return result;
        }
        if (!newInput.exists()) {
            result.addError("Does not exist");
            return result;
        }
        if (!newInput.isDirectory()) {
            result.addError("Is not a directory");
            return result;
        }
        if (!newInput.canRead()) {
            result.addError("No read permission");
            return result;
        }
        if (this.m_permission == Permission.READ_WRITE && !newInput.canWrite()) {
            result.addError("No write permission");
            return result;
        }
        return result;
    }

    public static enum Permission {
        READ,
        READ_WRITE;

    }
}

