/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.base;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import java.util.regex.Pattern;

public class RegexValidator
implements ITextValidator {
    private final Pattern m_regex;

    public RegexValidator(String regex) {
        this.m_regex = Pattern.compile(regex, 256);
    }

    @Override
    public ValidationResult isValid(String initialInput, String newInput) {
        String input;
        ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)initialInput, (String)newInput));
        String string = input = newInput != null ? newInput : "";
        if (!this.m_regex.matcher(input).matches()) {
            result.addError("Input does not match required pattern '" + this.m_regex.toString() + "'");
        }
        return result;
    }
}

