/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.base;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;

public final class PortValidator
implements ITextValidator {
    @Override
    public ValidationResult isValid(String currentInput, String newInput) {
        ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
        if (newInput == null || newInput.trim().isEmpty()) {
            result.addError("Port must not be empty");
            return result;
        }
        try {
            int port = Integer.parseInt(newInput.trim());
            if (port <= 0) {
                result.addError("Invalid port");
            }
        }
        catch (NumberFormatException nfe) {
            result.addError("Invalid port");
        }
        return result;
    }
}

