/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.core.controller.system.Z;
import com.hello2morrow.sonargraph.core.controller.system.aa;
import com.hello2morrow.sonargraph.core.controller.system.ar;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectory;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.IAdditionalDynamicInfoProvider;
import com.hello2morrow.sonargraph.core.model.system.IDynamicSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemCreator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleMappingInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathMappingInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathType;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemMappingInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.system.SoftwareSystemPropertiesReader;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class z
extends Extension
implements IDynamicSystemProvider {
    private static final Logger a = LoggerFactory.getLogger(z.class);
    private final Map<String, IAdditionalDynamicInfoProvider> c = new HashMap<String, IAdditionalDynamicInfoProvider>();
    private final ISoftwareSystemCreator d;
    private final aa e;
    private final ar f;

    public z(ISoftwareSystemCreator systemCreator, aa languageProviderAccessor, ar persistenceAccessor) {
        assert (systemCreator != null) : "Parameter 'm_systemCreator' of method 'DynamicSystemProvider' must not be null";
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'DynamicSystemProvider' must not be null";
        assert (persistenceAccessor != null) : "Parameter 'persistenceAccessor' of method 'DynamicSystemProvider' must not be null";
        this.d = systemCreator;
        this.e = languageProviderAccessor;
        this.f = persistenceAccessor;
    }

    protected final ISoftwareSystemCreator a() {
        return this.d;
    }

    protected final aa b() {
        return this.e;
    }

    protected final ar c() {
        return this.f;
    }

    @Override
    public final void finishInstallationInitialization() {
        for (Z nextLanguageProvider : this.e.d()) {
            IAdditionalDynamicInfoProvider dynamicSystemInfoProvider = nextLanguageProvider.l();
            if (dynamicSystemInfoProvider == null) continue;
            this.c.put(dynamicSystemInfoProvider.getLanguage().getStandardName(), dynamicSystemInfoProvider);
        }
    }

    @Override
    public final Map<String, IAdditionalDynamicInfoProvider> getInfoProviders() {
        return Collections.unmodifiableMap(this.c);
    }

    @Override
    public final OperationResultWithOutcome<DynamicSystemInfo> loadSystemInfo(IWorkerContext workerContext, TFile systemDirectory) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'openSoftwareSystem' must not be null";
        assert (systemDirectory != null) : "Parameter 'systemDirectory' of method 'loadSystemInfo' must not be null";
        workerContext.working("Loading system info", true);
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading system info");
        SoftwareSystemDirectory.checkDirectory(systemDirectory, (OperationResult)result);
        if (result.isFailure()) {
            return result;
        }
        TFile systemFile = new TFile((File)systemDirectory, "system.sonargraph");
        SoftwareSystemFile.checkSoftwareSystemFile(systemFile, (OperationResult)result);
        if (result.isFailure()) {
            return result;
        }
        workerContext.working("Detect languages", true);
        OperationResultWithOutcome<SoftwareSystemPropertiesReader.SoftwareSystemProperties> readPropertiesResult = SoftwareSystemPropertiesReader.read(systemFile);
        result.addMessagesFrom(readPropertiesResult);
        if (result.isFailure()) {
            return result;
        }
        Set<Language> detectedLanguages = this.e.a(((SoftwareSystemPropertiesReader.SoftwareSystemProperties)readPropertiesResult.getOutcome()).getLanguages(), (OperationResult)result);
        workerContext.working("Load system file", true);
        OperationResultWithOutcome<DynamicSystemInfo> loadXmlResult = this.f.b(detectedLanguages).load(systemFile, SoftwareSystemDirectory.getSoftwareSystemName(systemDirectory), this.e.a());
        return loadXmlResult;
    }

    private ModuleInfo a(ModuleInfo externalModule, IDynamicSystemProvider.ISourceToClassRootProvider srcToClassRootProvider, ModuleInfo sonargraphModule) {
        assert (externalModule != null) : "Parameter 'externalModule' of method 'createMappedModuleInfo' must not be null";
        assert (srcToClassRootProvider != null) : "Parameter 'srcToClassRootProvider' of method 'createMappedModuleInfo' must not be null";
        assert (sonargraphModule != null) : "Parameter 'sonargraphModule' of method 'createMappedModuleInfo' must not be null";
        ModuleInfo mappedModule = new ModuleInfo(sonargraphModule.getId(), sonargraphModule.getName(), sonargraphModule.getDescription(), sonargraphModule.getLanguage(), sonargraphModule.getModuleType());
        List<RootPathInfo> srcRootsToUse = this.a(externalModule, sonargraphModule);
        OperationResultWithOutcome<List<RootPathInfo>> result = srcToClassRootProvider.getClassRootsForSourceRoots(externalModule.getName(), srcRootsToUse);
        if (result.isSuccess()) {
            List classRoots = (List)result.getOutcome();
            LinkedHashSet classRootsToUse = new LinkedHashSet(classRoots);
            srcRootsToUse.forEach(src -> mappedModule.addRootPath((RootPathInfo)src));
            classRootsToUse.forEach(cls -> mappedModule.addRootPath((RootPathInfo)cls));
        }
        return mappedModule;
    }

    protected final List<RootPathInfo> a(ModuleInfo externalModule, ModuleInfo sonargraphModule) {
        ArrayList<RootPathInfo> srcRootsToUse = new ArrayList<RootPathInfo>();
        for (RootPathInfo next : externalModule.getNonStandardRootPaths()) {
            if (!sonargraphModule.getNonStandardRootPaths().stream().anyMatch(src2 -> next.getPath().equals(src2.getPath()))) continue;
            srcRootsToUse.add(new RootPathInfo(next.getPath(), RootPathType.NON_STANDARD));
        }
        return srcRootsToUse;
    }

    private Optional<ModuleInfo> a(ModuleInfo moduleToFind, SoftwareSystem system) {
        assert (moduleToFind != null) : "Parameter 'moduleToFind' of method 'findMatchingModule' must not be null";
        assert (system != null) : "Parameter 'system' of method 'findMatchingModule' must not be null";
        Z languageProvider = this.e.b(moduleToFind.getLanguage());
        if (languageProvider != null) {
            Module match = null;
            block0 : switch (languageProvider.q()) {
                case STANDARD: {
                    String identifyingPath;
                    for (Module module : system.getUniqueExistingChild(Workspace.class).getChildren(languageProvider.b())) {
                        for (RootDirectoryPath rootDirectoryPath : languageProvider.a(module, RootPathType.STANDARD)) {
                            identifyingPath = FileUtility.getIdentifyingPath((TFile)rootDirectoryPath.getFile());
                            for (RootPathInfo rootPath : moduleToFind.getStandardRootPaths()) {
                                if (!identifyingPath.equals(rootPath.getPath())) continue;
                                match = module;
                                break block0;
                            }
                        }
                    }
                    break;
                }
                case NON_STANDARD: {
                    String identifyingPath;
                    for (Module module : system.getUniqueExistingChild(Workspace.class).getChildren(languageProvider.b())) {
                        for (RootDirectoryPath rootDirectoryPath : languageProvider.a(module, RootPathType.NON_STANDARD)) {
                            identifyingPath = FileUtility.getIdentifyingPath((TFile)rootDirectoryPath.getFile());
                            for (RootPathInfo rootPath : moduleToFind.getNonStandardRootPaths()) {
                                if (!identifyingPath.equals(rootPath.getPath())) continue;
                                match = module;
                                break block0;
                            }
                        }
                    }
                    break;
                }
                default: {
                    assert (false) : "Unhandled root path type: " + (Object)((Object)languageProvider.q());
                    break;
                }
            }
            if (match != null) {
                ModuleInfo moduleInfo = new ModuleInfo(match.getId(), match.getName(), match.getDescription(), match.getLanguage().getStandardName(), moduleToFind.getModuleType());
                for (RootDirectoryPath rootDirectoryPath : languageProvider.a(match, RootPathType.STANDARD)) {
                    moduleInfo.addRootPath(new RootPathInfo(FileUtility.getIdentifyingPath((TFile)rootDirectoryPath.getFile()), RootPathType.STANDARD));
                }
                for (RootDirectoryPath rootDirectoryPath : languageProvider.a(match, RootPathType.NON_STANDARD)) {
                    moduleInfo.addRootPath(new RootPathInfo(FileUtility.getIdentifyingPath((TFile)rootDirectoryPath.getFile()), RootPathType.NON_STANDARD));
                }
                return Optional.of(moduleInfo);
            }
        }
        return Optional.empty();
    }

    @Override
    public final Optional<ModuleInfo> mapModule(ModuleInfo externalModule, IDynamicSystemProvider.ISourceToClassRootProvider classRootProvider, SoftwareSystem system) {
        assert (externalModule != null) : "Parameter 'externalModule' of method 'mapModule' must not be null";
        assert (classRootProvider != null) : "Parameter 'classRootProvider' of method 'mapModule' must not be null";
        assert (system != null) : "Parameter 'system' of method 'mapModule' must not be null";
        Optional<ModuleInfo> match = this.a(externalModule, system);
        if (!match.isPresent()) {
            return match;
        }
        ModuleInfo mappedModule = this.a(externalModule, classRootProvider, match.get());
        return Optional.of(mappedModule);
    }

    private Optional<ModuleInfo> a(ModuleInfo moduleToFind, DynamicSystemInfo systemInfo) {
        assert (moduleToFind != null) : "Parameter 'moduleToFind' of method 'findMatchingModule' must not be null";
        assert (systemInfo != null) : "Parameter 'systemInfo' of method 'mapProjectToModule' must not be null";
        Z languageProvider = this.e.b(moduleToFind.getLanguage());
        if (languageProvider != null) {
            ModuleInfo match = null;
            block4: for (ModuleInfo next : systemInfo.getModules()) {
                if (!moduleToFind.getLanguage().equals(next.getLanguage())) continue;
                switch (languageProvider.q()) {
                    case STANDARD: {
                        for (RootPathInfo nextSgSrcPath : next.getStandardRootPaths()) {
                            for (RootPathInfo nextProjectSrcPath : moduleToFind.getStandardRootPaths()) {
                                if (!nextSgSrcPath.getPath().equals(nextProjectSrcPath.getPath())) continue;
                                match = next;
                                break block4;
                            }
                        }
                        continue block4;
                    }
                    case NON_STANDARD: {
                        for (RootPathInfo nextSgSrcPath : next.getNonStandardRootPaths()) {
                            for (RootPathInfo nextProjectSrcPath : moduleToFind.getNonStandardRootPaths()) {
                                if (!nextSgSrcPath.getPath().equals(nextProjectSrcPath.getPath())) continue;
                                match = next;
                                break block4;
                            }
                        }
                        continue block4;
                    }
                    default: {
                        assert (false) : "Unhandled root path type: " + (Object)((Object)languageProvider.q());
                        continue block4;
                    }
                }
            }
            if (match != null) {
                return Optional.of(match.copy());
            }
        }
        return Optional.empty();
    }

    @Override
    public final Optional<ModuleInfo> mapModule(ModuleInfo externalModule, IDynamicSystemProvider.ISourceToClassRootProvider srcToClassRootProvider, DynamicSystemInfo systemInfo, ISoftwareSystemProvider provider) {
        assert (externalModule != null) : "Parameter 'eclipseProject' of method 'mapModule' must not be null";
        assert (srcToClassRootProvider != null) : "Parameter 'srcToClassRootProvider' of method 'mapModule' must not be null";
        assert (systemInfo != null) : "Parameter 'systemInfo' of method 'mapModule' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'mapModule' must not be null";
        Optional<ModuleInfo> match = this.a(externalModule, systemInfo);
        if (!match.isPresent()) {
            return match;
        }
        return Optional.of(this.a(externalModule, srcToClassRootProvider, match.get()));
    }

    protected final ModuleInfo a(Z languageProvider, Module module, List<ModuleInfo> modulesToMatch) {
        String nextSourcePath;
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'matchModule' must not be null";
        assert (module != null) : "Parameter 'module' of method 'matchModule' must not be null";
        assert (modulesToMatch != null) : "Parameter 'modulesToMatch' of method 'matchModule' must not be null";
        boolean isCaseSensitive = Platform.isCaseSensitive();
        switch (languageProvider.q()) {
            case STANDARD: {
                for (RootDirectoryPath rootDirectoryPath : languageProvider.a(module, RootPathType.STANDARD)) {
                    nextSourcePath = FileUtility.getIdentifyingPath((TFile)rootDirectoryPath.getFile());
                    for (ModuleInfo nextToMatch : modulesToMatch) {
                        for (RootPathInfo nextRoot : nextToMatch.getStandardRootPaths()) {
                            if (!(isCaseSensitive ? nextSourcePath.equals(nextRoot.getPath()) : nextSourcePath.equalsIgnoreCase(nextRoot.getPath()))) continue;
                            return nextToMatch;
                        }
                    }
                }
                break;
            }
            case NON_STANDARD: {
                for (RootDirectoryPath rootDirectoryPath : languageProvider.a(module, RootPathType.NON_STANDARD)) {
                    nextSourcePath = FileUtility.getIdentifyingPath((TFile)rootDirectoryPath.getFile());
                    for (ModuleInfo nextToMatch : modulesToMatch) {
                        for (RootPathInfo nextRoot : nextToMatch.getNonStandardRootPaths()) {
                            if (!(isCaseSensitive ? nextSourcePath.equals(nextRoot.getPath()) : nextSourcePath.equalsIgnoreCase(nextRoot.getPath()))) continue;
                            return nextToMatch;
                        }
                    }
                }
                break;
            }
            default: {
                assert (false) : "Unhandled path type: " + (Object)((Object)languageProvider.q());
                break;
            }
        }
        if (a.isDebugEnabled()) {
            a.debug("No module/root directory matched");
            switch (languageProvider.q()) {
                case STANDARD: {
                    for (RootDirectoryPath rootDirectoryPath : languageProvider.a(module, RootPathType.STANDARD)) {
                        nextSourcePath = FileUtility.getIdentifyingPath((TFile)rootDirectoryPath.getFile());
                        a.debug("Candidate module::standard root directory: " + module.getName() + "::" + nextSourcePath);
                    }
                    for (ModuleInfo moduleInfo : modulesToMatch) {
                        for (RootPathInfo nextRoot : moduleInfo.getStandardRootPaths()) {
                            a.debug("Available module::standard root directory: " + moduleInfo.getName() + "::" + nextRoot.getPath());
                        }
                    }
                    break;
                }
                case NON_STANDARD: {
                    for (RootDirectoryPath rootDirectoryPath : languageProvider.a(module, RootPathType.NON_STANDARD)) {
                        nextSourcePath = FileUtility.getIdentifyingPath((TFile)rootDirectoryPath.getFile());
                        a.debug("Candidate module::non-standard root directory: " + module.getName() + "::" + nextSourcePath);
                    }
                    for (ModuleInfo moduleInfo : modulesToMatch) {
                        for (RootPathInfo nextRoot : moduleInfo.getNonStandardRootPaths()) {
                            a.debug("Available module::non-standard root directory: " + moduleInfo.getName() + "::" + nextRoot.getPath());
                        }
                    }
                    break;
                }
                default: {
                    assert (false) : "Unhandled path type: " + (Object)((Object)languageProvider.q());
                    break;
                }
            }
        }
        return null;
    }

    @Override
    public final OperationResultWithOutcome<SystemMappingInfo> mapSystemInfo(ISoftwareSystemProvider provider, DynamicSystemInfo sonargraphSystemInfo, List<ModuleInfo> externalProjects, IDynamicSystemProvider.ISourceToClassRootProvider classRootProvider, IDynamicSystemProvider.MappingType mappingType) {
        assert (provider != null) : "Parameter 'provider' of method 'mapSystemInfo' must not be null";
        assert (sonargraphSystemInfo != null) : "Parameter 'sonargraphSystemInfo' of method 'mapSystemInfo' must not be null";
        assert (externalProjects != null && externalProjects.size() > 0) : "Parameter 'externalProjects' of method 'mapSystemInfo' must not be empty";
        assert (classRootProvider != null) : "Parameter 'classRootProvider' of method 'mapSystemInfo' must not be null";
        assert (mappingType != null) : "Parameter 'mappingType' of method 'mapSystemInfo' must not be null";
        OperationResultWithOutcome mappingResult = new OperationResultWithOutcome("Create mapping info");
        ArrayList<ModuleMappingInfo> moduleMappings = new ArrayList<ModuleMappingInfo>();
        LinkedHashMap unmappedSonargraphModules = new LinkedHashMap();
        sonargraphSystemInfo.getModules().forEach(m2 -> {
            ModuleInfo moduleInfo = unmappedSonargraphModules.put(m2.getName(), m2);
        });
        for (ModuleInfo moduleInfo : externalProjects) {
            ModuleMappingInfo moduleMapping;
            Optional<ModuleInfo> match = this.a(moduleInfo, sonargraphSystemInfo);
            if (!match.isPresent()) {
                if (mappingType != IDynamicSystemProvider.MappingType.INCLUDE_UNMATCHED) continue;
                moduleMappings.add(this.a(moduleInfo));
                continue;
            }
            ModuleInfo sonargraphModule = match.get();
            if (unmappedSonargraphModules.remove(sonargraphModule.getName()) == null) {
                moduleMapping = this.a(moduleInfo);
                ModuleMappingInfo externalMapped = moduleMappings.stream().filter(m2 -> m2.getSonargraphModule().isPresent() && m2.getSonargraphModule().get().getName().equals(sonargraphModule.getName())).findFirst().orElse(null);
                if (externalMapped != null) {
                    String message = "Project '" + externalMapped.getExternalProject().get().getName() + "' has already been mapped to Sonargraph module '" + sonargraphModule.getName() + "'";
                    a.warn(message);
                    moduleMapping.addWarningMessage(String.valueOf(message) + ".\nPlease check the workspace definition in Sonargraph for a consistent assignment\n" + "of root directories to Sonargraph modules!\n" + "The script Core/ValidateRootDirectories.xml helps to identify misconfigured root directories.");
                }
                if (mappingType != IDynamicSystemProvider.MappingType.INCLUDE_UNMATCHED) continue;
                moduleMappings.add(moduleMapping);
                continue;
            }
            moduleMapping = new ModuleMappingInfo(sonargraphModule, moduleInfo);
            List<RootPathInfo> commonSourceRoots = this.a(moduleInfo, sonargraphModule);
            commonSourceRoots.forEach(src -> {
                RootPathMappingInfo mapped = new RootPathMappingInfo(moduleMapping, (RootPathInfo)src, EnumSet.of(RootPathMappingInfo.MappingStatus.EXTERNAL, RootPathMappingInfo.MappingStatus.INTERNAL, RootPathMappingInfo.MappingStatus.ACTIVE));
                moduleMapping.addRootPathMapping(mapped);
            });
            ArrayList<RootPathInfo> additionalSonargraphSourceRoots = new ArrayList<RootPathInfo>(sonargraphModule.getNonStandardRootPaths());
            additionalSonargraphSourceRoots.removeAll(commonSourceRoots);
            additionalSonargraphSourceRoots.forEach(src -> {
                RootPathMappingInfo mapped = new RootPathMappingInfo(moduleMapping, (RootPathInfo)src, EnumSet.of(RootPathMappingInfo.MappingStatus.INTERNAL, RootPathMappingInfo.MappingStatus.INACTIVE));
                moduleMapping.addRootPathMapping(mapped);
            });
            ArrayList<RootPathInfo> additionalExternalSourceRoots = new ArrayList<RootPathInfo>(moduleInfo.getNonStandardRootPaths());
            additionalExternalSourceRoots.removeAll(commonSourceRoots);
            ArrayList additionalExternalSrcRootMappings = new ArrayList(additionalExternalSourceRoots.size());
            additionalExternalSourceRoots.forEach(src -> {
                RootPathMappingInfo mapped = new RootPathMappingInfo(moduleMapping, (RootPathInfo)src, EnumSet.of(RootPathMappingInfo.MappingStatus.EXTERNAL, RootPathMappingInfo.MappingStatus.INACTIVE));
                additionalExternalSrcRootMappings.add(mapped);
                moduleMapping.addRootPathMapping(mapped);
            });
            OperationResultWithOutcome<List<RootPathInfo>> outputPathResult = classRootProvider.getClassRootsForSourceRoots(moduleInfo.getName(), commonSourceRoots);
            if (outputPathResult.isSuccess()) {
                OperationResultWithOutcome<List<RootPathInfo>> classRootsOfAdditionalSrcRootsResult;
                List classRoots = (List)outputPathResult.getOutcome();
                if (!additionalExternalSourceRoots.isEmpty() && (classRootsOfAdditionalSrcRootsResult = classRootProvider.getClassRootsForSourceRoots(moduleInfo.getName(), additionalExternalSourceRoots)).isSuccess()) {
                    List additionalClassRoots = (List)classRootsOfAdditionalSrcRootsResult.getOutcome();
                    int i2 = 0;
                    while (i2 < additionalClassRoots.size()) {
                        RootPathInfo additionalClsRoot = (RootPathInfo)additionalClassRoots.get(i2);
                        if (classRoots.contains(additionalClsRoot)) {
                            RootPathMappingInfo rootPath = (RootPathMappingInfo)additionalExternalSrcRootMappings.get(i2);
                            rootPath.setWarningMessage("Path is not included in Sonargraph workspace but output path is. Consider to fix workspace setup.");
                        } else {
                            moduleMapping.addRootPathMapping(new RootPathMappingInfo(moduleMapping, additionalClsRoot, EnumSet.of(RootPathMappingInfo.MappingStatus.EXTERNAL, RootPathMappingInfo.MappingStatus.INACTIVE)));
                        }
                        ++i2;
                    }
                }
                LinkedHashSet distinctClassRoots = new LinkedHashSet(classRoots);
                distinctClassRoots.forEach(cls -> moduleMapping.addRootPathMapping(new RootPathMappingInfo(moduleMapping, (RootPathInfo)cls, EnumSet.of(RootPathMappingInfo.MappingStatus.EXTERNAL, RootPathMappingInfo.MappingStatus.ACTIVE))));
            }
            moduleMappings.add(moduleMapping);
        }
        if (mappingType == IDynamicSystemProvider.MappingType.INCLUDE_UNMATCHED) {
            for (Map.Entry entry : unmappedSonargraphModules.entrySet()) {
                ModuleInfo sonargraphModule = (ModuleInfo)entry.getValue();
                ModuleMappingInfo mappingInfo = new ModuleMappingInfo(sonargraphModule, null);
                for (RootPathInfo root : sonargraphModule.getNonStandardRootPaths()) {
                    mappingInfo.addRootPathMapping(new RootPathMappingInfo(mappingInfo, root, EnumSet.of(RootPathMappingInfo.MappingStatus.INTERNAL, RootPathMappingInfo.MappingStatus.INACTIVE)));
                }
                for (RootPathInfo root : sonargraphModule.getStandardRootPaths()) {
                    mappingInfo.addRootPathMapping(new RootPathMappingInfo(mappingInfo, root, EnumSet.of(RootPathMappingInfo.MappingStatus.INTERNAL, RootPathMappingInfo.MappingStatus.INACTIVE)));
                }
                moduleMappings.add(mappingInfo);
            }
        }
        SystemMappingInfo systemMappingInfo = new SystemMappingInfo(sonargraphSystemInfo.getId(), sonargraphSystemInfo.getName(), sonargraphSystemInfo.getDescription(), moduleMappings);
        mappingResult.setOutcome((Object)systemMappingInfo);
        return mappingResult;
    }

    private ModuleMappingInfo a(ModuleInfo externalProject) {
        assert (externalProject != null) : "Parameter 'externalProject' of method 'createModuleMappingForMissingSonargraphModule' must not be null";
        ModuleMappingInfo moduleMapping = new ModuleMappingInfo(null, externalProject);
        for (RootPathInfo root : externalProject.getNonStandardRootPaths()) {
            moduleMapping.addRootPathMapping(new RootPathMappingInfo(moduleMapping, root, EnumSet.of(RootPathMappingInfo.MappingStatus.EXTERNAL, RootPathMappingInfo.MappingStatus.INACTIVE)));
        }
        for (RootPathInfo root : externalProject.getStandardRootPaths()) {
            moduleMapping.addRootPathMapping(new RootPathMappingInfo(moduleMapping, root, EnumSet.of(RootPathMappingInfo.MappingStatus.EXTERNAL, RootPathMappingInfo.MappingStatus.INACTIVE)));
        }
        return moduleMapping;
    }
}

