/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.controller.system.Z;
import com.hello2morrow.sonargraph.core.controller.system.aa;
import com.hello2morrow.sonargraph.core.controller.system.ar;
import com.hello2morrow.sonargraph.core.controller.system.z;
import com.hello2morrow.sonargraph.core.controllerinterface.system.i;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemCreator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathType;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemInfoMessageCause;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.system.PersistenceCause;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class y
extends z
implements i {
    private static final Logger c = LoggerFactory.getLogger(y.class);

    y(ISoftwareSystemCreator systemCreator, aa languageProviderAccessor, ar persistenceAccessor) {
        super(systemCreator, languageProviderAccessor, persistenceAccessor);
    }

    private OperationResultWithOutcome<SoftwareSystem> a(ISoftwareSystemCreator systemProvider, DynamicSystemInfo systemInfo, TFile systemDirectoryParent) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'initCoreSoftwareSystem' must not be null";
        assert (systemInfo != null) : "Parameter 'systemInfo' of method 'initCoreSoftwareSystem' must not be null";
        assert (systemDirectoryParent != null) : "Parameter 'systemDirectoryParent' of method 'initCoreSoftwareSystem' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create Dynamic System");
        String id = systemInfo.getId();
        String name = systemInfo.getName();
        String description = systemInfo.getDescription();
        if (id == null || id.length() == 0) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.ID_NOT_VALID, "Id not valid for system %s", new Object[]{id});
            return result;
        }
        if (!FileUtility.isWriteableDirectory((TFile)systemDirectoryParent)) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_WRITE_DIRECTORY, "Cannot create system in %s", new Object[]{systemDirectoryParent.getNormalizedPath()});
            return result;
        }
        TFile systemDirectory = FileUtility.getOrCreateDirectory((TFile)new TFile((File)systemDirectoryParent, String.valueOf(name) + ".sonargraph"), (OperationResult)result);
        if (!result.isSuccess()) {
            return result;
        }
        SoftwareSystem softwareSystem = systemProvider.createSoftwareSystem(name, id, new TFile((File)systemDirectory, "system.sonargraph"), new Properties(), false);
        if (description != null && description.length() > 0) {
            softwareSystem.setDescription(description);
        }
        result.setOutcome((Object)softwareSystem);
        return result;
    }

    private OperationResultWithOutcome<SoftwareSystem> a(DynamicSystemInfo systemInfo, TFile systemDirectory) {
        OperationResultWithOutcome<SoftwareSystem> result;
        assert (systemInfo != null) : "Parameter 'systemInfo' of method 'createSoftwareSystem' must not be null";
        assert (systemDirectory != null) : "Parameter 'systemDirectory' of method 'createSoftwareSystem' must not be null";
        OperationResultWithOutcome createDirectoryResult = new OperationResultWithOutcome("Create system parent directory");
        FileUtility.getOrCreateDirectory((TFile)systemDirectory, (OperationResult)createDirectoryResult);
        if (createDirectoryResult.isFailure()) {
            return createDirectoryResult;
        }
        TFile systemFile = new TFile((File)systemDirectory, "system.sonargraph");
        if (systemFile.canRead()) {
            result = new OperationResultWithOutcome<SoftwareSystem>("Read existing system");
            SoftwareSystem existingSystem = this.a().loadSoftwareSystem(systemDirectory, false, (OperationResult)result, EnumSet.noneOf(ISoftwareSystemProvider.OpenOption.class));
            if (!result.isFailure()) {
                systemInfo.setId(existingSystem.getId());
                for (Module mod : existingSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                    ModuleInfo modInfo = systemInfo.getModuleInfo(mod.getName());
                    if (modInfo == null) continue;
                    modInfo.setId(mod.getId());
                }
            }
        }
        if ((result = this.a(this.a(), systemInfo, systemDirectory)).isFailure()) {
            return result;
        }
        SoftwareSystem softwareSystem = (SoftwareSystem)result.getOutcome();
        assert (softwareSystem != null) : "Outcome expected";
        for (ModuleInfo moduleInfo : systemInfo.getModules()) {
            String language = moduleInfo.getLanguage();
            if (language == null || language.isEmpty()) {
                result.addError((OperationResult.IMessageCause)PersistenceCause.LANGUAGE_NOT_DEFINED, "No language defined for module '" + moduleInfo.getName() + "'", new Object[0]);
                continue;
            }
            if (!this.getInfoProviders().containsKey(language)) {
                result.addError((OperationResult.IMessageCause)PersistenceCause.LANGUAGE_NOT_SUPPORTED, "Language '" + language + "' of module '" + moduleInfo.getName() + "' is not supported", new Object[0]);
                continue;
            }
            OperationResultWithOutcome<Module> createModuleResult = this.a().createModule(softwareSystem, language, moduleInfo.getModuleType(), moduleInfo.getId(), moduleInfo.getName(), moduleInfo.getDescription());
            if (createModuleResult.isFailure()) {
                result.addMessagesFrom(createModuleResult);
                continue;
            }
            Module module = (Module)createModuleResult.getOutcome();
            assert (module != null) : "Module must not be null!";
            if (module.hasIssues(new IIssueId[0])) {
                result.addWarning((OperationResult.IMessageCause)PersistenceCause.ISSUES_CREATING_MODULE, "Creation of module '" + module.getName() + "' has led to issues.", new Object[0]);
            }
            for (ModuleInfo nextDependency : moduleInfo.getDependsUpon()) {
                WorkspaceDependency.IWorkspaceDependencyType workspaceDependencyType = this.getInfoProviders().get(language).getWorkspaceDependencyType(nextDependency.getModuleType());
                if (workspaceDependencyType == null) {
                    result.addError((OperationResult.IMessageCause)PersistenceCause.DEPENDENCY_TYPE_NOT_SUPPORTED, "No dependency type registered for " + nextDependency.getModuleType(), new Object[0]);
                    continue;
                }
                String id = nextDependency.getId();
                String name = nextDependency.getName();
                if (name == null || name.length() == 0) {
                    name = id;
                }
                WorkspaceDependency.AdditionalDependencyData dependencyData = this.getInfoProviders().get(language).getAdditionalDependencyData(nextDependency, workspaceDependencyType);
                OperationResultWithOutcome<WorkspaceDependency> dependencyResult = this.a().createWorkspaceDependency(softwareSystem, language, module.getId(), id, name, workspaceDependencyType.getStandardName(), dependencyData);
                if (dependencyResult.isFailure()) {
                    result.addMessagesFrom(dependencyResult);
                    continue;
                }
                WorkspaceDependency dependency = (WorkspaceDependency)dependencyResult.getOutcome();
                assert (dependency != null) : "created workspace dependency must not be null";
                module.addOutgoingWorkspaceDependency(dependency);
            }
            for (RootPathInfo nextRootPath : moduleInfo.getStandardRootPaths()) {
                TFile path = new TFile(nextRootPath.getPath());
                RootDirectoryPath nextRootDirectoryPath = module.createRootDirectoryPath(softwareSystem, module, path);
                if (module.getUniqueChild(new NameFilter(nextRootPath.getPath()), nextRootDirectoryPath.getClass()) != null) {
                    result.addWarning((OperationResult.IMessageCause)PersistenceCause.DUPLICATE_ROOT_DIRECTORY, "Ignored duplicate root directory '" + nextRootDirectoryPath.getName() + "' for module '" + moduleInfo.getName() + "'", new Object[0]);
                    continue;
                }
                module.addChild(nextRootDirectoryPath);
            }
            this.getInfoProviders().get(language).addAdditionalModuleInfo(this.a().getInstallation(), softwareSystem, module, moduleInfo, systemInfo, result);
        }
        return result;
    }

    @Override
    public OperationResultWithOutcome<TFile> a(DynamicSystemInfo system, TFile targetDir, TFile qualityModelFile) {
        assert (system != null) : "Parameter 'system' of method 'createSoftwareSystem' must not be null";
        assert (targetDir != null) : "Parameter 'targetDir' of method 'createSoftwareSystem' must not be null";
        OperationResultWithOutcome<SoftwareSystem> creation = this.a(system, targetDir);
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create dynamic system");
        if (creation.isFailure()) {
            result.addMessagesFrom(creation);
            return result;
        }
        assert (creation.getOutcome() != null) : "No system available!";
        SoftwareSystem softwareSystem = (SoftwareSystem)creation.getOutcome();
        OperationResult save = this.c().a(softwareSystem.getUsedLanguages()).save(softwareSystem, this.b().a());
        result.addMessagesFrom(save);
        if (result.isFailure()) {
            return result;
        }
        TFile systemDir = softwareSystem.getUniqueExistingChild(Files.class).getSystemDirectory().getDirectoryFile();
        if (qualityModelFile != null) {
            FileUtility.copyDirectory((TFile)qualityModelFile, (TFile)systemDir, (boolean)false, (OperationResult)result);
        }
        result.setOutcome((Object)systemDir);
        return result;
    }

    private void a(Z languageProvider, SoftwareSystem softwareSystem, Module module, ModuleInfo matchedModuleInfo) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'sync' must not be null";
        assert (module != null) : "Parameter 'module' of method 'sync' must not be null";
        assert (matchedModuleInfo != null) : "Parameter 'matchedModuleInfo' of method 'sync' must not be null";
        ArrayList<RootPathInfo> toBeCreatedStandardRootPaths = languageProvider.a(RootPathType.STANDARD) ? new ArrayList<RootPathInfo>(matchedModuleInfo.getStandardRootPaths()) : new ArrayList();
        for (RootDirectoryPath rootDirectoryPath : languageProvider.a(module, RootPathType.STANDARD)) {
            String standardPath = FileUtility.getIdentifyingPath((TFile)rootDirectoryPath.getFile());
            boolean found = false;
            for (RootPathInfo nextRootPathInfo : matchedModuleInfo.getStandardRootPaths()) {
                if (!FileUtility.areEqual((String)standardPath, (String)nextRootPathInfo.getPath())) continue;
                toBeCreatedStandardRootPaths.remove(nextRootPathInfo);
                found = true;
                break;
            }
            if (found) continue;
            rootDirectoryPath.setEnabled(false);
        }
        for (RootPathInfo rootPathInfo : toBeCreatedStandardRootPaths) {
            RootDirectoryPath nextCreated = module.createRootDirectoryPath(softwareSystem, module, new TFile(rootPathInfo.getPath()));
            module.addChild(nextCreated);
        }
        ArrayList<RootPathInfo> arrayList = languageProvider.a(RootPathType.NON_STANDARD) ? new ArrayList<RootPathInfo>(matchedModuleInfo.getNonStandardRootPaths()) : new ArrayList();
        for (RootDirectoryPath rootDirectoryPath : languageProvider.a(module, RootPathType.NON_STANDARD)) {
            String nonStandardPath = FileUtility.getIdentifyingPath((TFile)rootDirectoryPath.getFile());
            boolean found = false;
            for (RootPathInfo nextRootPathInfo : matchedModuleInfo.getNonStandardRootPaths()) {
                if (!FileUtility.areEqual((String)nonStandardPath, (String)nextRootPathInfo.getPath())) continue;
                arrayList.remove(nextRootPathInfo);
                found = true;
                break;
            }
            if (found) continue;
            rootDirectoryPath.setEnabled(false);
        }
        for (RootPathInfo rootPathInfo : arrayList) {
            RootDirectoryPath nextCreated = module.createNonStandardRootDirectoryPath(softwareSystem, module, new TFile(rootPathInfo.getPath()));
            module.addChild(nextCreated);
        }
    }

    public OperationResult a(IWorkerContext workerContext, List<ModuleInfo> moduleInfo, SoftwareSystem softwareSystem) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'synchronizeModules' must not be null";
        assert (moduleInfo != null) : "Parameter 'moduleInfo' of method 'synchronizeModules' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'synchronizeModules' must not be null";
        c.debug("Synchronize modules");
        OperationResult result = new OperationResult("Synchronize modules");
        aa languageProviderAccessor = this.b();
        ArrayList<ModuleInfo> modulesToMatch = new ArrayList<ModuleInfo>(moduleInfo);
        Workspace workspace = softwareSystem.getUniqueExistingChild(Workspace.class);
        List<Module> existingModulesToBeDisabled = workspace.getChildren(Module.class);
        for (Module nextExistingModule : workspace.getChildren(Module.class)) {
            Language nextLanguage = nextExistingModule.getLanguage();
            Z z2 = languageProviderAccessor.b(nextLanguage);
            if (z2 != null) {
                ModuleInfo matchedModuleInfo = this.a(z2, nextExistingModule, modulesToMatch);
                if (matchedModuleInfo != null) {
                    this.a(z2, softwareSystem, nextExistingModule, matchedModuleInfo);
                    modulesToMatch.remove(matchedModuleInfo);
                    existingModulesToBeDisabled.remove(nextExistingModule);
                } else {
                    result.addWarning((OperationResult.IMessageCause)SystemInfoMessageCause.NO_MATCHING_MODULE_FOUND, "Cannot find matching module info for module '%s'", new Object[]{nextExistingModule.getName()});
                }
            } else {
                result.addWarning((OperationResult.IMessageCause)SystemInfoMessageCause.LANGUAGE_PROVIDER_NOT_FOUND, "Cannot find language provider for '%s'", new Object[]{nextLanguage.getStandardName()});
            }
            if (modulesToMatch.isEmpty()) break;
        }
        for (Module nextExistingModuleToBeDisabled : existingModulesToBeDisabled) {
            RootDirectoryPath nextOriginal;
            Z languageProvider = languageProviderAccessor.b(nextExistingModuleToBeDisabled.getLanguage());
            if (languageProvider == null) continue;
            for (RootDirectoryPath rootDirectoryPath : languageProvider.a(nextExistingModuleToBeDisabled, RootPathType.STANDARD)) {
                nextOriginal = rootDirectoryPath.getOriginal();
                nextOriginal.setEnabled(false);
                if (rootDirectoryPath == nextOriginal) continue;
                rootDirectoryPath.setEnabled(false);
            }
            for (RootDirectoryPath rootDirectoryPath : languageProvider.a(nextExistingModuleToBeDisabled, RootPathType.NON_STANDARD)) {
                nextOriginal = rootDirectoryPath.getOriginal();
                nextOriginal.setEnabled(false);
                if (rootDirectoryPath == nextOriginal) continue;
                rootDirectoryPath.setEnabled(false);
            }
        }
        c.debug("Synchronize modules - done");
        return result;
    }
}

