/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.core.controller.system.O;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class v {
    private v() {
    }

    private static void a(List<Module> modules, Module module) {
        assert (modules != null) : "Parameter 'modules' of method 'addModuleToOrderedList' must not be null";
        assert (module != null) : "Parameter 'module' of method 'addModuleToOrderedList' must not be null";
        boolean addedReferencedModule = false;
        modules.add(module);
        for (Module referencedModule : module.getReferencedToModules(false)) {
            if (modules.contains(referencedModule)) continue;
            v.a(modules, referencedModule);
            addedReferencedModule = true;
        }
        if (addedReferencedModule) {
            modules.remove(module);
            modules.add(module);
        }
    }

    private static void a(List<O> deltaDetectors) {
        assert (deltaDetectors != null && !deltaDetectors.isEmpty()) : "Parameter 'deltaDetectors' of method 'orderDeltaDetectors' must not be empty";
        final ArrayList<Module> orderedModuleList = new ArrayList<Module>(deltaDetectors.size());
        for (O next : deltaDetectors) {
            Module nextModule = next.c();
            if (orderedModuleList.contains(nextModule)) continue;
            v.a(orderedModuleList, nextModule);
        }
        Collections.sort(deltaDetectors, new Comparator<O>(){

            public int a(O d1, O d2) {
                if (!a && d1 == null) {
                    throw new AssertionError((Object)"Parameter 'd1' of method 'compare' must not be null");
                }
                if (!a && d2 == null) {
                    throw new AssertionError((Object)"Parameter 'd2' of method 'compare' must not be null");
                }
                Module m1 = d1.c();
                Module m2 = d2.c();
                return orderedModuleList.indexOf(m1) - orderedModuleList.indexOf(m2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((O)object, (O)object2);
            }
        });
    }

    public static List<ModuleDelta> a(IWorkerContext workerContext, Map<Module, O> moduleToDeltaDetector, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'performDeltaDetection' must not be null";
        assert (moduleToDeltaDetector != null && !moduleToDeltaDetector.isEmpty()) : "Parameter 'moduleToDeltaDetector' of method 'detectDelta' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'performDeltaDetection' must not be null";
        ArrayList<ModuleDelta> moduleDeltas = new ArrayList<ModuleDelta>(moduleToDeltaDetector.size());
        ArrayList<O> detectorList = new ArrayList<O>();
        workerContext.setNumberOfSteps(2 * moduleToDeltaDetector.size());
        for (Map.Entry<Module, O> nextEntry : moduleToDeltaDetector.entrySet()) {
            Module nextModule = nextEntry.getKey();
            O nextDetector = nextEntry.getValue();
            workerContext.beginSubTask(String.format("Synchronizing of module '%s'", nextModule.getShortName()));
            workerContext.setNumberOfSteps(1);
            try {
                try {
                    nextDetector.a(result);
                    detectorList.add(nextDetector);
                }
                catch (Throwable t2) {
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_DETECT_DELTA, t2);
                    workerContext.endStep();
                    workerContext.endSubTask();
                    continue;
                }
            }
            catch (Throwable throwable) {
                workerContext.endStep();
                workerContext.endSubTask();
                throw throwable;
            }
            workerContext.endStep();
            workerContext.endSubTask();
        }
        if (result.isFailure()) {
            return moduleDeltas;
        }
        v.a(detectorList);
        boolean changesDetected = false;
        for (O detector : detectorList) {
            ModuleDelta delta = null;
            workerContext.beginSubTask(String.format("Detecting delta of module '%s'", detector.c().getShortName()));
            try {
                try {
                    delta = detector.a(workerContext, result, changesDetected);
                    if (delta != null && !delta.isEmpty()) {
                        moduleDeltas.add(delta);
                        changesDetected = true;
                    }
                }
                catch (Throwable t3) {
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_DETECT_DELTA, t3);
                    workerContext.endSubTask();
                    continue;
                }
            }
            catch (Throwable throwable) {
                workerContext.endSubTask();
                throw throwable;
            }
            workerContext.endSubTask();
        }
        return moduleDeltas;
    }
}

