/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.script;

import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.javapg.runtime.lexer.base.b;
import com.hello2morrow.sonargraph.core.controller.system.base.e;
import com.hello2morrow.sonargraph.core.controller.system.script.ScriptFormatterLexer;
import com.hello2morrow.sonargraph.core.controller.system.script.ScriptLexer;
import com.hello2morrow.sonargraph.core.model.common.FormatterOptions;
import com.hello2morrow.sonargraph.core.model.element.BlockedFromGroovyScript;
import java.io.IOException;
import java.io.StringReader;

@BlockedFromGroovyScript
public final class ScriptFormatter
extends e {
    private static final Pair<Integer, Integer> L_R_BRACES = new Pair((Object)112, (Object)113);

    public ScriptFormatter() {
        super(L_R_BRACES);
    }

    public ScriptFormatter(FormatterOptions options) {
        super(options, L_R_BRACES);
    }

    @Override
    protected b getLexer() {
        return new ScriptLexer();
    }

    @Override
    public String format(String textToFormat) {
        assert (textToFormat != null) : "Parameter 'textToFormat' of method 'format' must not be null";
        if (textToFormat.length() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        ScriptFormatterLexer lexer = new ScriptFormatterLexer();
        lexer.assignInput(new StringReader(textToFormat), "String Lexer");
        try {
            int nextToken;
            boolean singleLineComment = false;
            int indentationLevel = 0;
            int previousToken = 85;
            while ((nextToken = lexer.nextToken()) != 0) {
                String lexeme = lexer.getLexeme();
                switch (nextToken) {
                    case 82: {
                        result.append(lexeme);
                        break;
                    }
                    case 83: {
                        result.append(lexeme);
                        result.append(this.createIndentation(indentationLevel));
                        break;
                    }
                    case 85: {
                        if (previousToken == 85 && !this.getOptions().isIndentEmptyLines()) {
                            this.clearLine(result);
                        }
                        int numberOfNewlines = StringUtility.countLines((String)lexeme) - 1;
                        this.clearWhitespace(result);
                        result.append(this.getOptions().getLineBreak());
                        int i2 = 2;
                        while (i2 <= numberOfNewlines) {
                            if (this.getOptions().isIndentEmptyLines()) {
                                result.append(this.createIndentation(indentationLevel));
                            }
                            result.append(this.getOptions().getLineBreak());
                            ++i2;
                        }
                        result.append(this.createIndentation(indentationLevel));
                        break;
                    }
                    case 84: {
                        if (previousToken == 85) break;
                        result.append(" ");
                        break;
                    }
                    case 40: 
                    case 110: {
                        result.append(lexeme);
                        ++indentationLevel;
                        break;
                    }
                    case 86: {
                        result.append(lexeme);
                        ++indentationLevel;
                        break;
                    }
                    case 87: {
                        result.append(lexeme);
                        --indentationLevel;
                        break;
                    }
                    case 112: {
                        if (this.getOptions().getBracesStart() == FormatterOptions.BracesPlacement.SAME_LINE && previousToken == 85) {
                            result.setLength(result.lastIndexOf(this.getOptions().getLineBreak()));
                            this.addBlankIfNecessary(result);
                        } else if (this.getOptions().getBracesStart() == FormatterOptions.BracesPlacement.NEXT_LINE && previousToken != 85) {
                            this.clearWhitespace(result);
                            result.append(this.getOptions().getLineBreak());
                            previousToken = 85;
                            result.append(this.createIndentation(indentationLevel));
                        }
                        if (previousToken != 85) {
                            this.addBlankIfNecessary(result);
                        }
                        result.append(lexeme);
                        ++indentationLevel;
                        break;
                    }
                    case 111: 
                    case 114: {
                        result.append(lexeme);
                        --indentationLevel;
                        break;
                    }
                    case 113: {
                        --indentationLevel;
                        if (previousToken == 85) {
                            this.clearLine(result);
                            result.append(this.createIndentation(indentationLevel));
                        }
                        if (this.getOptions().getBracesEnd() == FormatterOptions.BracesPlacement.SAME_LINE && previousToken == 85 && !singleLineComment) {
                            result.setLength(result.lastIndexOf(this.getOptions().getLineBreak()));
                            this.addBlankIfNecessary(result);
                        } else if (this.getOptions().getBracesEnd() == FormatterOptions.BracesPlacement.NEXT_LINE && previousToken != 85) {
                            this.clearWhitespace(result);
                            result.append(this.getOptions().getLineBreak());
                            result.append(this.createIndentation(indentationLevel));
                        } else if (previousToken == 112) {
                            this.addBlankIfNecessary(result);
                        }
                        result.append(lexeme);
                        break;
                    }
                    default: {
                        result.append(lexeme);
                    }
                }
                if (nextToken == 83) {
                    previousToken = 85;
                    singleLineComment = true;
                    continue;
                }
                if (nextToken == 84) continue;
                previousToken = nextToken;
                singleLineComment = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!textToFormat.endsWith(StringUtility.DEFAULT_LINE_SEPARATOR)) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }
}

