/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.script;

import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.api.ITypeAccess;
import com.hello2morrow.sonargraph.core.api.controller.ICoreVisitor;
import com.hello2morrow.sonargraph.core.api.model.ElementAccess;
import com.hello2morrow.sonargraph.core.api.model.FieldAccess;
import com.hello2morrow.sonargraph.core.api.model.MethodAccess;
import com.hello2morrow.sonargraph.core.api.model.RoutineAccess;
import com.hello2morrow.sonargraph.core.api.model.TypeAccess;
import com.hello2morrow.sonargraph.core.api.script.controller.IScriptCoreAccess;
import com.hello2morrow.sonargraph.core.api.script.model.MetricIdAccess;
import com.hello2morrow.sonargraph.core.api.script.model.SearchResult;
import com.hello2morrow.sonargraph.core.controller.system.api.AbstractCoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.api.CoreFactoryVisitor;
import com.hello2morrow.sonargraph.core.controller.system.api.CoreVisitor;
import com.hello2morrow.sonargraph.core.controller.system.script.internal.a;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.programming.IField;
import com.hello2morrow.sonargraph.core.model.programming.IMethod;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.script.IMetricIdProvider;
import com.hello2morrow.sonargraph.core.model.script.MetricSorting;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import groovy.lang.Closure;

public class CoreAccess
extends AbstractCoreAccess
implements IScriptCoreAccess {
    private final IMetricIdProvider m_metricIdProvider;
    private final a m_api;

    public CoreAccess(Installation installation, SoftwareSystem softwareSystem, IMetricIdProvider metricIdProvider, a api) {
        super(softwareSystem);
        assert (api != null) : "Parameter 'api' of method 'SystemAccess' must not be null";
        this.m_api = api;
        String coreAccessVariable = "coreAccess";
        this.m_metricIdProvider = metricIdProvider;
        if (!api.b("coreAccess")) {
            this.m_factory = new CoreFactoryVisitor(installation, softwareSystem);
            api.a("com.hello2morrow.sonargraph.core.api.controller");
            api.a("com.hello2morrow.sonargraph.core.api.model");
            api.a("com.hello2morrow.sonargraph.core.api.model.architecture");
            api.a("com.hello2morrow.sonargraph.core.api.script.controller");
            api.a("com.hello2morrow.sonargraph.core.api.script.model");
            api.a("com.hello2morrow.sonargraph.api");
            api.a("com.hello2morrow.sonargraph.api.architecture");
            api.a("coreAccess", this, IScriptCoreAccess.class);
            api.c(ParserDependency.class.getName());
            api.c(IParserDependencyType.class.getName());
        }
    }

    @Override
    public final MetricIdAccess getOrCreateMetricId(String id, String presentationName, String description, boolean isFloat, String ... categoryIds) {
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'id' must not be empty");
        }
        if (presentationName == null) {
            throw new IllegalArgumentException("Parameter 'presentationName' must not be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Parameter 'description' must not be null");
        }
        return new MetricIdAccess(this.m_metricIdProvider.getOrCreateScriptMetricId(this.m_api.a(), id, presentationName, description, isFloat, null, null, MetricSorting.HIGHER_WORSE, 0.0, Double.POSITIVE_INFINITY, categoryIds));
    }

    @Override
    public final MetricIdAccess getOrCreateMetricId(String id, String presentationName, String description, boolean isFloat, Number lowerThreshold, Number upperThreshold, String ... categoryIds) {
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'id' must not be empty");
        }
        if (presentationName == null) {
            throw new IllegalArgumentException("Parameter 'presentationName' must not be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Parameter 'description' must not be null");
        }
        if (lowerThreshold == null && upperThreshold != null || lowerThreshold != null && upperThreshold == null) {
            throw new IllegalArgumentException("Parameters 'lowerThreshold' and 'upperThreshold' must either both be null or both non-null");
        }
        return new MetricIdAccess(this.m_metricIdProvider.getOrCreateScriptMetricId(this.m_api.a(), id, presentationName, description, isFloat, lowerThreshold, upperThreshold, MetricSorting.HIGHER_WORSE, 0.0, Double.POSITIVE_INFINITY, categoryIds));
    }

    @Override
    public MetricIdAccess getOrCreateMetricId(String id, String presentationName, String description, boolean isFloat, Number lowerThreshold, Number upperThreshold, MetricSorting sorting, double minValue, double maxValue, String ... categoryIds) {
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'id' must not be empty");
        }
        if (presentationName == null) {
            throw new IllegalArgumentException("Parameter 'presentationName' must not be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Parameter 'description' must not be null");
        }
        return new MetricIdAccess(this.m_metricIdProvider.getOrCreateScriptMetricId(this.m_api.a(), id, presentationName, description, isFloat, lowerThreshold, upperThreshold, sorting, minValue, maxValue, categoryIds));
    }

    @Override
    public final MetricIdAccess getOrCreateMetricId(String id, String presentationName, String description, boolean isFloat, Number lowerThreshold, Number upperThreshold, Number bestValue, Number worstValue, String ... categoryIds) {
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'id' must not be empty");
        }
        if (presentationName == null) {
            throw new IllegalArgumentException("Parameter 'presentationName' must not be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Parameter 'description' must not be null");
        }
        if (lowerThreshold == null && upperThreshold != null || lowerThreshold != null && upperThreshold == null) {
            throw new IllegalArgumentException("Parameters 'lowerThreshold' and 'upperThreshold' must either both be null or both non-null");
        }
        return new MetricIdAccess(this.m_metricIdProvider.getOrCreateScriptMetricId(this.m_api.a(), id, presentationName, description, isFloat, lowerThreshold, upperThreshold, MetricSorting.HIGHER_WORSE, 0.0, Double.POSITIVE_INFINITY, categoryIds));
    }

    @Deprecated
    public final void visitSystemNamespaces(ICoreVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Parameter 'visitor' must not be null");
        }
        ((SoftwareSystem)this.m_element).getUniqueExistingChild(LogicalSystemNamespaces.class).accept((CoreVisitor)visitor);
    }

    @Deprecated
    public final void visitModuleNamespaces(ICoreVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Parameter 'visitor' must not be null");
        }
        ((SoftwareSystem)this.m_element).getUniqueExistingChild(LogicalModuleNamespaces.class).accept((CoreVisitor)visitor);
    }

    private SearchResult<TypeAccess> internalFindTypes(NamedElement searchRoot, Closure<Boolean> predicate, int limit) {
        assert (searchRoot != null) : "Parameter 'searchRoot' of method 'internalFindTypes' must not be null";
        assert (predicate != null) : "Parameter 'predicate' of method 'internalFindTypes' must not be null";
        SearchVisitor visitor = new SearchVisitor(IType.class, predicate, limit, true);
        searchRoot.accept(visitor);
        return visitor.getResult();
    }

    public SearchResult<MethodAccess> findMethods(Closure<Boolean> predicate, int limit) {
        if (predicate == null) {
            throw new IllegalArgumentException("Parameter 'predicate' must not be null");
        }
        return this.internalFindMethods(((SoftwareSystem)this.m_element).getUniqueExistingChild(Workspace.class), predicate, limit);
    }

    public SearchResult<MethodAccess> findMethods(ElementAccess<? extends NamedElement> searchRoot, Closure<Boolean> predicate, int limit) {
        if (searchRoot == null) {
            throw new IllegalArgumentException("Parameter 'searchRoot' must not be null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("Parameter 'predicate' must not be null");
        }
        return this.internalFindMethods(searchRoot.getElement(), predicate, limit);
    }

    private SearchResult<MethodAccess> internalFindMethods(NamedElement searchRoot, Closure<Boolean> predicate, int limit) {
        assert (searchRoot != null) : "Parameter 'searchRoot' of method 'internalFindMethods' must not be null";
        assert (predicate != null) : "Parameter 'predicate' of method 'internalFindMethods' must not be null";
        SearchVisitor visitor = new SearchVisitor(IMethod.class, predicate, limit, true);
        searchRoot.accept(visitor);
        return visitor.getResult();
    }

    public SearchResult<RoutineAccess> findRoutines(Closure<Boolean> predicate, int limit) {
        if (predicate == null) {
            throw new IllegalArgumentException("Parameter 'predicate' must not be null");
        }
        return this.internalFindRoutines(((SoftwareSystem)this.m_element).getUniqueExistingChild(Workspace.class), predicate, limit);
    }

    public SearchResult<RoutineAccess> findRoutines(ElementAccess<? extends NamedElement> searchRoot, Closure<Boolean> predicate, int limit) {
        if (searchRoot == null) {
            throw new IllegalArgumentException("Parameter 'searchRoot' must not be null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("Parameter 'predicate' must not be null");
        }
        return this.internalFindRoutines(searchRoot.getElement(), predicate, limit);
    }

    private SearchResult<RoutineAccess> internalFindRoutines(NamedElement root, Closure<Boolean> predicate, int limit) {
        assert (root != null) : "Parameter 'root' of method 'internalFindRoutines' must not be null";
        assert (predicate != null) : "Parameter 'predicate' of method 'internalFindRoutines' must not be null";
        SearchVisitor visitor = new SearchVisitor(IRoutine.class, predicate, limit, true);
        root.accept(visitor);
        return visitor.getResult();
    }

    public SearchResult<FieldAccess> findFields(Closure<Boolean> predicate, int limit) {
        if (predicate == null) {
            throw new IllegalArgumentException("Parameter 'predicate' must not be null");
        }
        return this.internalFindFields(((SoftwareSystem)this.m_element).getUniqueExistingChild(Workspace.class), predicate, limit);
    }

    public SearchResult<FieldAccess> findFields(ElementAccess<? extends NamedElement> searchRoot, Closure<Boolean> predicate, int limit) {
        if (searchRoot == null) {
            throw new IllegalArgumentException("Parameter 'searchRoot' must not be null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("Parameter 'predicate' must not be null");
        }
        return this.internalFindFields(searchRoot.getElement(), predicate, limit);
    }

    private SearchResult<FieldAccess> internalFindFields(NamedElement root, Closure<Boolean> predicate, int limit) {
        assert (root != null) : "Parameter 'root' of method 'internalFindFields' must not be null";
        assert (predicate != null) : "Parameter 'predicate' of method 'internalFindFields' must not be null";
        SearchVisitor visitor = new SearchVisitor(IField.class, predicate, limit, false);
        root.accept(visitor);
        return visitor.getResult();
    }

    public SearchResult<TypeAccess> findTypes(Closure<Boolean> predicate, int limit) {
        if (predicate == null) {
            throw new IllegalArgumentException("Parameter 'predicate' must not be null");
        }
        return this.internalFindTypes(((SoftwareSystem)this.m_element).getUniqueExistingChild(Workspace.class), predicate, limit);
    }

    @Override
    public <T extends INamedElementAccess> SearchResult<? extends ITypeAccess> findTypes(T searchRoot, Closure<Boolean> predicate, int limit) {
        if (searchRoot == null) {
            throw new IllegalArgumentException("Parameter 'searchRoot' must not be null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("Parameter 'predicate' must not be null");
        }
        return this.internalFindTypes((NamedElement)((ElementAccess)searchRoot).getElement(), predicate, limit);
    }

    protected class SearchVisitor<T extends ElementAccess<? extends NamedElement>>
    extends NamedElementVisitor {
        private final Class<?> m_classToBeMatched;
        private final SearchResult<T> m_result = new SearchResult();
        private final Closure<Boolean> m_predicate;
        private final int m_limit;
        private final boolean m_recursive;

        protected SearchVisitor(Class<?> classToBeMatched, Closure<Boolean> predicate, int limit, boolean recursive) {
            this.m_classToBeMatched = classToBeMatched;
            this.m_predicate = predicate;
            this.m_limit = limit;
            this.m_recursive = recursive;
        }

        @Override
        public boolean done() {
            return this.m_limit > 0 && this.m_result.size() >= this.m_limit;
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            if (this.m_classToBeMatched.isAssignableFrom(element.getClass())) {
                ElementAccess<? extends NamedElement> accessObject = CoreAccess.this.m_factory.createAccessObject(element);
                if (((Boolean)this.m_predicate.call(accessObject)).booleanValue()) {
                    this.m_result.addMatch(accessObject);
                }
                if (this.m_recursive) {
                    this.visitChildrenOf(element);
                }
            } else {
                this.visitChildrenOf(element);
            }
        }

        public SearchResult<T> getResult() {
            return this.m_result;
        }
    }
}

