/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.h;
import com.hello2morrow.sonargraph.core.controllerinterface.system.f;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.RegexValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.author.SourceFilesToAuthorsInfo;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemSettingsDirectory;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class q
extends Extension
implements f {
    private static final Logger b = LoggerFactory.getLogger(q.class);
    private static final String c = "$Authors$";
    private final SoftwareSystem d;
    private final Map<String, String> e = new THashMap();
    private final Set<String> f = new THashSet();
    private boolean g = false;

    public q(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'AuthorsExtension' must not be null";
        this.d = softwareSystem;
        Properties props = new Properties();
        TFile in = this.a(new OperationResult("Delete empty directory"), true);
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new TFileInputStream((File)in)));){
                props.load(reader);
                String authorsList = props.getProperty(c);
                if (authorsList != null) {
                    String[] authors = authorsList.split(",");
                    Arrays.stream(authors).forEach(a2 -> {
                        boolean bl2 = this.f.add((String)a2);
                    });
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        if (entry.getKey().equals(c)) continue;
                        this.e.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e2) {
            b.error("Problem reading from " + in.getAbsolutePath(), (Throwable)e2);
        }
    }

    private TFile a(OperationResult result, boolean removeEmptyDirectory) {
        String[] files;
        assert (result != null) : "Parameter 'result' of method 'getDeveloperPropertiesFile' must not be null";
        SoftwareSystemSettingsDirectory settingsDirectory = this.d.getUniqueExistingChild(Files.class).getSoftwareSystemSettingsDirectory();
        TFile settingsDir = settingsDirectory.getFile();
        if (removeEmptyDirectory && settingsDir.exists() && (files = settingsDir.list()) != null && files.length == 0) {
            try {
                settingsDir.rm();
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE_DIRECTORY, (Throwable)ex);
            }
        }
        return new TFile((File)settingsDir, "Developers.properties");
    }

    @Override
    public synchronized void a(String assignee) {
        assert (assignee != null && assignee.length() > 0) : "Parameter 'assignee' of method 'addAuthorIfNeeded' must not be empty";
        if (this.f.contains(assignee)) {
            return;
        }
        if (this.e.get(assignee) != null) {
            return;
        }
        this.f.add(assignee);
        this.a();
    }

    @Override
    public synchronized String getAuthorNameFromPotentialAlias(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getAuthorNameFromPotentialAlias' must not be empty";
        if (this.f.contains(name)) {
            return name;
        }
        String result = this.e.get(name);
        if (result == null) {
            this.f.add(name);
            result = name;
            this.g = true;
        }
        return result;
    }

    @Override
    public synchronized Collection<String> getAuthors() {
        ArrayList<String> authors = new ArrayList<String>(this.f);
        authors.sort((s1, s2) -> s1.compareTo((String)s2));
        return authors;
    }

    @Override
    public synchronized Map<String, String> getAliasMap() {
        return Collections.unmodifiableMap(this.e);
    }

    private OperationResult a() {
        OperationResult result = new OperationResult("Write developer info");
        SoftwareSystemSettingsDirectory settingsDirectory = this.d.getUniqueExistingChild(Files.class).getSoftwareSystemSettingsDirectory();
        settingsDirectory.enforceExistence(result);
        if (result.isFailure()) {
            return result;
        }
        TFile out = this.a(result, false);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter((File)out));){
                Properties props = new Properties();
                props.put(c, this.f.stream().collect(Collectors.joining(",")));
                props.putAll(this.e);
                props.store(writer, "Manages developer names and aliases");
                this.g = false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            b.error("Problem writing to " + out.getAbsolutePath(), (Throwable)e2);
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e2);
            this.g = true;
        }
        return result;
    }

    @Override
    public synchronized void a(OperationResult result, Map<String, String> aliases, Collection<String> authors) {
        assert (aliases != null) : "Parameter 'newMap' of method 'updateAliasMap' must not be null";
        assert (authors != null) : "Parameter 'authors' of method 'updateAuthorsAndAliases' must not be null";
        HashSet<AnalyzerGroup> group = new HashSet<AnalyzerGroup>();
        group.add(AnalyzerGroup.SCM);
        h analyzerExtension = this.d.getExtension(h.class);
        Set<AnalyzerGroup> toRestart = analyzerExtension.a(group, ResetMode.ALL);
        this.e.clear();
        this.e.putAll(aliases);
        this.f.clear();
        this.f.addAll(authors);
        result.addMessagesFrom(this.a());
        analyzerExtension.a(toRestart);
    }

    @Override
    public synchronized void scmDataAnalysisFinished() {
        if (this.g) {
            this.a();
        }
    }

    @Override
    public ITextValidator getAuthorNameValidator(final List<String> existingNames) {
        assert (existingNames != null) : "Parameter 'existingNames' of method 'getAuthorNameValidator' must not be null";
        return new RegexValidator("(\\p{Alpha}|\\p{Digit}|\\-|\\.|_)+( (\\p{Alpha}|\\p{Digit}|\\-|_|\\.)+)*"){

            @Override
            public ValidationResult isValid(String initialInput, String newInput) {
                ValidationResult result = super.isValid(initialInput, newInput);
                if (!result.isFailure() && existingNames.contains(newInput)) {
                    result.addError("Name is already in use");
                }
                return result;
            }
        };
    }

    @Override
    public SourceFilesToAuthorsInfo getSourceFilesToAuthors() {
        g analyzerExtension = this.d.getExtension(g.class);
        AnalyzerResult result = analyzerExtension.d(CoreAnalyzerId.SCM_METRICS);
        if (result != null && result.getState() == AnalyzerState.FINISHED) {
            return result.getUniqueChild(SourceFilesToAuthorsInfo.class);
        }
        return null;
    }
}

