/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.controller.system.aZ;
import com.hello2morrow.sonargraph.core.controller.system.analysis.a;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.controller.system.architecture.AutoCompletionProposalsCollector;
import com.hello2morrow.sonargraph.core.controller.system.architecture.f;
import com.hello2morrow.sonargraph.core.controller.system.architecture.m;
import com.hello2morrow.sonargraph.core.controller.system.architecture.n;
import com.hello2morrow.sonargraph.core.controller.system.architecture.r;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.ArchitectureCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.architecture.AggregatedDeprecationInfo;
import com.hello2morrow.sonargraph.core.model.architecture.AggregatedViolationInfo;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElementsInfo;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssue;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.ElementAssignmentInfo;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureDefinitionElement;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedElements;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedExternal;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedInternal;
import com.hello2morrow.sonargraph.core.model.common.AutoCompletionProposal;
import com.hello2morrow.sonargraph.core.model.common.FormatterOptions;
import com.hello2morrow.sonargraph.core.model.common.IFormatter;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.INamedElementAdapter;
import com.hello2morrow.sonargraph.core.model.element.INamedElementNode;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.ISourceFileRegionVisitor;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.NamespaceUtility;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.persistence.architecture.ArchitectureFilePersistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public abstract class p
extends Extension
implements a,
n.c,
IArchitectureProvider {
    private final Installation a;
    private final SoftwareSystem b;
    private final Map<String, ArchitectureFile> d = new TreeMap<String, ArchitectureFile>();
    private final Map<String, String> e = new LinkedHashMap<String, String>();
    private final m f = new m();

    protected p(Installation installation, SoftwareSystem softwareSystem) {
        assert (installation != null) : "Parameter 'installation' of method 'ArchitectureProvider' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ArchitectureProvider' must not be null";
        this.a = installation;
        this.b = softwareSystem;
    }

    protected final SoftwareSystem d() {
        return this.b;
    }

    @Override
    public IFormatter getFormatter(FormatterOptions options) {
        assert (options != null) : "Parameter 'options' of method 'getFormatter' must not be null";
        return new f(options);
    }

    @Override
    public final String getArchitectureCheckConfigurationFileName() {
        return AnalyzerConfigurationFile.getFileName(CoreAnalyzerId.ARCHITECTURE_CHECK);
    }

    protected final ArchitectureCheckConfiguration a(boolean forEdit) {
        AnalyzerConfiguration configuration;
        g analyzerExtension = this.d().getExtension(g.class);
        AnalyzerConfiguration analyzerConfiguration = configuration = forEdit ? analyzerExtension.c(CoreAnalyzerId.ARCHITECTURE_CHECK) : analyzerExtension.b(CoreAnalyzerId.ARCHITECTURE_CHECK);
        assert (configuration != null && configuration instanceof ArchitectureCheckConfiguration) : "Unexpected class in method 'getArchitectureCheckConfiguration': " + configuration;
        return (ArchitectureCheckConfiguration)configuration;
    }

    protected final ArchitectureFile e(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'addArchitectureFile' must not be null";
        return this.d.put(architectureFile.getIdentifyingPath(), architectureFile);
    }

    protected final ArchitectureFile b(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'removeArchitectureFile' must not be empty";
        return this.d.remove(identifyingPath);
    }

    @Override
    public final ArchitectureFile getArchitectureFile(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getArchitectureFile' must not be empty";
        return !identifyingPath.startsWith("./") ? this.d.get("./" + identifyingPath) : this.d.get(identifyingPath);
    }

    protected final ArchitectureFilePersistence g() {
        return new ArchitectureFilePersistence(this.a.getVersion());
    }

    protected final Architecture h() {
        return this.b.getUniqueExistingChild(Files.class).getArchitecture();
    }

    protected final Set<NamedElement> a(List<? extends Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getNormalizedArchitectureFileToDelete' must not be empty";
        ArrayList<NamedElement> namedElements = new ArrayList<NamedElement>(elements.size());
        for (Element element : elements) {
            if (!(element instanceof NamedElement)) continue;
            namedElements.add((NamedElement)element);
        }
        return NamedElementUtility.normalize(namedElements, true, new Class[0]);
    }

    protected final void a(String oldIdentifyingPath, String newIdentifyingPath) {
        assert (oldIdentifyingPath != null && oldIdentifyingPath.length() > 0) : "Parameter 'oldIdentifyingPath' of method 'changeIdentifyingPathOfArchitectureFile' must not be empty";
        assert (newIdentifyingPath != null && newIdentifyingPath.length() > 0) : "Parameter 'newIdentifyingPath' of method 'changeIdentifyingPathOfArchitectureFile' must not be empty";
        ArchitectureFile found = this.d.remove(oldIdentifyingPath);
        assert (found != null) : "'found' of method 'changeIdentifyingPathOfArchitectureFile' must not be null";
        ArchitectureFile replaced = this.d.put(newIdentifyingPath, found);
        assert (replaced == null) : "'replaced' of method 'changeIdentifyingPathOfArchitectureFile' must be null";
    }

    protected final ArchitectureCheckConfiguration i() {
        return (ArchitectureCheckConfiguration)this.b.getExtension(g.class).b(CoreAnalyzerId.ARCHITECTURE_CHECK);
    }

    @Override
    public final boolean areDeletableArchitectureFileElements(List<? extends Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'areDeletableArchitectureFileElements' must not be empty";
        for (Element element : elements) {
            if (element instanceof ArchitectureFile) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Collection<String> architectureFileElementsDeletionAffectsArchitectureCheck(List<? extends Element> elements) {
        assert (this.areDeletableArchitectureFileElements(elements)) : "Not deletable architecture file elements: " + elements;
        ArchitectureCheckConfiguration configuration = this.i();
        assert (configuration != null) : "'configuration' of method 'architectureFileElementsDeletionAffectsArchitectureCheck' must not be null";
        ArrayList<String> affected = new ArrayList<String>();
        for (Element element : this.a(elements)) {
            if (!(element instanceof ArchitectureFile) || !configuration.isChecked(((ArchitectureFile)element).getIdentifyingPath())) continue;
            affected.add(((ArchitectureFile)element).getIdentifyingPath());
        }
        return affected;
    }

    @Override
    public final List<ArchitectureFile> getAvailableArchitectureFiles() {
        return new ArrayList<ArchitectureFile>(this.d.values());
    }

    @Override
    public final List<ArchitectureFile> getCheckedArchitectureFiles() {
        return this.d.values().stream().filter(a2 -> a2.isChecked()).collect(Collectors.toList());
    }

    @Override
    public final boolean isArchitectureFileDirectory(DirectoryPath directoryPath) {
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'isArchitectureDirectory' must not be null";
        return directoryPath == this.b.getUniqueExistingChild(Files.class).getArchitecture();
    }

    @Override
    public ITextValidator getArchitectureFileNameValidator(final DirectoryPath directoryPath, final ArchitectureFile architectureFile) {
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'getArchitectureFileNameValidator' must not be null";
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null) {
                    result.addError("Input not valid");
                    return result;
                }
                if ((newInput = newInput.trim()).isEmpty()) {
                    result.addError("Must not be empty");
                    return result;
                }
                if (!FileUtility.isValidName((String)newInput)) {
                    result.addError("Architecture name is not valid");
                }
                if (newInput.endsWith(CoreFileType.ARCHITECTURE.getDefaultExtension())) {
                    result.addError("Architecture name needs to be specified without file extension");
                }
                if (result.isFailure()) {
                    return result;
                }
                if (result.inputModified()) {
                    String newInputWithExtension = String.valueOf(newInput) + CoreFileType.ARCHITECTURE.getDefaultExtension();
                    for (ArchitectureFile next : directoryPath.getChildren(ArchitectureFile.class)) {
                        if (next == architectureFile || !next.getShortName().equalsIgnoreCase(newInputWithExtension)) continue;
                        result.addError("Architecture file with name '" + newInput + "' already exists");
                        break;
                    }
                }
                return result;
            }
        };
    }

    @Override
    public void accept(ISourceFileRegionVisitor visitor, String content, IFileType fileType) {
        assert (fileType != null) : "Parameter 'fileType' of method 'accept' must not be null";
        assert (fileType.equals((Object)CoreFileType.ARCHITECTURE)) : "Unexpected 'fileType' " + fileType.getPresentationName();
        this.f.a(visitor, content);
    }

    @Override
    public boolean mayBeAddedToArchitectureCheck(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'mayBeAddedToArchitectureCheck' must not be empty";
        for (Element next : elements) {
            if (!(next instanceof ArchitectureFile)) {
                return false;
            }
            ArchitectureFile file = (ArchitectureFile)next;
            if (!file.isChecked() && file.canBeChecked()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mayBeRemovedFromArchitectureCheck(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'mayBeRemovedFromArchitectureCheck' must not be empty";
        for (Element next : elements) {
            if (next instanceof ArchitectureFile && ((ArchitectureFile)next).isChecked()) continue;
            return false;
        }
        return true;
    }

    protected final void j() {
        this.d.clear();
        this.e.clear();
    }

    protected void b(String identifyingPath, String content) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'addArchitectureFileContentForCompilation' must not be empty";
        assert (content != null) : "Parameter 'content' of method 'addArchitectureFileContentForCompilation' must not be null";
        this.e.put(identifyingPath, content);
    }

    protected String c(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'removeArchitectureFileContentForCompilation' must not be empty";
        String content = this.e.remove(identifyingPath);
        assert (content != null) : "No content found for '" + identifyingPath + "'";
        return content;
    }

    @Override
    public String d(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getArchitectureFileContentForCompilation' must not be empty";
        assert (this.e.containsKey(identifyingPath)) : "No content present for ArchitectureFile '" + identifyingPath + "'";
        return this.e.get(identifyingPath);
    }

    private Artifact a(List<Artifact> artifacts, List<String> artifactPath, int index) {
        assert (artifacts != null) : "Parameter 'artifacts' of method 'findArtifact' must not be null";
        assert (artifactPath != null) : "Parameter 'artifactPath' of method 'findArtifact' must not be null";
        String nextArtifactNameToMatch = artifactPath.get(index);
        for (Artifact nextArtifact : artifacts) {
            if (!nextArtifact.getShortName().equals(nextArtifactNameToMatch)) continue;
            if (index < artifactPath.size() - 1) {
                return this.a(nextArtifact.getChildren(Artifact.class), artifactPath, index + 1);
            }
            return nextArtifact;
        }
        return null;
    }

    @Override
    public Artifact e(String artifactPath) {
        assert (artifactPath != null && artifactPath.length() > 0) : "Parameter 'artifactPath' of method 'find' must not be empty";
        List<String> parts = Artifact.getArtifactPathParts(artifactPath);
        assert (!parts.isEmpty()) : "'parts' must not be empty";
        ArchitectureFile architectureFile = this.getArchitectureFile(parts.get(0));
        return architectureFile != null ? this.a(architectureFile.getChildren(Artifact.class), parts, 1) : null;
    }

    static boolean a(ElementAssignmentInfo info, Artifact currentArtifact) {
        assert (info != null) : "Parameter 'info' of method 'findArtifactPath' must not be null";
        assert (currentArtifact != null) : "Parameter 'currentArtifact' of method 'findArtifact' must not be null";
        IAssignableToArtifact assignable = info.getAssignable();
        if (currentArtifact.contains(assignable)) {
            info.add(currentArtifact);
            for (Connector connector : currentArtifact.getChildren(Connector.class)) {
                if (!connector.contains(assignable)) continue;
                info.add(connector);
            }
            for (Interface interface_ : currentArtifact.getChildren(Interface.class)) {
                if (!interface_.contains(assignable)) continue;
                info.add(interface_);
            }
            return true;
        }
        for (Artifact artifact : currentArtifact.getChildren(Artifact.class)) {
            if (!p.a(info, artifact)) continue;
            return true;
        }
        return false;
    }

    private void a(ElementAssignmentInfo info) {
        assert (info != null) : "Parameter 'info' of method 'collectAssignmentInfo' must not be null";
        boolean atLeastOneArchitectureFileChecked = false;
        boolean assignmentFound = false;
        block0: for (ArchitectureFile next : this.d.values()) {
            if (!next.isChecked() || !next.modelLoaded() || !next.getModel().equals((Object)info.getModel())) continue;
            atLeastOneArchitectureFileChecked = true;
            for (Artifact nextArtifact : next.getChildren(Artifact.class)) {
                if (!p.a(info, nextArtifact)) continue;
                assignmentFound = true;
                continue block0;
            }
        }
        if (atLeastOneArchitectureFileChecked && !assignmentFound) {
            if (info.getAssignable().isExternal()) {
                info.add(this.d(info.getModel()));
            } else {
                info.add(this.c(info.getModel()));
            }
        }
    }

    @Override
    public final ElementAssignmentInfo getAssignmentInfo(Element element) {
        LogicalModuleProgrammingElement lpe;
        assert (element != null) : "Parameter 'element' of method 'getAssignmentInfo' must not be null";
        if (element instanceof IComponent) {
            IComponent component = (IComponent)((Object)element);
            if (!component.isExcluded() && !component.getNamedElement().getRefactoringState().hasBeenDeleted()) {
                ElementAssignmentInfo info = new ElementAssignmentInfo(component, IArchitecturalModelProvider.ArchitectureModel.PHYSICAL);
                this.a(info);
                return info.isEmpty() ? null : info;
            }
        } else if (element instanceof LogicalModuleProgrammingElement && !((lpe = (LogicalModuleProgrammingElement)element).getParent() instanceof LogicalModuleProgrammingElement)) {
            ElementAssignmentInfo info = new ElementAssignmentInfo(lpe, IArchitecturalModelProvider.ArchitectureModel.LOGICAL);
            this.a(info);
            return info.isEmpty() ? null : info;
        }
        return null;
    }

    @Override
    public final ArchitectureElementsInfo getArchitectureElementsInfo(List<Element> elements, ArchitectureFile architectureFile) {
        r collector;
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getAssignedElements' must not be empty";
        ArrayList<NamedElement> physicalArchitectureElements = new ArrayList<NamedElement>();
        ArrayList<NamedElement> logicalArchitectureElements = new ArrayList<NamedElement>();
        ArrayList<NamedElement> uncheckedArchitectureElements = new ArrayList<NamedElement>();
        ArrayList<NamedElement> physicalAssignables = new ArrayList<NamedElement>();
        ArrayList<NamedElement> logicalAssignables = new ArrayList<NamedElement>();
        for (Element element : elements) {
            NamedElement nextNamedElement;
            ArchitectureFile nextArchitectureFile;
            if (element instanceof IComponent) {
                IComponent nextComponent = (IComponent)((Object)element);
                if (nextComponent.isExcluded() || nextComponent.getNamedElement().getRefactoringState().hasBeenDeleted()) continue;
                physicalAssignables.add(nextComponent.getNamedElement());
                continue;
            }
            if (element instanceof LogicalModuleProgrammingElement) {
                LogicalModuleProgrammingElement nextLogicalModuleProgrammingElement = (LogicalModuleProgrammingElement)element;
                if (nextLogicalModuleProgrammingElement.getParent() instanceof LogicalModuleProgrammingElement) continue;
                logicalAssignables.add(nextLogicalModuleProgrammingElement);
                continue;
            }
            if (!(element instanceof IArchitectureDefinitionElement) || (nextArchitectureFile = (nextNamedElement = ((IArchitectureDefinitionElement)((Object)element)).getNamedElement()).getParent(ArchitectureFile.class, ParentMode.SELF_OR_FIRST_PARENT)) == null) continue;
            if (nextArchitectureFile.isChecked()) {
                if (nextArchitectureFile.getModel().equals((Object)IArchitecturalModelProvider.ArchitectureModel.PHYSICAL)) {
                    physicalArchitectureElements.add(nextNamedElement);
                    continue;
                }
                logicalArchitectureElements.add(nextNamedElement);
                continue;
            }
            uncheckedArchitectureElements.add(nextNamedElement);
        }
        if (!physicalAssignables.isEmpty()) {
            for (ArchitectureFile architectureFile2 : this.d.values()) {
                if (architectureFile != null && architectureFile2 != architectureFile || !architectureFile2.isChecked() || !architectureFile2.modelLoaded() || !architectureFile2.getModel().equals((Object)IArchitecturalModelProvider.ArchitectureModel.PHYSICAL)) continue;
                collector = new r(physicalAssignables, physicalArchitectureElements);
                architectureFile2.accept(collector);
            }
            if (architectureFile == null) {
                for (UnassignedElements unassignedElements : this.h().getChildren(UnassignedElements.class)) {
                    if (!unassignedElements.getModel().equals((Object)IArchitecturalModelProvider.ArchitectureModel.PHYSICAL)) continue;
                    collector = new r(physicalAssignables, physicalArchitectureElements);
                    unassignedElements.accept(collector);
                }
            }
        }
        if (!logicalAssignables.isEmpty()) {
            for (ArchitectureFile architectureFile3 : this.d.values()) {
                if (architectureFile != null && architectureFile3 != architectureFile || !architectureFile3.isChecked() || !architectureFile3.modelLoaded() || !architectureFile3.getModel().equals((Object)IArchitecturalModelProvider.ArchitectureModel.LOGICAL)) continue;
                collector = new r(logicalAssignables, logicalArchitectureElements);
                architectureFile3.accept(collector);
            }
            if (architectureFile == null) {
                for (UnassignedElements unassignedElements : this.h().getChildren(UnassignedElements.class)) {
                    if (!unassignedElements.getModel().equals((Object)IArchitecturalModelProvider.ArchitectureModel.LOGICAL)) continue;
                    collector = new r(logicalAssignables, logicalArchitectureElements);
                    unassignedElements.accept(collector);
                }
            }
        }
        return new ArchitectureElementsInfo(physicalArchitectureElements, logicalArchitectureElements, uncheckedArchitectureElements);
    }

    private Artifact a(Artifact artifact, Collection<? extends IAssignableToArtifact> assignables) {
        assert (artifact != null) : "Parameter 'artifact' of method 'find' must not be null";
        assert (assignables != null) : "Parameter 'assignables' of method 'find' must not be null";
        if (artifact.contains(assignables)) {
            return artifact;
        }
        for (Artifact nextArtifact : artifact.getChildren(Artifact.class)) {
            Artifact found = this.a(nextArtifact, assignables);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private Artifact a(ArchitectureFile file, Collection<? extends IAssignableToArtifact> assignables, boolean toplevel) {
        assert (file != null) : "Parameter 'file' of method 'find' must not be null";
        assert (assignables != null) : "Parameter 'assignables' of method 'find' must not be null";
        List<Artifact> artifactChildren = file.getChildren(Artifact.class);
        if (!artifactChildren.isEmpty()) {
            for (Artifact nextArtifact : artifactChildren) {
                Artifact found = this.a(nextArtifact, assignables);
                if (found == null) continue;
                return toplevel ? nextArtifact : found;
            }
        }
        return null;
    }

    @Override
    public Artifact getParentArtifact(ArchitectureFile file, Element element, boolean toplevel) {
        assert (file != null) : "Parameter 'file' of method 'getParentArtifact' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getParentArtifact' must not be null";
        if (file.isChecked()) {
            IArchitecturalModelProvider.ArchitectureModel architectureModel = file.getModel();
            if (element instanceof IComponent) {
                if (architectureModel.equals((Object)IArchitecturalModelProvider.ArchitectureModel.PHYSICAL)) {
                    return this.a(file, Collections.singletonList((IComponent)((Object)element)), toplevel);
                }
                aZ collector = new aZ();
                ((IComponent)((Object)element)).getNamedElement().accept(collector);
                HashSet<LogicalProgrammingElement> logicalProgrammingElements = new HashSet<LogicalProgrammingElement>();
                for (ProgrammingElement next : collector.a()) {
                    LogicalProgrammingElement nextLogicalProgrammingElement = NamespaceUtility.getLogicalProgrammingElement(next, false);
                    if (nextLogicalProgrammingElement == null) continue;
                    logicalProgrammingElements.add(nextLogicalProgrammingElement);
                }
                if (!logicalProgrammingElements.isEmpty()) {
                    return this.a(file, logicalProgrammingElements, toplevel);
                }
            } else if (element instanceof IDirectoryPath) {
                List<IComponent> components = ((IDirectoryPath)((Object)element)).getNamedElement().getChildren(IComponent.class).stream().filter(c2 -> !c2.isExcluded() && !c2.getNamedElement().getRefactoringState().hasBeenDeleted()).collect(Collectors.toList());
                if (architectureModel.equals((Object)IArchitecturalModelProvider.ArchitectureModel.PHYSICAL)) {
                    return this.a(file, components, toplevel);
                }
                aZ collector = new aZ();
                components.forEach(c2 -> c2.getNamedElement().accept(collector));
                HashSet<LogicalProgrammingElement> logicalProgrammingElements = new HashSet<LogicalProgrammingElement>();
                for (ProgrammingElement next : collector.a()) {
                    LogicalProgrammingElement nextLogicalProgrammingElement = NamespaceUtility.getLogicalProgrammingElement(next, false);
                    if (nextLogicalProgrammingElement == null) continue;
                    logicalProgrammingElements.add(nextLogicalProgrammingElement);
                }
                if (!logicalProgrammingElements.isEmpty()) {
                    return this.a(file, logicalProgrammingElements, toplevel);
                }
            } else if (element instanceof LogicalNamespace) {
                switch (architectureModel) {
                    case LOGICAL: {
                        return this.a(file, ((LogicalNamespace)element).getChildren(LogicalProgrammingElement.class), toplevel);
                    }
                    case PHYSICAL: {
                        HashSet<IComponent> components = new HashSet<IComponent>();
                        for (ProgrammingElement next : ((LogicalNamespace)element).getProgrammingElements()) {
                            IComponent nextComponent = next.getParent(IComponent.class, new Class[0]);
                            if (nextComponent == null) continue;
                            components.add(nextComponent);
                        }
                        return this.a(file, components, toplevel);
                    }
                }
                assert (false) : "Unhandled model: " + (Object)((Object)architectureModel);
            }
        }
        return null;
    }

    private List<Element> b(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getElements' must not be empty";
        ArrayList<Element> expanded = new ArrayList<Element>();
        for (Element next : elements) {
            if (next instanceof INamedElementAdapter) {
                for (NamedElement nextNamedElement : ((INamedElementAdapter)((Object)next)).getAdaptedTo()) {
                    expanded.add(nextNamedElement.getElement());
                }
                continue;
            }
            expanded.add(next.getElement());
        }
        return expanded;
    }

    @Override
    public List<NamedElement> getArchitectureRelatedElements(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getArchitectureRelatedElements' must not be empty";
        ArrayList<NamedElement> relevant = new ArrayList<NamedElement>();
        for (Element next : this.b(elements)) {
            if (next instanceof IDiffElement && (next = ((IDiffElement)((Object)next)).getCurrentElement()) == null) {
                return Collections.emptyList();
            }
            if (next instanceof Issue) {
                Artifact artifact;
                Issue nextIssue = (Issue)next;
                next = ((Issue)next).getAffectedElement();
                if (nextIssue instanceof ArchitectureViolationIssue && (artifact = this.e(((ArchitectureViolationIssue)nextIssue).getArtifactFromPath())) != null) {
                    next = artifact;
                }
            } else if (next instanceof INamedElementNode) {
                next = ((INamedElementNode)((Object)next)).getNamedElement();
            }
            if (next.isExcluded()) {
                return Collections.emptyList();
            }
            if (next instanceof IArchitectureDefinitionElement) {
                relevant.add(((IArchitectureDefinitionElement)((Object)next)).getNamedElement());
                continue;
            }
            ElementAssignmentInfo assignmentInfo = this.getAssignmentInfo(next);
            if (assignmentInfo != null) {
                relevant.add(assignmentInfo.getAssignable().getNamedElement());
                continue;
            }
            return Collections.emptyList();
        }
        return relevant;
    }

    protected final UnassignedInternal c(IArchitecturalModelProvider.ArchitectureModel model) {
        assert (model != null) : "Parameter 'model' of method 'getUnassignedInternalNode' must not be null";
        return this.h().getChildren(UnassignedInternal.class).stream().filter(c2 -> c2.getModel().equals((Object)model)).findFirst().orElse(null);
    }

    protected final UnassignedExternal d(IArchitecturalModelProvider.ArchitectureModel model) {
        assert (model != null) : "Parameter 'model' of method 'getUnassignedExternalNode' must not be null";
        return this.h().getChildren(UnassignedExternal.class).stream().filter(c2 -> c2.getModel().equals((Object)model)).findFirst().orElse(null);
    }

    @Override
    public final List<AutoCompletionProposal> getAutoCompletionProposals(ArchitectureFile file, String text, int offset, int line) {
        assert (file != null) : "Parameter 'file' of method 'getAutoCompletionProposals' must not be null";
        return AutoCompletionProposalsCollector.a(text, offset, line, file.getIdentifyingPath(), this.h());
    }

    @Override
    public final AggregatedViolationInfo getAggregatedViolationInfo(List<NamedElement> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getAggregatedViolationInfo' must not be null";
        return n.a(elements, this.b.getCurrentModel(IVirtualModel.class), this);
    }

    @Override
    public AggregatedDeprecationInfo getAggregatedDeprecationInfo(List<NamedElement> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getAggregatedDeprecationInfo' must not be null";
        return n.b(elements, this.b.getCurrentModel(IVirtualModel.class), this);
    }
}

