/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.controller.system.base.b;
import com.hello2morrow.sonargraph.core.controller.system.bd;
import com.hello2morrow.sonargraph.core.controller.system.c;
import com.hello2morrow.sonargraph.core.controller.system.n;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ModifiableFileIdFilter;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.transaction.AnalyzerExecutionInfo;
import com.hello2morrow.sonargraph.core.persistence.architecture.ArchitectureFilePersistence;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;

public final class o
extends b {
    private final SoftwareSystem c;

    public o(SoftwareSystem softwareSystem) {
        this.c = softwareSystem;
    }

    @Override
    public List<Class<? extends IModifiableFile>> getModifiableFileClasses() {
        return Collections.singletonList(ArchitectureFile.class);
    }

    @Override
    public void writeModifiableFileToStream(IModifiableFile file, OutputStream stream, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'writeContentToStream' must not be null";
        assert (file instanceof ArchitectureFile) : "Unexpected class: " + file.getClass().getName();
        assert (stream != null) : "Parameter 'stream' of method 'writeContentToStream' must not be null";
        assert (result != null) : "Parameter 'result' of method 'writeModifiableFileToStream' must not be null";
        this.c.getExtension(n.class).g().save((ArchitectureFile)file, stream, result);
    }

    public OperationResultWithOutcome<IModifiableFile> restoreModifiableFileFromStream(InputStream inputStream, RestoreStateDto dto, EnumSet<Modification> determinedModifications, List<String> otherFilesOfTx) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restoreFile' must not be null";
        assert (dto != null) : "Parameter 'dto' of method 'restoreFile' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreFile' must not be null";
        assert (otherFilesOfTx != null) : "Parameter 'otherFilesOfTx' of method 'restoreFile' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Restore Groovy script '" + dto.getCurrentStateFileEntry().getIdentifyingPath() + "'");
        ArchitectureFile architectureFile = this.c.getUniqueExistingChild(Files.class).getArchitecture().getFirstChildRecursively(new ModifiableFileIdFilter(dto.getModifiableFileId()), ArchitectureFile.class, new Class[0]);
        assert (architectureFile != null) : "Architecture '" + dto.getCurrentStateFileEntry().getIdentifyingPath() + "' must exist!";
        n architectureExtension = this.c.getExtension(n.class);
        ArchitectureFilePersistence persistence = architectureExtension.g();
        String content = persistence.loadFromStream(inputStream, (OperationResult)result);
        if (result.isFailure()) {
            return result;
        }
        assert (content != null) : "architecture file content must not be null";
        boolean needsReCompile = false;
        if (!architectureFile.getIdentifyingPath().equals(dto.getCurrentStateFileEntry().getIdentifyingPath())) {
            TFile newPath = new TFile((File)architectureFile.getParent(Architecture.class, new Class[0]).getFile(), dto.getCurrentStateFileEntry().getIdentifyingPath()).getNormalizedAbsoluteFile();
            try {
                architectureFile.getFile().mv((File)newPath);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE, (Throwable)ex);
                return result;
            }
            String previousIdentifyingPath = architectureFile.getIdentifyingPath();
            architectureFile.setPath(newPath);
            architectureExtension.a(previousIdentifyingPath, architectureFile.getIdentifyingPath());
            architectureExtension.c(previousIdentifyingPath);
            architectureExtension.b(architectureFile.getIdentifyingPath(), content);
            Files files = this.c.getUniqueExistingChild(Files.class);
            ArrayList otherFiles = new ArrayList(otherFilesOfTx.size());
            otherFilesOfTx.stream().forEach(id -> {
                Optional<IModifiableFile> optionalFile = files.findById((String)id);
                assert (optionalFile.isPresent()) : "File with id '" + id + "' not found";
                otherFiles.add(optionalFile.get());
            });
            bd undoRedoExtension = this.c.getExtension(bd.class);
            AnalyzerConfigurationFile configurationFile = architectureExtension.b();
            for (IModifiableFile next : otherFiles) {
                if (next instanceof ArchitectureFile) {
                    result.addMessagesFrom(architectureExtension.c((ArchitectureFile)next));
                    undoRedoExtension.a(next.getFileId()).setNeedsSave(false, true);
                    continue;
                }
                if (next != configurationFile || !architectureExtension.a(architectureFile.getIdentifyingPath())) continue;
                configurationFile.setNeedsSave(true);
                result.addMessagesFrom(this.c.getExtension(c.class).a(configurationFile));
                undoRedoExtension.a(configurationFile.getFileId()).setNeedsSave(false, true);
            }
            needsReCompile = true;
        }
        architectureFile.setContent(content, false);
        if (!dto.getCurrentStateFileEntry().needsSave()) {
            needsReCompile = true;
        }
        if (needsReCompile) {
            architectureExtension.a((IWorkerContext)DefaultWorkerContext.INSTANCE);
        }
        result.setOutcome((Object)architectureFile);
        return result;
    }

    @Override
    public AnalyzerExecutionInfo getAnalyzerExecutionInfo(String identifyingPath, RestoreStateDto restoreDto) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getAnalyzerExecutionInfo' must not be empty";
        assert (restoreDto != null) : "Parameter 'restoreDto' of method 'getAnalyzerExecutionInfo' must not be null";
        if (!identifyingPath.equals(restoreDto.getCurrentStateFileEntry().getIdentifyingPath()) || !restoreDto.getCurrentStateFileEntry().needsSave()) {
            return AnalyzerExecutionInfo.groups(CoreAnalyzerId.ARCHITECTURE_CHECK.getAffectedGroups());
        }
        return AnalyzerExecutionInfo.none();
    }
}

