/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.file.TrueZipFacade;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.controller.system.ArchitectureMessageCause;
import com.hello2morrow.sonargraph.core.controller.system.P;
import com.hello2morrow.sonargraph.core.controller.system.S;
import com.hello2morrow.sonargraph.core.controller.system.al;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.controller.system.architecture.h;
import com.hello2morrow.sonargraph.core.controller.system.architecture.q;
import com.hello2morrow.sonargraph.core.controller.system.architecture.x;
import com.hello2morrow.sonargraph.core.controller.system.architecture.y;
import com.hello2morrow.sonargraph.core.controller.system.base.AnalyzerConfigurationChangeMode;
import com.hello2morrow.sonargraph.core.controller.system.base.f;
import com.hello2morrow.sonargraph.core.controller.system.base.j;
import com.hello2morrow.sonargraph.core.controller.system.base.m;
import com.hello2morrow.sonargraph.core.controller.system.p;
import com.hello2morrow.sonargraph.core.controllerinterface.system.e;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.ArchitectureCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureCheckConfigurationInconsistent;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.architecture.IClearableArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedElements;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedExternal;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedInternal;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ModifiableDirectoryPathCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.Path;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.architecture.ArchitectureFilePersistence;
import com.hello2morrow.sonargraph.core.persistence.architecture.ArchitectureXmlPersistence;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class n
extends p
implements S,
f,
j,
m,
e,
IModifiableFileDeltaKey {
    private static final Logger e = LoggerFactory.getLogger(n.class);
    public static final LinkedHashSet<AnalyzerGroup> a = new LinkedHashSet<AnalyzerGroup>(Arrays.asList(AnalyzerGroup.ARCHITECTURE, AnalyzerGroup.ARCHITECTURE_METRICS));
    private final P f;
    private final Map<String, IAssignableAttributeRetriever> g = new THashMap();
    private static volatile /* synthetic */ int[] h;

    public n(Installation installation, SoftwareSystem softwareSystem, List<IAssignableAttributeRetriever> retrievers, P finishModelProcessor) {
        super(installation, softwareSystem);
        assert (retrievers != null) : "Parameter 'retrievers' of method 'ArchitectureExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'ArchitectureExtension' must not be null";
        this.f = finishModelProcessor;
        LinkedHashSet<IAssignableAttributeRetriever> allRetrievers = new LinkedHashSet<IAssignableAttributeRetriever>(n.a());
        allRetrievers.addAll(retrievers);
        for (IAssignableAttributeRetriever next : allRetrievers) {
            IAssignableAttributeRetriever previous = this.g.put(next.getName(), next);
            assert (previous == null) : "Duplicate attribute retriever: " + next;
        }
        this.f.a(this);
    }

    public static List<IAssignableAttributeRetriever> a() {
        return Arrays.asList(new com.hello2morrow.sonargraph.core.controller.system.architecture.j(), new x(), new y());
    }

    @Override
    public String getDefaultRetrieverName() {
        return "ArchitectureFilterName";
    }

    @Override
    public AnalyzerConfigurationFile b() {
        return this.d().getExtension(g.class).a(CoreAnalyzerId.ARCHITECTURE_CHECK);
    }

    @Override
    public void a(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        Architecture architecture = this.h();
        architecture.enforceExistence(result);
        if (result.isSuccess() && (SoftwareSystemFilesDirectory.isOutOfSync(this.b()) || architecture.isOutOfSync(new String[][]{CoreFileType.ARCHITECTURE.getExtensions()}))) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
        }
    }

    private OperationResult a(TFile contentFile, TFile modelFile, ArchitectureFile architectureFile, boolean saveToDisk) {
        assert (contentFile != null) : "Parameter 'contentFile' of method 'addArchitectureFile' must not be null";
        assert (modelFile != null) : "Parameter 'modelFile' of method 'addArchitectureFile' must not be null";
        OperationResult result = new OperationResult("Add Architecture File");
        ArchitectureFilePersistence persistence = this.g();
        if (architectureFile == null) {
            Architecture architecture = this.h();
            TFile architectureDirectory = architecture.getFile();
            String archName = modelFile.getName();
            String archRelPath = "./" + archName;
            architectureFile = architecture.getFirstChild(new NameFilter(archRelPath), ArchitectureFile.class);
            assert (architectureFile == null) : "File should not be there: " + archName;
            architectureFile = new ArchitectureFile(architecture, new TFile((File)architectureDirectory, archName), contentFile.lastModified(), this.d().getUniqueExistingChild(Files.class));
            architecture.addChild(architectureFile);
            this.e(architectureFile);
            persistence.load(contentFile, architectureFile, result);
        } else {
            persistence.load(contentFile, architectureFile, result);
            architectureFile.reloaded(contentFile.lastModified(), false);
        }
        if (saveToDisk) {
            OperationResult saveResult = persistence.save(architectureFile, modelFile);
            result.addMessagesFrom(saveResult);
            if (saveResult.isSuccess()) {
                architectureFile.setExistsOnDisk(true);
                architectureFile.resetTimestamp();
            }
            TrueZipFacade.clear((TFile)modelFile);
        }
        this.b(architectureFile.getIdentifyingPath(), architectureFile.getContent());
        return result;
    }

    @Override
    public Set<IAnalyzerId> getAffectedAnalyzerIdsOnModifiableFileInterchange() {
        return Collections.singleton(CoreAnalyzerId.ARCHITECTURE_CHECK);
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, boolean onSystemOpen, PrepareRefreshResult result) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        assert (result != null) : "Parameter 'result' of method 'prepareRefresh' must not be null";
        THashSet identifyingPaths = new THashSet();
        final Architecture architectureDirectory = this.h();
        architectureDirectory.checkExistence();
        deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider((Set)identifyingPaths, result){
            private final /* synthetic */ Set c;
            private final /* synthetic */ PrepareRefreshResult d;
            {
                this.c = set;
                this.d = prepareRefreshResult;
            }

            @Override
            public IModifiableFileDeltaKey getKey() {
                return n.this;
            }

            @Override
            public DirectoryPath getDirectoryPath() {
                return architectureDirectory;
            }

            @Override
            public List<IFileType> getFileTypes() {
                return Collections.singletonList(CoreFileType.ARCHITECTURE);
            }

            @Override
            public boolean accept(TFile file) {
                if (!b && file == null) {
                    throw new AssertionError((Object)"Parameter 'file' of method 'accept' must not be null");
                }
                String identifyingPath = FileUtility.calculateRelativePath((TFile)file, (TFile)architectureDirectory.getFile());
                String normalizedIdentifyingPath = identifyingPath.toLowerCase();
                if (this.c.add(normalizedIdentifyingPath)) {
                    return true;
                }
                this.d.addWarning(ArchitectureMessageCause.IGNORED_ARCHITECTURE_FILE, "Ignored '" + identifyingPath + "' which differs only in case from already processed architecture file.", new Object[0]);
                return false;
            }

            @Override
            public String getImageResource(IFileType fileType) {
                return ArchitectureFile.class.getSimpleName();
            }
        });
    }

    @Override
    public void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return n.this;
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!(b || modified != null && modified instanceof ArchitectureFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + modified));
                }
                TFile file = modified.getFile();
                n.this.a(file, file, (ArchitectureFile)modified, false);
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!(b || deleted != null && deleted instanceof ArchitectureFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + deleted));
                }
                ArchitectureFile doomed = (ArchitectureFile)deleted;
                n.this.b(doomed.getIdentifyingPath());
                doomed.remove();
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!b && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                TFile file = added.getFile();
                n.this.a(file, file, null, false);
            }

            @Override
            public void visitAdded(ModifiableDirectoryPathCandidate added) {
            }

            @Override
            public void visitDeleted(IModifiableDirectory deleted) {
            }
        }, true);
        if (delta.containsFiles(this) && modifications != null) {
            this.m();
            this.a(workerContext);
        }
    }

    private void l() {
        List<ArchitectureFile> availableArchitectureFiles = this.getAvailableArchitectureFiles();
        if (!availableArchitectureFiles.isEmpty()) {
            availableArchitectureFiles.forEach(a2 -> a2.clear(false));
            h loader = new h(this);
            for (ArchitectureFile next : availableArchitectureFiles) {
                if (next.modelLoaded()) continue;
                loader.b(next);
            }
        }
    }

    void a(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'reCompile' must not be null";
        List<ArchitectureFile> checked = this.b(true);
        this.l();
        this.d(workerContext, checked);
    }

    private boolean a(ArchitectureFile architectureFile, IAssignableToArtifact element) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'feedComponent' must not be null";
        assert (element != null) : "Parameter 'element' of method 'feedComponent' must not be null";
        for (Artifact consumer : architectureFile.getArtifactsByPriority()) {
            Artifact.Match match = consumer.offerComponent(element);
            if (match == null) continue;
            match.getFinalOwner().assignComponent(element);
            return true;
        }
        List<UnassignedElements> unassignedNodes = architectureFile.getChildren(UnassignedElements.class);
        assert (unassignedNodes.size() == 2) : "Missing unassigned nodes for " + architectureFile.getName();
        if (element.isExternal()) {
            unassignedNodes.get(1).assignComponent(element);
        } else {
            unassignedNodes.get(0).assignComponent(element);
        }
        return false;
    }

    @Override
    public Collection<IAssignableToArtifact> a(IArchitecturalModelProvider.ArchitectureModel model) {
        assert (model != null) : "Parameter 'model' of method 'getUnassignedInternalComponents' must not be null";
        UnassignedInternal unassignedNode = this.c(model);
        return unassignedNode == null ? Collections.emptyList() : unassignedNode.getAssignedElements();
    }

    @Override
    public Collection<IAssignableToArtifact> b(IArchitecturalModelProvider.ArchitectureModel model) {
        assert (model != null) : "Parameter 'model' of method 'getUnassignedExternalComponents' must not be null";
        UnassignedExternal unassignedNode = this.d(model);
        return unassignedNode == null ? Collections.emptyList() : unassignedNode.getAssignedElements();
    }

    @Override
    public Collection<IAssignableToArtifact> a(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getUnassignedInternalComponents' must not be null";
        return architectureFile.getUniqueExistingChild(UnassignedInternal.class).getAssignedElements();
    }

    @Override
    public Collection<IAssignableToArtifact> b(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getUnassignedExternalComponents' must not be null";
        return architectureFile.getUniqueExistingChild(UnassignedExternal.class).getAssignedElements();
    }

    private void m() {
        g analyzerExtension = this.d().getExtension(g.class);
        AnalyzerConfigurationFile analyzerConfigurationFile = analyzerExtension.a(CoreAnalyzerId.ARCHITECTURE_CHECK);
        if (analyzerConfigurationFile != null) {
            analyzerConfigurationFile.removeIssues();
            AnalyzerConfiguration configuration = analyzerExtension.b(CoreAnalyzerId.ARCHITECTURE_CHECK);
            if (configuration != null) {
                Map<String, ArchitectureFile> identifyingPathToArchitectureFile = this.getAvailableArchitectureFiles().stream().collect(Collectors.toMap(ModifiableFile::getIdentifyingPath, a2 -> a2));
                assert (configuration instanceof ArchitectureCheckConfiguration) : "Unexpected class in method 'checkArchitectureCheckConfiguration': " + configuration;
                ArchitectureCheckConfiguration architectureCheckConfiguration = (ArchitectureCheckConfiguration)configuration;
                architectureCheckConfiguration.resetWarnings();
                for (String nextIdentifyingPath : architectureCheckConfiguration.getIdentifyingPaths()) {
                    if (identifyingPathToArchitectureFile.containsKey(nextIdentifyingPath)) continue;
                    analyzerConfigurationFile.addIssue(new ArchitectureCheckConfigurationInconsistent(analyzerConfigurationFile, "Architecture file '" + nextIdentifyingPath + "' not found."));
                    architectureCheckConfiguration.setWarning(nextIdentifyingPath, "Architecture file not found.");
                }
            }
        }
    }

    @Override
    public void a(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        this.m();
    }

    private void f(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'clearAllIssues' must not be null";
        architectureFile.getChildrenRecursively(ArchitectureElement.class, new Class[0]).forEach(a2 -> a2.removeIssues());
        architectureFile.removeIssues(CoreIssueId.ARCHITECTURE_FILE_ERROR, CoreIssueId.ARCHITECTURE_FILE_WARNING);
    }

    private List<ArchitectureFile> b(boolean resetChecked) {
        List<ArchitectureFile> checked;
        e.debug("Reset component assignment");
        List<ArchitectureFile> available = this.getAvailableArchitectureFiles();
        ArchitectureCheckConfiguration configuration = this.i();
        if (configuration != null) {
            checked = new ArrayList();
            for (ArchitectureFile nextAvailable : available) {
                nextAvailable.clear(true);
                nextAvailable.setHasDeprecations(false);
                nextAvailable.setHasViolations(false);
                nextAvailable.getChildrenRecursively(ArchitectureElement.class, new Class[0]).forEach(a2 -> a2.removeIssues(CoreIssueId.CYCLIC_ARTIFACT, CoreIssueId.DEPRECATED_ARTIFACT_NOT_EMPTY, CoreIssueId.EMPTY_ARCHITECTURE_ELEMENT, CoreIssueId.UNRESOLVED_REQUIRED_ARTIFACT));
                if (!configuration.isChecked(nextAvailable.getIdentifyingPath())) continue;
                checked.add(nextAvailable);
            }
        } else {
            checked = Collections.emptyList();
        }
        Architecture architecture = this.h();
        if (resetChecked) {
            UnassignedElements node;
            int logicalChecks = 0;
            int physicalChecks = 0;
            for (ArchitectureFile nextAvailable : available) {
                boolean isChecked = checked.contains(nextAvailable);
                nextAvailable.getChildren(IClearableArchitectureElement.class).forEach(a2 -> a2.clear());
                nextAvailable.checked(isChecked);
                if (!isChecked) continue;
                switch (n.c()[nextAvailable.getModel().ordinal()]) {
                    case 2: {
                        ++physicalChecks;
                        break;
                    }
                    case 1: {
                        ++logicalChecks;
                    }
                }
            }
            if (physicalChecks == 0) {
                node = this.c(IArchitecturalModelProvider.ArchitectureModel.PHYSICAL);
                if (node != null) {
                    node.remove();
                }
                if ((node = this.d(IArchitecturalModelProvider.ArchitectureModel.PHYSICAL)) != null) {
                    node.remove();
                }
            }
            if (logicalChecks == 0) {
                node = this.c(IArchitecturalModelProvider.ArchitectureModel.LOGICAL);
                if (node != null) {
                    node.remove();
                }
                if ((node = this.d(IArchitecturalModelProvider.ArchitectureModel.LOGICAL)) != null) {
                    node.remove();
                }
            }
            architecture.getChildren(UnassignedElements.class).forEach(u2 -> u2.clear());
        } else {
            for (ArchitectureFile nextArchitectureFile : checked) {
                nextArchitectureFile.getChildren(IClearableArchitectureElement.class).forEach(a2 -> a2.clear());
            }
            for (UnassignedElements next : architecture.getChildren(UnassignedElements.class)) {
                next.clear();
            }
        }
        this.f.c();
        e.debug("Reset component assignment - done");
        return checked;
    }

    private void a(List<ArchitectureFile> checked, IArchitecturalModelProvider.ArchitectureModel model, List<IAssignableToArtifact> assignableElements) {
        assert (checked != null && checked.size() > 0) : "Parameter 'checked' of method 'assignComponents' must not be null and not be empty";
        assert (model != null) : "Parameter 'model' of method 'assignComponents' must not be null";
        assert (assignableElements != null) : "Parameter 'assignableElements' of method 'assignComponents' must not be null";
        Architecture architecture = this.h();
        UnassignedInternal unassignedInternalComponents = this.c(model);
        if (unassignedInternalComponents == null) {
            unassignedInternalComponents = new UnassignedInternal(architecture, model);
            architecture.addChild(unassignedInternalComponents);
        } else {
            unassignedInternalComponents.clear();
        }
        UnassignedExternal unassignedExternalComponents = this.d(model);
        if (unassignedExternalComponents == null) {
            unassignedExternalComponents = new UnassignedExternal(architecture, model);
            architecture.addChild(unassignedExternalComponents);
        } else {
            unassignedExternalComponents.clear();
        }
        for (IAssignableToArtifact nextElement : assignableElements) {
            boolean used = false;
            for (ArchitectureFile nextArchitectureFile : checked) {
                if (!this.a(nextArchitectureFile, nextElement)) continue;
                used = true;
            }
            if (used) continue;
            if (!nextElement.isExternal()) {
                unassignedInternalComponents.assignComponent(nextElement);
                continue;
            }
            unassignedExternalComponents.assignComponent(nextElement);
        }
        this.g.values().forEach(r2 -> r2.reset());
        for (ArchitectureFile nextArchitectureFile : checked) {
            nextArchitectureFile.getChildren(Artifact.class).forEach(a2 -> a2.assignmentFinished());
        }
    }

    private boolean a(List<ArchitectureFile> checked, IArchitecturalModelProvider.ArchitectureModel model, NamedElement root) {
        assert (checked != null) : "Parameter 'checked' of method 'assignComponents' must not be null";
        assert (model != null) : "Parameter 'model' of method 'assignComponents' must not be null";
        assert (root != null) : "Parameter 'root' of method 'assignComponents' must not be null";
        List<ArchitectureFile> modelFiles = checked.stream().filter(f2 -> f2.getModel().equals((Object)model)).collect(Collectors.toList());
        if (!modelFiles.isEmpty()) {
            q collector = new q();
            root.accept(collector);
            this.a(modelFiles, model, collector.a());
            return true;
        }
        return false;
    }

    private void d(IWorkerContext workerContext, List<ArchitectureFile> checked) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'assignComponents' must not be null";
        assert (checked != null) : "Parameter 'checked' of method 'assignComponents' must not be null";
        e.debug("Assign components");
        if (this.d().isClearable()) {
            workerContext.working("Assign components", true);
            int changes = 0;
            this.h().removeChildren(UnassignedElements.class);
            if (this.a(checked, IArchitecturalModelProvider.ArchitectureModel.LOGICAL, this.d().getUniqueExistingChild(LogicalModuleNamespaces.class))) {
                ++changes;
            }
            if (this.a(checked, IArchitecturalModelProvider.ArchitectureModel.PHYSICAL, this.d().getUniqueExistingChild(Workspace.class))) {
                ++changes;
            }
            if (changes > 0) {
                this.f.c();
            }
        }
        checked.forEach(f2 -> f2.accept(new a()));
        e.debug("Assign components - done");
    }

    @Override
    public void a(IWorkerContext workerContext, SoftwareSystem softwareSystem, boolean onSystemOpen) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'componentModelModified' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'parserModelModified' must not be null";
        List<ArchitectureFile> checked = this.b(onSystemOpen);
        if (onSystemOpen) {
            this.l();
        }
        this.d(workerContext, checked);
    }

    @Override
    public void a(IWorkerContext workerContext, SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToBeDisptached, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'cleared' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'cleared' must not be null";
        assert (eventsToBeDisptached != null) : "Parameter 'eventsToBeDisptached' of method 'cleared' must not be null";
        this.b(false);
    }

    @Override
    public void a(IWorkerContext workerContext, AnalyzerConfigurationChangeMode mode, AnalyzerConfiguration configuration, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'configurationChanged' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'configurationChanged' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'configurationChanged' must not be null";
        assert (result != null) : "Parameter 'result' of method 'configurationChanged' must not be null";
        if (mode != AnalyzerConfigurationChangeMode.OPEN && configuration.affects(CoreAnalyzerId.ARCHITECTURE_CHECK)) {
            if (modifications != null) {
                modifications.add(Modification.ARCHITECTURE_MODIFIED);
            }
            this.m();
            List<ArchitectureFile> checked = this.b(true);
            this.d(workerContext, checked);
        }
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, List<? extends Element> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteArchitectureFileElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'deleteArchitectureFileElements' must not be empty";
        OperationResult result = new OperationResult("Delete architecture file element(s)");
        this.a(result);
        if (result.isFailure()) {
            return result;
        }
        g analyzerExtension = this.d().getExtension(g.class);
        Set<AnalyzerGroup> allToRestart = analyzerExtension.a(a, ResetMode.ALL);
        Set<NamedElement> normalized = this.a(elements);
        ArrayList<String> removedEntries = new ArrayList<String>();
        ArchitectureCheckConfiguration configuration = this.i();
        assert (configuration != null) : "'configuration' of method 'deleteArchitectureFileElements' must not be null";
        for (NamedElement nextNamedElement : normalized) {
            if (!(nextNamedElement instanceof ArchitectureFile)) continue;
            ArchitectureFile nextArchitectureFile = (ArchitectureFile)nextNamedElement;
            String identifyingPath = nextArchitectureFile.getIdentifyingPath();
            if (configuration.isChecked(identifyingPath)) {
                removedEntries.add(identifyingPath);
            }
            this.b(identifyingPath);
            this.c(identifyingPath);
            SoftwareSystemFilesDirectory.removeFile(nextArchitectureFile.getFile(), false, result);
            nextArchitectureFile.remove();
        }
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        for (String next : removedEntries) {
            configuration.removeValue(next);
        }
        this.a(workerContext, modifications, analyzerExtension, result);
        analyzerExtension.a(allToRestart);
        result.setIsSuccess(true);
        return result;
    }

    private void a(IWorkerContext workerContext, EnumSet<Modification> modifications, g analyzerExtension, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'updateScriptRunnerConfiguration' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'finishWithArchitectureCheckConfigurationUpdate' must not be null";
        assert (analyzerExtension != null) : "Parameter 'analyzerExtension' of method 'finishWithArchitectureCheckConfigurationUpdate' must not be null";
        assert (result != null) : "Parameter 'result' of method 'updateScriptRunnerConfiguration' must not be null";
        AnalyzerConfigurationFile configuration = this.b();
        if (configuration != null) {
            configuration.setNeedsSave(true);
            result.addMessagesFrom(analyzerExtension.a(configuration));
        }
        this.a(workerContext);
        this.f.a(workerContext, this.d(), modifications, result);
    }

    boolean a(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'isChecked' must not be empty";
        ArchitectureCheckConfiguration configuration = this.i();
        return configuration != null && configuration.isChecked(identifyingPath);
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, ArchitectureFile architectureFile, String name) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editArchitectureFile' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'editArchitectureFile' must not be null";
        DirectoryPath directoryPath = architectureFile.getParent(DirectoryPath.class, new Class[0]);
        assert (directoryPath != null) : "'directoryPath' of method 'editArchitectureFile' must not be null";
        assert (this.getArchitectureFileNameValidator(directoryPath, architectureFile).isValid(null, name).isSuccess()) : "Not a valid name: " + name;
        OperationResult result = new OperationResult("Edit '" + architectureFile.getIdentifyingPath() + "'");
        this.a(result);
        if (result.isFailure()) {
            return result;
        }
        g analyzerExtension = this.d().getExtension(g.class);
        Set<AnalyzerGroup> allToRestart = analyzerExtension.a(a, ResetMode.ALL);
        try {
            if (this.a(architectureFile.getIdentifyingPath())) {
                AnalyzerConfigurationFile config = this.b();
                assert (config != null) : "'config' of method 'editArchitectureFile' must not be null";
                config.setNeedsSave(true);
            }
            Map<ArchitectureFile, String> architectureFileToNewContent = com.hello2morrow.sonargraph.core.controller.system.architecture.a.a(this.getAvailableArchitectureFiles(), architectureFile, name);
            for (Map.Entry<ArchitectureFile, String> nextEntry : architectureFileToNewContent.entrySet()) {
                ArchitectureFile nextArchitectureFile = nextEntry.getKey();
                String nextNewContent = nextEntry.getValue();
                nextArchitectureFile.setContent(nextNewContent, true);
                result.addMessagesFrom(this.c(nextArchitectureFile));
            }
            String previousIdentifyingPath = architectureFile.getIdentifyingPath();
            TFile targetFile = new TFile((File)directoryPath.getFile(), String.valueOf(name) + CoreFileType.ARCHITECTURE.getDefaultExtension());
            try {
                architectureFile.getFile().mv((File)targetFile);
                architectureFile.setPath(targetFile);
                if (architectureFile.needsSave()) {
                    result.addMessagesFrom(this.c(architectureFile));
                }
            }
            catch (IOException e2) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE);
                OperationResult operationResult = result;
                analyzerExtension.a(allToRestart);
                return operationResult;
            }
            String content = this.c(previousIdentifyingPath);
            this.b(architectureFile.getIdentifyingPath(), content);
            this.a(previousIdentifyingPath, architectureFile.getIdentifyingPath());
            ArchitectureCheckConfiguration configuration = this.i();
            if (configuration != null) {
                configuration.replaceIfPresent(previousIdentifyingPath, architectureFile.getIdentifyingPath());
            }
            this.a(workerContext, EnumSet.noneOf(Modification.class), analyzerExtension, result);
        }
        finally {
            analyzerExtension.a(allToRestart);
        }
        return result;
    }

    OperationResult c(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'save' must not be null";
        this.f(architectureFile);
        architectureFile.setNeedsSave(true);
        OperationResult saveResult = this.g().save(architectureFile, architectureFile.getFile());
        this.b(architectureFile.getIdentifyingPath(), architectureFile.getContent());
        if (saveResult.isSuccess()) {
            TrueZipFacade.sync((TFile)architectureFile.getFile());
            architectureFile.setNeedsSave(false);
        }
        return saveResult;
    }

    @Override
    public List<ArchitectureFile> d(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getApplyingFiles' must not be null";
        return com.hello2morrow.sonargraph.core.controller.system.architecture.a.a(this.getAvailableArchitectureFiles(), architectureFile);
    }

    public void a(ArchitectureFile architectureFile, Set<ArchitectureFile> collector) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getApplyingAndRequiringFilesRecursively' must not be null";
        List<ArchitectureFile> applyingAndRequiringFiles = this.d(architectureFile);
        for (ArchitectureFile next : applyingAndRequiringFiles) {
            if (!collector.add(next)) continue;
            this.a(next, collector);
        }
    }

    @Override
    public OperationResultWithOutcome<ArchitectureFile> a(IWorkerContext workerContext, String name, DirectoryPath directoryPath, boolean addExampleSnippet) {
        ArchitectureFile architectureFile;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createArchitectureFile' must not be null";
        assert (name != null) : "Parameter 'name' of method 'createArchitectureFile' must not be null";
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'createArchitectureFile' must not be null";
        assert (this.getArchitectureFileNameValidator(directoryPath, null).isValid(null, name).isSuccess()) : "Not a valid name: " + name;
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create Architecture File");
        this.a((OperationResult)result);
        if (result.isFailure()) {
            return result;
        }
        TFile file = new TFile((File)directoryPath.getFile(), String.valueOf(name) + CoreFileType.ARCHITECTURE.getDefaultExtension());
        if (addExampleSnippet) {
            String content = al.a(this.d());
            architectureFile = new ArchitectureFile(directoryPath, file, file.lastModified(), this.d().getUniqueExistingChild(Files.class), content);
        } else {
            architectureFile = new ArchitectureFile(directoryPath, file, file.lastModified(), this.d().getUniqueExistingChild(Files.class), al.a());
        }
        this.b(architectureFile.getIdentifyingPath(), architectureFile.getContent());
        OperationResult saveResult = this.g().save(architectureFile, file);
        result.addMessagesFrom(saveResult);
        TrueZipFacade.sync((TFile)file);
        if (saveResult.isSuccess()) {
            architectureFile.setExistsOnDisk(true);
            architectureFile.resetTimestamp();
        }
        TrueZipFacade.clear((TFile)file);
        if (result.isSuccess()) {
            directoryPath.addChild(architectureFile);
            result.setOutcome((Object)architectureFile);
        }
        this.e(architectureFile);
        ArchitectureCheckConfiguration configuration = this.i();
        if (configuration != null && configuration.isChecked(architectureFile.getIdentifyingPath())) {
            g analyzerExtension = this.d().getExtension(g.class);
            Set<AnalyzerGroup> allToRestart = analyzerExtension.a(a, ResetMode.ALL);
            architectureFile.checked(true);
            this.a(workerContext);
            this.m();
            this.f.a(workerContext, this.d(), EnumSet.of(Modification.ARCHITECTURE_MODIFIED), (OperationResult)result);
            analyzerExtension.a(allToRestart);
        } else if (addExampleSnippet) {
            h loader = new h(this);
            loader.b(architectureFile);
            this.f.a(workerContext, this.d(), EnumSet.of(Modification.ARCHITECTURE_MODIFIED), (OperationResult)result);
        } else {
            this.f.a(workerContext, this.d(), EnumSet.noneOf(Modification.class), (OperationResult)result);
        }
        return result;
    }

    ArchitectureFile a(IWorkerContext workerContext, TFile generatedArchitectureFile, boolean addToArchitectureCheck, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'architectureFileGenerated' must not be null";
        assert (generatedArchitectureFile != null) : "Parameter 'generatedArchitectureFile' of method 'architectureFileGenerated' must not be null";
        assert (result != null) : "Parameter 'result' of method 'architectureFileGenerated' must not be null";
        assert (FileUtility.areEqual((TFile)this.h().getDirectoryFile(), (TFile)generatedArchitectureFile.getParentFile())) : "File not underneath the architecture directory: " + generatedArchitectureFile;
        Path architectureFile = null;
        for (ArchitectureFile next : this.getAvailableArchitectureFiles()) {
            if (!FileUtility.areEqual((TFile)next.getFile(), (TFile)generatedArchitectureFile)) continue;
            architectureFile = next;
            break;
        }
        boolean checked = false;
        if (architectureFile == null) {
            String architectureFileName = FileUtility.removeExtension((String)generatedArchitectureFile.getName());
            assert (this.getArchitectureFileNameValidator(this.h(), null).isValid(null, architectureFileName).isSuccess()) : "Not a valid name: " + architectureFileName;
            architectureFile = new ArchitectureFile(this.h(), generatedArchitectureFile, generatedArchitectureFile.lastModified(), this.d().getUniqueExistingChild(Files.class));
            this.g().load(generatedArchitectureFile, (ArchitectureFile)architectureFile, result);
            if (result.isSuccess()) {
                this.h().addChild(architectureFile);
                this.b(((ModifiableFile)architectureFile).getIdentifyingPath(), ((ArchitectureFile)architectureFile).getContent());
                this.e((ArchitectureFile)architectureFile);
                ArchitectureCheckConfiguration configuration = this.i();
                assert (configuration != null) : "Parameter 'configuration' of method 'architectureFileGenerated' must not be null";
                if (configuration.isChecked(((ModifiableFile)architectureFile).getIdentifyingPath())) {
                    checked = true;
                } else if (addToArchitectureCheck) {
                    configuration.addIdentifyingPath(((ModifiableFile)architectureFile).getIdentifyingPath());
                    AnalyzerConfigurationFile analyzerConfigurationFile = this.b();
                    assert (analyzerConfigurationFile != null) : "Parameter 'analyzerConfigurationFile' of method 'architectureFileGenerated' must not be null";
                    analyzerConfigurationFile.setNeedsSave(true);
                    checked = true;
                }
            }
        } else {
            this.a(generatedArchitectureFile, architectureFile.getFile(), (ArchitectureFile)architectureFile, false);
            checked = ((ArchitectureFile)architectureFile).isChecked();
        }
        ((ArchitectureFile)architectureFile).checked(checked);
        this.a(workerContext);
        this.m();
        return architectureFile;
    }

    @Override
    public void modifyArchitectureFileSource(ArchitectureFile architectureFile, String content, IOriginator originator) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'modifyArchitectureFileSource' must not be null";
        assert (content != null) : "Parameter 'content' of method 'modifyArchitectureFileSource' must not be null";
        assert (originator != null) : "Parameter 'originator' of method 'modifyArchitectureFileSource' must not be null";
        architectureFile.setContent(content, false);
        if (!architectureFile.needsSave()) {
            architectureFile.setNeedsSave(true);
            this.f.a((IWorkerContext)DefaultWorkerContext.INSTANCE, this.d(), EnumSet.noneOf(Modification.class), originator, new OperationResult("Modify architecture file source"));
        }
    }

    OperationResult a(IWorkerContext workerContext, List<ArchitectureFile> files, Map<IModifiableFile, IModificationOnSave> modificationsOnSave) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'saveFiles' must not be null";
        assert (files != null && !files.isEmpty()) : "Parameter 'files' of method 'saveFile' must not be empty";
        e.debug("Save files");
        OperationResult result = new OperationResult("Save architecture files");
        ArchitectureFilePersistence persistence = this.g();
        for (ArchitectureFile nextArchitectureFile : files) {
            String content;
            String modifiedContent;
            this.f(nextArchitectureFile);
            IModificationOnSave modification = modificationsOnSave.get(nextArchitectureFile);
            if (modification != null && !(modifiedContent = modification.apply(content = nextArchitectureFile.getContent())).equals(content)) {
                nextArchitectureFile.setContent(modifiedContent, true);
            }
            nextArchitectureFile.setNeedsSave(true);
            OperationResult saveResult = persistence.save(nextArchitectureFile, nextArchitectureFile.getFile());
            if (saveResult.isSuccess()) {
                nextArchitectureFile.setNeedsSave(false);
            }
            result.addMessagesFrom(saveResult);
            this.b(nextArchitectureFile.getIdentifyingPath(), nextArchitectureFile.getContent());
        }
        this.a(workerContext);
        e.debug("Save files - done");
        return result;
    }

    @Override
    public OperationResult b(IWorkerContext workerContext, List<Element> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'addToArchitectureCheck' must not be null";
        assert (this.mayBeAddedToArchitectureCheck(elements)) : "Not valid elements to be added";
        OperationResult result = new OperationResult("Add to architecture check");
        ArchitectureCheckConfiguration configuration = this.a(true);
        for (Element next : elements) {
            assert (next != null && next instanceof ArchitectureFile) : "Unexpected class in method 'addToArchitectureCheck': " + next;
            configuration.addIdentifyingPath(((ArchitectureFile)next).getIdentifyingPath());
        }
        result.addMessagesFrom(this.d().getExtension(g.class).a(workerContext, configuration));
        return result;
    }

    @Override
    public OperationResult c(IWorkerContext workerContext, List<Element> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'removeFromArchitectureCheck' must not be null";
        assert (this.mayBeRemovedFromArchitectureCheck(elements)) : "Not valid elements to be removed";
        OperationResult result = new OperationResult("Remove from architecture check");
        ArchitectureCheckConfiguration configuration = this.a(true);
        for (Element next : elements) {
            assert (next != null && next instanceof ArchitectureFile) : "Unexpected class in method 'removeFromArchitectureCheck': " + next;
            ArchitectureFile nextArchitectureFile = (ArchitectureFile)next;
            nextArchitectureFile.setHasViolations(false);
            nextArchitectureFile.setHasDeprecations(false);
            configuration.removeIdentifyingPath(nextArchitectureFile.getIdentifyingPath());
        }
        result.addMessagesFrom(this.d().getExtension(g.class).a(workerContext, configuration));
        return result;
    }

    public List<IModifiableFile> e() {
        ArrayList<IModifiableFile> result = new ArrayList<IModifiableFile>();
        result.addAll(this.h().getChildrenRecursively(ArchitectureFile.class, new Class[0]));
        return result;
    }

    @Override
    public boolean a(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'exports' must not be null";
        return CoreFileType.ARCHITECTURE.equals(modifiableFile.getFileType());
    }

    @Override
    public String f() {
        return "Architecture";
    }

    @Override
    public void a(IModifiableFile modifiableFile, TFile targetFile, OperationResult result) {
        assert (modifiableFile != null && modifiableFile instanceof ArchitectureFile) : "Unexpected class in method 'exportFile': " + modifiableFile;
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'exportFile' must not be null";
        ArchitectureFile architectureFile = (ArchitectureFile)modifiableFile;
        result.addMessagesFrom(this.g().save(architectureFile, targetFile));
    }

    @Override
    public void a(IWorkerContext workerContext, ImportQualityModel importQualityModel, EnumSet<Modification> modfications, OperationResult result) {
        assert (importQualityModel != null) : "Parameter 'importQualityModel' of method 'importFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'importFiles' must not be null";
        List<ImportQualityModel.ImportQualityModelCandidate> candidates = importQualityModel.getCandidatesByFileType(CoreFileType.ARCHITECTURE);
        Architecture architecture = this.h();
        block0: for (ImportQualityModel.ImportQualityModelCandidate nextImportQualityModelCandidate : candidates) {
            if (!nextImportQualityModelCandidate.isIncluded()) continue;
            TFile contentFile = nextImportQualityModelCandidate.getModifiableFile().getFile();
            String contentFileIdentifyingPath = nextImportQualityModelCandidate.getModifiableFile().getIdentifyingPath();
            if (importQualityModel.discardCurrentContent() || !nextImportQualityModelCandidate.isAlreadyInModel()) {
                TFile targetFile = new TFile((File)architecture.getFile(), contentFileIdentifyingPath).getNormalizedFile();
                result.addMessagesFrom(this.a(contentFile, targetFile.getNormalizedFile(), null, true));
                continue;
            }
            if (importQualityModel.discardCurrentContent()) continue;
            for (IModifiableFile nextAvailable : this.e()) {
                assert (nextAvailable != null && nextAvailable instanceof ArchitectureFile) : "Unexpected class in method 'importFiles': " + nextAvailable;
                if (!nextAvailable.getIdentifyingPath().equals(contentFileIdentifyingPath)) continue;
                result.addMessagesFrom(this.a(contentFile, nextAvailable.getFile(), (ArchitectureFile)nextAvailable, true));
                continue block0;
            }
        }
    }

    @Override
    public void a(IWorkerContext workerContext, EnumSet<Modification> modfications, OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'discardFiles' must not be null";
        this.j();
        this.h().removeAll(result);
    }

    @Override
    public void b(IWorkerContext workerContext, EnumSet<Modification> modfications, OperationResult result) {
        this.a(workerContext);
        this.m();
    }

    @Override
    public void a(TFile qualityModel) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'setQualityModelRoot' must not be null";
        this.h().setPath(new TFile((File)qualityModel, "./Architecture"));
    }

    @Override
    public IAssignableAttributeRetriever getAttributeRetriever(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getAttributeRetriver' must not be empty";
        return this.g.get(name);
    }

    @Override
    public OperationResult exportArchitectureToXmlFile(IWorkerContext workerContext, ArchitectureFile file, TFile targetFile) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'exportArchitectureToXmlFile' must not be null";
        assert (file != null) : "Parameter 'file' of method 'exportArchitectureToXmlFile' must not be null";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportArchitectureToXmlFile' must not be null";
        OperationResult result = new OperationResult("Exporting Arhitecture to XML File");
        if (targetFile.isDirectory()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.CANNOT_OVERWRITE_DIRECTORY);
            return result;
        }
        new ArchitectureXmlPersistence().save(file, targetFile, result);
        return result;
    }

    static /* synthetic */ int[] c() {
        if (h != null) {
            return h;
        }
        int[] nArray = new int[IArchitecturalModelProvider.ArchitectureModel.values().length];
        try {
            nArray[IArchitecturalModelProvider.ArchitectureModel.LOGICAL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IArchitecturalModelProvider.ArchitectureModel.PHYSICAL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        h = nArray;
        return nArray;
    }

    private static final class a
    implements NamedElement.INamedElementVisitor {
        private a() {
        }

        @Override
        public void visitChildrenOf(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'namedElement' of method 'visitChildrenOf' must not be null";
            namedElement.getChildren().forEach(c2 -> c2.accept(this));
        }

        @Override
        public void visitNamedElement(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'namedElement' of method 'visitNamedElement' must not be null";
            namedElement.finishModification();
            this.visitChildrenOf(namedElement);
        }
    }
}

