/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.x;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.EmptyNodeProgrammingElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyEndPoints;
import com.hello2morrow.sonargraph.core.model.explorationview.ReadOnlyArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class aL
extends x
implements ArchitecturalViewNode.IVisitor {
    private static final Logger c = LoggerFactory.getLogger(aL.class);
    private static final Set<ArchitecturalViewNode> d = new THashSet();
    private static final Set<ProgrammingElement> e = new THashSet();
    private static ArchitecturalViewElement f;
    private static int g;
    private final Set<ParserDependency> h = new THashSet();
    private final List<ArchitecturalViewNode> i;
    private final List<AssignableToArtifactNode> j;
    private final boolean k;

    private static void a(ArchitecturalViewElement element, String error) {
        assert (element != null) : "Parameter 'element' of method 'logError' must not be null";
        assert (error != null && error.length() > 0) : "Parameter 'error' of method 'logError' must not be empty";
        if (f == null || f != element) {
            c.error("Integrity check failed for '" + (element instanceof ExplorationViewRepresentation ? "Representation" : element.getRelativePath()) + "' (" + element.getElementInfo(false, true) + ")");
            f = element;
        }
        c.error(error);
        ++g;
    }

    private static void a(String error) {
        assert (error != null && error.length() > 0) : "Parameter 'error' of method 'logError' must not be empty";
        c.error(error);
        ++g;
    }

    private static void a(ArchitecturalViewNode node, Collection<ProgrammingElement> programmingElements, Collection<ProgrammingElement> relevantProgrammingElements) {
        assert (node != null) : "Parameter 'node' of method 'checkProgrammingElementIntegrity' must not be null";
        assert (relevantProgrammingElements != null) : "Parameter 'relevantProgrammingElements' of method 'checkProgrammingElementIntegrity' must not be null";
        if (d.add(node)) {
            ArchitecturalViewElement nextParent;
            for (ProgrammingElement nextProgrammingElement : node.getRelevantProgrammingElements()) {
                if (e.add(nextProgrammingElement)) continue;
                aL.a(node, "Contains duplicate relevant programming element: " + nextProgrammingElement.getFullyQualifiedName() + " [" + nextProgrammingElement.getClass().getName() + "]");
            }
            e.clear();
            if (programmingElements != null) {
                for (ProgrammingElement nextProgrammingElement : node.getProgrammingElements()) {
                    if (e.add(nextProgrammingElement)) continue;
                    aL.a(node, "Contains duplicate programming element: " + nextProgrammingElement.getFullyQualifiedName() + " [" + nextProgrammingElement.getClass().getName() + "]");
                }
                e.clear();
            }
            if ((nextParent = node.getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT)) == null) {
                aL.a(node, "Has no parent");
            } else if (nextParent instanceof ArchitecturalViewNode) {
                if (!(node.isSuppressed() || nextParent.isSuppressed() || node.getPresentationMode() == PresentationMode.FLAT && node.isRecursive() && nextParent.isRecursive())) {
                    e.addAll(((ArchitecturalViewNode)nextParent).getRelevantProgrammingElements());
                    if (!e.containsAll(relevantProgrammingElements)) {
                        aL.a(node, "Parent does not contain all relevant programming elements: " + nextParent.getElementInfo());
                    }
                    e.clear();
                }
                if (programmingElements != null) {
                    e.addAll(((ArchitecturalViewNode)nextParent).getProgrammingElements());
                    if (!e.containsAll(programmingElements)) {
                        aL.a(node, "Parent does not contain all programming elements: " + nextParent.getElementInfo());
                    }
                    e.clear();
                }
                aL.a((ArchitecturalViewNode)nextParent, programmingElements, relevantProgrammingElements);
            }
        }
    }

    private static String a(Collection<? extends NamedElement> children) {
        assert (children != null && !children.isEmpty()) : "Parameter 'children' of method 'getChildrenList' must not be empty";
        StringBuilder builder = new StringBuilder();
        int i2 = 1;
        for (NamedElement namedElement : children) {
            builder.append("\n[").append(i2).append("] ");
            builder.append(namedElement.getName());
            builder.append(" (").append(namedElement.getClass().getSimpleName()).append(")");
            ++i2;
        }
        return builder.toString();
    }

    private aL(List<ArchitecturalViewNode> leafsCollector, List<AssignableToArtifactNode> assignableToArtifactNodesCollector, boolean programmingElementsChanged) {
        assert (leafsCollector != null) : "Parameter 'leafsCollector' of method 'StructureIntegrityChecker' must not be null";
        this.i = leafsCollector;
        this.j = assignableToArtifactNodesCollector;
        this.k = programmingElementsChanged;
    }

    private void a(ArchitecturalViewElement element) {
        List<NamedElement> children;
        assert (element != null) : "Parameter 'element' of method 'checkElement' must not be null";
        if (!element.isValid()) {
            aL.a(element, "Element is not valid");
        }
        if (ArchitecturalViewElement.VISIBLE.test(element) && !element.isSuppressed() && element.getRelativeIndex() == -1) {
            aL.a(element, "Has no relative index");
        }
        if ((element instanceof ExplorationViewRepresentation || element instanceof ArtifactPropertiesNode) && !(children = element.getChildren()).isEmpty()) {
            int startIndex = 0;
            if (element instanceof ArtifactNode) {
                if (!(children.get(0) instanceof ArtifactNodeFilter)) {
                    aL.a(element, "Inconsistent child order: " + aL.a(children));
                } else {
                    startIndex = 1;
                }
            } else if (element instanceof ReadOnlyArtifactNode) {
                startIndex = 0;
            }
            boolean inArtifactSection = true;
            int i2 = startIndex;
            while (i2 < children.size()) {
                NamedElement next = children.get(i2);
                if (next instanceof ArtifactPropertiesNode) {
                    if (!inArtifactSection) {
                        aL.a(element, "Inconsistent child order: " + aL.a(children));
                        break;
                    }
                } else {
                    inArtifactSection = false;
                }
                ++i2;
            }
        }
    }

    @Override
    public void visitArchitecturalViewElement(ArchitecturalViewElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewElement' must not be null";
        this.a(element);
        this.visitChildrenOf(element);
    }

    private void a(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'checkNode' must not be null";
        this.a((ArchitecturalViewElement)node);
        ArchitecturalViewNode nodeParent = node.getNodeParent();
        if (nodeParent != null) {
            if (nodeParent.isSuppressed()) {
                aL.a(node, "Node parent must not be suppressed");
            }
        } else {
            ArchitecturalViewElement elementParent = node.getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT);
            if (elementParent == null) {
                aL.a(node, "Has no element parent");
            } else if (elementParent instanceof ArchitecturalViewNode && !node.isDeleted()) {
                aL.a(node, "Non-top-level node may only return a null-node-parent if it has been deleted");
            }
        }
        if (node.isExpanded() && !node.isExpandable()) {
            aL.a(node, "Node is expanded but is not expandable");
        }
        if (node.isExpanded() && !node.isVisible()) {
            aL.a(node, "Node is expanded but not visible");
        }
        if (node.isSelected() && !node.isVisible()) {
            aL.a(node, "Node is selected but not visible");
        }
        if (node.isVisible() && nodeParent != null) {
            if (!nodeParent.isExpanded()) {
                aL.a(node, "Node is visible but parent is not expanded");
            }
            if (nodeParent.isSuppressed()) {
                aL.a(node, "Node is visible but parent is suppressed");
            }
            if (nodeParent.isRemovedByFocus()) {
                aL.a(node, "Node is visible but parent is removed by focus");
            }
            if (nodeParent.isDeleted()) {
                aL.a(node, "Node is visible but parent is deleted");
            }
        }
    }

    private void b(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'checkNodeDependencies' must not be null";
        Collection<ArchitecturalViewNode.ArchitecturalViewDependency> outgoing = node.getOutgoingDependencies();
        if (!outgoing.isEmpty()) {
            for (ArchitecturalViewNode.ArchitecturalViewDependency nextOut : outgoing) {
                for (ParserDependency nextOutParserDependency : nextOut.getParserDependencies()) {
                    if (this.h.add(nextOutParserDependency)) continue;
                    aL.a(node, "Outgoing parser dependency already found: " + nextOutParserDependency);
                }
            }
            if (!node.isVisible()) {
                aL.a(node, "Node with outgoing dependencies not visible");
            }
            for (ArchitecturalViewNode.ArchitecturalViewDependency nextOut : outgoing) {
                int nextNumberOfParserDependencies;
                ArchitecturalViewNode nextTo = nextOut.getTo();
                if (!nextTo.isVisible()) {
                    aL.a(node, "Has dependency to '" + nextTo.getElementInfo() + "' but 'to' is not visible");
                }
                if ((nextNumberOfParserDependencies = nextOut.getNumberOfParserDependencies()) <= 0) {
                    aL.a(node, "Has dependency to '" + nextTo.getElementInfo() + "' but number of parser dependencies are: " + nextNumberOfParserDependencies);
                    continue;
                }
                int nextNumberOfParserDependenciesViolating = nextOut.getNumberOfParserDependenciesViolating();
                if (nextNumberOfParserDependencies >= nextNumberOfParserDependenciesViolating) continue;
                aL.a(node, "Has dependency to '" + nextTo.getElementInfo() + "' but number of violating parser dependencies are more than the total: " + nextNumberOfParserDependencies + "/" + nextNumberOfParserDependenciesViolating);
            }
        }
    }

    private void a(RecursiveNode recursiveNode) {
        ArchitecturalViewNode parentOfRecursiveNode;
        assert (recursiveNode != null) : "Parameter 'recursiveNode' of method 'checkRecursiveNode' must not be null";
        if (recursiveNode.isSuppressed()) {
            ArchitecturalViewNode parent = recursiveNode.getParent(ArchitecturalViewNode.class, new Class[0]);
            if (parent == null) {
                aL.a(recursiveNode, "Suppressed node has no direct parent");
            }
            if (recursiveNode.isVisible()) {
                aL.a(recursiveNode, "Suppressed node is visible");
            }
            if (recursiveNode.isExpanded()) {
                aL.a(recursiveNode, "Suppressed node is expanded");
            }
            if (recursiveNode.isSelected()) {
                aL.a(recursiveNode, "Suppressed node is selected");
            }
        }
        if ((parentOfRecursiveNode = recursiveNode.getNodeParent()) != null && recursiveNode.getPresentationMode() == PresentationMode.FLAT && parentOfRecursiveNode.isRecursive()) {
            aL.a(recursiveNode, "Recursive node has a recursive node parent in 'Flat' mode: " + parentOfRecursiveNode.getElementInfo());
        }
    }

    private void c(ArchitecturalViewNode node) {
        StringBuilder info;
        THashSet nextSharedProgrammingElements;
        List<ArchitecturalViewNode> nodeChildren;
        assert (node != null) : "Parameter 'node' of method 'checkSharedChildren' must not be null";
        if (this.k) {
            nodeChildren = node.getAllNodeChildren(n2 -> true, false);
            for (ArchitecturalViewNode nextChild : nodeChildren) {
                for (ArchitecturalViewNode nextChildToCheckAgainst : nodeChildren) {
                    if (nextChild == nextChildToCheckAgainst) continue;
                    nextSharedProgrammingElements = new THashSet(nextChild.getProgrammingElements());
                    nextSharedProgrammingElements.retainAll(nextChildToCheckAgainst.getProgrammingElements());
                    if (nextSharedProgrammingElements.isEmpty()) continue;
                    info = new StringBuilder("Children in same parent share programming elements\n");
                    info.append("Shares with: ").append(nextChildToCheckAgainst.getElementInfo()).append("\n");
                    info.append(nextSharedProgrammingElements.size()).append(" shared programming element(s): ");
                    info.append(aL.a((Collection<? extends NamedElement>)nextSharedProgrammingElements));
                    aL.a(nextChild, info.toString());
                }
            }
        }
        nodeChildren = node.getNodeChildren(n2 -> true, false);
        for (ArchitecturalViewNode nextChild : nodeChildren) {
            for (ArchitecturalViewNode nextChildToCheckAgainst : nodeChildren) {
                if (nextChild == nextChildToCheckAgainst) continue;
                nextSharedProgrammingElements = new THashSet(nextChild.getRelevantProgrammingElements());
                nextSharedProgrammingElements.retainAll(nextChildToCheckAgainst.getRelevantProgrammingElements());
                if (nextSharedProgrammingElements.isEmpty()) continue;
                info = new StringBuilder("Children in same parent share relevant programming elements\n");
                info.append("Shares with: ").append(nextChildToCheckAgainst.getElementInfo()).append("\n");
                info.append(nextSharedProgrammingElements.size()).append(" shared programming element(s): ");
                info.append(aL.a((Collection<? extends NamedElement>)nextSharedProgrammingElements));
                aL.a(nextChild, info.toString());
            }
        }
    }

    @Override
    public void visitArchitecturalViewNode(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'visitArchitecturalViewNode' must not be null";
        this.a(node);
        this.b(node);
        if (node.isRecursive()) {
            if (!(node instanceof RecursiveNode)) {
                aL.a(node, "Is recursive but is of class: " + node.getClass().getSimpleName());
            } else {
                this.a((RecursiveNode)node);
            }
        } else {
            if (node instanceof RecursiveNode) {
                aL.a(node, "Is not recursive but is of class: " + node.getClass().getSimpleName());
            }
            if (node.isSuppressed()) {
                aL.a(node, "Suppressed node is not a recursive node: " + node.getClass().getSimpleName());
            }
            if (node.isPart()) {
                aL.a(node, "Part node is not a recursive node: " + node.getClass().getSimpleName());
            }
            if (node.isDeletedFlat()) {
                aL.a(node, "Deleted flat node is not a recursive node: " + node.getClass().getSimpleName());
            }
        }
        this.c(node);
        if (this.j != null && node instanceof AssignableToArtifactNode) {
            this.j.add((AssignableToArtifactNode)node);
        }
        if (!node.hasChildren()) {
            this.i.add(node);
        }
        this.visitChildrenOf(node);
    }

    static void a(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'checkAfterInitialCreation' must not be null";
        if (c.isDebugEnabled()) {
            c.debug("Check after initial creation");
            TreeSet<String> missingProgrammingElements = new TreeSet<String>();
            ParserDependencyEndPoints endPoints = new ParserDependencyEndPoints();
            for (ProgrammingElement nextProgrammingElement : representation.getProgrammingElements()) {
                Iterator<ParserDependency> nextIterator = nextProgrammingElement.getDependencyIterator();
                while (nextIterator.hasNext()) {
                    ParserDependency nextParserDependency = nextIterator.next();
                    if (!representation.includeParserDependency(nextParserDependency, endPoints)) continue;
                    ArchitecturalViewNode nextFromNode = representation.getLeafNode(endPoints.getFrom());
                    ArchitecturalViewNode nextToNode = representation.getLeafNode(endPoints.getTo());
                    if (nextFromNode == null || nextToNode == null) {
                        if (endPoints.getFrom() == nextProgrammingElement) {
                            if (nextFromNode == null) {
                                aL.a("Missing leaf node for 'from' of outgoing dependency:\n<MISSING> " + endPoints.getFrom().getFullyQualifiedName() + " -> " + endPoints.getTo().getFullyQualifiedName());
                                missingProgrammingElements.add(endPoints.getFrom().getFullyQualifiedName());
                            }
                            if (nextToNode == null) {
                                aL.a("Missing leaf node for 'to' of outgoing dependency:\n" + endPoints.getFrom().getFullyQualifiedName() + " -> <MISSING> " + endPoints.getTo().getFullyQualifiedName());
                                missingProgrammingElements.add(endPoints.getTo().getFullyQualifiedName());
                            }
                        } else {
                            if (nextFromNode == null) {
                                aL.a("Missing leaf node for 'from' of incoming dependency:\n<MISSING> " + endPoints.getFrom().getFullyQualifiedName() + " -> " + endPoints.getTo().getFullyQualifiedName());
                                missingProgrammingElements.add(endPoints.getFrom().getFullyQualifiedName());
                            }
                            if (nextToNode == null) {
                                aL.a("Missing leaf node for 'to' of incoming dependency:\n" + endPoints.getFrom().getFullyQualifiedName() + " -> <MISSING> " + endPoints.getTo().getFullyQualifiedName());
                                missingProgrammingElements.add(endPoints.getTo().getFullyQualifiedName());
                            }
                        }
                    }
                    endPoints.reset();
                }
            }
            if (!missingProgrammingElements.isEmpty()) {
                for (String next : missingProgrammingElements) {
                    aL.a("Missing programming element: " + next);
                }
            }
            c.debug("Check after initial creation - done");
        }
    }

    static void a(ExplorationViewRepresentation representation, boolean programmingElementsChanged) {
        assert (representation != null) : "Parameter 'representation' of method 'check' must not be null";
        if (c.isDebugEnabled()) {
            c.debug("Check structure integrity" + (programmingElementsChanged ? " [programming elements changed]" : ""));
            ArrayList<ArchitecturalViewNode> leafs = new ArrayList<ArchitecturalViewNode>();
            ArrayList<AssignableToArtifactNode> assignableToArtifactNodesCollector = programmingElementsChanged ? new ArrayList<AssignableToArtifactNode>() : null;
            ((ArchitecturalViewElement)representation).accept(new aL(leafs, assignableToArtifactNodesCollector, programmingElementsChanged));
            if (programmingElementsChanged) {
                Collection<ProgrammingElement> allRepresentationProgrammingElements = representation.getProgrammingElements();
                int numberOfProgrammingElements = 0;
                for (ArchitecturalViewNode nextNode : representation.getChildren(ArchitecturalViewNode.class)) {
                    numberOfProgrammingElements += nextNode.getNumberOfProgrammingElements();
                }
                if (allRepresentationProgrammingElements.size() != numberOfProgrammingElements) {
                    aL.a((ArchitecturalViewElement)representation, "Different number of programnming elements (representation/cumulated): " + allRepresentationProgrammingElements.size() + "/" + numberOfProgrammingElements);
                }
                THashSet checkProgrammingElements = new THashSet();
                for (ArchitecturalViewNode next : leafs) {
                    Collection<ProgrammingElement> nextProgrammingElements = next.getProgrammingElements();
                    Collection<ProgrammingElement> nextVisibleProgrammingElements = next.getRelevantProgrammingElements();
                    checkProgrammingElements.addAll(nextVisibleProgrammingElements);
                    checkProgrammingElements.removeAll(nextProgrammingElements);
                    if (!checkProgrammingElements.isEmpty()) {
                        aL.a(next, "Not all relevant programming elements found: " + aL.a((Collection<? extends NamedElement>)checkProgrammingElements));
                    }
                    checkProgrammingElements.clear();
                }
                THashSet all = new THashSet(allRepresentationProgrammingElements);
                THashSet notFound = new THashSet();
                for (AssignableToArtifactNode next : assignableToArtifactNodesCollector) {
                    Collection<ProgrammingElement> nextProgrammingElements = next.getProgrammingElements();
                    Collection<ProgrammingElement> nextVisibleProgrammingElements = next.getRelevantProgrammingElements();
                    for (ProgrammingElement remove : nextProgrammingElements) {
                        if (all.remove(remove) || remove instanceof EmptyNodeProgrammingElement) continue;
                        notFound.add(remove);
                    }
                    aL.a(next, nextProgrammingElements, nextVisibleProgrammingElements);
                }
                if (!all.isEmpty()) {
                    aL.a((ArchitecturalViewElement)representation, "Not all programming elements found: " + aL.a((Collection<? extends NamedElement>)all));
                }
                if (!notFound.isEmpty()) {
                    aL.a((ArchitecturalViewElement)representation, "To many programming elements found: " + aL.a((Collection<? extends NamedElement>)notFound));
                }
            } else {
                for (ArchitecturalViewNode next : leafs) {
                    Collection<ProgrammingElement> nextVisibleProgrammingElements = next.getRelevantProgrammingElements();
                    aL.a(next, null, nextVisibleProgrammingElements);
                }
            }
            int numberOfDetectedErrors = g;
            d.clear();
            e.clear();
            g = 0;
            f = null;
            if (numberOfDetectedErrors == 0) {
                c.debug("Check structure integrity" + (programmingElementsChanged ? " [programming elements changed]" : "") + " - done [errors: 0]");
            } else {
                c.error("Check structure integrity" + (programmingElementsChanged ? " [programming elements changed]" : "") + " - done [errors: " + numberOfDetectedErrors + "]");
                if (c.isTraceEnabled()) assert (false) : "Integrity check failed with " + numberOfDetectedErrors + " error(s)";
            }
        }
    }
}

