/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.b;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.x;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElementHasAssignedElementsIssue;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElementHasNoAssignedElementsIssue;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactAssignmentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactOutgoingDependencyMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactVisibility;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOperationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyEndPoints;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementAggregatingNode;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class a {
    private static final Logger b = LoggerFactory.getLogger(a.class);
    private static volatile /* synthetic */ int[] c;
    private static volatile /* synthetic */ int[] d;
    private static volatile /* synthetic */ int[] e;

    private a() {
    }

    private static boolean a(ArtifactNode from, ArtifactNode anchor, ArtifactNode target) {
        assert (from != null) : "Parameter 'from' of method 'isHidden' must not be null";
        assert (anchor != null) : "Parameter 'parent' of method 'isHiddenFrom' must not be null";
        assert (target != null) : "Parameter 'target' of method 'isHiddenFrom' must not be null";
        assert (anchor == target || target.hasAsParent(anchor, false));
        if (anchor == target || from == anchor && target.getParent() == anchor) {
            return false;
        }
        ArtifactNode node = target;
        while (node != anchor) {
            if (node.getVisibility().contains(ArtifactVisibility.HIDDEN)) {
                return true;
            }
            node = node.getParent(ArtifactNode.class, ExplorationViewRepresentation.class);
        }
        return false;
    }

    private static boolean a(ArtifactNode anchor, ArtifactNode source) {
        assert (anchor != null) : "Parameter 'anchor' of method 'isLocal' must not be null";
        assert (source != null) : "Parameter 'source' of method 'isLocal' must not be null";
        assert (anchor == source || source.hasAsParent(anchor, false));
        if (anchor == source) {
            return false;
        }
        ArtifactNode node = source;
        while (node != anchor) {
            if (node.getVisibility().contains(ArtifactVisibility.LOCAL)) {
                return true;
            }
            node = node.getParent(ArtifactNode.class, ExplorationViewRepresentation.class);
        }
        return false;
    }

    private static String b(ArtifactNode from, ArtifactNode to) {
        String violationMessage = null;
        ArchitecturalViewElement commonParent = from.getParent(ArchitecturalViewElement.class, new Class[0]);
        while (!to.hasAsParent(commonParent, false)) {
            commonParent = commonParent.getParent(ArchitecturalViewElement.class, new Class[0]);
            assert (commonParent != null);
        }
        ArtifactNode fromAnchor = null;
        ArtifactPropertiesNode toAnchor = null;
        int fromIndex = -1;
        int toIndex = -1;
        int index = 0;
        for (ArtifactNode artifactNode : commonParent.getChildren(ArtifactNode.class)) {
            if (artifactNode == from || from.hasAsParent(artifactNode, false)) {
                fromAnchor = artifactNode;
                fromIndex = index;
            } else if (artifactNode == to || to.hasAsParent(artifactNode, false)) {
                toAnchor = artifactNode;
                toIndex = index;
            }
            if (fromAnchor != null && toAnchor != null) break;
            ++index;
        }
        assert (fromAnchor != null && toAnchor != null && fromAnchor != toAnchor);
        assert (fromIndex >= 0 && toIndex >= 0 && fromIndex != toIndex);
        if (com.hello2morrow.sonargraph.core.controller.system.explorationview.a.a(fromAnchor, from)) {
            violationMessage = String.format("'%s' cannot access '%s' because '%s' is <local>", from.getName(), to.getName(), from.getName());
        } else if (com.hello2morrow.sonargraph.core.controller.system.explorationview.a.a(from, toAnchor, to)) {
            violationMessage = String.format("'%s' cannot access '%s' because it is <hidden>", from.getName(), to.getName());
        } else if (!toAnchor.isPublic() || toIndex < fromIndex) {
            switch (com.hello2morrow.sonargraph.core.controller.system.explorationview.a.a()[fromAnchor.getOutgoingDependencyMode().ordinal()]) {
                case 2: {
                    if (toIndex >= fromIndex) break;
                    violationMessage = String.format("'%s' cannot access '%s' because it is defined above it", fromAnchor.getName(), toAnchor.getName());
                    break;
                }
                case 4: {
                    violationMessage = String.format("'%s' cannot access '%s'", fromAnchor.getName(), toAnchor.getName());
                    break;
                }
                case 3: {
                    if (toIndex - fromIndex == 1) break;
                    violationMessage = String.format("'%s' cannot access '%s' because it not directly beneath it", fromAnchor.getName(), toAnchor.getName());
                    break;
                }
            }
        }
        return violationMessage;
    }

    private static boolean c(ArtifactNode from, ArtifactNode to) {
        assert (from != null) : "Parameter 'from' of method 'checkUsingAllowedDependencies' must not be null";
        assert (to != null) : "Parameter 'to' of method 'checkUsingAllowedDependencies' must not be null";
        do {
            for (ArtifactNode target : from.getAllowed()) {
                if (target == to) {
                    return true;
                }
                if (!to.hasAsParent(target, false) || com.hello2morrow.sonargraph.core.controller.system.explorationview.a.a(target, target, to)) continue;
                return true;
            }
        } while (!from.getVisibility().contains(ArtifactVisibility.LOCAL) && (from = from.getParent(ArtifactNode.class, ParentMode.ONLY_DIRECT_PARENT)) != null);
        return false;
    }

    private static String d(ArtifactNode from, ArtifactNode to) {
        assert (from != null) : "Parameter 'from' of method 'checkArtifactDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'checkArtifactDependency' must not be null";
        assert (from != to) : "No self reference expected for: " + from;
        String violationMessage = null;
        b.debug(String.format("Checking %s -> %s", from.getName(), to.getName()));
        if (to.hasAsParent(from, false)) {
            if (com.hello2morrow.sonargraph.core.controller.system.explorationview.a.a(from, from, to)) {
                violationMessage = String.format("'%s' cannot access '%s' because it is <hidden>", from.getName(), to.getName());
            }
        } else if (from.hasAsParent(to, false)) {
            violationMessage = "Nested artifact '" + from.getName() + "' cannot access parent artifact '" + to.getName() + "'";
        } else if (!com.hello2morrow.sonargraph.core.controller.system.explorationview.a.c(from, to)) {
            violationMessage = com.hello2morrow.sonargraph.core.controller.system.explorationview.a.b(from, to);
        }
        if (violationMessage != null) {
            b.debug("Violation: " + violationMessage);
        }
        return violationMessage;
    }

    private static void a(ExplorationViewRepresentation representation, ArtifactNode fromArtifact, ProgrammingElementAggregatingNode node, Map<ArtifactNode, List<ParserDependency>> toArtifactToParserDependencies, ParserDependencyEndPoints endPoints) {
        assert (representation != null) : "Parameter 'representation' of method 'collectToArtifacts' must not be null";
        assert (fromArtifact != null) : "Parameter 'fromArtifact' of method 'collectToArtifacts' must not be null";
        assert (node != null) : "Parameter 'node' of method 'collectToArtifacts' must not be null";
        assert (!node.isExternal()) : "Node is external";
        assert (toArtifactToParserDependencies != null) : "Parameter 'toArtifactToParserDependencies' of method 'collectToArtifacts' must not be null";
        assert (endPoints != null) : "Parameter 'endPoints' of method 'collectToArtifacts' must not be null";
        for (ProgrammingElement nextProgrammingElement : node.getRelevantProgrammingElements()) {
            Iterator<ParserDependency> iter = nextProgrammingElement.getDependencyIterator();
            while (iter.hasNext()) {
                ArtifactNode nextToArtifact;
                ParserDependency nextParserDependency = iter.next();
                if (representation.includeOutgoingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints).isIncluded() && (nextToArtifact = representation.getArtifactNode(endPoints.getTo())) != null && nextToArtifact != fromArtifact) {
                    List<ParserDependency> deps = toArtifactToParserDependencies.get(nextToArtifact);
                    if (deps == null) {
                        deps = new ArrayList<ParserDependency>();
                        toArtifactToParserDependencies.put(nextToArtifact, deps);
                    }
                    deps.add(nextParserDependency);
                }
                endPoints.reset();
            }
        }
    }

    private static void a(ArtifactNode artifact, boolean recursively) {
        assert (artifact != null) : "Parameter 'artifact' of method 'checkAssignmentMode' must not be null";
        artifact.removeIssues(CoreIssueId.ARCHITECTURAL_VIEW_ELEMENT_HAS_NO_ASSIGNED_ELEMENTS, CoreIssueId.ARCHITECTURAL_VIEW_ELEMENT_HAS_ASSIGNED_ELEMENTS);
        ArtifactAssignmentMode assignmentMode = artifact.getAssignmentMode();
        switch (com.hello2morrow.sonargraph.core.controller.system.explorationview.a.b()[assignmentMode.ordinal()]) {
            case 3: {
                if (!artifact.hasAssignedElement(true)) break;
                artifact.addIssue(new ArchitecturalViewElementHasAssignedElementsIssue(artifact, "Marked as '" + assignmentMode.getPresentationName() + "' and has assigned elements"));
                break;
            }
            case 1: {
                if (artifact.hasAssignedElement(true)) break;
                artifact.addIssue(new ArchitecturalViewElementHasNoAssignedElementsIssue(artifact, "Marked as '" + assignmentMode.getPresentationName() + "' and has no assigned elements"));
                break;
            }
            case 2: {
                break;
            }
            default: {
                assert (false) : "Unhandled assignment mode: " + assignmentMode;
                break;
            }
        }
        if (recursively) {
            artifact.getChildren(ArtifactNode.class).forEach(c2 -> com.hello2morrow.sonargraph.core.controller.system.explorationview.a.a(c2, recursively));
        }
    }

    static void a(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'check' must not be null";
        b.debug("Check assignment mode");
        List<ArtifactNode> topLevelArtifactNodes = representation.getChildren(ArtifactNode.class);
        if (!topLevelArtifactNodes.isEmpty()) {
            topLevelArtifactNodes.forEach(a2 -> com.hello2morrow.sonargraph.core.controller.system.explorationview.a.a(a2, true));
        }
        b.debug("Check assignment mode - done");
    }

    private static void a(ExplorationViewRepresentation representation, ArtifactNode artifact, ParserDependencyEndPoints endPoints) {
        assert (representation != null) : "Parameter 'representation' of method 'checkArtifact' must not be null";
        assert (artifact != null) : "Parameter 'artifact' of method 'checkArtifact' must not be null";
        assert (endPoints != null) : "Parameter 'endPoints' of method 'checkArtifact' must not be null";
        com.hello2morrow.sonargraph.core.controller.system.explorationview.a.a(artifact, false);
        THashMap toArtifactToParserDependencies = new THashMap();
        for (ProgrammingElementAggregatingNode programmingElementAggregatingNode : artifact.getChildren(ArtifactNode.EXCLUDE_ARTIFACT_NODES, ProgrammingElementAggregatingNode.class)) {
            if (programmingElementAggregatingNode.isExternal()) continue;
            com.hello2morrow.sonargraph.core.controller.system.explorationview.a.a(representation, artifact, programmingElementAggregatingNode, (Map<ArtifactNode, List<ParserDependency>>)toArtifactToParserDependencies, endPoints);
        }
        for (Map.Entry entry : toArtifactToParserDependencies.entrySet()) {
            ArtifactNode nextToArtifact = (ArtifactNode)entry.getKey();
            List nextParserDependencies = (List)entry.getValue();
            String violationMessage = com.hello2morrow.sonargraph.core.controller.system.explorationview.a.d(artifact, nextToArtifact);
            if (violationMessage != null) {
                if (!representation.addArchitectureViolation(nextParserDependencies, violationMessage)) continue;
                artifact.setHasViolation(true);
                artifact.getParents(ArtifactNode.class, ExplorationViewRepresentation.class).forEach(p2 -> p2.setHasViolation(true));
                continue;
            }
            if (!nextToArtifact.hasHiddenElements()) continue;
            for (ParserDependency next : nextParserDependencies) {
                ArchitecturalViewNode nextToLeafNode = representation.getLeafNode(next.getTo());
                assert (nextToLeafNode != null) : "Parameter 'nextToLeafNode' of method 'checkArtifact' must not be null";
                if (!nextToLeafNode.isHidden() || !representation.addArchitectureViolation(Collections.singletonList(next), String.format("'%s' may not be accessed because it is <hidden>", nextToLeafNode.getName()))) continue;
                ArchitecturalViewNode nextFromLeafNode = representation.getLeafNode(next.getFrom());
                assert (nextFromLeafNode != null) : "Parameter 'nextFromLeafNode' of method 'checkArtifact' must not be null";
                nextFromLeafNode.setHasViolation(true);
                nextFromLeafNode.getParents(ArchitecturalViewNode.class, ExplorationViewRepresentation.class).forEach(p2 -> p2.setHasViolation(true));
            }
        }
        artifact.getChildren(ArtifactNode.class).forEach(c2 -> com.hello2morrow.sonargraph.core.controller.system.explorationview.a.a(representation, c2, endPoints));
    }

    private static void c(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'checkInArchitectureModellingOperation' must not be null";
        representation.clearDependencyInfo(false);
        List<ArtifactNode> topLevelArtifactNodes = representation.getChildren(ArtifactNode.class);
        if (!topLevelArtifactNodes.isEmpty()) {
            b.debug("Reset artifacts in modelling mode");
            a visitor = new a();
            topLevelArtifactNodes.forEach(a3 -> a3.accept(visitor));
            b.debug("Check artifacts in modelling mode");
            ParserDependencyEndPoints endPoints = new ParserDependencyEndPoints();
            topLevelArtifactNodes.forEach(a2 -> com.hello2morrow.sonargraph.core.controller.system.explorationview.a.a(representation, a2, endPoints));
        }
    }

    private static void d(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'checkArchitectureViolationsInNonArchitectureModellingOperation' must not be null";
        b processor = new b(representation);
        processor.a(representation.getCurrentModel(), representation.getBasedOnArchitectureFile(), representation.getStructureMode().isLogical(), representation.getRepresentationInfo());
    }

    static void b(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'check' must not be null";
        b.debug("Check architecture");
        switch (com.hello2morrow.sonargraph.core.controller.system.explorationview.a.c()[representation.getOperationMode().ordinal()]) {
            case 1: 
            case 2: {
                com.hello2morrow.sonargraph.core.controller.system.explorationview.a.c(representation);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                com.hello2morrow.sonargraph.core.controller.system.explorationview.a.d(representation);
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + (Object)((Object)representation.getOperationMode());
                break;
            }
        }
        b.debug("Check architecture done");
    }

    static /* synthetic */ int[] a() {
        if (c != null) {
            return c;
        }
        int[] nArray = new int[ArtifactOutgoingDependencyMode.values().length];
        try {
            nArray[ArtifactOutgoingDependencyMode.RELAXED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ArtifactOutgoingDependencyMode.RESTRICTED.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ArtifactOutgoingDependencyMode.STRICT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ArtifactOutgoingDependencyMode.UNRESTRICTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        c = nArray;
        return nArray;
    }

    static /* synthetic */ int[] b() {
        if (d != null) {
            return d;
        }
        int[] nArray = new int[ArtifactAssignmentMode.values().length];
        try {
            nArray[ArtifactAssignmentMode.DEPRECATED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ArtifactAssignmentMode.OPTIONAL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ArtifactAssignmentMode.STANDARD.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        d = nArray;
        return nArray;
    }

    static /* synthetic */ int[] c() {
        if (e != null) {
            return e;
        }
        int[] nArray = new int[ExplorationViewOperationMode.values().length];
        try {
            nArray[ExplorationViewOperationMode.ARCHITECTURAL_MODELLING_LOGICAL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExplorationViewOperationMode.ARCHITECTURAL_MODELLING_PHYSICAL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExplorationViewOperationMode.ARCHITECTURE_EXPLORATION_LOGICAL.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExplorationViewOperationMode.ARCHITECTURE_EXPLORATION_PHYSICAL.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExplorationViewOperationMode.SYSTEM_EXPLORATION_LOGICAL.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExplorationViewOperationMode.SYSTEM_EXPLORATION_PHYSICAL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        e = nArray;
        return nArray;
    }

    static class a
    extends x
    implements ArchitecturalViewNode.IVisitor {
        a() {
        }

        @Override
        public final void visitArchitecturalViewNode(ArchitecturalViewNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
            element.setHasViolation(false);
            element.setHasDeprecation(false);
            super.visitArchitecturalViewElement(element);
        }
    }
}

