/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IExplorationViewRepresentationOwner;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class U {
    private static Logger b = LoggerFactory.getLogger(U.class);

    private U() {
    }

    private static String c(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'getRepresentationInfo' must not be null";
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(representation.getClass().getSimpleName()).append("]");
        builder.append(" ").append((Object)representation.getOperationMode()).append(",").append((Object)representation.getStructureMode()).append(",").append((Object)representation.getPresentationMode());
        if (representation.inInitialCreation()) {
            builder.append(",IN_INITIAL_CREATION");
        } else if (representation.inModification()) {
            builder.append(",IN_MODIFICATION");
        }
        if (representation.isInEditOperation()) {
            builder.append(",IN_EDIT_OPERATION");
        }
        if (representation.isInTransfer()) {
            builder.append(",IN_TRANSFER");
        }
        return builder.toString();
    }

    private static String a(IExplorationViewRepresentationOwner owner) {
        assert (owner != null) : "Parameter 'owner' of method 'getOwnerInfo' must not be null";
        return "[" + owner.getClass().getSimpleName() + "] '" + owner.getId() + "' " + (Object)((Object)owner.getOperationMode());
    }

    private static String a(Collection<? extends ArchitecturalViewElement> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getElementsInfo' must not be null";
        if (elements.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int size = elements.size();
        builder.append(" - Based on " + size + (size == 1 ? " element:" : " elements:"));
        for (ArchitecturalViewElement architecturalViewElement : elements) {
            builder.append("\n - ").append(architecturalViewElement.getElementInfo());
        }
        return builder.toString();
    }

    private static String b(Collection<String> basedOn) {
        assert (basedOn != null) : "Parameter 'basedOn' of method 'getInfo' must not be null";
        if (basedOn.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int size = basedOn.size();
        builder.append(" - based on " + size + (size == 1 ? " entry:" : " entries:"));
        for (String next : basedOn) {
            builder.append("\n - ").append(next);
        }
        return builder.toString();
    }

    private static String c(Collection<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        assert (dependencies != null) : "Parameter 'dependencies' of method 'getDependenciesInfo' must not be null";
        if (dependencies.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int size = dependencies.size();
        builder.append(" - based on " + size + (size == 1 ? " parser dependency:" : " parser dependencies:"));
        for (ArchitecturalViewNode.ArchitecturalViewDependency next : dependencies) {
            builder.append("\n - ").append(next.getFrom().getRelativePath()).append(" -> ").append(next.getTo().getRelativePath());
        }
        return builder.toString();
    }

    private static String d(Collection<? extends ParserDependency> parserDependencies) {
        assert (parserDependencies != null) : "Parameter 'parserDependencies' of method 'getParserDependenciesInfo' must not be null";
        if (parserDependencies.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int size = parserDependencies.size();
        builder.append(" - based on " + size + (size == 1 ? " parser dependency:" : " parser dependencies:"));
        for (ParserDependency parserDependency : parserDependencies) {
            builder.append("\n - ").append(parserDependency);
        }
        return builder.toString();
    }

    private static String b(String op, PresentationMode presentationMode, String info, ExplorationViewRepresentation representation) {
        assert (op != null && op.length() > 0) : "Parameter 'op' of method 'getMessage' must not be empty";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'getMessage' must not be null";
        assert (info != null) : "Parameter 'info' of method 'getMessage' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'getMessage' must not be null";
        return String.valueOf(U.a(representation.getParent(IExplorationViewRepresentationOwner.class, new Class[0]))) + " " + U.c(representation) + " " + op + " '[" + (Object)((Object)presentationMode) + "]'" + (!info.isEmpty() ? " (" + info + ")" : "");
    }

    static void a(String op, PresentationMode presentationMode, String info, ExplorationViewRepresentation representation) {
        assert (op != null && op.length() > 0) : "Parameter 'op' of method 'logOp' must not be empty";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'logOp' must not be null";
        assert (info != null) : "Parameter 'info' of method 'logOp' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'logOp' must not be null";
        if (b.isDebugEnabled()) {
            b.debug(U.b(op, presentationMode, info, representation));
        }
    }

    static void a(String op, PresentationMode presentationMode, String info, Collection<String> basedOn, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'logOp' must not be null";
        assert (op != null && op.length() > 0) : "Parameter 'op' of method 'logOp' must not be empty";
        assert (info != null) : "Parameter 'info' of method 'logOp' must not be null";
        assert (basedOn != null) : "Parameter 'parserDependencies' of method 'logOp' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'logOp' must not be null";
        if (b.isDebugEnabled()) {
            b.debug(String.valueOf(U.b(op, presentationMode, info, representation)) + U.b(basedOn));
        }
    }

    static void a(String op, PresentationMode presentationMode, String info, List<? extends ArchitecturalViewElement> elements, ExplorationViewRepresentation representation) {
        assert (op != null && op.length() > 0) : "Parameter 'op' of method 'logOpElementBased' must not be empty";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'logOpElementBased' must not be null";
        assert (info != null) : "Parameter 'info' of method 'logOpElementBased' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'logOpElementBased' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'logOpElementBased' must not be null";
        if (b.isDebugEnabled()) {
            b.debug(String.valueOf(U.b(op, presentationMode, info, representation)) + U.a(elements));
        }
    }

    static void b(String op, PresentationMode presentationMode, String info, Collection<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'logOpDependencyBased' must not be null";
        assert (op != null && op.length() > 0) : "Parameter 'op' of method 'logOpDependencyBased' must not be empty";
        assert (info != null) : "Parameter 'info' of method 'logOpDependencyBased' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'logOpDependencyBased' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'logOpDependencyBased' must not be null";
        if (b.isDebugEnabled()) {
            b.debug(String.valueOf(U.b(op, presentationMode, info, representation)) + U.c(dependencies));
        }
    }

    static void c(String op, PresentationMode presentationMode, String info, Collection<? extends ParserDependency> parserDependencies, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'logOpParserDependencyBased' must not be null";
        assert (op != null && op.length() > 0) : "Parameter 'op' of method 'logOpParserDependencyBased' must not be empty";
        assert (info != null) : "Parameter 'info' of method 'logOpParserDependencyBased' must not be null";
        assert (parserDependencies != null) : "Parameter 'parserDependencies' of method 'logOpParserDependencyBased' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'logOpParserDependencyBased' must not be null";
        if (b.isDebugEnabled()) {
            b.debug(String.valueOf(U.b(op, presentationMode, info, representation)) + U.d(parserDependencies));
        }
    }

    static void a(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'logStartModification' must not be null";
        if (b.isDebugEnabled()) {
            b.debug("<<Start modification>> " + U.a(representation.getParent(IExplorationViewRepresentationOwner.class, new Class[0])) + " " + U.c(representation));
        }
    }

    static void b(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'logFinishModification' must not be null";
        if (b.isDebugEnabled()) {
            b.debug("<<Finish modification>> " + U.a(representation.getParent(IExplorationViewRepresentationOwner.class, new Class[0])) + " " + U.c(representation));
        }
    }

    public static String a(IExplorationViewRepresentationOwner owner, PresentationMode presentationMode) {
        assert (owner != null) : "Parameter 'owner' of method 'logInteraction' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'logInteraction' must not be null";
        if (b.isDebugEnabled()) {
            String msg = "<<Load>> " + U.a(owner) + "," + (Object)((Object)presentationMode);
            b.debug(msg);
            return msg;
        }
        return "";
    }

    public static String a(String interaction, String additionalInfo, ExplorationViewRepresentation representation) {
        assert (interaction != null && interaction.length() > 0) : "Parameter 'interaction' of method 'logInteraction' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'logInteraction' must not be null";
        if (b.isDebugEnabled()) {
            String msg = "<<" + interaction + ">> " + U.a(representation.getParent(IExplorationViewRepresentationOwner.class, new Class[0])) + " " + U.c(representation) + (additionalInfo != null && !additionalInfo.isEmpty() ? "\n<Detail> " + additionalInfo : "");
            b.debug(msg);
            return msg;
        }
        return "";
    }

    public static void a(String msg, String additionalInfo) {
        assert (msg != null) : "Parameter 'msg' of method 'logDone' must not be null";
        if (b.isDebugEnabled()) {
            assert (msg.length() > 0) : "Parameter 'msg' of method 'logDone' must not be empty";
            b.debug(String.valueOf(msg) + (additionalInfo != null && !additionalInfo.isEmpty() ? " <" + additionalInfo + ">" : "") + " - done");
        }
    }
}

