/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.aC;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ad;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.as;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.g;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.x;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.CreatedRecursiveNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveNode;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveNonLeafNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import com.hello2morrow.sonargraph.core.model.refactoring.AssignableToArtifactRefactoringDescriptor;
import com.hello2morrow.sonargraph.core.model.refactoring.RecursiveElementRefactoringDescriptor;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RecursiveNodeMoveRenameProcessor {
    private static final Logger b = LoggerFactory.getLogger(RecursiveNodeMoveRenameProcessor.class);
    private final ExplorationViewRepresentation c;
    private final RecursiveElementRefactoringDescriptor d;
    private final AssignableToArtifactRefactoringDescriptor e;
    private final ArchitecturalViewNode f;
    private c g;
    private int h;
    private int i;

    private static Set<String> a(AssignableToArtifactRefactoringDescriptor descriptor, ArchitecturalViewNode target) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'getExisting' must not be null";
        if (target == null) {
            return Collections.emptySet();
        }
        HashSet<String> existing = new HashSet<String>();
        for (ArchitecturalViewNode nextChild : target.getNodeChildren(n2 -> true, false)) {
            if (!(nextChild instanceof AssignableToArtifactNode)) continue;
            existing.add(descriptor.getRelevantNamePartForRename(nextChild.getName()));
        }
        return existing;
    }

    private static State a(AssignableToArtifactRefactoringDescriptor descriptor, RecursiveNode source, ArchitecturalViewNode target) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'determineState' must not be null";
        assert (source != null) : "Parameter 'source' of method 'determineState' must not be null";
        assert (source != target) : "Same instances";
        b.debug("Determine state " + source.getElementInfo(true, false) + " -> " + (target != null ? target.getElementInfo(true, false) : "<no target>"));
        State state = State.EMPTY;
        Set<String> existing = RecursiveNodeMoveRenameProcessor.a(descriptor, target);
        for (ArchitecturalViewNode nextChild : source.getNodeChildren(n2 -> true, false)) {
            if (!(nextChild instanceof AssignableToArtifactNode)) continue;
            String nextRelevantNamePart = descriptor.getRelevantNamePartForRename(nextChild.getName());
            if (existing.contains(nextRelevantNamePart)) {
                state = State.CONTAINS_ONLY_COLLIDING;
                b.debug("Colliding '" + nextRelevantNamePart + "'");
                continue;
            }
            state = State.CONTAINS_AT_LEAST_ONE_MOVABLE;
            b.debug("First movable '" + nextRelevantNamePart + "'");
            break;
        }
        b.debug("Determine state " + source.getElementInfo(true, false) + " -> " + (target != null ? target.getElementInfo(true, false) : "<no target>") + " - done");
        return state;
    }

    static State a(AssignableToArtifactRefactoringDescriptor descriptor, RecursiveNode source, ArchitecturalViewNode target, ExplorationViewRepresentation representation) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'check' must not be null";
        assert (source != null) : "Parameter 'source' of method 'process' must not be null";
        assert (target != null) : "Parameter 'target' of method 'check' must not be null";
        assert (source != target) : "Same instances";
        assert (representation != null) : "Parameter 'representation' of method 'check' must not be null";
        b.debug("Check " + source.getElementInfo(true, false));
        State state = RecursiveNodeMoveRenameProcessor.a(descriptor, source, target);
        if (state != State.CONTAINS_AT_LEAST_ONE_MOVABLE) {
            a checkVisitor = new a(descriptor, source, target, state, representation);
            source.accept(checkVisitor);
            state = checkVisitor.b();
        }
        b.debug("Check " + source.getElementInfo(true, false) + " - done [" + (Object)((Object)state) + "]");
        return state;
    }

    static String a(RecursiveElementRefactoringDescriptor recursiveDescriptor, RecursiveNode source, ArchitecturalViewNode target, boolean recursive) {
        assert (recursiveDescriptor != null) : "Parameter 'recursiveDescriptor' of method 'getRecursiveNodeMoveTargetName' must not be null";
        assert (source != null) : "Parameter 'source' of method 'getRecursiveNodeMoveTarget' must not be null";
        assert (target != null) : "Parameter 'target' of method 'getRecursiveNodeMoveTarget' must not be null";
        assert (source != target) : "Same instances";
        if (recursive) {
            String sourceShortName = source.getFirstUnderlyingElement().getShortName();
            if (target instanceof RecursiveNode) {
                return String.valueOf(target.getName()) + recursiveDescriptor.getSeparator() + sourceShortName;
            }
            return sourceShortName;
        }
        String sourceName = source.getFirstUnderlyingElement().getName();
        if (target instanceof RecursiveNode) {
            return String.valueOf(target.getName()) + recursiveDescriptor.getSeparator() + sourceName;
        }
        return sourceName;
    }

    static void a(ValidationResult result, RecursiveElementRefactoringDescriptor descriptor, String name) {
        assert (result != null) : "Parameter 'result' of method 'isRecursiveElementNameValid' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'isRecursiveElementNameValid' must not be null";
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.isEmpty()) {
            result.addError("Must not be empty");
        } else if (!descriptor.isValidNameForRename(name)) {
            result.addError("Not a valid name");
        }
    }

    static ITextValidator a(final RecursiveElementRefactoringDescriptor recursiveDescriptor) {
        assert (recursiveDescriptor != null) : "Parameter 'recursiveDescriptor' of method 'getNameValidator' must not be null";
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                RecursiveNodeMoveRenameProcessor.a(result, recursiveDescriptor, newInput);
                return result;
            }
        };
    }

    static ITextValidator a(final RecursiveElementRefactoringDescriptor recursiveDescriptor, final AssignableToArtifactRefactoringDescriptor assignableDescriptor, final NonRecursiveNonLeafNode root, final RecursiveNode node, final ExplorationViewRepresentation representation) {
        assert (recursiveDescriptor != null) : "Parameter 'recursiveDescriptor' of method 'getRenameValidator' must not be null";
        assert (assignableDescriptor != null) : "Parameter 'assignableDescriptor' of method 'getRenameValidator' must not be null";
        assert (root != null) : "Parameter 'root' of method 'getRenameValidator' must not be null";
        assert (node != null) : "Parameter 'node' of method 'getRenameValidator' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'getRenameValidator' must not be null";
        return new ITextValidator(){

            @Override
            public final ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                RecursiveNodeMoveRenameProcessor.a(result, recursiveDescriptor, newInput);
                if (result.isSuccess()) {
                    List<String> splitName = recursiveDescriptor.split(newInput);
                    RecursiveNode target = com.hello2morrow.sonargraph.core.controller.system.explorationview.g.a(splitName, RecursiveNode.class, root, representation);
                    if (node == target) {
                        result.addError("Name must be different");
                    } else if (target != null) {
                        State state = RecursiveNodeMoveRenameProcessor.a(assignableDescriptor, node, (ArchitecturalViewNode)target, representation);
                        switch (state) {
                            case CONTAINS_ONLY_COLLIDING: {
                                result.addError("All contained assignables collide with existing ones");
                                break;
                            }
                            case EMPTY: 
                            case CONTAINS_AT_LEAST_ONE_MOVABLE: {
                                break;
                            }
                            default: {
                                if (!a) {
                                    throw new AssertionError((Object)("Unhandled state: " + (Object)((Object)state)));
                                }
                                break;
                            }
                        }
                    }
                }
                return result;
            }
        };
    }

    RecursiveNodeMoveRenameProcessor(ExplorationViewRepresentation representation, RecursiveElementRefactoringDescriptor recursiveDescriptor, AssignableToArtifactRefactoringDescriptor assignableDescriptor, ArchitecturalViewNode rootNode) {
        assert (representation != null) : "Parameter 'representation' of method 'RecursiveNodeMoveRenameProcessor' must not be null";
        assert (recursiveDescriptor != null) : "Parameter 'descriptor' of method 'RecursiveNodeMoveRenameProcessor' must not be null";
        assert (assignableDescriptor != null) : "Parameter 'assignableDescriptor' of method 'RecursiveNodeMoveRenameProcessor' must not be null";
        assert (rootNode != null) : "Parameter 'rootNode' of method 'RecursiveNodeMoveRenameProcessor' must not be null";
        this.c = representation;
        this.d = recursiveDescriptor;
        this.e = assignableDescriptor;
        this.f = rootNode;
    }

    int a() {
        return this.h;
    }

    public int b() {
        return this.i;
    }

    private RecursiveNode a(List<String> shortNames, ExplorationViewRepresentation representation) {
        assert (shortNames != null && !shortNames.isEmpty()) : "Parameter 'shortNames' of method 'findElsewhere' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'findElsewhere' must not be null";
        b.debug("Search recursive element '" + shortNames + "'");
        RecursiveNode found = null;
        if (this.g == null) {
            b.debug("Collecting 'NonRecursiveNonLeafNode' instances");
            this.g = new c();
            this.c.accept(this.g);
            b.debug("Collecting 'NonRecursiveNonLeafNode' instances - done");
        }
        for (NonRecursiveNonLeafNode next : this.g.b()) {
            RecursiveNode nextFoundElsewhere = com.hello2morrow.sonargraph.core.controller.system.explorationview.g.a(shortNames, RecursiveNode.class, next, representation);
            if (nextFoundElsewhere == null) continue;
            found = nextFoundElsewhere;
            break;
        }
        b.debug("Search recursive element '" + shortNames + "' - done " + (found == null ? "[not found]" : "[found in '" + found.getElementInfo(true, false) + "']"));
        return found;
    }

    RecursiveNode a(String name, ExplorationViewRepresentation representation) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getRecursiveElement' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'getOrCreateRecursiveElement' must not be null";
        b.debug("Get recursive element '" + name + "'");
        ArrayList<RecursiveNode> createdRecursiveNodes = new ArrayList<RecursiveNode>();
        List<String> shortNames = this.d.split(name);
        RecursiveNode recursiveLeafNode = null;
        int i2 = 0;
        ArchitecturalViewNode currentNode = this.f;
        NamedElement currentUnderlyingParent = currentNode.getFirstUnderlyingElement();
        for (String nextShortName : shortNames) {
            ++i2;
            RecursiveNode nextRecursiveNode = com.hello2morrow.sonargraph.core.controller.system.explorationview.g.a(Collections.singletonList(nextShortName), RecursiveNode.class, currentNode, representation);
            if (nextRecursiveNode != null) {
                if (nextRecursiveNode.isDeleted()) {
                    b.debug("Recycled already deleted node: " + nextRecursiveNode.getElementInfo(true, false));
                    nextRecursiveNode.setDeleted(false);
                    nextRecursiveNode.setDeletedRecycled(true);
                }
                currentUnderlyingParent = nextRecursiveNode.getFirstUnderlyingElement();
            } else {
                RecursiveNode nextFoundElsewhere = this.a(shortNames.subList(0, i2), representation);
                if (nextFoundElsewhere != null) {
                    b.debug("Using recursive node found elsewhere: " + nextFoundElsewhere.getElementInfo(true, false));
                    currentUnderlyingParent = nextFoundElsewhere.getFirstUnderlyingElement();
                    nextRecursiveNode = nextFoundElsewhere.copy(currentNode);
                    as.a(nextRecursiveNode);
                    createdRecursiveNodes.add(nextRecursiveNode);
                } else {
                    currentUnderlyingParent = this.d.createPrototype(currentUnderlyingParent, nextShortName, null);
                    assert (currentUnderlyingParent != null && currentUnderlyingParent instanceof IRecursiveElement) : "Unexpected class in method 'getRecursiveElement': " + currentUnderlyingParent;
                    b.debug("Created prototype element: " + currentUnderlyingParent);
                    nextRecursiveNode = new CreatedRecursiveNode((ArchitecturalViewElement)currentNode, this.c.getPresentationMode(), (IRecursiveElement)((Object)currentUnderlyingParent));
                    createdRecursiveNodes.add(nextRecursiveNode);
                }
                currentNode.addChild(nextRecursiveNode);
            }
            recursiveLeafNode = nextRecursiveNode;
            currentNode = nextRecursiveNode;
        }
        if (!createdRecursiveNodes.isEmpty()) {
            createdRecursiveNodes.forEach(c2 -> aC.b(c2));
            ad.b(createdRecursiveNodes, this.c);
        }
        b.debug("Get recursive element '" + name + "' - done");
        assert (recursiveLeafNode != null) : "'leafNode' of method 'getOrCreateRecursiveElement' must not be null";
        return recursiveLeafNode;
    }

    private void a(RecursiveNode source, ArchitecturalViewNode target, b consumer) {
        assert (source != null) : "Parameter 'source' of method 'process' must not be null";
        assert (target != null) : "Parameter 'target' of method 'process' must not be null";
        assert (source != target) : "Same instances";
        assert (consumer != null) : "Parameter 'consumer' of method 'process' must not be null";
        b.debug("Process " + source.getElementInfo(true, false) + " -> " + target.getElementInfo(true, false));
        ArrayList<AssignableToArtifactNode> colliding = new ArrayList<AssignableToArtifactNode>();
        ArrayList<AssignableToArtifactNode> moveables = new ArrayList<AssignableToArtifactNode>();
        Set<String> existing = RecursiveNodeMoveRenameProcessor.a(this.e, target);
        for (ArchitecturalViewNode nextChild : source.getNodeChildren(n2 -> true, false)) {
            String nextRelevantNamePart = this.e.getRelevantNamePartForRename(nextChild.getName());
            if (!(nextChild instanceof AssignableToArtifactNode)) continue;
            if (existing.contains(nextRelevantNamePart)) {
                b.trace("Colliding '" + nextRelevantNamePart + "'");
                colliding.add((AssignableToArtifactNode)nextChild);
                ++this.h;
                continue;
            }
            b.trace("Moveable '" + nextRelevantNamePart + "'");
            moveables.add((AssignableToArtifactNode)nextChild);
            ++this.i;
        }
        b.debug("Detected " + moveables.size() + " moveable(s) and " + colliding.size() + " colliding");
        consumer.a(source, target, moveables, colliding);
        b.debug("Process " + source.getElementInfo(true, false) + " -> " + target.getElementInfo(true, false) + " - done");
    }

    private Set<RecursiveNode> a(RecursiveNode source, ArchitecturalViewNode target) {
        List<RecursiveNode> recursiveTargetParents;
        int index;
        assert (source != null) : "Parameter 'source' of method 'skip' must not be null";
        assert (target != null) : "Parameter 'target' of method 'skip' must not be null";
        assert (source != target) : "Same instances";
        if (target instanceof RecursiveNode && (index = (recursiveTargetParents = target.getParents(RecursiveNode.class, ExplorationViewRepresentation.class, NonRecursiveNode.class)).indexOf(source)) != -1) {
            List<RecursiveNode> subList = recursiveTargetParents.subList(0, index);
            THashSet skip = new THashSet(subList.size() + 1);
            skip.add((RecursiveNode)target);
            skip.addAll(subList);
            return skip;
        }
        return Collections.emptySet();
    }

    void a(RecursiveNode source, ArchitecturalViewNode target, boolean recursive, b consumer, ExplorationViewRepresentation representation) {
        assert (source != null) : "Parameter 'source' of method 'process' must not be null";
        assert (target != null) : "Parameter 'target' of method 'process' must not be null";
        assert (source != target) : "Same instances";
        assert (consumer != null) : "Parameter 'consumer' of method 'process' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'process' must not be null";
        b.debug("Process '" + source.getElementInfo(true, false) + "' -> '" + target.getElementInfo(true, false) + "'" + (recursive ? " [recursive]" : ""));
        this.a(source, target, consumer);
        if (recursive) {
            Set<RecursiveNode> skip = this.a(source, target);
            source.accept(new d(source, target, skip, consumer, representation));
        }
        b.debug("Process '" + source.getElementInfo(true, false) + "' -> '" + target.getElementInfo(true, false) + "'" + (recursive ? " [recursive]" : "") + " - done");
    }

    private static final class a
    extends x
    implements ArchitecturalViewNode.IVisitor,
    RecursiveNode.IVisitor {
        private final AssignableToArtifactRefactoringDescriptor c;
        private final RecursiveNode d;
        private final ExplorationViewRepresentation e;
        private ArchitecturalViewNode f;
        private State g;
        private boolean h;

        private a(AssignableToArtifactRefactoringDescriptor descriptor, RecursiveNode source, ArchitecturalViewNode target, State state, ExplorationViewRepresentation representation) {
            assert (descriptor != null) : "Parameter 'descriptor' of method 'CheckVisitor' must not be null";
            assert (source != null) : "Parameter 'source' of method 'ProcessVisitor' must not be null";
            assert (state != null) : "Parameter 'state' of method 'CheckVisitor' must not be null";
            assert (representation != null) : "Parameter 'representation' of method 'CheckVisitor' must not be null";
            this.c = descriptor;
            this.d = source;
            this.f = target;
            this.g = state;
            this.e = representation;
        }

        @Override
        public void visitRecursiveNode(RecursiveNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitRecursiveNode' must not be null";
            if (this.d != element) {
                if (this.f != null) {
                    this.f = com.hello2morrow.sonargraph.core.controller.system.explorationview.g.a(Collections.singletonList(element.getShortName()), RecursiveNode.class, this.f, this.e);
                }
                State state = RecursiveNodeMoveRenameProcessor.a(this.c, element, this.f);
                switch (state) {
                    case CONTAINS_AT_LEAST_ONE_MOVABLE: 
                    case CONTAINS_ONLY_COLLIDING: {
                        this.g = state;
                        break;
                    }
                    case EMPTY: {
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled state: " + (Object)((Object)state);
                        break;
                    }
                }
            }
            if (this.g == State.CONTAINS_AT_LEAST_ONE_MOVABLE || this.f == this.d) {
                this.h = true;
            } else {
                super.visitChildrenOf(element);
            }
        }

        @Override
        public void visitArchitecturalViewNode(ArchitecturalViewNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
        }

        @Override
        protected boolean a() {
            return this.h;
        }

        State b() {
            return this.g;
        }
    }

    static interface b {
        public void a(RecursiveNode var1, ArchitecturalViewNode var2, List<AssignableToArtifactNode> var3, List<AssignableToArtifactNode> var4);
    }

    private static final class c
    extends x
    implements NonRecursiveNonLeafNode.IVisitor,
    RecursiveNode.IVisitor {
        private final ArrayDeque<NonRecursiveNonLeafNode> c = new ArrayDeque();
        private final Set<NonRecursiveNonLeafNode> d = new LinkedHashSet<NonRecursiveNonLeafNode>();

        private c() {
        }

        @Override
        public void visitNonRecursiveNonLeafNode(NonRecursiveNonLeafNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitNonRecursiveNonLeafNode' must not be null";
            if (!element.isExternal()) {
                this.c.push(element);
                this.visitChildrenOf(element);
                this.c.pop();
            }
        }

        @Override
        public void visitRecursiveNode(RecursiveNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitRecursiveNode' must not be null";
            assert (!this.c.isEmpty()) : "No root found for: " + element;
            this.d.add(this.c.getFirst());
        }

        Set<NonRecursiveNonLeafNode> b() {
            return Collections.unmodifiableSet(this.d);
        }
    }

    private final class d
    extends x
    implements ArchitecturalViewNode.IVisitor,
    RecursiveNode.IVisitor {
        private final ArrayDeque<ArchitecturalViewNode> d = new ArrayDeque();
        private final RecursiveNode e;
        private final Set<RecursiveNode> f;
        private final b g;
        private final ExplorationViewRepresentation h;
        private boolean i;

        private d(RecursiveNode source, ArchitecturalViewNode target, Set<RecursiveNode> skip, b consumer, ExplorationViewRepresentation representation) {
            assert (source != null) : "Parameter 'source' of method 'ProcessVisitor' must not be null";
            assert (target != null) : "Parameter 'target' of method 'ProcessVisitor' must not be null";
            assert (skip != null) : "Parameter 'skip' of method 'ProcessVisitor' must not be null";
            assert (consumer != null) : "Parameter 'consumer' of method 'ProcessVisitor' must not be null";
            assert (representation != null) : "Parameter 'representation' of method 'ProcessVisitor' must not be null";
            this.e = source;
            this.f = skip;
            this.g = consumer;
            this.d.push(target);
            this.h = representation;
        }

        @Override
        public void visitRecursiveNode(RecursiveNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitRecursiveNode' must not be null";
            if (this.e == element) {
                super.visitChildrenOf(element);
            } else if (!this.f.contains(element)) {
                ArchitecturalViewNode currentTarget = this.d.peek();
                String nextTargetName = String.valueOf(currentTarget.getName()) + RecursiveNodeMoveRenameProcessor.this.d.getSeparator() + element.getFirstUnderlyingElement().getShortName();
                currentTarget = RecursiveNodeMoveRenameProcessor.this.a(nextTargetName, this.h);
                RecursiveNodeMoveRenameProcessor.this.a(element, currentTarget, this.g);
                if (currentTarget == this.e) {
                    this.i = true;
                } else {
                    this.d.push(currentTarget);
                    super.visitChildrenOf(element);
                    this.d.pop();
                }
            }
        }

        @Override
        public void visitArchitecturalViewNode(ArchitecturalViewNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
        }

        @Override
        protected boolean a() {
            return this.i;
        }
    }

    static enum State {
        EMPTY,
        CONTAINS_AT_LEAST_ONE_MOVABLE,
        CONTAINS_ONLY_COLLIDING;

    }
}

