/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.controller.system.diff.a;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricValueDiff;
import com.hello2morrow.sonargraph.integration.access.controller.g;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class v
extends a {
    private final IReport c;

    public v(ISoftwareSystem baselineSystem, g baselineSystemInfoProcessor, SoftwareSystem currentSystem, IReport currentReport) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem);
        assert (currentReport != null) : "Parameter 'currentReport' of method 'MetricDiffProcessor' must not be null";
        this.c = currentReport;
    }

    @Override
    public void a(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'process' must not be null";
        HashMap<String, com.hello2morrow.sonargraph.integration.access.model.IMetricId> baselineNameToMetricIdMap = new HashMap<String, com.hello2morrow.sonargraph.integration.access.model.IMetricId>();
        HashMap<com.hello2morrow.sonargraph.integration.access.model.IMetricId, com.hello2morrow.sonargraph.integration.access.model.IMetricValue> baselineMetricToValueMap = new HashMap<com.hello2morrow.sonargraph.integration.access.model.IMetricId, com.hello2morrow.sonargraph.integration.access.model.IMetricValue>();
        String systemLevelStandardName = CoreMetricLevel.SYSTEM.getStandardName();
        Optional baselineSystemLevel = this.b().a(systemLevelStandardName);
        if (baselineSystemLevel.isPresent()) {
            List metricIdsForLevel = this.b().a((IMetricLevel)baselineSystemLevel.get());
            for (com.hello2morrow.sonargraph.integration.access.model.IMetricId nextBaselineMetricId : metricIdsForLevel) {
                baselineNameToMetricIdMap.put(nextBaselineMetricId.getName(), nextBaselineMetricId);
                Map map = this.b().a(systemLevelStandardName, nextBaselineMetricId.getName());
                com.hello2morrow.sonargraph.integration.access.model.IMetricValue value = (com.hello2morrow.sonargraph.integration.access.model.IMetricValue)map.get(this.a());
                baselineMetricToValueMap.put(nextBaselineMetricId, value);
            }
        }
        Map<IMetricCategory, Map<IMetricDescriptor, IMetricValue>> currentSystemMetrics = this.c.getSystemLevelMetrics();
        HashMap<String, IMetricDescriptor> currentMetricIdToDescriptorMap = new HashMap<String, IMetricDescriptor>();
        HashMap<IMetricDescriptor, IMetricValue> currentMetricToValueMap = new HashMap<IMetricDescriptor, IMetricValue>();
        for (Map.Entry<IMetricCategory, Map<IMetricDescriptor, IMetricValue>> entry : currentSystemMetrics.entrySet()) {
            Map<IMetricDescriptor, IMetricValue> nextCategoryMetrics = entry.getValue();
            for (Map.Entry<IMetricDescriptor, IMetricValue> nextDescriptorEntry : nextCategoryMetrics.entrySet()) {
                IMetricDescriptor metricDescriptor = nextDescriptorEntry.getKey();
                IMetricValue previous = currentMetricToValueMap.put(metricDescriptor, nextDescriptorEntry.getValue());
                assert (previous == null) : "Metric value for " + metricDescriptor.toString() + " Was not null: " + previous.getValue();
                currentMetricIdToDescriptorMap.put(metricDescriptor.getMetricId().getStandardName(), metricDescriptor);
            }
        }
        for (Map.Entry<IMetricCategory, Map<IMetricDescriptor, IMetricValue>> entry : baselineNameToMetricIdMap.entrySet()) {
            String metricName = (String)((Object)entry.getKey());
            IMetricDescriptor currentMetricDescriptor = (IMetricDescriptor)currentMetricIdToDescriptorMap.remove(metricName);
            com.hello2morrow.sonargraph.integration.access.model.IMetricValue baselineValue = (com.hello2morrow.sonargraph.integration.access.model.IMetricValue)baselineMetricToValueMap.get(entry.getValue());
            if (currentMetricDescriptor != null) {
                IMetricValue currentValue = (IMetricValue)currentMetricToValueMap.remove(currentMetricDescriptor);
                Pair<IDiffElement.Change, Pair<Number, Number>> changePair = v.a(currentMetricDescriptor.getMetricId(), baselineValue.getValue(), currentValue.getValue(), false);
                String changeDescription = this.a(baselineValue.getValue(), currentValue.getValue(), (IDiffElement.Change)((Object)changePair.getFirst()), (Number)((Pair)changePair.getSecond()).getFirst());
                MetricValueDiff diff = new MetricValueDiff(parent, baselineValue, currentValue, (IDiffElement.Change)((Object)changePair.getFirst()), (Number)((Pair)changePair.getSecond()).getFirst(), (Number)((Pair)changePair.getSecond()).getSecond(), changeDescription);
                parent.addChild(diff);
                continue;
            }
            MetricValueDiff diff = new MetricValueDiff(parent, baselineValue, null, IDiffElement.Change.REMOVED);
            parent.addChild(diff);
        }
        for (Map.Entry<IMetricCategory, Map<IMetricDescriptor, IMetricValue>> entry : currentMetricToValueMap.entrySet()) {
            MetricValueDiff diff = new MetricValueDiff(parent, null, (IMetricValue)((Object)entry.getValue()), IDiffElement.Change.ADDED);
            parent.addChild(diff);
        }
    }

    private String a(Number baselineValue, Number currentValue, IDiffElement.Change valueChange, Number valueDifference) {
        assert (baselineValue != null) : "Parameter 'baselineValue' of method 'createChangeDescription' must not be null";
        assert (currentValue != null) : "Parameter 'currentValue' of method 'createChangeDescription' must not be null";
        assert (valueChange != null) : "Parameter 'valueChange' of method 'createChangeDescription' must not be null";
        assert (valueDifference != null) : "Parameter 'valueDifference' of method 'createChangeDescription' must not be null";
        StringBuilder result = new StringBuilder();
        if (valueChange != IDiffElement.Change.UNMODIFIED) {
            result.append(NumberUtility.format((Number)baselineValue)).append(" -> ").append(NumberUtility.format((Number)currentValue));
            result.append(" (");
            if (valueDifference.floatValue() > 0.0f) {
                result.append("+");
            }
            result.append(NumberUtility.format((Number)valueDifference));
            result.append(")");
        }
        return result.length() == 0 ? null : result.toString();
    }

    static Pair<IDiffElement.Change, Pair<Number, Number>> a(IMetricId metricId, Number baselineValue, Number currentValue, boolean isHigherWorse) {
        IDiffElement.Change diffChange;
        int change;
        Float relativeDiff;
        Number valueDiff;
        assert (metricId != null) : "Parameter 'metricId' of method 'determineChangeOfValues' must not be null";
        assert (baselineValue != null) : "Parameter 'baselineValue' of method 'determineChangeOfValues' must not be null";
        assert (currentValue != null) : "Parameter 'currentValue' of method 'determineChangeOfValues' must not be null";
        if (metricId.isFloat()) {
            float difference = currentValue.floatValue() - baselineValue.floatValue();
            if ((double)Math.abs(difference) < 0.01) {
                valueDiff = Float.valueOf(0.0f);
                relativeDiff = Float.valueOf(0.0f);
                change = 0;
            } else {
                change = Float.compare(baselineValue.floatValue(), currentValue.floatValue());
                relativeDiff = Float.compare(0.0f, baselineValue.floatValue()) != 0 ? Float.valueOf(difference / baselineValue.floatValue()) : Float.valueOf(Float.NaN);
                valueDiff = Float.valueOf(difference);
            }
        } else {
            change = Integer.compare(baselineValue.intValue(), currentValue.intValue());
            valueDiff = currentValue.intValue() - baselineValue.intValue();
            relativeDiff = Float.compare(0.0f, baselineValue.floatValue()) != 0 ? Float.valueOf((float)valueDiff.intValue() / baselineValue.floatValue()) : Float.valueOf(Float.NaN);
        }
        if (change == 0) {
            Pair numericChange = new Pair((Object)valueDiff, (Object)relativeDiff);
            return new Pair((Object)IDiffElement.Change.UNMODIFIED, (Object)numericChange);
        }
        IMetricId.StandardSorting sorting = metricId.getSorting();
        if (isHigherWorse && sorting == IMetricId.StandardSorting.INDIFFERENT) {
            sorting = IMetricId.StandardSorting.HIGHER_WORSE;
        }
        switch (sorting) {
            case HIGHER_WORSE: {
                diffChange = change < 0 ? IDiffElement.Change.WORSENED : IDiffElement.Change.IMPROVED;
                break;
            }
            case LOWER_WORSE: {
                diffChange = change < 0 ? IDiffElement.Change.IMPROVED : IDiffElement.Change.WORSENED;
                break;
            }
            case OPTIMUM_AT_ZERO: {
                double baselineAbsValue = Math.abs(baselineValue.doubleValue());
                double currentAbsValue = Math.abs(currentValue.doubleValue());
                double difference = baselineAbsValue - currentAbsValue;
                diffChange = difference < 0.0 ? IDiffElement.Change.WORSENED : IDiffElement.Change.IMPROVED;
                break;
            }
            case INDIFFERENT: {
                diffChange = IDiffElement.Change.MODIFIED;
                break;
            }
            default: {
                assert (false) : "Unexpected sorting " + sorting.getStandardName();
                diffChange = null;
            }
        }
        Pair numericChange = new Pair((Object)valueDiff, (Object)relativeDiff);
        return new Pair((Object)diffChange, (Object)numericChange);
    }
}

