/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.foundation.text.IntBasedHash;
import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.core.controller.system.base.SourceLineMatcher;
import com.hello2morrow.sonargraph.core.controller.system.diff.D;
import com.hello2morrow.sonargraph.core.controller.system.diff.r;
import com.hello2morrow.sonargraph.core.model.element.IIssueWithLineContext;
import com.hello2morrow.sonargraph.core.model.element.IssueWithDescription;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.element.pattern.LineBasedContextSimilarityMatchPattern;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.GenericNamedElementIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.LineBasedIssueDiff;
import com.hello2morrow.sonargraph.integration.access.model.ILineBasedIssue;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.INamedElementIssue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class t
extends D<INamedElementIssue, NamedElementIssue> {
    private HashMap<NamedElementIssue, String> c = new HashMap();
    private Map<NamedElementIssue, D.a<INamedElementIssue, NamedElementIssue>> d = new HashMap<NamedElementIssue, D.a<INamedElementIssue, NamedElementIssue>>();

    public t(r<INamedElementIssue, NamedElementIssue> resolutionChangeProvider) {
        super(resolutionChangeProvider);
    }

    @Override
    protected IssueDiff<INamedElementIssue, NamedElementIssue> a(NamedElement parent, INamedElementIssue baselineIssue, NamedElementIssue currentIssue, IDiffElement.Change change, String changeDescription) {
        if (changeDescription == null) {
            if ((baselineIssue == null || baselineIssue instanceof ILineBasedIssue) && (currentIssue == null || currentIssue instanceof IIssueWithLineContext)) {
                return new LineBasedIssueDiff(parent, (ILineBasedIssue)baselineIssue, (IssueWithDescription)currentIssue, change);
            }
            return new GenericNamedElementIssueDiff(parent, baselineIssue, currentIssue, change);
        }
        if ((baselineIssue == null || baselineIssue instanceof ILineBasedIssue) && (currentIssue == null || currentIssue instanceof IIssueWithLineContext)) {
            return new LineBasedIssueDiff(parent, (ILineBasedIssue)baselineIssue, (IssueWithDescription)currentIssue, change, changeDescription);
        }
        return new GenericNamedElementIssueDiff(parent, baselineIssue, currentIssue, change, changeDescription);
    }

    @Override
    protected D.a<INamedElementIssue, NamedElementIssue> a(INamedElementIssue baselineIssue, Set<NamedElementIssue> currentIssues) {
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'findMatchingIssue' must not be null";
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'findMatchingIssue' must not be null";
        if (baselineIssue instanceof ILineBasedIssue) {
            return this.c(baselineIssue, currentIssues);
        }
        return this.b(baselineIssue, currentIssues);
    }

    private D.a<INamedElementIssue, NamedElementIssue> b(INamedElementIssue baselineIssue, Set<NamedElementIssue> currentIssues) {
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'exactMatch' must not be null";
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'exactMatch' must not be null";
        for (NamedElementIssue nextCurrent : currentIssues) {
            if (!(!(baselineIssue instanceof ILineBasedIssue) ? baselineIssue.getIssueProvider().getName().equals(nextCurrent.getProvider().getStandardName()) && baselineIssue.getDescription().equals(nextCurrent.getDescription()) : baselineIssue.getLine() == nextCurrent.getLineNumber() && baselineIssue.getIssueProvider().getName().equals(nextCurrent.getProvider().getStandardName()) && baselineIssue.getDescription().equals(nextCurrent.getDescription()))) continue;
            return new D.a<INamedElementIssue, NamedElementIssue>(baselineIssue, nextCurrent, 1.0, IDiffElement.Change.UNMODIFIED, "");
        }
        return null;
    }

    private D.a<INamedElementIssue, NamedElementIssue> c(INamedElementIssue baselineIssue, Set<NamedElementIssue> currentIssues) {
        ILineBasedIssue baseline = (ILineBasedIssue)baselineIssue;
        INamedElement namedElement = (INamedElement)baseline.getAffectedNamedElements().get(0);
        String baselineFqName = namedElement.getOriginalFqName().orElse(namedElement.getFqName());
        String baselinePattern = LineBasedContextSimilarityMatchPattern.createPattern(baselineFqName, baseline.getLine(), baseline.getLineText(), new IntBasedHash(baseline.getPrefixHashs()), new IntBasedHash(baseline.getPostfixHashs()));
        D.a<INamedElementIssue, NamedElementIssue> bestMatch = null;
        for (NamedElementIssue nextCurrent : currentIssues) {
            StrictPair<IDiffElement.Change, String> changeAndDescription;
            double previousSimilarity;
            D.a<INamedElementIssue, NamedElementIssue> previous;
            assert (nextCurrent != null && nextCurrent instanceof IIssueWithLineContext) : "Unexpected class in method 'findMatchingIssue': " + nextCurrent;
            IIssueWithLineContext lineContextIssue = (IIssueWithLineContext)((Object)nextCurrent);
            String currentPattern = this.c.get(nextCurrent);
            if (currentPattern == null) {
                currentPattern = LineBasedContextSimilarityMatchPattern.createPattern(lineContextIssue);
                this.c.put(nextCurrent, currentPattern);
            }
            if (baselinePattern.equals(currentPattern)) {
                return new D.a<INamedElementIssue, NamedElementIssue>(baselineIssue, nextCurrent, 1.0, IDiffElement.Change.UNMODIFIED, "");
            }
            StrictPair<Double, Set<SourceLineMatcher.TextModification>> similarityResult = SourceLineMatcher.a(lineContextIssue, baselineFqName, baseline.getLineText(), baseline.getLine(), new IntBasedHash(baseline.getPrefixHashs()), new IntBasedHash(baseline.getPostfixHashs()));
            double similarity = (Double)similarityResult.getFirst();
            if (Double.compare(similarity, 0.6) < 0) continue;
            if (bestMatch != null) {
                if (Double.compare(similarity, bestMatch.c()) <= 0) continue;
                previous = this.d.get(nextCurrent);
                double d2 = previousSimilarity = previous != null ? previous.c() : -1.0;
                if (Double.compare(similarity, previousSimilarity) <= 0) continue;
                changeAndDescription = this.a(similarity, (Set<SourceLineMatcher.TextModification>)((Set)similarityResult.getSecond()));
                bestMatch = new D.a<INamedElementIssue, NamedElementIssue>(baselineIssue, nextCurrent, similarity, (IDiffElement.Change)((Object)changeAndDescription.getFirst()), (String)changeAndDescription.getSecond());
                continue;
            }
            previous = this.d.get(nextCurrent);
            double d3 = previousSimilarity = previous != null ? previous.c() : -1.0;
            if (Double.compare(similarity, previousSimilarity) <= 0) continue;
            changeAndDescription = this.a(similarity, (Set<SourceLineMatcher.TextModification>)((Set)similarityResult.getSecond()));
            bestMatch = new D.a<INamedElementIssue, NamedElementIssue>(baselineIssue, nextCurrent, similarity, (IDiffElement.Change)((Object)changeAndDescription.getFirst()), (String)changeAndDescription.getSecond());
        }
        return bestMatch;
    }

    @Override
    private StrictPair<IDiffElement.Change, String> a(double similarity, Set<SourceLineMatcher.TextModification> modifications) {
        assert (modifications != null) : "Parameter 'modifications' of method 'convertToChange' must not be null";
        if (modifications.contains((Object)SourceLineMatcher.TextModification.UNMODIFIED)) {
            return new StrictPair((Object)IDiffElement.Change.UNMODIFIED, (Object)"");
        }
        String description = modifications.stream().map(m2 -> m2.getPresentationName()).collect(Collectors.joining(", ", "Modifications: ", "; Similarity: " + NumberUtility.format((Number)similarity)));
        return new StrictPair((Object)IDiffElement.Change.MODIFIED, (Object)description);
    }

    @Override
    protected void a(NamedElement parent, List<INamedElementIssue> baselineIssues, Set<INamedElementIssue> baselineNamedElementIssues, Set<NamedElementIssue> currentNamedElementIssues) {
        this.c = new HashMap();
        this.d = new HashMap<NamedElementIssue, D.a<INamedElementIssue, NamedElementIssue>>();
        this.a(baselineIssues, currentNamedElementIssues);
        for (D.a<INamedElementIssue, NamedElementIssue> nextMatch : this.d.values()) {
            this.a(parent, baselineNamedElementIssues, currentNamedElementIssues, nextMatch);
        }
    }

    private void a(List<INamedElementIssue> baselineIssues, Set<NamedElementIssue> currentNamedElementIssues) {
        ArrayList<INamedElementIssue> leftOverBaselineIssues = new ArrayList<INamedElementIssue>();
        for (INamedElementIssue nextBaseline : baselineIssues) {
            D.a<INamedElementIssue, NamedElementIssue> previousBestMatch;
            D.a<INamedElementIssue, NamedElementIssue> match = this.a(nextBaseline, currentNamedElementIssues);
            if (match == null) continue;
            NamedElementIssue current = match.b();
            double similarity = match.c();
            if (Double.compare(similarity, 1.0) == 0) {
                currentNamedElementIssues.remove(current);
            }
            if ((previousBestMatch = this.d.get(current)) != null) {
                double previousSimilarity = previousBestMatch.c();
                assert (Double.compare(similarity, previousSimilarity) > 0) : "Previous match must only exist if current similarity is higher.";
                leftOverBaselineIssues.add(previousBestMatch.a());
            }
            this.d.put(current, match);
        }
        if (leftOverBaselineIssues.size() > 0) {
            this.a((List<INamedElementIssue>)leftOverBaselineIssues, currentNamedElementIssues);
        }
    }
}

