/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.core.controller.system.diff.d;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.IgnoreDefinitionDiff;
import com.hello2morrow.sonargraph.integration.access.controller.g;
import com.hello2morrow.sonargraph.integration.access.model.IElement;
import com.hello2morrow.sonargraph.integration.access.model.IIgnoreDefinition;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import java.util.Map;
import java.util.stream.Collectors;

public final class s
extends d<IIgnoreDefinition, IgnoreDefinition> {
    public s(ISoftwareSystem baselineSystem, g baselineSystemInfoProcessor, SoftwareSystem currentSystem) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem, ResolutionType.IGNORE, IIgnoreDefinition.class, IgnoreDefinition.class);
    }

    public IgnoreDefinitionDiff a(NamedElement parent, IIgnoreDefinition baseline, IgnoreDefinition current, IDiffElement.Change change, String message) {
        return new IgnoreDefinitionDiff(parent, baseline, current, change, message);
    }

    public IgnoreDefinitionDiff a(NamedElement parent, IIgnoreDefinition baseline, IgnoreDefinition current, IDiffElement.Change change) {
        return new IgnoreDefinitionDiff(parent, baseline, current, change);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String a(IDiffElement.Change change, IIgnoreDefinition baseline, IgnoreDefinition current) {
        assert (change != null) : "Parameter 'change' of method 'createDescriptionForSingleMatchedElement' must not be null";
        StringBuilder description = new StringBuilder();
        switch (change) {
            case ADDED: 
            case WORSENED: 
            case MODIFIED: 
            case IMPROVED: 
            case UNMODIFIED: {
                if (current.getMatchingElementsCount() == 0) {
                    return "No matching issues";
                }
                if (current.getMatchingElementsCount() == 1) {
                    Element affectedElement = current.getAssociatedIssues().get(0).getAffectedElement();
                    description.append(affectedElement.getPresentationName(true));
                    if (affectedElement.getDescription() != null && affectedElement.getDescription().trim().length() > 0) {
                        description.append(", ").append(affectedElement.getDescription());
                        return description.toString();
                    } else {
                        String issueDescription = current.getAssociatedIssues().get(0).getDescription();
                        if (issueDescription == null || issueDescription.trim().length() <= 0) return description.toString();
                        description.append(", ").append(issueDescription);
                    }
                    return description.toString();
                } else {
                    Map<String, Long> issueTypeCounts = current.getAssociatedIssues().stream().map(i2 -> ((Issue)i2).getId()).collect(Collectors.groupingBy(IStandardEnumeration::getPresentationName, Collectors.counting()));
                    boolean first = true;
                    for (Map.Entry<String, Long> nextType : issueTypeCounts.entrySet()) {
                        if (!first) {
                            description.append(", ");
                        }
                        description.append(nextType.getValue()).append(" ").append(nextType.getKey());
                        if (nextType.getValue() > 1L) {
                            description.append("s");
                        }
                        if (!first) continue;
                        first = false;
                    }
                }
                return description.toString();
            }
            case REMOVED: {
                if (baseline.getMatchingElementsCount() == 0) {
                    return "No matching elements";
                }
                if (baseline.getMatchingElementsCount() == 1) {
                    IIssue issue = (IIssue)baseline.getIssues().get(0);
                    description.append(issue.getPresentationName());
                    if (issue.getDescription() == null || issue.getDescription().trim().length() <= 0) return description.toString();
                    description.append(", ").append(issue.getDescription());
                    return description.toString();
                }
                Map<String, Long> issueTypeCounts = baseline.getIssues().stream().map(i2 -> i2.getIssueType()).collect(Collectors.groupingBy(IElement::getPresentationName, Collectors.counting()));
                boolean first = true;
                for (Map.Entry<String, Long> nextType : issueTypeCounts.entrySet()) {
                    if (!first) {
                        description.append(", ");
                    }
                    description.append(nextType.getValue()).append(" ").append(nextType.getKey());
                    if (nextType.getValue() > 1L) {
                        description.append("s");
                    }
                    if (!first) continue;
                    first = false;
                }
                return description.toString();
            }
        }
        return null;
    }
}

