/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.core.controller.system.diff.n;
import com.hello2morrow.sonargraph.core.controller.system.diff.p;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.DiffUtility;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.BaselineOccurrenceDto;
import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.CurrentOccurrenceDto;
import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.DuplicateDto;
import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.DuplicateOccurrenceDto;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockOccurrenceDiff;
import com.hello2morrow.sonargraph.integration.access.controller.g;
import com.hello2morrow.sonargraph.integration.access.model.IDuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.integration.access.model.IDuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class o
extends com.hello2morrow.sonargraph.core.controller.system.diff.b<IDuplicateCodeBlockIssue, DuplicateCodeBlockIssue> {
    private static final Logger d = LoggerFactory.getLogger(o.class);
    private static final double e = 0.2;

    public o(ISoftwareSystem baselineSystem, g baselineSystemInfoProcessor, Set<IIssue> allBaselineIssues, SoftwareSystem softwareSystem, Set<Issue> allCurrentIssues, Map<NamedElement, String> namedElementToFqNameCache) {
        super(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, softwareSystem, allCurrentIssues, namedElementToFqNameCache, IDuplicateCodeBlockIssue.class, DuplicateCodeBlockIssue.class);
    }

    @Override
    protected void a(NamedElement parent, List<IDuplicateCodeBlockIssue> baselineIssues, List<DuplicateCodeBlockIssue> currentIssues) {
        assert (parent != null) : "Parameter 'parent' of method 'computeDiffs' must not be null";
        assert (baselineIssues != null) : "Parameter 'baselineIssues' of method 'computeDiffs' must not be null";
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'computeDiffs' must not be null";
        List<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselineDuplicates = this.a(baselineIssues);
        List<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> currentDuplicates = this.b(currentIssues);
        this.b(parent, baselineDuplicates, currentDuplicates);
        this.c(parent, baselineDuplicates, currentDuplicates);
        this.a(parent, baselineDuplicates);
        this.b(parent, currentDuplicates);
        assert (baselineDuplicates.isEmpty()) : "Not all baseline cycles processed! Remaining: " + baselineDuplicates.stream().map(pair -> ((DuplicateDto)pair.getFirst()).toString()).collect(Collectors.toList());
        assert (currentDuplicates.isEmpty()) : "Not all current cycles processed! Remaining: " + currentDuplicates.stream().map(pair -> ((DuplicateDto)pair.getFirst()).toString()).collect(Collectors.toList());
    }

    @Override
    private List<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> a(List<IDuplicateCodeBlockIssue> baselineIssues) {
        assert (baselineIssues != null) : "Parameter 'baselineIssues' of method 'collectBaselineDuplicateIssues' must not be null";
        ArrayList<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselineDtos = new ArrayList<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>>(baselineIssues.size());
        for (IDuplicateCodeBlockIssue nextBaseline : baselineIssues) {
            List baselineOccurrences = nextBaseline.getOccurrences();
            ArrayList<BaselineOccurrenceDto> occurrenceDtos = new ArrayList<BaselineOccurrenceDto>(baselineOccurrences.size());
            for (IDuplicateCodeBlockOccurrence nextOccurrence : baselineOccurrences) {
                occurrenceDtos.add(new BaselineOccurrenceDto(nextOccurrence));
            }
            Collections.sort(occurrenceDtos);
            DuplicateDto duplicateDto = new DuplicateDto(nextBaseline.getPresentationName(), nextBaseline.getTotalDuplicateLineCount(), occurrenceDtos);
            baselineDtos.add((StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>)new StrictPair(duplicateDto, (Object)nextBaseline));
        }
        Collections.sort(baselineDtos, new Comparator<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>>(){

            public int a(StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> pair1, StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> pair2) {
                return ((DuplicateDto)pair1.getFirst()).compareTo((DuplicateDto)pair2.getFirst());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>)((StrictPair)object), (StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>)((StrictPair)object2));
            }
        });
        return baselineDtos;
    }

    private List<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> b(List<DuplicateCodeBlockIssue> currentIssues) {
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'collectCurrentDuplicateIssues' must not be null";
        ArrayList<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> currentDtos = new ArrayList<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>>(currentIssues.size());
        for (DuplicateCodeBlockIssue nextCurrent : currentIssues) {
            DuplicateCodeBlock duplicateCodeBlock = (DuplicateCodeBlock)nextCurrent.getAffectedElement();
            List<DuplicateCodeBlockOccurrence> occurrences = duplicateCodeBlock.getChildren(DuplicateCodeBlockOccurrence.class);
            ArrayList<CurrentOccurrenceDto> occurrenceDtos = new ArrayList<CurrentOccurrenceDto>(occurrences.size());
            for (DuplicateCodeBlockOccurrence nextOccurrence : occurrences) {
                CurrentOccurrenceDto occurrenceDto = new CurrentOccurrenceDto(nextOccurrence);
                occurrenceDtos.add(occurrenceDto);
            }
            Collections.sort(occurrenceDtos);
            DuplicateDto duplicateDto = new DuplicateDto(nextCurrent.getAffectedElement().getName(), duplicateCodeBlock.getTotalDuplicateLineCount(), occurrenceDtos);
            currentDtos.add((StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>)new StrictPair(duplicateDto, (Object)nextCurrent));
        }
        Collections.sort(currentDtos, new Comparator<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>>(){

            public int a(StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> pair1, StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> pair2) {
                return ((DuplicateDto)pair1.getFirst()).compareTo((DuplicateDto)pair2.getFirst());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>)((StrictPair)object), (StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>)((StrictPair)object2));
            }
        });
        return currentDtos;
    }

    private void b(NamedElement parent, List<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselineDuplicates, List<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> currentDuplicates) {
        assert (baselineDuplicates != null) : "Parameter 'baselineDuplicates' of method 'processExactMatches' must not be null";
        assert (currentDuplicates != null) : "Parameter 'currentDuplicates' of method 'processExactMatches' must not be null";
        if (baselineDuplicates.isEmpty() || currentDuplicates.isEmpty()) {
            return;
        }
        HashSet<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselinesToRemove = new HashSet<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>>();
        HashSet<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> currentsToRemove = new HashSet<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>>();
        block0: for (StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> baselinePair : baselineDuplicates) {
            DuplicateDto baselineDto = (DuplicateDto)baselinePair.getFirst();
            for (StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> currentPair : currentDuplicates) {
                if (currentsToRemove.contains(currentPair)) continue;
                DuplicateDto currentDto = (DuplicateDto)currentPair.getFirst();
                int compare = baselineDto.compareTo(currentDto);
                if (compare == 0) {
                    DuplicateCodeBlockIssueDiff diff = this.a(parent, baselineDto, (IDuplicateCodeBlockIssue)baselinePair.getSecond(), currentDto, (DuplicateCodeBlockIssue)currentPair.getSecond());
                    if (diff == null) continue;
                    parent.addChild(diff);
                    baselinesToRemove.add(baselinePair);
                    currentsToRemove.add(currentPair);
                    continue block0;
                }
                if (compare < 0) continue block0;
            }
        }
        baselineDuplicates.removeAll(baselinesToRemove);
        currentDuplicates.removeAll(currentsToRemove);
    }

    private DuplicateCodeBlockIssueDiff a(NamedElement parent, DuplicateDto<BaselineOccurrenceDto> baseline, IDuplicateCodeBlockIssue baselineDuplicateIssue, DuplicateDto<CurrentOccurrenceDto> current, DuplicateCodeBlockIssue currentDuplicateIssue) {
        String changeDescription;
        IDiffElement.Change change;
        assert (parent != null) : "Parameter 'parent' of method 'determineDiff' must not be null";
        assert (baseline != null) : "Parameter 'baseline' of method 'determineDiff' must not be null";
        assert (baselineDuplicateIssue != null) : "Parameter 'baselineDuplicateIssue' of method 'determineDiffForExactMatches' must not be null";
        assert (current != null) : "Parameter 'current' of method 'determineDiff' must not be null";
        assert (currentDuplicateIssue != null) : "Parameter 'currentDuplicateIssue' of method 'determineDiffForExactMatches' must not be null";
        List<BaselineOccurrenceDto> baselineOccurrences = baseline.getOccurrences();
        List<CurrentOccurrenceDto> currentOccurrences = current.getOccurrences();
        assert (baselineOccurrences.size() == currentOccurrences.size()) : "Equal sizes expected, but was " + baselineOccurrences.size() + " (baseline) " + currentOccurrences.size() + " (current)";
        Pair<IDiffElement.Change, String> determineResolutionChange = this.a(baselineDuplicateIssue, currentDuplicateIssue);
        if (determineResolutionChange.getFirst() != IDiffElement.Change.UNMODIFIED) {
            change = (IDiffElement.Change)((Object)determineResolutionChange.getFirst());
            changeDescription = (String)determineResolutionChange.getSecond();
        } else {
            change = IDiffElement.Change.UNMODIFIED;
            changeDescription = "";
        }
        DuplicateCodeBlockIssueDiff diff = new DuplicateCodeBlockIssueDiff(parent, baselineDuplicateIssue, currentDuplicateIssue, change, changeDescription, DuplicateCodeBlockIssueDiff.DuplicateChange.UNMODIFIED);
        int i2 = 0;
        while (i2 < baselineOccurrences.size()) {
            CurrentOccurrenceDto currentOcc;
            BaselineOccurrenceDto baselineOcc = baselineOccurrences.get(i2);
            if (baselineOcc.compareTo(currentOcc = currentOccurrences.get(i2)) != 0) {
                return null;
            }
            DuplicateCodeBlockOccurrenceDiff occurrenceDiff = new DuplicateCodeBlockOccurrenceDiff(diff, (IDuplicateCodeBlockOccurrence)baselineOcc.getOccurrence(), (DuplicateCodeBlockOccurrence)currentOcc.getOccurrence(), IDiffElement.Change.UNMODIFIED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.UNMODIFIED, "");
            diff.addChild(occurrenceDiff);
            ++i2;
        }
        return diff;
    }

    private void c(NamedElement parent, List<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselineDuplicates, List<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> currentDuplicates) {
        assert (parent != null) : "Parameter 'parent' of method 'processModified' must not be null";
        assert (baselineDuplicates != null) : "Parameter 'baselineDuplicates' of method 'processModified' must not be null";
        assert (currentDuplicates != null) : "Parameter 'currentDuplicates' of method 'processModified' must not be null";
        ArrayList<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselinesToRemove = new ArrayList<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>>();
        ArrayList<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> currentToRemove = new ArrayList<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>>();
        block0: for (StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> nextCurrentPair : currentDuplicates) {
            ArrayList<b> scoreInfo = new ArrayList<b>();
            for (StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> nextBaselinePair : baselineDuplicates) {
                StrictPair<Double, Integer> score = n.a((DuplicateDto)nextBaselinePair.getFirst(), (DuplicateDto)nextCurrentPair.getFirst());
                if (Double.compare((Double)score.getFirst(), 1.0) == 0) {
                    DuplicateCodeBlockIssueDiff diff = this.a(parent, nextBaselinePair, nextCurrentPair);
                    parent.addChild(diff);
                    baselinesToRemove.add(nextBaselinePair);
                    currentToRemove.add(nextCurrentPair);
                    continue block0;
                }
                if (!((Double)score.getFirst() > 0.0)) continue;
                scoreInfo.add(new b((Double)score.getFirst(), (Integer)score.getSecond(), nextBaselinePair, nextCurrentPair));
            }
            if (scoreInfo.size() <= 0) continue;
            scoreInfo.sort(new Comparator<b>(){

                public int a(b o1, b o2) {
                    int compareUnmatched = Integer.compare(o2.b(), o1.b());
                    if (compareUnmatched == 0) {
                        return Double.compare(o1.a(), o2.a());
                    }
                    return compareUnmatched;
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((b)object, (b)object2);
                }
            });
            b bestMatch = (b)scoreInfo.get(scoreInfo.size() - 1);
            if (bestMatch.a() > 0.2) {
                DuplicateCodeBlockIssueDiff diff = this.a(parent, bestMatch.c(), bestMatch.d());
                parent.addChild(diff);
                baselinesToRemove.add(bestMatch.c());
                currentToRemove.add(bestMatch.d());
                continue;
            }
            d.debug("Ignoring 'modified' match of '{}' and '{}', because score of {} is below threshold", new Object[]{bestMatch.c().getFirst(), bestMatch.d().getFirst(), bestMatch.a()});
        }
        baselineDuplicates.removeAll(baselinesToRemove);
        currentDuplicates.removeAll(currentToRemove);
    }

    private DuplicateCodeBlockIssueDiff a(NamedElement parent, StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> baselinePair, StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> currentPair) {
        DuplicateDto baselineDuplicateDto = (DuplicateDto)baselinePair.getFirst();
        IDuplicateCodeBlockIssue baselineIssue = (IDuplicateCodeBlockIssue)baselinePair.getSecond();
        DuplicateDto currentDuplicateDto = (DuplicateDto)currentPair.getFirst();
        DuplicateCodeBlockIssue currentIssue = (DuplicateCodeBlockIssue)currentPair.getSecond();
        ArrayList baselineOccurenceDtos = new ArrayList(baselineDuplicateDto.getOccurrences());
        Pair<IDiffElement.Change, String> resolutionChange = this.a(baselineIssue, currentIssue);
        IDiffElement.Change change = (IDiffElement.Change)((Object)resolutionChange.getFirst());
        String changeDescription = (String)resolutionChange.getSecond();
        ArrayList<a> occurrenceDiffDtos = new ArrayList<a>();
        HashMap baselineOccurrencesToDiffMap = new HashMap();
        for (CurrentOccurrenceDto currentOccurrenceDto : currentDuplicateDto.getOccurrences()) {
            DuplicateOccurrenceDto baselineOccBestMatch = null;
            n.a bestMatchResult = null;
            int i2 = 0;
            while (i2 < baselineOccurenceDtos.size()) {
                BaselineOccurrenceDto nextBaselineOcc = (BaselineOccurrenceDto)baselineOccurenceDtos.get(i2);
                StrictPair<DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail, Integer> matchInfo = p.a(currentOccurrenceDto, nextBaselineOcc);
                if (matchInfo != null) {
                    if (matchInfo.getFirst() == DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.UNMODIFIED) {
                        bestMatchResult = new n.a((DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail)((Object)matchInfo.getFirst()), (Integer)matchInfo.getSecond(), Math.max(currentOccurrenceDto.getBlockSize(), nextBaselineOcc.getBlockSize()), i2);
                        baselineOccBestMatch = nextBaselineOcc;
                        break;
                    }
                    if (bestMatchResult == null || (Integer)matchInfo.getSecond() > bestMatchResult.b()) {
                        bestMatchResult = new n.a((DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail)((Object)matchInfo.getFirst()), (Integer)matchInfo.getSecond(), Math.max(currentOccurrenceDto.getBlockSize(), nextBaselineOcc.getBlockSize()), i2);
                        baselineOccBestMatch = nextBaselineOcc;
                    }
                }
                ++i2;
            }
            if (baselineOccBestMatch != null && bestMatchResult != null) {
                IDiffElement.Change convertedChange = bestMatchResult.a().convertToChange();
                IDuplicateCodeBlockOccurrence baselineOccurrence = (IDuplicateCodeBlockOccurrence)baselineOccBestMatch.getOccurrence();
                String occChangeDescription = this.a(baselineOccurrence, (DuplicateCodeBlockOccurrence)currentOccurrenceDto.getOccurrence(), convertedChange, bestMatchResult.a());
                a dto = new a(baselineOccurrence, (DuplicateCodeBlockOccurrence)currentOccurrenceDto.getOccurrence(), convertedChange, bestMatchResult.a(), occChangeDescription, bestMatchResult.b());
                ArrayList<a> baselineMatches = (ArrayList<a>)baselineOccurrencesToDiffMap.get(baselineOccBestMatch);
                if (baselineMatches == null) {
                    baselineMatches = new ArrayList<a>();
                    baselineOccurrencesToDiffMap.put(baselineOccBestMatch, baselineMatches);
                } else if (bestMatchResult.a() == DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.UNMODIFIED) {
                    baselineMatches.clear();
                }
                baselineMatches.add(dto);
                continue;
            }
            String occChangeDescription = this.a(null, (DuplicateCodeBlockOccurrence)currentOccurrenceDto.getOccurrence(), IDiffElement.Change.ADDED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.ADDED);
            a dto = new a(null, (DuplicateCodeBlockOccurrence)currentOccurrenceDto.getOccurrence(), IDiffElement.Change.ADDED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.ADDED, occChangeDescription, 0);
            occurrenceDiffDtos.add(dto);
        }
        for (Map.Entry entry : baselineOccurrencesToDiffMap.entrySet()) {
            List diffMatches = (List)entry.getValue();
            if (diffMatches.size() > 1) {
                diffMatches.sort(new Comparator<a>(){

                    public int a(a o1, a o2) {
                        return Integer.compare(o1.f(), o2.f());
                    }

                    @Override
                    public /* synthetic */ int compare(Object object, Object object2) {
                        return this.a((a)object, (a)object2);
                    }
                });
            }
            a baselineOccDto = (a)diffMatches.get(diffMatches.size() - 1);
            occurrenceDiffDtos.add(baselineOccDto);
            baselineOccurenceDtos.remove(entry.getKey());
        }
        for (BaselineOccurrenceDto baselineOccurrenceDto : baselineOccurenceDtos) {
            String occChangeDescription = this.a((IDuplicateCodeBlockOccurrence)baselineOccurrenceDto.getOccurrence(), null, IDiffElement.Change.REMOVED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.REMOVED);
            a dto = new a((IDuplicateCodeBlockOccurrence)baselineOccurrenceDto.getOccurrence(), null, IDiffElement.Change.REMOVED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.REMOVED, occChangeDescription, 0);
            occurrenceDiffDtos.add(dto);
        }
        StrictPair<StrictPair<IDiffElement.Change, String>, DuplicateCodeBlockIssueDiff.DuplicateChange> strictPair = this.a(baselineIssue, currentIssue, occurrenceDiffDtos, change, changeDescription);
        DuplicateCodeBlockIssueDiff issueDiff = new DuplicateCodeBlockIssueDiff(parent, baselineIssue, currentIssue, (IDiffElement.Change)((Object)((StrictPair)strictPair.getFirst()).getFirst()), (String)((StrictPair)strictPair.getFirst()).getSecond(), (DuplicateCodeBlockIssueDiff.DuplicateChange)((Object)strictPair.getSecond()));
        for (a nextDto : occurrenceDiffDtos) {
            DuplicateCodeBlockOccurrenceDiff occDiff = new DuplicateCodeBlockOccurrenceDiff(issueDiff, nextDto.a(), nextDto.b(), nextDto.c(), nextDto.e(), nextDto.d());
            issueDiff.addChild(occDiff);
        }
        return issueDiff;
    }

    private StrictPair<StrictPair<IDiffElement.Change, String>, DuplicateCodeBlockIssueDiff.DuplicateChange> a(IDuplicateCodeBlockIssue baselineIssue, DuplicateCodeBlockIssue currentIssue, List<a> occurrences, IDiffElement.Change change, String changeDescription) {
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'createDuplicateChangeDescription' must not be null";
        assert (currentIssue != null) : "Parameter 'currentIssue' of method 'createDuplicateChangeDescription' must not be null";
        assert (occurrences != null) : "Parameter 'occurrences' of method 'createDuplicateChangeDescription' must not be null";
        assert (change != null) : "Parameter 'change' of method 'createDuplicateChangeDescription' must not be null";
        assert (changeDescription != null) : "Parameter 'changeDescription' of method 'createDuplicateChangeDescription' must not be null";
        StringBuilder description = new StringBuilder(changeDescription);
        IDiffElement.Change computedChange = change;
        DuplicateCodeBlockIssueDiff.DuplicateChange duplicateChange = DuplicateCodeBlockIssueDiff.DuplicateChange.UNMODIFIED;
        int numberOfBaselineOcc = baselineIssue.getOccurrences().size();
        int numberOfCurrentOcc = ((DuplicateCodeBlock)currentIssue.getAffectedElement()).getTotalNumberOfOccurrences();
        long numberOfRemovedOcc = occurrences.stream().filter(occ -> occ.c() == IDiffElement.Change.REMOVED).count();
        long numberOfAddedOcc = occurrences.stream().filter(occ -> occ.c() == IDiffElement.Change.ADDED).count();
        int baselineTotalLineCount = baselineIssue.getTotalDuplicateLineCount();
        if (baselineTotalLineCount == -1) {
            baselineTotalLineCount = baselineIssue.getTotalDuplicateLineCount();
        }
        int currentTotalLines = ((DuplicateCodeBlock)currentIssue.getAffectedElement()).getTotalDuplicateLineCount();
        int diffOfTotalLines = currentTotalLines - baselineTotalLineCount;
        int diffOccurrences = numberOfCurrentOcc - numberOfBaselineOcc;
        StringBuilder diffOccString = new StringBuilder();
        if (diffOccurrences != 0) {
            diffOccString.append("(");
            if (diffOccurrences > 0) {
                diffOccString.append("+");
            }
            diffOccString.append(diffOccurrences).append(")");
            duplicateChange = DuplicateCodeBlockIssueDiff.DuplicateChange.OCCURRENCES;
        }
        if (numberOfRemovedOcc > 0L && numberOfRemovedOcc > numberOfAddedOcc) {
            computedChange = IDiffElement.Change.IMPROVED;
            this.a(description);
            description.append("Occurrences: ").append(numberOfBaselineOcc).append(" -> ").append(numberOfCurrentOcc);
            description.append(" ").append(diffOccString.toString());
            if (numberOfAddedOcc > 0L) {
                description.append(" [-").append(numberOfRemovedOcc);
                description.append("/+").append(numberOfAddedOcc);
                description.append("])");
            }
        } else if (numberOfAddedOcc > 0L && numberOfAddedOcc > numberOfRemovedOcc) {
            computedChange = IDiffElement.Change.WORSENED;
            this.a(description);
            description.append("Occurrences: ").append(numberOfBaselineOcc).append(" -> ").append(numberOfCurrentOcc);
            description.append(" ").append(diffOccString.toString());
            if (numberOfRemovedOcc > 0L) {
                description.append("[");
                description.append("-").append(numberOfRemovedOcc).append("/");
                description.append("+").append(numberOfAddedOcc);
                description.append("])");
            }
        } else {
            assert (numberOfAddedOcc - numberOfRemovedOcc == 0L) : "numberOfAdded must be equal to numberOfRemoved, but was " + numberOfAddedOcc + " != " + numberOfRemovedOcc;
            computedChange = IDiffElement.Change.MODIFIED;
            this.a(description);
            description.append("Occurrences: ").append(numberOfBaselineOcc);
            if (numberOfAddedOcc > 0L) {
                description.append(" (").append(diffOccString.toString());
                description.append("-").append(numberOfRemovedOcc);
                description.append("/");
                description.append("+").append(numberOfAddedOcc);
                description.append(")");
            }
        }
        if (diffOfTotalLines != 0) {
            this.a(description);
            duplicateChange = DuplicateCodeBlockIssueDiff.DuplicateChange.INVOLVED_LINES;
            assert (baselineTotalLineCount > 0) : "Invalid value of baselineTotalLineCount: " + baselineTotalLineCount;
            description.append("Involved Lines: ").append(NumberUtility.format((Number)baselineTotalLineCount, (boolean)true)).append(" -> ").append(NumberUtility.format((Number)currentTotalLines, (boolean)true));
            description.append(" (");
            if (diffOfTotalLines > 0) {
                description.append("+");
                computedChange = IDiffElement.Change.WORSENED;
            } else {
                computedChange = IDiffElement.Change.IMPROVED;
            }
            description.append(NumberUtility.format((Number)diffOfTotalLines, (boolean)true));
            description.append(")");
        } else {
            this.a(description);
            description.append("Involved Lines: ").append(NumberUtility.format((Number)baselineTotalLineCount, (boolean)true));
        }
        if (change == IDiffElement.Change.RESOLUTION_ADDED || change == IDiffElement.Change.RESOLUTION_REMOVED) {
            computedChange = change;
        }
        StrictPair changeAndDescription = new StrictPair((Object)computedChange, (Object)description.toString());
        return new StrictPair((Object)changeAndDescription, (Object)duplicateChange);
    }

    private void a(StringBuilder description) {
        assert (description != null) : "Parameter 'description' of method 'addDotIfNotEmpty' must not be null";
        if (description.length() > 0) {
            description.append(", ");
        }
    }

    private String a(IDuplicateCodeBlockOccurrence baseline, DuplicateCodeBlockOccurrence current, IDiffElement.Change change, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail changeDetail) {
        assert (change != null) : "Parameter 'change' of method 'createChangeDescription' must not be null";
        StringBuilder description = new StringBuilder();
        switch (changeDetail) {
            case REMOVED: {
                StringBuilder removed = new StringBuilder().append(baseline.getStartLine()).append("-").append(baseline.getEndLine()).append(" (").append(baseline.getBlockSize()).append(" Lines)");
                description.append(DiffUtility.createChangeDetails(removed.toString(), "", change));
                break;
            }
            case ADDED: {
                StringBuilder added = new StringBuilder().append(current.getBlockBegin()).append("-").append(current.getBlockEnd()).append(" (").append(current.getBlockSize()).append(" Lines)");
                description.append(DiffUtility.createChangeDetails("", added.toString(), change));
                break;
            }
            case UNMODIFIED: {
                description.append(baseline.getStartLine()).append("-").append(baseline.getEndLine());
                description.append(" (").append(current.getBlockSize()).append(" Lines)");
                break;
            }
            case EXTENDED: 
            case REDUCED: {
                description.append(baseline.getStartLine()).append("-").append(baseline.getEndLine());
                description.append(" -> ");
                description.append(current.getBlockBegin()).append("-").append(current.getBlockEnd());
                description.append(" (").append(current.getBlockSize()).append(" Lines, ");
                description.append(changeDetail.getPresentationName()).append(" by ");
                int blockSizeDifference = current.getBlockSize() - baseline.getBlockSize();
                assert (blockSizeDifference != 0) : "Blocksize is unchanged: " + current.getBlockSize();
                description.append(Math.abs(blockSizeDifference));
                description.append(" Lines)");
                break;
            }
            case MOVED: {
                description.append(baseline.getStartLine()).append("-").append(baseline.getEndLine());
                description.append(" -> ");
                description.append(current.getBlockBegin()).append("-").append(current.getBlockEnd());
                description.append(" (").append(current.getBlockSize()).append(" Lines, ");
                description.append(changeDetail.getPresentationName()).append(" by ");
                int startDifference = current.getBlockBegin() - baseline.getStartLine();
                description.append(startDifference);
                description.append(" Lines)");
                break;
            }
            case MODIFIED: {
                description.append(current.getBlockBegin()).append("-").append(current.getBlockEnd());
                description.append(" (").append(current.getBlockSize()).append(" Lines)");
                break;
            }
            default: {
                assert (false) : "Unhandled changeDetail " + changeDetail.getPresentationName();
                break;
            }
        }
        return description.toString();
    }

    private void a(NamedElement parent, List<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> removed) {
        assert (parent != null) : "Parameter 'parent' of method 'processRemoved' must not be null";
        Iterator<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselineIter = removed.iterator();
        while (baselineIter.hasNext()) {
            StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> next = baselineIter.next();
            String changeDescription = DiffUtility.createChangeDetails(this.a((IDuplicateCodeBlockIssue)next.getSecond()), "", IDiffElement.Change.REMOVED);
            DuplicateCodeBlockIssueDiff diff = new DuplicateCodeBlockIssueDiff(parent, (IDuplicateCodeBlockIssue)next.getSecond(), null, IDiffElement.Change.REMOVED, changeDescription, DuplicateCodeBlockIssueDiff.DuplicateChange.REMOVED);
            for (BaselineOccurrenceDto nextBaselineOcc : ((DuplicateDto)next.getFirst()).getOccurrences()) {
                String occChangeDescription = this.a((IDuplicateCodeBlockOccurrence)nextBaselineOcc.getOccurrence(), null, IDiffElement.Change.REMOVED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.REMOVED);
                DuplicateCodeBlockOccurrenceDiff occDiff = new DuplicateCodeBlockOccurrenceDiff(diff, (IDuplicateCodeBlockOccurrence)nextBaselineOcc.getOccurrence(), null, IDiffElement.Change.REMOVED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.REMOVED, occChangeDescription);
                diff.addChild(occDiff);
            }
            parent.addChild(diff);
            baselineIter.remove();
        }
    }

    private void b(NamedElement parent, List<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> added) {
        assert (parent != null) : "Parameter 'parent' of method 'processAdded' must not be null";
        assert (added != null) : "Parameter 'added' of method 'processAdded' must not be null";
        Iterator<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> iter = added.iterator();
        while (iter.hasNext()) {
            StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> next = iter.next();
            String changeDescription = DiffUtility.createChangeDetails("", this.a((DuplicateCodeBlockIssue)next.getSecond()), IDiffElement.Change.ADDED);
            DuplicateCodeBlockIssueDiff diff = new DuplicateCodeBlockIssueDiff(parent, null, (DuplicateCodeBlockIssue)next.getSecond(), IDiffElement.Change.ADDED, changeDescription, DuplicateCodeBlockIssueDiff.DuplicateChange.ADDED);
            for (CurrentOccurrenceDto nextOcc : ((DuplicateDto)next.getFirst()).getOccurrences()) {
                String occChangeDescription = this.a(null, (DuplicateCodeBlockOccurrence)nextOcc.getOccurrence(), IDiffElement.Change.ADDED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.ADDED);
                DuplicateCodeBlockOccurrenceDiff occDiff = new DuplicateCodeBlockOccurrenceDiff(diff, null, (DuplicateCodeBlockOccurrence)nextOcc.getOccurrence(), IDiffElement.Change.ADDED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.ADDED, occChangeDescription);
                diff.addChild(occDiff);
            }
            parent.addChild(diff);
            iter.remove();
        }
    }

    private String a(IDuplicateCodeBlockIssue baselineDuplicate) {
        assert (baselineDuplicate != null) : "Parameter 'baselineDuplicate' of method 'getBaselineInfo' must not be null";
        int duplicateLineCount = baselineDuplicate.getTotalDuplicateLineCount();
        if (duplicateLineCount == -1) {
            duplicateLineCount = baselineDuplicate.getTotalDuplicateLineCount();
        }
        return this.a(baselineDuplicate.getOccurrences().size(), duplicateLineCount);
    }

    private String a(DuplicateCodeBlockIssue currentDuplicate) {
        assert (currentDuplicate != null) : "Parameter 'currentDuplicate' of method 'getCurrentInfo' must not be null";
        DuplicateCodeBlock duplicate = (DuplicateCodeBlock)currentDuplicate.getAffectedElement();
        int duplicateLineCount = duplicate.getTotalDuplicateLineCount();
        return this.a(duplicate.getTotalNumberOfOccurrences(), duplicateLineCount);
    }

    private String a(int occurrences, int duplicateLineCount) {
        StringBuilder info = new StringBuilder("Occurrences: ");
        info.append(occurrences);
        info.append(", Involved Lines: ").append(NumberUtility.format((Number)duplicateLineCount, (boolean)true));
        return info.toString();
    }

    private static class a {
        private final IDuplicateCodeBlockOccurrence a;
        private final DuplicateCodeBlockOccurrence b;
        private final IDiffElement.Change c;
        private final DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail d;
        private final String e;
        private final int f;

        public a(IDuplicateCodeBlockOccurrence baselineOcc, DuplicateCodeBlockOccurrence currentOccurrence, IDiffElement.Change change, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail changeDetail, String changeDescription, int overlap) {
            this.a = baselineOcc;
            this.b = currentOccurrence;
            this.c = change;
            this.d = changeDetail;
            this.e = changeDescription;
            this.f = overlap;
        }

        public IDuplicateCodeBlockOccurrence a() {
            return this.a;
        }

        public DuplicateCodeBlockOccurrence b() {
            return this.b;
        }

        public IDiffElement.Change c() {
            return this.c;
        }

        public String d() {
            return this.e;
        }

        public DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail e() {
            return this.d;
        }

        public int f() {
            return this.f;
        }
    }

    private static class b {
        private final double a;
        private final StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> b;
        private final StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> c;
        private final Integer d;

        public b(double score, Integer unmatchedOccurrences, StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> baselinePair, StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> currentPair) {
            this.a = score;
            this.d = unmatchedOccurrences;
            this.c = baselinePair;
            this.b = currentPair;
        }

        public double a() {
            return this.a;
        }

        public Integer b() {
            return this.d;
        }

        public StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> c() {
            return this.c;
        }

        public StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> d() {
            return this.b;
        }
    }
}

