/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.controller.system.diff.b;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CyclicElementDiff;
import com.hello2morrow.sonargraph.integration.access.controller.g;
import com.hello2morrow.sonargraph.integration.access.model.ICycleGroupIssue;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class i
extends b<ICycleGroupIssue, CycleGroupIssue> {
    static final int c = 20;

    public i(ISoftwareSystem baselineSystem, g baselineSystemInfoProcessor, Set<IIssue> allBaselineIssues, SoftwareSystem currentSystem, Set<Issue> allCurrentIssues, Map<NamedElement, String> namedElementToFqNameCache) {
        super(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, currentSystem, allCurrentIssues, namedElementToFqNameCache, ICycleGroupIssue.class, CycleGroupIssue.class);
    }

    @Override
    protected void a(NamedElement parent, List<ICycleGroupIssue> baselineIssues, List<CycleGroupIssue> currentIssues) {
        assert (parent != null) : "Parameter 'parent' of method 'computeDiffs' must not be null";
        assert (baselineIssues != null) : "Parameter 'baselineIssues' of method 'computeDiffs' must not be null";
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'computeDiffs' must not be null";
        Map<a, ICycleGroupIssue> baselineCyclesMap = this.a(baselineIssues);
        Map<a, CycleGroupIssue> currentCyclesMap = this.b(currentIssues);
        this.a(parent, baselineCyclesMap, currentCyclesMap);
        this.b(parent, baselineCyclesMap, currentCyclesMap);
        this.c(parent, baselineCyclesMap, currentCyclesMap);
        this.d(parent, baselineCyclesMap, currentCyclesMap);
        this.a(parent, baselineCyclesMap);
        this.b(parent, currentCyclesMap);
        assert (baselineCyclesMap.isEmpty()) : "Not all baseline cycles processed! Remaining: " + baselineCyclesMap.keySet();
        assert (currentCyclesMap.isEmpty()) : "Not all current cycles processed! Remaining: " + currentCyclesMap.keySet();
    }

    private Map<a, ICycleGroupIssue> a(List<ICycleGroupIssue> baselineIssues) {
        HashMap<a, ICycleGroupIssue> baselineCyclesMap = new HashMap<a, ICycleGroupIssue>();
        for (ICycleGroupIssue nextIssue : baselineIssues) {
            TreeSet<String> elementFqNames = new TreeSet<String>();
            for (INamedElement nextCyclicElement : nextIssue.getAffectedNamedElements()) {
                elementFqNames.add(this.a(nextCyclicElement));
            }
            a dto = new a(nextIssue.getIssueType().getName(), nextIssue.getPresentationName(), elementFqNames);
            baselineCyclesMap.put(dto, nextIssue);
        }
        return baselineCyclesMap;
    }

    private Map<a, CycleGroupIssue> b(List<CycleGroupIssue> currentIssues) {
        HashMap<a, CycleGroupIssue> currentCycleMap = new HashMap<a, CycleGroupIssue>();
        for (CycleGroupIssue nextIssue : currentIssues) {
            TreeSet<String> elementFqNames = new TreeSet<String>();
            NamedElement affectedElement = nextIssue.getAffectedElement();
            assert (affectedElement instanceof AnalyzerCycleGroup) : "Unexpected affected element: " + affectedElement;
            AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)affectedElement;
            for (NamedElement nextCyclicElement : cycleGroup.getCyclicNamedElements()) {
                elementFqNames.add(this.b(nextCyclicElement));
            }
            a dto = new a(nextIssue.getId().getStandardName(), nextIssue.getAffectedElement().getPresentationName(true), elementFqNames);
            currentCycleMap.put(dto, nextIssue);
        }
        return currentCycleMap;
    }

    private void a(NamedElement parent, Map<a, ICycleGroupIssue> baselineCyclesMap, Map<a, CycleGroupIssue> currentCyclesMap) {
        assert (parent != null) : "Parameter 'parent' of method 'processExactMatches' must not be null";
        assert (baselineCyclesMap != null) : "Parameter 'baselineCyclesMap' of method 'processExactMatches' must not be null";
        assert (currentCyclesMap != null) : "Parameter 'currentCyclesMap' of method 'processExactMatches' must not be null";
        ArrayList<a> matchedBaselines = new ArrayList<a>();
        for (Map.Entry<a, ICycleGroupIssue> nextBaselineEntry : baselineCyclesMap.entrySet()) {
            CycleGroupIssueDiff.CycleChange cycleChange;
            IDiffElement.Change change;
            CycleGroupIssue current = currentCyclesMap.remove(nextBaselineEntry.getKey());
            if (current == null) continue;
            ICycleGroupIssue baseline2 = nextBaselineEntry.getValue();
            Pair<IDiffElement.Change, String> resolutionChange = this.a(baseline2, current);
            int baselineDepsToRemove = baseline2.getParserDependenciesToRemove();
            int currentDepsToRemove = ((AnalyzerCycleGroup)current.getAffectedElement()).getParserDependenciesToRemove();
            String changeDetails = (String)resolutionChange.getSecond();
            if (changeDetails.length() > 0) {
                changeDetails = String.valueOf(changeDetails) + ". ";
            }
            if (baselineDepsToRemove == currentDepsToRemove) {
                change = IDiffElement.Change.UNMODIFIED;
                cycleChange = CycleGroupIssueDiff.CycleChange.UNMODIFIED;
            } else if (baselineDepsToRemove > currentDepsToRemove) {
                change = IDiffElement.Change.IMPROVED;
                changeDetails = String.valueOf(changeDetails) + "Parser dependencies to remove: " + baselineDepsToRemove + " -> " + currentDepsToRemove;
                cycleChange = CycleGroupIssueDiff.CycleChange.PARSER_DEPENDENCIES_CHANGED;
            } else {
                change = IDiffElement.Change.WORSENED;
                changeDetails = String.valueOf(changeDetails) + "Parser dependencies to remove: " + baselineDepsToRemove + " -> " + currentDepsToRemove;
                cycleChange = CycleGroupIssueDiff.CycleChange.PARSER_DEPENDENCIES_CHANGED;
            }
            if (resolutionChange.getFirst() != IDiffElement.Change.UNMODIFIED) {
                change = (IDiffElement.Change)((Object)resolutionChange.getFirst());
            }
            CycleGroupIssueDiff diff = changeDetails.length() == 0 ? new CycleGroupIssueDiff(parent, baseline2, current, change, cycleChange) : new CycleGroupIssueDiff(parent, baseline2, current, change, changeDetails, cycleChange);
            parent.addChild(diff);
            this.a(diff, baseline2, current);
            matchedBaselines.add(nextBaselineEntry.getKey());
        }
        matchedBaselines.forEach(baseline -> {
            Object v2 = baselineCyclesMap.remove(baseline);
        });
    }

    private void a(CycleGroupIssueDiff parent, ICycleGroupIssue baseline, CycleGroupIssue current) {
        ArrayList<INamedElement> affectedBaselineElements = new ArrayList<INamedElement>(baseline.getAffectedNamedElements());
        affectedBaselineElements.sort(new Comparator<INamedElement>(){

            public int a(INamedElement o1, INamedElement o2) {
                return o1.getFqName().compareTo(o2.getFqName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((INamedElement)object, (INamedElement)object2);
            }
        });
        AnalyzerCycleGroup currentCycleGroup = (AnalyzerCycleGroup)current.getAffectedElement();
        ArrayList<NamedElement> affectedCurrentElements = new ArrayList<NamedElement>(currentCycleGroup.getCyclicNamedElements());
        affectedCurrentElements.sort(new Comparator<NamedElement>(){

            public int a(NamedElement o1, NamedElement o2) {
                return o1.getFullyQualifiedName().compareTo(o2.getFullyQualifiedName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((NamedElement)object, (NamedElement)object2);
            }
        });
        int i2 = 0;
        while (i2 < affectedCurrentElements.size()) {
            INamedElement baselineElement = (INamedElement)affectedBaselineElements.get(i2);
            NamedElement currentElement = (NamedElement)affectedCurrentElements.get(i2);
            CyclicElementDiff diff = new CyclicElementDiff((NamedElement)parent, baselineElement, currentElement, IDiffElement.Change.UNMODIFIED);
            parent.addChild(diff);
            ++i2;
        }
    }

    private void b(NamedElement parent, Map<a, ICycleGroupIssue> baselineCyclesMap, Map<a, CycleGroupIssue> currentCyclesMap) {
        assert (parent != null) : "Parameter 'parent' of method 'processWorsened' must not be null";
        assert (baselineCyclesMap != null) : "Parameter 'baselineCyclesMap' of method 'processWorsened' must not be null";
        assert (currentCyclesMap != null) : "Parameter 'currentCyclesMap' of method 'processWorsened' must not be null";
        ArrayList<a> matchedCurrent = new ArrayList<a>();
        for (Map.Entry<a, CycleGroupIssue> nextCurrentEntry : currentCyclesMap.entrySet()) {
            a current2 = nextCurrentEntry.getKey();
            CycleGroupIssue currentIssue = nextCurrentEntry.getValue();
            ArrayList<Pair<a, ICycleGroupIssue>> baselineCandidates = new ArrayList<Pair<a, ICycleGroupIssue>>();
            for (Map.Entry<a, ICycleGroupIssue> nextBaselineEntry : baselineCyclesMap.entrySet()) {
                a baseline = nextBaselineEntry.getKey();
                if (!current2.c().equals(baseline.c())) continue;
                HashSet<String> baselineCyclicElements = new HashSet<String>(baseline.b());
                if (current2.b().containsAll(baseline.b())) {
                    baselineCandidates.add(new Pair((Object)baseline, (Object)nextBaselineEntry.getValue()));
                    continue;
                }
                if (current2.b().size() <= baselineCyclicElements.size()) continue;
                baselineCyclicElements.retainAll(current2.b());
                double similarity = (double)baselineCyclicElements.size() * 1.0 / (double)baseline.b().size();
                if (Double.compare(similarity, 0.6) <= 0) continue;
                baselineCandidates.add((Pair<a, ICycleGroupIssue>)new Pair((Object)baseline, (Object)nextBaselineEntry.getValue()));
            }
            if (baselineCandidates.size() == 1) {
                IDiffElement.Change resultingChange;
                ICycleGroupIssue baselineIssue = (ICycleGroupIssue)((Pair)baselineCandidates.get(0)).getSecond();
                Pair<IDiffElement.Change, String> pair = this.a(baselineIssue, currentIssue);
                StringBuilder changeDetails = new StringBuilder();
                if (pair.getFirst() != IDiffElement.Change.UNMODIFIED) {
                    resultingChange = (IDiffElement.Change)((Object)pair.getFirst());
                    changeDetails.append((String)pair.getSecond()).append(". ");
                } else {
                    resultingChange = IDiffElement.Change.WORSENED;
                }
                changeDetails.append("Involved cyclic elements: ").append(((a)((Pair)baselineCandidates.get(0)).getFirst()).b().size());
                changeDetails.append(" -> ");
                changeDetails.append(current2.b().size());
                CycleGroupIssueDiff diff = new CycleGroupIssueDiff(parent, baselineIssue, currentIssue, resultingChange, changeDetails.toString(), CycleGroupIssueDiff.CycleChange.CYCLIC_ELEMENTS_CHANGED);
                parent.addChild(diff);
                this.a(diff, baselineCandidates, currentIssue);
                matchedCurrent.add(current2);
            } else if (baselineCandidates.size() > 1) {
                StringBuilder currentChangeDetails = new StringBuilder("New cycle group integrating baseline groups: ");
                for (Pair pair : baselineCandidates) {
                    currentChangeDetails.append(((a)pair.getFirst()).a()).append(", ");
                    ICycleGroupIssue baseline = (ICycleGroupIssue)pair.getSecond();
                    Pair<IDiffElement.Change, String> resolutionChange = this.a(baseline, currentIssue);
                    StringBuilder changeDetails = new StringBuilder();
                    if (resolutionChange.getFirst() != IDiffElement.Change.UNMODIFIED) {
                        changeDetails.append((String)resolutionChange.getSecond()).append(" ");
                    }
                    changeDetails.append("Integrated into: " + current2.a());
                    CycleGroupIssueDiff baselineRemovedDiff = new CycleGroupIssueDiff(parent, baseline, null, IDiffElement.Change.REMOVED, changeDetails.toString(), CycleGroupIssueDiff.CycleChange.INTEGRATED);
                    parent.addChild(baselineRemovedDiff);
                    this.a(baselineRemovedDiff, baseline);
                }
                CycleGroupIssueDiff cycleGroupIssueDiff = new CycleGroupIssueDiff(parent, null, nextCurrentEntry.getValue(), IDiffElement.Change.WORSENED, currentChangeDetails.substring(0, currentChangeDetails.length() - 2), CycleGroupIssueDiff.CycleChange.INTEGRATED);
                parent.addChild(cycleGroupIssueDiff);
                this.a(cycleGroupIssueDiff, baselineCandidates, currentIssue);
                matchedCurrent.add(current2);
            }
            baselineCandidates.forEach(c2 -> {
                Object v2 = baselineCyclesMap.remove(c2.getFirst());
            });
        }
        matchedCurrent.forEach(current -> {
            Object v2 = currentCyclesMap.remove(current);
        });
    }

    private void a(CycleGroupIssueDiff parent, ICycleGroupIssue baseline) {
        assert (parent != null) : "Parameter 'parent' of method 'addRemovedCyclicElements' must not be null";
        assert (baseline != null) : "Parameter 'baseline' of method 'addRemovedCyclicElements' must not be null";
        for (INamedElement next : baseline.getAffectedNamedElements()) {
            CyclicElementDiff diff = new CyclicElementDiff((NamedElement)parent, next, null, IDiffElement.Change.REMOVED);
            parent.addChild(diff);
        }
    }

    private void a(CycleGroupIssueDiff parent, CycleGroupIssue current) {
        assert (parent != null) : "Parameter 'parent' of method 'addAddedCyclicElements' must not be null";
        assert (current != null) : "Parameter 'current' of method 'addAddedCyclicElements' must not be null";
        AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)current.getAffectedElement();
        for (NamedElement next : cycleGroup.getCyclicNamedElements()) {
            CyclicElementDiff diff = new CyclicElementDiff((NamedElement)parent, null, next, IDiffElement.Change.ADDED);
            parent.addChild(diff);
        }
    }

    private void a(CycleGroupIssueDiff parent, List<Pair<a, ICycleGroupIssue>> baselineCandidates, CycleGroupIssue currentIssue) {
        assert (parent != null) : "Parameter 'parent' of method 'addCyclicElementsForWorsenedCycle' must not be null";
        assert (baselineCandidates != null && baselineCandidates.size() > 0) : "Parameter 'baselineCandidates' of method 'addCyclicElementsForWorsenedCycle' must not be empty";
        assert (currentIssue != null) : "Parameter 'currentIsseu' of method 'addCyclicElementsForWorsenedCycle' must not be null";
        TreeMap<String, Pair> baselineFqNameToElementMap = new TreeMap<String, Pair>();
        for (Pair<a, ICycleGroupIssue> next : baselineCandidates) {
            for (INamedElement nextCyclic : ((ICycleGroupIssue)next.getSecond()).getAffectedNamedElements()) {
                baselineFqNameToElementMap.put(nextCyclic.getFqName(), new Pair((Object)nextCyclic, (Object)((ICycleGroupIssue)next.getSecond())));
            }
        }
        AnalyzerCycleGroup currentGroup = (AnalyzerCycleGroup)currentIssue.getAffectedElement();
        for (NamedElement namedElement : currentGroup.getCyclicNamedElements()) {
            CyclicElementDiff diff;
            Pair baselinePair = (Pair)baselineFqNameToElementMap.remove(namedElement.getFullyQualifiedName());
            if (baselinePair != null) {
                INamedElement baselineCyclic = (INamedElement)baselinePair.getFirst();
                diff = baselineCandidates.size() > 1 ? new CyclicElementDiff((NamedElement)parent, baselineCyclic, namedElement, IDiffElement.Change.UNMODIFIED, "Baseline cycle group: " + ((ICycleGroupIssue)baselinePair.getSecond()).getPresentationName()) : new CyclicElementDiff((NamedElement)parent, baselineCyclic, namedElement, IDiffElement.Change.UNMODIFIED);
            } else {
                diff = new CyclicElementDiff((NamedElement)parent, null, namedElement, IDiffElement.Change.ADDED);
            }
            parent.addChild(diff);
        }
        for (Map.Entry entry : baselineFqNameToElementMap.entrySet()) {
            CyclicElementDiff diff = new CyclicElementDiff((NamedElement)parent, (INamedElement)((Pair)entry.getValue()).getFirst(), null, IDiffElement.Change.REMOVED);
            parent.addChild(diff);
        }
    }

    private void a(CycleGroupIssueDiff parent, ICycleGroupIssue baselineIssue, List<Pair<a, CycleGroupIssue>> currentCandidates) {
        assert (parent != null) : "Parameter 'parent' of method 'addCyclicElementsForImprovedCycle' must not be null";
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'addCyclicElementsForImprovedCycle' must not be null";
        assert (currentCandidates != null && !currentCandidates.isEmpty()) : "Parameter 'currentCandidates' of method 'addCyclicElementsForImprovedCycle' must not be empty";
        HashMap<String, Pair> currentEntriesFqNameToElement = new HashMap<String, Pair>();
        for (Pair<a, CycleGroupIssue> nextCurrentPair : currentCandidates) {
            AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)((CycleGroupIssue)nextCurrentPair.getSecond()).getAffectedElement();
            for (NamedElement nextCyclic : cycleGroup.getCyclicNamedElements()) {
                currentEntriesFqNameToElement.put(nextCyclic.getFullyQualifiedName(), new Pair((Object)nextCyclic, (Object)((CycleGroupIssue)nextCurrentPair.getSecond())));
            }
        }
        for (INamedElement nextBaselineCyclic : baselineIssue.getAffectedNamedElements()) {
            CyclicElementDiff diff;
            Pair currentPair = (Pair)currentEntriesFqNameToElement.remove(nextBaselineCyclic.getFqName());
            if (currentPair == null) {
                diff = new CyclicElementDiff((NamedElement)parent, nextBaselineCyclic, null, IDiffElement.Change.REMOVED);
            } else {
                NamedElement currentCyclic = (NamedElement)currentPair.getFirst();
                diff = currentCandidates.size() > 1 ? new CyclicElementDiff((NamedElement)parent, nextBaselineCyclic, currentCyclic, IDiffElement.Change.ADDED, "Baseline cycle group: " + baselineIssue.getPresentationName()) : new CyclicElementDiff((NamedElement)parent, nextBaselineCyclic, currentCyclic, IDiffElement.Change.UNMODIFIED);
            }
            parent.addChild(diff);
        }
    }

    private void c(NamedElement parent, Map<a, ICycleGroupIssue> baselineCyclesMap, Map<a, CycleGroupIssue> currentCyclesMap) {
        assert (parent != null) : "Parameter 'parent' of method 'processImproved' must not be null";
        assert (baselineCyclesMap != null) : "Parameter 'baselineCyclesMap' of method 'processImproved' must not be null";
        assert (currentCyclesMap != null) : "Parameter 'currentCyclesMap' of method 'processImproved' must not be null";
        ArrayList<a> matchedBaseline = new ArrayList<a>();
        for (Map.Entry<a, ICycleGroupIssue> nextBaselineEntry : baselineCyclesMap.entrySet()) {
            a baseline2 = nextBaselineEntry.getKey();
            ArrayList<Pair<a, CycleGroupIssue>> currentCandidates = new ArrayList<Pair<a, CycleGroupIssue>>();
            for (Map.Entry<a, CycleGroupIssue> nextCurrentEntry : currentCyclesMap.entrySet()) {
                a a2 = nextCurrentEntry.getKey();
                if (!baseline2.c().equals(a2.c())) continue;
                HashSet<String> currentCyclicElements = new HashSet<String>(a2.b());
                if (baseline2.b().containsAll(currentCyclicElements)) {
                    currentCandidates.add(new Pair((Object)a2, (Object)nextCurrentEntry.getValue()));
                    continue;
                }
                if (baseline2.b().size() <= currentCyclicElements.size()) continue;
                currentCyclicElements.retainAll(baseline2.b());
                double similarity = (double)currentCyclicElements.size() * 1.0 / (double)a2.b().size();
                if (Double.compare(similarity, 0.6) <= 0) continue;
                currentCandidates.add((Pair<a, CycleGroupIssue>)new Pair((Object)a2, (Object)nextCurrentEntry.getValue()));
            }
            ICycleGroupIssue baselineIssue = nextBaselineEntry.getValue();
            if (currentCandidates.size() == 1) {
                IDiffElement.Change resultingChange;
                CycleGroupIssue currentIssue = (CycleGroupIssue)((Pair)currentCandidates.get(0)).getSecond();
                Pair<IDiffElement.Change, String> pair = this.a(baselineIssue, currentIssue);
                StringBuilder changeDetails = new StringBuilder();
                if (pair.getFirst() != IDiffElement.Change.UNMODIFIED) {
                    resultingChange = (IDiffElement.Change)((Object)pair.getFirst());
                    changeDetails.append((String)pair.getSecond()).append(". ");
                } else {
                    resultingChange = IDiffElement.Change.IMPROVED;
                }
                changeDetails.append("Involved cyclic elements: ").append(baseline2.b().size());
                changeDetails.append(" -> ");
                changeDetails.append(((a)((Pair)currentCandidates.get(0)).getFirst()).b().size());
                CycleGroupIssueDiff diff = new CycleGroupIssueDiff(parent, baselineIssue, currentIssue, resultingChange, changeDetails.toString(), CycleGroupIssueDiff.CycleChange.CYCLIC_ELEMENTS_CHANGED);
                parent.addChild(diff);
                this.a(diff, baselineIssue, currentCandidates);
                matchedBaseline.add(baseline2);
            } else if (currentCandidates.size() > 1) {
                StringBuilder baselineChangeDetails = new StringBuilder("Split into: ");
                for (Pair pair : currentCandidates) {
                    baselineChangeDetails.append(((a)pair.getFirst()).a()).append(", ");
                    CycleGroupIssue currentIssue = (CycleGroupIssue)pair.getSecond();
                    Pair<IDiffElement.Change, String> resolutionChange = this.a(baselineIssue, currentIssue);
                    StringBuilder changeDescription = new StringBuilder();
                    if (resolutionChange.getFirst() != IDiffElement.Change.UNMODIFIED) {
                        changeDescription.append((String)resolutionChange.getSecond()).append(". ");
                    }
                    changeDescription.append("New cycle group split from: ").append(baseline2.a()).append(" [Baseline]");
                    CycleGroupIssueDiff currentAddedDiff = new CycleGroupIssueDiff(parent, null, currentIssue, IDiffElement.Change.IMPROVED, changeDescription.toString(), CycleGroupIssueDiff.CycleChange.SPLIT);
                    parent.addChild(currentAddedDiff);
                    this.a(currentAddedDiff, (CycleGroupIssue)pair.getSecond());
                }
                CycleGroupIssueDiff cycleGroupIssueDiff = new CycleGroupIssueDiff(parent, baselineIssue, null, IDiffElement.Change.REMOVED, baselineChangeDetails.substring(0, baselineChangeDetails.length() - 2), CycleGroupIssueDiff.CycleChange.SPLIT);
                parent.addChild(cycleGroupIssueDiff);
                this.a(cycleGroupIssueDiff, baselineIssue, currentCandidates);
                matchedBaseline.add(baseline2);
            }
            currentCandidates.forEach(c2 -> {
                Object v2 = currentCyclesMap.remove(c2.getFirst());
            });
        }
        matchedBaseline.forEach(baseline -> {
            Object v2 = baselineCyclesMap.remove(baseline);
        });
    }

    private void d(NamedElement parent, Map<a, ICycleGroupIssue> baselineCyclesMap, Map<a, CycleGroupIssue> currentCyclesMap) {
        assert (parent != null) : "Parameter 'parent' of method 'processImproved' must not be null";
        assert (baselineCyclesMap != null) : "Parameter 'baselineCyclesMap' of method 'processImproved' must not be null";
        assert (currentCyclesMap != null) : "Parameter 'currentCyclesMap' of method 'processImproved' must not be null";
        ArrayList<a> matchedBaseline = new ArrayList<a>();
        for (Map.Entry<a, ICycleGroupIssue> nextBaselineEntry : baselineCyclesMap.entrySet()) {
            a baseline2 = nextBaselineEntry.getKey();
            Pair currentBestCandidate = null;
            for (Map.Entry<a, CycleGroupIssue> nextCurrentEntry : currentCyclesMap.entrySet()) {
                double sizeDifference;
                a current = nextCurrentEntry.getKey();
                if (!baseline2.c().equals(current.c()) || Double.compare(1.0 - (sizeDifference = (double)Math.abs(baseline2.b().size() - current.b().size()) * 1.0 / (double)baseline2.b().size()), 0.6) < 0) continue;
                HashSet<String> currentCyclicElements = new HashSet<String>(current.b());
                currentCyclicElements.retainAll(baseline2.b());
                double similarity = (double)currentCyclicElements.size() * 1.0 / (double)baseline2.b().size();
                if (Double.compare(similarity, 0.6) < 0 || currentBestCandidate != null && Double.compare((Double)currentBestCandidate.getFirst(), similarity) >= 0) continue;
                currentBestCandidate = new Pair((Object)similarity, (Object)new Pair((Object)current, (Object)nextCurrentEntry.getValue()));
            }
            if (currentBestCandidate == null) continue;
            a current = (a)((Pair)currentBestCandidate.getSecond()).getFirst();
            TreeSet<String> baselineChangedFqNames = new TreeSet<String>(baseline2.b());
            baselineChangedFqNames.removeAll(current.b());
            TreeSet<String> currentChangedFqNames = new TreeSet<String>(current.b());
            currentChangedFqNames.removeAll(baseline2.b());
            ICycleGroupIssue baselineIssue = nextBaselineEntry.getValue();
            CycleGroupIssue currentIssue = (CycleGroupIssue)((Pair)currentBestCandidate.getSecond()).getSecond();
            StringBuilder changeDetails = new StringBuilder();
            IDiffElement.Change resultingChange = null;
            Pair<IDiffElement.Change, String> resolutionChange = this.a(baselineIssue, currentIssue);
            int cycleGroupSizeComparison = Integer.compare(baseline2.b().size(), current.b().size());
            CycleGroupIssueDiff.CycleChange cycleChange = CycleGroupIssueDiff.CycleChange.CYCLIC_ELEMENTS_CHANGED;
            if (resolutionChange.getFirst() != IDiffElement.Change.UNMODIFIED) {
                resultingChange = (IDiffElement.Change)((Object)resolutionChange.getFirst());
                changeDetails.append((String)resolutionChange.getSecond()).append(". ");
            } else {
                resultingChange = cycleGroupSizeComparison == 0 ? IDiffElement.Change.MODIFIED : (cycleGroupSizeComparison < 0 ? IDiffElement.Change.WORSENED : IDiffElement.Change.IMPROVED);
            }
            if (cycleGroupSizeComparison == 0) {
                changeDetails.append(baselineChangedFqNames.size()).append(" of ").append(baseline2.b().size()).append(" cyclic elements ");
                if (baselineChangedFqNames.size() == 1) {
                    changeDetails.append("has changed");
                } else {
                    changeDetails.append("have changed");
                }
                cycleChange = CycleGroupIssueDiff.CycleChange.CYCLIC_ELEMENTS_MODIFIED;
            } else {
                changeDetails.append("Involved cyclic elements: ").append(baseline2.b().size());
                changeDetails.append(" -> ");
                changeDetails.append(current.b().size());
                cycleChange = CycleGroupIssueDiff.CycleChange.CYCLIC_ELEMENTS_MODIFIED;
            }
            changeDetails.append(" (").append((int)((Double)currentBestCandidate.getFirst() * 100.0)).append("% similarity). ");
            changeDetails.append(baseline2.a());
            changeDetails.append(" -> ");
            changeDetails.append(current.a());
            CycleGroupIssueDiff modifiedDiff = new CycleGroupIssueDiff(parent, baselineIssue, currentIssue, resultingChange, changeDetails.toString(), cycleChange);
            parent.addChild(modifiedDiff);
            this.b(modifiedDiff, baselineIssue, currentIssue);
            matchedBaseline.add(baseline2);
            currentCyclesMap.remove(((Pair)currentBestCandidate.getSecond()).getFirst());
        }
        matchedBaseline.forEach(baseline -> {
            Object v2 = baselineCyclesMap.remove(baseline);
        });
    }

    private void b(CycleGroupIssueDiff parent, ICycleGroupIssue baselineIssue, CycleGroupIssue currentIssue) {
        assert (parent != null) : "Parameter 'parent' of method 'addCyclicElementsForModifiedCycle' must not be null";
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'addCyclicElementsForModifiedCycle' must not be null";
        assert (currentIssue != null) : "Parameter 'currentIssue' of method 'addCyclicElementsForModifiedCycle' must not be null";
        HashMap<String, INamedElement> baselineFqNameToNamedElementMap = new HashMap<String, INamedElement>();
        for (INamedElement next : baselineIssue.getAffectedNamedElements()) {
            baselineFqNameToNamedElementMap.put(next.getFqName(), next);
        }
        AnalyzerCycleGroup currentCycle = (AnalyzerCycleGroup)currentIssue.getAffectedElement();
        HashMap<String, NamedElement> currentFqNameToNamedElementMap = new HashMap<String, NamedElement>();
        for (NamedElement next : currentCycle.getCyclicNamedElements()) {
            currentFqNameToNamedElementMap.put(next.getFullyQualifiedName(), next);
        }
        TreeMap<String, CyclicElementDiff> cyclicElements = new TreeMap<String, CyclicElementDiff>();
        for (Map.Entry nextBaselineEntry : baselineFqNameToNamedElementMap.entrySet()) {
            String fqName = (String)nextBaselineEntry.getKey();
            NamedElement currentCyclic = (NamedElement)currentFqNameToNamedElementMap.remove(fqName);
            CyclicElementDiff diff = currentCyclic == null ? new CyclicElementDiff((NamedElement)parent, (INamedElement)nextBaselineEntry.getValue(), null, IDiffElement.Change.REMOVED) : new CyclicElementDiff((NamedElement)parent, (INamedElement)nextBaselineEntry.getValue(), currentCyclic, IDiffElement.Change.UNMODIFIED);
            cyclicElements.put(fqName, diff);
        }
        for (Map.Entry nextCurrentEntry : currentFqNameToNamedElementMap.entrySet()) {
            CyclicElementDiff diff = new CyclicElementDiff((NamedElement)parent, null, (NamedElement)nextCurrentEntry.getValue(), IDiffElement.Change.ADDED);
            cyclicElements.put((String)nextCurrentEntry.getKey(), diff);
        }
        for (CyclicElementDiff diff : cyclicElements.values()) {
            parent.addChild(diff);
        }
    }

    private void a(NamedElement parent, Map<a, ICycleGroupIssue> baselineCyclesMap) {
        for (ICycleGroupIssue nextRemoved : baselineCyclesMap.values()) {
            CycleGroupIssueDiff diff = new CycleGroupIssueDiff(parent, nextRemoved, null, IDiffElement.Change.REMOVED, nextRemoved.getDescription(), CycleGroupIssueDiff.CycleChange.REMOVED);
            parent.addChild(diff);
            ArrayList<INamedElement> affectedNamedElements = new ArrayList<INamedElement>(nextRemoved.getAffectedNamedElements());
            affectedNamedElements.sort(new Comparator<INamedElement>(){

                public int a(INamedElement o1, INamedElement o2) {
                    return o1.getFqName().compareTo(o2.getFqName());
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((INamedElement)object, (INamedElement)object2);
                }
            });
            for (INamedElement removedCyclic : affectedNamedElements) {
                CyclicElementDiff cyclicDiff = new CyclicElementDiff((NamedElement)diff, removedCyclic, null, IDiffElement.Change.REMOVED);
                diff.addChild(cyclicDiff);
            }
        }
        baselineCyclesMap.clear();
    }

    private void b(NamedElement parent, Map<a, CycleGroupIssue> currentCyclesMap) {
        for (CycleGroupIssue nextAdded : currentCyclesMap.values()) {
            CycleGroupIssueDiff diff = new CycleGroupIssueDiff(parent, null, nextAdded, IDiffElement.Change.ADDED, nextAdded.getAffectedElement().getDescription(), CycleGroupIssueDiff.CycleChange.ADDED);
            parent.addChild(diff);
            AnalyzerCycleGroup cycle = (AnalyzerCycleGroup)nextAdded.getAffectedElement();
            ArrayList<NamedElement> cyclicNamedElements = new ArrayList<NamedElement>(cycle.getCyclicNamedElements());
            cyclicNamedElements.sort(new Comparator<NamedElement>(){

                public int a(NamedElement o1, NamedElement o2) {
                    return o1.getFullyQualifiedName().compareTo(o2.getFullyQualifiedName());
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((NamedElement)object, (NamedElement)object2);
                }
            });
            for (NamedElement addedCyclic : cyclicNamedElements) {
                CyclicElementDiff cyclicDiff = new CyclicElementDiff((NamedElement)diff, null, addedCyclic, IDiffElement.Change.ADDED);
                diff.addChild(cyclicDiff);
            }
        }
        currentCyclesMap.clear();
    }

    private static final class a {
        private final String b;
        private final Set<String> c;
        private final String d;

        public a(String type, String cycleName, Set<String> cyclicElementFqNames) {
            assert (type != null && type.length() > 0) : "Parameter 'type' of method 'CycleGroupDto' must not be empty";
            assert (cycleName != null && cycleName.length() > 0) : "Parameter 'cycleName' of method 'CycleGroupDto' must not be empty";
            assert (cyclicElementFqNames != null && !cyclicElementFqNames.isEmpty()) : "Parameter 'cyclicElementFqNames' of method 'CycleGroupDto' must not be empty";
            this.d = type;
            this.b = cycleName;
            this.c = Collections.unmodifiableSet(cyclicElementFqNames);
        }

        public String a() {
            return this.b;
        }

        public Set<String> b() {
            return this.c;
        }

        public String c() {
            return this.d;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.d == null ? 0 : this.d.hashCode());
            result = 31 * result + (this.c == null ? 0 : this.c.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            a other = (a)obj;
            if (this.d == null ? other.d != null : !this.d.equals(other.d)) {
                return false;
            }
            return !(this.c == null ? other.c != null : !this.c.equals(other.c));
        }

        public String toString() {
            return this.b;
        }
    }
}

