/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.model.element.IssueType;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.pattern.DependencyIssuePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementFullyQualifiedNamePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementIssuePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.ParserDependencyEndpointPattern;
import com.hello2morrow.sonargraph.core.model.resolution.Matching;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionDefinitionDiff;
import com.hello2morrow.sonargraph.core.persistence.report.ReportXmlWriter;
import com.hello2morrow.sonargraph.integration.access.controller.g;
import com.hello2morrow.sonargraph.integration.access.model.DependencyPatternType;
import com.hello2morrow.sonargraph.integration.access.model.ElementPatternType;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyPattern;
import com.hello2morrow.sonargraph.integration.access.model.IElementPattern;
import com.hello2morrow.sonargraph.integration.access.model.IMatching;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;

abstract class d<B extends IResolution, C extends Resolution>
extends com.hello2morrow.sonargraph.core.controller.system.diff.a {
    private final ResolutionType c;
    private final Class<B> d;
    private final Class<C> e;

    public d(ISoftwareSystem baselineSystem, g baselineSystemInfoProcessor, SoftwareSystem currentSystem, ResolutionType baselineResolutionType, Class<B> baselineResolutionClass, Class<C> currentResolutionClass) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem);
        assert (baselineResolutionType != null) : "Parameter 'baselineResolutionType' of method 'AbstractResolutionDiffProcessor' must not be null";
        assert (baselineResolutionClass != null) : "Parameter 'baselineResolutionClass' of method 'AbstractResolutionDiffProcessor' must not be null";
        assert (currentResolutionClass != null) : "Parameter 'currentResolutionClass' of method 'AbstractResolutionDiffProcessor' must not be null";
        this.c = baselineResolutionType;
        this.d = baselineResolutionClass;
        this.e = currentResolutionClass;
    }

    @Override
    public void a(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'process' must not be null";
        Map<d, B> baselineResolutionMap = this.d();
        Map<d, C> currentResolutionMap = this.e();
        for (Map.Entry<d, B> nextBaselineEntry : baselineResolutionMap.entrySet()) {
            d baselineMatchingDto = nextBaselineEntry.getKey();
            IResolution baseline = (IResolution)nextBaselineEntry.getValue();
            Resolution current = (Resolution)currentResolutionMap.remove(baselineMatchingDto);
            if (current != null) {
                ResolutionDefinitionDiff<IResolution, Resolution> diff;
                StringJoiner changeDescriptionParts = new StringJoiner(". ", "", ".");
                if (baseline.getMatchingElementsCount() != current.getMatchingElementsCount()) {
                    changeDescriptionParts.add("Matched: " + baseline.getMatchingElementsCount() + " -> " + current.getMatchingElementsCount());
                }
                if (!baseline.getDescription().equals(current.getDescription())) {
                    changeDescriptionParts.add("Description: " + baseline.getDescription() + " -> " + current.getDescription());
                }
                this.a(baseline, current, changeDescriptionParts);
                if (changeDescriptionParts.length() == 1) {
                    String description = this.a(IDiffElement.Change.UNMODIFIED, baseline, current);
                    diff = description != null ? this.a(parent, baseline, current, IDiffElement.Change.UNMODIFIED, description) : this.a(parent, baseline, current, IDiffElement.Change.UNMODIFIED);
                } else {
                    String changeDescription = changeDescriptionParts.toString();
                    diff = this.a(parent, baseline, current, IDiffElement.Change.MODIFIED, changeDescription);
                }
                assert (diff != null) : "No diff created by " + this.getClass().getSimpleName();
                parent.addChild(diff);
                continue;
            }
            String description = this.a(IDiffElement.Change.REMOVED, baseline, current);
            ResolutionDefinitionDiff<IResolution, Resolution> removed = description != null ? this.a(parent, baseline, current, IDiffElement.Change.REMOVED, description) : this.a(parent, baseline, current, IDiffElement.Change.REMOVED);
            parent.addChild(removed);
        }
        for (Resolution nextCurrentResolution : currentResolutionMap.values()) {
            String description = this.a(IDiffElement.Change.ADDED, null, nextCurrentResolution);
            ResolutionDefinitionDiff<Object, Resolution> added = description != null ? this.a(parent, null, nextCurrentResolution, IDiffElement.Change.ADDED, description) : this.a(parent, null, nextCurrentResolution, IDiffElement.Change.ADDED);
            parent.addChild(added);
        }
    }

    protected String a(IDiffElement.Change change, B baseline, C current) {
        assert (change != null) : "Parameter 'change' of method 'createDescriptionForSingleMatchedElement' must not be null";
        return null;
    }

    protected void a(B baseline, C current, StringJoiner changeDescriptionParts) {
        assert (baseline != null) : "Parameter 'baseline' of method 'addToChangeDescription' must not be null";
        assert (current != null) : "Parameter 'current' of method 'addToChangeDescription' must not be null";
        assert (changeDescriptionParts != null) : "Parameter 'changeDescriptionParts' of method 'addToChangeDescription' must not be null";
    }

    protected abstract ResolutionDefinitionDiff<B, C> a(NamedElement var1, B var2, C var3, IDiffElement.Change var4, String var5);

    protected abstract ResolutionDefinitionDiff<B, C> a(NamedElement var1, B var2, C var3, IDiffElement.Change var4);

    protected final Map<d, B> d() {
        List resolutions = this.b().a(r2 -> r2.getType() == this.c, this.d);
        LinkedHashMap<d, IResolution> resolutionMap = new LinkedHashMap<d, IResolution>();
        for (IResolution next : resolutions) {
            b patternDto;
            ArrayList<b> elementPatterns;
            c matchingDto = null;
            IMatching matching = next.getMatching();
            if (matching != null) {
                elementPatterns = new ArrayList<b>();
                for (IElementPattern nextPattern : matching.getPatterns()) {
                    patternDto = new b(nextPattern.getType().getStandardName(), nextPattern.getPattern());
                    elementPatterns.add(patternDto);
                }
                matchingDto = new c(matching.getInfo(), elementPatterns);
            }
            elementPatterns = new ArrayList();
            for (IElementPattern nextPattern : next.getElementPatterns()) {
                patternDto = new b(nextPattern.getType().getStandardName(), nextPattern.getPattern());
                elementPatterns.add(patternDto);
            }
            ArrayList<a> dependencyPatterns = new ArrayList<a>();
            for (IDependencyPattern nextPattern : next.getDependencyPatterns()) {
                a patternDto2 = new a(nextPattern.getType().getStandardName(), nextPattern.getFromPattern(), nextPattern.getToPattern());
                dependencyPatterns.add(patternDto2);
            }
            resolutionMap.put(new d(next.getCreationDate().getTime(), matchingDto, elementPatterns, dependencyPatterns, next.getDescriptor()), next);
        }
        return resolutionMap;
    }

    protected final Map<d, C> e() {
        List<C> unfilteredResolutions = this.c().getCurrentModel().getResolutions(this.e);
        List resolutions = unfilteredResolutions.stream().filter(r2 -> r2.getClass().equals(this.e)).collect(Collectors.toList());
        LinkedHashMap<d, Resolution> resolutionMap = new LinkedHashMap<d, Resolution>();
        boolean isResolutionMigrationNeeded = com.hello2morrow.sonargraph.integration.access.foundation.c.a((String)this.a().getVersion());
        for (Resolution next : resolutions) {
            ArrayList<b> elementPatterns;
            c matchingDto = null;
            Matching matching = next.getUniqueChild(Matching.class);
            if (matching != null) {
                elementPatterns = new ArrayList<b>();
                for (String string : matching.getElementFqNames()) {
                    b patternDto = new b(ElementPatternType.FULLY_QUALIFIED_NAME.getStandardName(), string);
                    elementPatterns.add(patternDto);
                }
                matchingDto = new c(matching.getInformation(), elementPatterns);
            }
            elementPatterns = new ArrayList();
            for (NamedElementIssuePattern namedElementIssuePattern : next.getChildren(NamedElementIssuePattern.class)) {
                ElementPatternType type = namedElementIssuePattern instanceof NamedElementFullyQualifiedNamePattern ? ElementPatternType.FULLY_QUALIFIED_NAME : ElementPatternType.WILDCARD;
                b patternDto = new b(type.getStandardName(), namedElementIssuePattern.getPattern());
                elementPatterns.add(patternDto);
            }
            ArrayList<a> arrayList = new ArrayList<a>();
            for (DependencyIssuePattern nextPattern : next.getChildren(DependencyIssuePattern.class)) {
                DependencyPatternType type = nextPattern instanceof ParserDependencyEndpointPattern ? DependencyPatternType.PARSER_DEPENDENCY_ENDPOINT : DependencyPatternType.WILDCARD;
                a patternDto = new a(type.getStandardName(), nextPattern.getFromPattern(), nextPattern.getToPattern());
                arrayList.add(patternDto);
            }
            IssueType type = next.getUniqueChild(IssueType.class);
            assert (type != null) : "Missing issue type for resolution " + next;
            String descriptor = isResolutionMigrationNeeded ? ReportXmlWriter.createDeprecatedIssueDescriptor(type) : ReportXmlWriter.createIssueDescriptor(type);
            resolutionMap.put(new d(next.getDate().getTime(), matchingDto, elementPatterns, arrayList, descriptor), next);
        }
        return resolutionMap;
    }

    private static final class a {
        private final String b;
        private final String c;
        private final String d;

        public a(String type, String fromPattern, String toPattern) {
            assert (type != null && type.length() > 0) : "Parameter 'type' of method 'DependencyPatternDto' must not be empty";
            assert (fromPattern != null && fromPattern.length() > 0) : "Parameter 'fromPattern' of method 'DependencyPatternDto' must not be empty";
            assert (toPattern != null && toPattern.length() > 0) : "Parameter 'toPattern' of method 'DependencyPatternDto' must not be empty";
            this.b = type;
            this.c = fromPattern;
            this.d = toPattern;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DependencyPatternDto [m_type=");
            builder.append(this.b);
            builder.append(", m_fromPattern=");
            builder.append(this.c);
            builder.append(", m_toPattern=");
            builder.append(this.d);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.c == null ? 0 : this.c.hashCode());
            result = 31 * result + (this.d == null ? 0 : this.d.hashCode());
            result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            a other = (a)obj;
            if (this.c == null ? other.c != null : !this.c.equals(other.c)) {
                return false;
            }
            if (this.d == null ? other.d != null : !this.d.equals(other.d)) {
                return false;
            }
            return !(this.b == null ? other.b != null : !this.b.equals(other.b));
        }
    }

    private static final class b {
        private final String b;
        private final String c;

        public b(String type, String pattern) {
            assert (type != null && type.length() > 0) : "Parameter 'type' of method 'ElementPattern' must not be empty";
            assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'ElementPattern' must not be empty";
            this.c = type;
            this.b = pattern;
        }

        public String a() {
            return this.b;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ElementPatternDto [m_type=");
            builder.append(this.c);
            builder.append(", m_pattern=");
            builder.append(this.b);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
            result = 31 * result + (this.c == null ? 0 : this.c.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            b other = (b)obj;
            if (this.b == null ? other.b != null : !this.b.equals(other.b)) {
                return false;
            }
            return !(this.c == null ? other.c != null : !this.c.equals(other.c));
        }
    }

    private static final class c {
        private final List<b> b;
        private final String c;

        public c(String info, List<b> elementPatterns) {
            assert (info != null) : "Parameter 'info' of method 'MatchinInfoDto' must not be null";
            assert (elementPatterns != null && !elementPatterns.isEmpty()) : "Parameter 'elementPatterns' of method 'MatchinInfoDto' must not be empty";
            this.c = info;
            LinkedHashMap<String, b> patterns = new LinkedHashMap<String, b>();
            for (b next : elementPatterns) {
                if (patterns.containsKey(next.a())) continue;
                patterns.put(next.a(), next);
            }
            this.b = new ArrayList(patterns.values());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MatchingDto [m_info=");
            builder.append(this.c);
            builder.append(", m_elementPatterns=");
            builder.append(this.b);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
            result = 31 * result + (this.c == null ? 0 : this.c.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            c other = (c)obj;
            if (this.b == null ? other.b != null : !this.b.equals(other.b)) {
                return false;
            }
            return !(this.c == null ? other.c != null : !this.c.equals(other.c));
        }
    }

    private static final class d {
        private final long a;
        private final String b;
        private final c c;
        private final List<b> d;
        private final List<a> e;

        public d(long timestamp, c matching, List<b> elementPatterns, List<a> dependencyPatterns, String descriptor) {
            this.a = timestamp;
            this.c = matching;
            this.d = elementPatterns;
            this.e = dependencyPatterns;
            this.b = descriptor;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MatchingInfoDto [m_descriptor=");
            builder.append(this.b);
            builder.append(", m_matching=");
            builder.append(this.c);
            builder.append(", m_timestamp=");
            builder.append(this.a);
            builder.append(", m_elementPatterns=");
            builder.append(this.d);
            builder.append(", m_dependencyPatterns=");
            builder.append(this.e);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.a ^ this.a >>> 32);
            result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
            result = 31 * result + (this.e == null ? 0 : this.e.hashCode());
            result = 31 * result + (this.d == null ? 0 : this.d.hashCode());
            result = 31 * result + (this.c == null ? 0 : this.c.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            d other = (d)obj;
            if (this.a != other.a) {
                return false;
            }
            if (this.b == null ? other.b != null : !this.b.equals(other.b)) {
                return false;
            }
            if (this.e == null ? other.e != null : !this.e.equals(other.e)) {
                return false;
            }
            if (this.d == null ? other.d != null : !this.d.equals(other.d)) {
                return false;
            }
            return !(this.c == null ? other.c != null : !this.c.equals(other.c));
        }
    }
}

