/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.e;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.DiffUtility;
import com.hello2morrow.sonargraph.integration.access.controller.g;
import com.hello2morrow.sonargraph.integration.access.model.IRefactoring;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import java.util.StringJoiner;

public abstract class c<B extends IRefactoring, C extends RefactoringDefinition>
extends e<B, C> {
    public c(ISoftwareSystem baselineSystem, g baselineSystemInfoProcessor, SoftwareSystem currentSystem, ResolutionType resolutionType, Class<B> baselineResolutionClass, Class<C> currentResolutionClass) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem, resolutionType, baselineResolutionClass, currentResolutionClass);
    }

    @Override
    protected void a(B baseline, C current, StringJoiner changeDescriptionParts) {
        super.a(baseline, current, changeDescriptionParts);
        StatusInfo.Status baselineStatus = DiffUtility.convertBaselineRefactoringStatus(baseline.getStatus());
        if (baselineStatus != ((RefactoringDefinition)current).getStatus()) {
            changeDescriptionParts.add("Status: " + baselineStatus.getPresentationName() + " -> " + ((RefactoringDefinition)current).getStatus().getPresentationName());
        }
        if (baseline.getNumberOfPotentiallyDoneElements() != ((RefactoringDefinition)current).getNumberOfPotentiallyDoneElements()) {
            changeDescriptionParts.add("Potentially done elements: " + baseline.getNumberOfPotentiallyDoneElements() + " -> " + ((RefactoringDefinition)current).getNumberOfPotentiallyDoneElements());
        }
        if (!baseline.getInformation().equals(((Resolution)current).getInformation())) {
            changeDescriptionParts.add("Information: " + baseline.getInformation() + " -> " + ((Resolution)current).getInformation());
        }
    }
}

