/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.controller.system.diff.r;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.integration.access.controller.g;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

abstract class b<B extends IIssue, C extends Issue>
extends com.hello2morrow.sonargraph.core.controller.system.diff.a
implements r<B, C> {
    private final Class<B> c;
    private final Class<C> d;
    private final Set<Issue> e;
    private final Map<NamedElement, String> f;
    private final Set<IIssue> g;

    public b(ISoftwareSystem baselineSystem, g baselineSystemInfoProcessor, Set<IIssue> allBaselineIssues, SoftwareSystem currentSystem, Set<Issue> allCurrentIssues, Map<NamedElement, String> namedElementToFqNameCache, Class<B> baselineIssueClass, Class<C> currentIssueClass) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem);
        this.g = allBaselineIssues;
        this.e = allCurrentIssues;
        this.f = namedElementToFqNameCache;
        this.c = baselineIssueClass;
        this.d = currentIssueClass;
    }

    @Override
    public final void a(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'process' must not be null";
        ArrayList<B> baselineIssues = new ArrayList<B>(this.a(this.b(), this.d()));
        ArrayList<C> currentIssues = new ArrayList<C>(this.a(this.e()));
        Collections.sort(baselineIssues, new g.a());
        Collections.sort(currentIssues, new a());
        this.a(parent, baselineIssues, currentIssues);
        this.g.removeAll(baselineIssues);
        this.e.removeAll(currentIssues);
    }

    protected final List<B> a(g systemInfoProcessor, Predicate<B> filter) {
        assert (systemInfoProcessor != null) : "Parameter 'systemInfoProcessor' of method 'getBaselineIssues' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'getBaselineIssues' must not be null";
        Set toleratedIssueCategoryNames = this.g().stream().map(cat -> cat.getStandardName()).collect(Collectors.toSet());
        Set ignoredIssueCategoryNames = this.f().stream().map(cat -> cat.getStandardName()).collect(Collectors.toSet());
        List baselineIssues = systemInfoProcessor.a(this.g, i2 -> {
            if (!this.c.isAssignableFrom(i2.getClass())) {
                return false;
            }
            IIssue baselineIssue = i2;
            if (!filter.test(baselineIssue)) {
                return false;
            }
            assert (this.c.isAssignableFrom(i2.getClass())) : "Filtering incomplete, unexpected baseline issue type detected: " + i2.getClass().getCanonicalName();
            String categoryName = baselineIssue.getIssueType().getCategory().getName();
            if (toleratedIssueCategoryNames.size() > 0 && !toleratedIssueCategoryNames.contains(categoryName)) {
                return false;
            }
            boolean tolerated = !ignoredIssueCategoryNames.contains(categoryName);
            return tolerated;
        });
        List matchingBaselineIssues = baselineIssues.stream().map(i2 -> i2).collect(Collectors.toList());
        return matchingBaselineIssues;
    }

    protected final List<C> a(Predicate<C> filter) {
        assert (filter != null) : "Parameter 'filter' of method 'getCurrentIssues' must not be null";
        List currentIssues = this.e.stream().filter(i2 -> {
            if (!this.d.isAssignableFrom(i2.getClass())) {
                return false;
            }
            Issue currentIssue = i2;
            if (!filter.test(currentIssue)) {
                return false;
            }
            assert (this.d.isAssignableFrom(i2.getClass())) : "Filtering incomplete, unexpected current issue type detected: " + i2.getClass().getCanonicalName();
            IssueCategory issueCategory = currentIssue.getId().getCategory();
            if (this.g().size() > 0 && !this.g().contains((Object)issueCategory)) {
                return false;
            }
            return !this.f().contains((Object)issueCategory);
        }).collect(Collectors.toList());
        List matchingCurrentIssues = currentIssues.stream().map(i2 -> i2).collect(Collectors.toList());
        return matchingCurrentIssues;
    }

    protected Predicate<B> d() {
        return i2 -> true;
    }

    protected Predicate<C> e() {
        return i2 -> true;
    }

    protected Set<IssueCategory> f() {
        return Collections.emptySet();
    }

    protected Set<IssueCategory> g() {
        return Collections.emptySet();
    }

    public final String b(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getOrCreateFqNameFromCachedElement' must not be null";
        String originalFqName = this.f.get(namedElement);
        if (originalFqName == null) {
            originalFqName = namedElement.getOriginalFullyQualifiedName();
            this.f.put(namedElement, originalFqName);
        }
        return originalFqName;
    }

    protected abstract void a(NamedElement var1, List<B> var2, List<C> var3);

    @Override
    public final Pair<IDiffElement.Change, String> a(B baselineIssue, C currentIssue) {
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'determineResolutionChange' must not be null";
        assert (currentIssue != null) : "Parameter 'currentIssue' of method 'determineResolutionChange' must not be null";
        com.hello2morrow.sonargraph.core.model.element.IResolution currentResolution = ((Issue)currentIssue).getResolution();
        if (!baselineIssue.hasResolution() && currentResolution == null) {
            return new Pair((Object)IDiffElement.Change.UNMODIFIED, (Object)"");
        }
        if (!baselineIssue.hasResolution() && currentResolution != null) {
            assert (currentResolution != null && currentResolution instanceof Resolution) : "Unexpected class in method 'determineResolutionChange': " + currentResolution;
            Resolution resolution = (Resolution)currentResolution;
            StringBuilder description = new StringBuilder("Resolution added: ");
            description.append(this.a(resolution.getKind().getPresentationName(), resolution.getPriority().getPresentationName(), resolution.getAssignee(), Iso8601DateFormat.formatDateAndTime((Date)resolution.getDate())));
            description.append(" ");
            return new Pair((Object)IDiffElement.Change.RESOLUTION_ADDED, (Object)description.toString());
        }
        IResolution baselineResolution = this.b().a(baselineIssue);
        String baselineType = baselineResolution.getType().getPresentationName();
        if (baselineIssue.hasResolution() && currentResolution == null) {
            StringBuilder description = new StringBuilder("Resolution removed: ");
            description.append(this.a(baselineType, baselineResolution.getPriority().getPresentationName(), baselineResolution.getAssignee(), baselineResolution.getDate()));
            description.append(" ");
            return new Pair((Object)IDiffElement.Change.RESOLUTION_REMOVED, (Object)description.toString());
        }
        if (baselineIssue.hasResolution() && currentResolution != null) {
            assert (currentResolution != null && currentResolution instanceof Resolution) : "Unexpected class in method 'determineResolutionChange': " + currentResolution;
            Resolution resolution = (Resolution)currentResolution;
            ResolutionKind baselineKind = IIssueDiff.convertResolutionType(baselineResolution.getType());
            if (baselineKind == resolution.getKind()) {
                return new Pair((Object)IDiffElement.Change.UNMODIFIED, (Object)"");
            }
            StringBuilder description = new StringBuilder("");
            description.append(baselineKind.getPresentationName());
            description.append(" -> ");
            description.append(resolution.getKind().getPresentationName());
            return new Pair((Object)IDiffElement.Change.MODIFIED, (Object)description.toString());
        }
        assert (false) : "Not expected to be reached. All cases should have been handled above for baselineResolution '" + baselineResolution + "', currentResolution '" + currentResolution + "'";
        return null;
    }

    protected String a(String kind, String priority, String assignee, String created) {
        StringBuilder description = new StringBuilder();
        description.append(kind);
        description.append(" [");
        description.append("Priority: ").append(priority).append(", ");
        if (!assignee.isEmpty()) {
            description.append("Assignee: ").append(assignee).append(", ");
        }
        description.append("Created: ").append(created);
        description.append("]");
        return description.toString();
    }

    protected static final class a
    implements Comparator<Issue> {
        public int a(Issue i1, Issue i2) {
            assert (i1 != null) : "Parameter 'i1' of method 'compare' must not be null";
            assert (i2 != null) : "Parameter 'i2' of method 'compare' must not be null";
            if (i1 == i2) {
                return 0;
            }
            int compared = Integer.compare(i1.getLineNumber(), i2.getLineNumber());
            if (compared == 0 && (compared = Integer.compare(i1.getColumn(), i2.getColumn())) == 0 && (compared = i1.getName().compareToIgnoreCase(i2.getName())) == 0) {
                compared = Integer.compare(i1.hashCode(), i2.hashCode());
            }
            return compared;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((Issue)object, (Issue)object2);
        }
    }
}

