/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SimplePropertyDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateBaselineConditionsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateCurrentConditionsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateElementDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGatesDiff;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractCurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentSystemConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.DiffAgainstBaselineConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.MetricValueDiffQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.Operator;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateDiffCheck;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilter;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGates;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueQualityGateCondition;
import com.hello2morrow.sonargraph.integration.access.controller.g;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ISystemFileElement;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGate;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGateElement;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGateExcludeFilter;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGateIssueCondition;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGateMetricDiffCondition;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGateThresholdIssueCondition;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGateThresholdIssueDiffCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class QualityGateDiffProcessor
extends com.hello2morrow.sonargraph.core.controller.system.diff.a {
    public QualityGateDiffProcessor(ISoftwareSystem baselineSystem, g baselineSystemInfoProcessor, SoftwareSystem currentSystem) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem);
    }

    @Override
    public void a(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'process' must not be null";
        LinkedHashMap<String, QualityGate> currentQualityGatesMap = new LinkedHashMap<String, QualityGate>();
        QualityGates qualityGatesDirectory = this.c().getUniqueExistingChild(Files.class).getQualityGatesDirectory();
        QualityGatesDiff qualityGatesDiff = new QualityGatesDiff(parent, qualityGatesDirectory);
        for (QualityGate nextCurrent : qualityGatesDirectory.getChildren(QualityGate.class)) {
            if (!nextCurrent.isChecked()) continue;
            currentQualityGatesMap.put(nextCurrent.getIdentifyingPath(), nextCurrent);
        }
        LinkedHashMap<String, IQualityGate> baselineQualityGatesMap = new LinkedHashMap<String, IQualityGate>();
        for (ISystemFileElement iSystemFileElement : this.b().v()) {
            if (!(iSystemFileElement instanceof IQualityGate)) continue;
            baselineQualityGatesMap.put(iSystemFileElement.getPath(), (IQualityGate)iSystemFileElement);
        }
        for (Map.Entry entry : currentQualityGatesMap.entrySet()) {
            IQualityGate baselineQualityGate = (IQualityGate)baselineQualityGatesMap.remove(entry.getKey());
            if (baselineQualityGate == null) {
                this.a(qualityGatesDiff, (QualityGate)entry.getValue());
                continue;
            }
            this.a((NamedElement)qualityGatesDiff, baselineQualityGate, (QualityGate)entry.getValue());
        }
        for (IQualityGate iQualityGate : baselineQualityGatesMap.values()) {
            this.a(qualityGatesDiff, iQualityGate);
        }
        parent.addChild(qualityGatesDiff);
    }

    private void a(QualityGatesDiff qualityGatesDiff, QualityGate current) {
        assert (qualityGatesDiff != null) : "Parameter 'qualityGatesDiff' of method 'processAdded' must not be null";
        assert (current != null) : "Parameter 'current' of method 'processAdded' must not be null";
        QualityGateDiff addedDiff = new QualityGateDiff((NamedElement)qualityGatesDiff, null, current, IDiffElement.Change.ADDED);
        CurrentSystemConditions currentConditions = current.getUniqueExistingChild(CurrentSystemConditions.class);
        QualityGateCurrentConditionsDiff currentConditionsDiff = new QualityGateCurrentConditionsDiff((NamedElement)addedDiff, currentConditions, currentConditions.getShortName(), currentConditions.getPresentationName(true), IDiffElement.Change.ADDED);
        for (AbstractCurrentIssueQualityGateCondition currentCondition : currentConditions.getChildren(AbstractCurrentIssueQualityGateCondition.class)) {
            QualityGateElementDiff currentDiff = new QualityGateElementDiff(currentConditionsDiff, null, currentCondition, IDiffElement.Change.ADDED, currentCondition.getImageResourceName());
            currentConditionsDiff.addChild(currentDiff);
        }
        for (QualityGateExcludeFilter nextExclude : currentConditions.getChildren(QualityGateExcludeFilter.class)) {
            QualityGateElementDiff filterDiff = new QualityGateElementDiff(currentConditionsDiff, null, nextExclude, IDiffElement.Change.ADDED, nextExclude.getImageResourceName());
            currentConditionsDiff.addChild(filterDiff);
        }
        addedDiff.addChild(currentConditionsDiff);
        DiffAgainstBaselineConditions baselineConditions = current.getUniqueExistingChild(DiffAgainstBaselineConditions.class);
        QualityGateBaselineConditionsDiff baselineConditionDiffs = new QualityGateBaselineConditionsDiff((NamedElement)addedDiff, baselineConditions, baselineConditions.getShortName(), baselineConditions.getPresentationName(true), IDiffElement.Change.ADDED);
        for (AbstractQualityGateElement baselineIssueCondition : baselineConditions.getChildren(AbstractQualityGateElement.class)) {
            if (baselineIssueCondition instanceof QualityGateExcludeFilter) continue;
            QualityGateElementDiff diff = new QualityGateElementDiff(baselineConditionDiffs, null, baselineIssueCondition, IDiffElement.Change.ADDED, baselineIssueCondition.getImageResourceName());
            baselineConditionDiffs.addChild(diff);
        }
        for (QualityGateExcludeFilter nextExclude : baselineConditions.getChildren(QualityGateExcludeFilter.class)) {
            QualityGateElementDiff filterDiff = new QualityGateElementDiff(baselineConditionDiffs, null, nextExclude, IDiffElement.Change.ADDED, nextExclude.getImageResourceName());
            baselineConditionDiffs.addChild(filterDiff);
        }
        addedDiff.addChild(baselineConditionDiffs);
        qualityGatesDiff.addChild(addedDiff);
    }

    private void a(NamedElement parent, IQualityGate baseline, QualityGate current) {
        assert (parent != null) : "Parameter 'parent' of method 'computeQualityGateDiff' must not be null";
        assert (baseline != null) : "Parameter 'baseline' of method 'computeQualityGateDiff' must not be null";
        assert (current != null) : "Parameter 'current' of method 'computeQualityGateDiff' must not be null";
        QualityGateDiff diff = new QualityGateDiff(parent, baseline, current, IDiffElement.Change.UNMODIFIED);
        Map<a, IQualityGateElement> baselineElements = this.a(baseline);
        Map<a, AbstractQualityGateElement> currentElements = this.b(current.getUniqueExistingChild(CurrentSystemConditions.class));
        CurrentSystemConditions currentSystemConditions = current.getUniqueExistingChild(CurrentSystemConditions.class);
        QualityGateCurrentConditionsDiff currentConditionsDiff = new QualityGateCurrentConditionsDiff((NamedElement)diff, currentSystemConditions, currentSystemConditions.getShortName(), currentSystemConditions.getPresentationName(true), null);
        this.a((NamedElement)currentConditionsDiff, baselineElements, currentElements);
        diff.addChild(currentConditionsDiff);
        Map<a, IQualityGateElement> baselineBaselineElements = this.b(baseline);
        Map<a, AbstractQualityGateElement> currentBaselineElements = this.c(current.getUniqueExistingChild(DiffAgainstBaselineConditions.class));
        DiffAgainstBaselineConditions baselineSystemConditions = current.getUniqueExistingChild(DiffAgainstBaselineConditions.class);
        QualityGateBaselineConditionsDiff baselineConditionsDiff = new QualityGateBaselineConditionsDiff((NamedElement)diff, baselineSystemConditions, baselineSystemConditions.getShortName(), baselineSystemConditions.getPresentationName(true), null);
        this.a((NamedElement)baselineConditionsDiff, baselineBaselineElements, currentBaselineElements);
        diff.addChild(baselineConditionsDiff);
        parent.addChild(diff);
    }

    private void a(NamedElement parentDiff, Map<a, IQualityGateElement> baselineElements, Map<a, AbstractQualityGateElement> currentElements) {
        assert (parentDiff != null) : "Parameter 'parentDiff' of method 'processConditionsOfModified' must not be null";
        assert (baselineElements != null) : "Parameter 'baselineElements' of method 'processConditionsOfModified' must not be null";
        assert (currentElements != null) : "Parameter 'currentElements' of method 'processConditionsOfModified' must not be null";
        ArrayList<a> exactMatches = new ArrayList<a>();
        for (Map.Entry<a, IQualityGateElement> nextBaselineEntry : baselineElements.entrySet()) {
            a baselineRecord = nextBaselineEntry.getKey();
            AbstractQualityGateElement currentElement = currentElements.remove(baselineRecord);
            if (currentElement == null) continue;
            QualityGateElementDiff elementDiff = new QualityGateElementDiff(parentDiff, nextBaselineEntry.getValue(), currentElement, IDiffElement.Change.UNMODIFIED, currentElement.getImageResourceName());
            parentDiff.addChild(elementDiff);
            exactMatches.add(baselineRecord);
        }
        exactMatches.forEach(match -> {
            Object v2 = baselineElements.remove(match);
        });
        ArrayList<QualityGateElementDiff> removedFilters = new ArrayList<QualityGateElementDiff>();
        ArrayList<QualityGateElementDiff> addedFilters = new ArrayList<QualityGateElementDiff>();
        HashSet<a> unmatchedCurrentElements = new HashSet<a>(currentElements.keySet());
        HashMap<b, List<b>> baselineRecordsToCurrentMatches = new HashMap<b, List<b>>();
        for (Map.Entry<a, IQualityGateElement> nextBaselineEntry : baselineElements.entrySet()) {
            a baselineRecord = nextBaselineEntry.getKey();
            ArrayList<b> currentRecordMatches = new ArrayList<b>();
            for (Map.Entry<a, AbstractQualityGateElement> nextCurrentEntry : currentElements.entrySet()) {
                int score;
                a currentRecord = nextCurrentEntry.getKey();
                if (!baselineRecord.e.equals(currentRecord.e) || (score = this.a(baselineRecord, currentRecord)) < 2) continue;
                b match2 = new b(baselineRecord, currentRecord, score);
                currentRecordMatches.add(match2);
                unmatchedCurrentElements.remove(currentRecord);
            }
            if (currentRecordMatches.isEmpty()) {
                QualityGateElementDiff diffCondition = new QualityGateElementDiff(parentDiff, nextBaselineEntry.getValue(), null, IDiffElement.Change.REMOVED, nextBaselineEntry.getValue().getImageResourceName());
                if (baselineRecord.b instanceof IQualityGateExcludeFilter) {
                    removedFilters.add(diffCondition);
                    continue;
                }
                parentDiff.addChild(diffCondition);
                continue;
            }
            currentRecordMatches.sort(new c());
            b bestMatch = (b)currentRecordMatches.remove(0);
            baselineRecordsToCurrentMatches.put(bestMatch, currentRecordMatches);
        }
        for (a nextUnmatched : unmatchedCurrentElements) {
            AbstractQualityGateElement unmatched = (AbstractQualityGateElement)nextUnmatched.b;
            QualityGateElementDiff diffCondition = new QualityGateElementDiff(parentDiff, null, unmatched, IDiffElement.Change.ADDED, unmatched.getImageResourceName());
            if (nextUnmatched.b instanceof QualityGateExcludeFilter) {
                addedFilters.add(diffCondition);
                continue;
            }
            parentDiff.addChild(diffCondition);
        }
        if (!baselineRecordsToCurrentMatches.isEmpty()) {
            HashSet<a> unmatchedCurrentRecords = new HashSet<a>(currentElements.keySet());
            unmatchedCurrentRecords.removeAll(unmatchedCurrentElements);
            StrictPair<Set<a>, Set<a>> unmatchedElements = this.a(parentDiff, baselineRecordsToCurrentMatches, unmatchedCurrentRecords);
            Set unmatchedBaselineConditions = (Set)unmatchedElements.getFirst();
            Set unmatchedCurrentConditions = (Set)unmatchedElements.getSecond();
            for (a nextRemoved : unmatchedBaselineConditions) {
                IQualityGateElement removed = (IQualityGateElement)nextRemoved.b;
                QualityGateElementDiff elementDiff = new QualityGateElementDiff(parentDiff, removed, null, IDiffElement.Change.REMOVED, removed.getImageResourceName());
                if (removed instanceof IQualityGateExcludeFilter) {
                    removedFilters.add(elementDiff);
                    continue;
                }
                parentDiff.addChild(elementDiff);
            }
            for (a nextAdded : unmatchedCurrentConditions) {
                AbstractQualityGateElement added = (AbstractQualityGateElement)nextAdded.b;
                QualityGateElementDiff elementDiff = new QualityGateElementDiff(parentDiff, null, added, IDiffElement.Change.ADDED, added.getImageResourceName());
                if (nextAdded.b instanceof IQualityGateExcludeFilter) {
                    addedFilters.add(elementDiff);
                    continue;
                }
                parentDiff.addChild(elementDiff);
            }
        }
        for (QualityGateElementDiff next : removedFilters) {
            parentDiff.addChild(next);
        }
        for (QualityGateElementDiff next : addedFilters) {
            parentDiff.addChild(next);
        }
    }

    private StrictPair<Set<a>, Set<a>> a(NamedElement parentDiff, Map<b, List<b>> bestMatchesToAlternatives, Set<a> unmatchedCurrentRecords) {
        assert (parentDiff != null) : "Parameter 'parentDiff' of method 'processMatches' must not be null";
        assert (bestMatchesToAlternatives != null && !bestMatchesToAlternatives.isEmpty()) : "Parameter 'bestMatchesToAlternatives' of method 'processMatches' must not be empty";
        assert (unmatchedCurrentRecords != null) : "Parameter 'unmatchedCurrentRecords' of method 'processMatches' must not be null";
        ArrayList<b> bestMatches = new ArrayList<b>(bestMatchesToAlternatives.keySet());
        bestMatches.sort(new c());
        HashSet<Object> processedCurrentConditions = new HashSet<Object>();
        HashSet<b> matchedBaselines = new HashSet<b>();
        LinkedHashSet<a> unmatchedBaselines = new LinkedHashSet<a>();
        LinkedHashSet unmatchedCurrent = new LinkedHashSet();
        boolean conflict = false;
        for (b nextBest : bestMatches) {
            List<b> alternatives = bestMatchesToAlternatives.remove(nextBest);
            if (processedCurrentConditions.contains(nextBest.c.b)) {
                if (alternatives.size() > 0) {
                    b newBestMatch = alternatives.remove(0);
                    bestMatchesToAlternatives.put(newBestMatch, alternatives);
                    conflict = true;
                    break;
                }
                unmatchedBaselines.add(nextBest.b);
                break;
            }
            this.a(parentDiff, nextBest);
            unmatchedCurrentRecords.remove(nextBest.c);
            bestMatchesToAlternatives.values().stream().forEach(matches -> {
                boolean bl2 = matches.remove(nextBest);
            });
            matchedBaselines.add(nextBest);
            processedCurrentConditions.add(nextBest.c.b);
        }
        if (bestMatchesToAlternatives.isEmpty()) {
            return new StrictPair(Collections.emptySet(), unmatchedCurrentRecords);
        }
        if (conflict) {
            StrictPair<Set<a>, Set<a>> recursiveResult = this.a(parentDiff, bestMatchesToAlternatives, unmatchedCurrentRecords);
            unmatchedBaselines.addAll((Collection)recursiveResult.getFirst());
            unmatchedCurrent.addAll((Collection)recursiveResult.getSecond());
        }
        return new StrictPair(unmatchedBaselines, unmatchedCurrent);
    }

    private void a(NamedElement parent, b match) {
        assert (parent != null) : "Parameter 'parent' of method 'createModifiedDiff' must not be null";
        assert (match != null) : "Parameter 'match' of method 'createModifiedDiff' must not be null";
        AbstractQualityGateElement current = (AbstractQualityGateElement)match.c.b;
        QualityGateElementDiff diff = new QualityGateElementDiff(parent, (IQualityGateElement)match.b.b, current, IDiffElement.Change.MODIFIED, current.getImageResourceName());
        Map<QualityGateProperty, String> baselineProps = match.b.c;
        Map<QualityGateProperty, String> currentProps = match.c.c;
        for (Map.Entry<QualityGateProperty, String> next : baselineProps.entrySet()) {
            SimplePropertyDiff propDiff;
            String currentValue = currentProps.get((Object)next.getKey());
            String baselineValue = next.getValue();
            if (!next.getValue().equals(currentValue)) {
                propDiff = new SimplePropertyDiff(diff, next.getKey().getStandardName(), next.getKey().getPresentationName(), baselineValue, currentValue, IDiffElement.Change.MODIFIED);
                diff.addChild(propDiff);
                continue;
            }
            propDiff = new SimplePropertyDiff(diff, next.getKey().getStandardName(), next.getKey().getPresentationName(), baselineValue, currentValue, IDiffElement.Change.UNMODIFIED);
            diff.addChild(propDiff);
        }
        parent.addChild(diff);
        QualityGateElementDiff firstFilter = parent.getFirstChild(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (namedElement instanceof QualityGateElementDiff) {
                    return ((QualityGateElementDiff)namedElement).getCurrent() instanceof QualityGateExcludeFilter;
                }
                return false;
            }
        }, QualityGateElementDiff.class);
        if (firstFilter != null && !(current instanceof QualityGateExcludeFilter)) {
            parent.moveChild(QualityGateElementDiff.class, diff, parent.getIndexOf(QualityGateElementDiff.class, firstFilter));
        }
    }

    private int a(a baseline, a current) {
        int score = 0;
        for (Map.Entry<QualityGateProperty, String> next : baseline.c.entrySet()) {
            if (!next.getValue().equals(current.c.get((Object)next.getKey()))) continue;
            ++score;
            if (next.getKey() == QualityGateProperty.ISSUE_TYPE) {
                score += 3;
            }
            if (next.getKey() != QualityGateProperty.METRIC_ID) continue;
            score += 2;
        }
        return score;
    }

    private Map<a, IQualityGateElement> a(IQualityGate baseline) {
        a record;
        LinkedHashMap<a, IQualityGateElement> baselineRecords = new LinkedHashMap<a, IQualityGateElement>();
        for (IQualityGateIssueCondition nextCondition : baseline.getCurrentSystemConditions().getCurrentSystemConditions()) {
            record = this.a(nextCondition, nextCondition.getName(), nextCondition instanceof IQualityGateThresholdIssueCondition);
            baselineRecords.put(record, (IQualityGateElement)nextCondition);
        }
        for (IQualityGateExcludeFilter nextExcludeFilter : baseline.getCurrentSystemConditions().getExcludeFilters()) {
            record = this.a(nextExcludeFilter, nextExcludeFilter.getName());
            baselineRecords.put(record, (IQualityGateElement)nextExcludeFilter);
        }
        return baselineRecords;
    }

    private Map<a, IQualityGateElement> b(IQualityGate baseline) {
        a record;
        assert (baseline != null) : "Parameter 'baseline' of method 'computeBaselineBaselineRecords' must not be null";
        LinkedHashMap<a, IQualityGateElement> baselineRecords = new LinkedHashMap<a, IQualityGateElement>();
        for (IQualityGateElement nextCondition : baseline.getDiffAgainstBaselineConditions().getDiffConditions()) {
            record = nextCondition instanceof IQualityGateMetricDiffCondition ? this.a(nextCondition, nextCondition.getName()) : this.b(nextCondition, nextCondition.getName(), nextCondition instanceof IQualityGateThresholdIssueDiffCondition);
            baselineRecords.put(record, nextCondition);
        }
        for (IQualityGateExcludeFilter nextExcludeFilter : baseline.getDiffAgainstBaselineConditions().getExcludeFilters()) {
            record = this.a(nextExcludeFilter, nextExcludeFilter.getName());
            baselineRecords.put(record, (IQualityGateElement)nextExcludeFilter);
        }
        return baselineRecords;
    }

    private a a(IQualityGateExcludeFilter excludeFilter, String filterName) {
        String[] nameParts = this.a(filterName);
        int index = 0;
        String conditionType = nameParts[index++];
        LinkedHashMap<QualityGateProperty, String> properties = new LinkedHashMap<QualityGateProperty, String>();
        properties.put(QualityGateProperty.ISSUE_TYPE, nameParts[index++]);
        properties.put(QualityGateProperty.SEVERITY, nameParts[index++]);
        properties.put(QualityGateProperty.RESOLUTION, nameParts[index++]);
        if (nameParts.length > index) {
            String metricId = nameParts[index++];
            properties.put(QualityGateProperty.METRIC_ID, metricId);
        }
        a record = new a(excludeFilter, conditionType, excludeFilter.getName(), properties);
        return record;
    }

    private a a(Object condition, String conditionName, boolean isThresholdCondition) {
        String[] nameParts = this.a(conditionName);
        int index = 0;
        String conditionType = nameParts[index++];
        LinkedHashMap<QualityGateProperty, String> properties = new LinkedHashMap<QualityGateProperty, String>();
        properties.put(QualityGateProperty.ISSUE_TYPE, nameParts[index++]);
        properties.put(QualityGateProperty.SEVERITY, nameParts[index++]);
        properties.put(QualityGateProperty.RESOLUTION, nameParts[index++]);
        if (isThresholdCondition) {
            String metricId = nameParts[index++];
            properties.put(QualityGateProperty.METRIC_ID, metricId);
        }
        String operator = Operator.fromStandardName(nameParts[index++]).getPresentationName();
        properties.put(QualityGateProperty.OPERATOR, operator);
        properties.put(QualityGateProperty.LIMIT, nameParts[index++]);
        return new a(condition, conditionType, conditionName, properties);
    }

    private a b(Object condition, String conditionName, boolean isThresholdCondition) {
        assert (condition != null) : "Parameter 'condition' of method 'createBaselineIssueConditionRecordOfBaseline' must not be null";
        assert (conditionName != null && conditionName.length() > 0) : "Parameter 'conditionName' of method 'createBaselineIssueConditionRecordOfBaseline' must not be empty";
        String[] nameParts = this.a(conditionName);
        int index = 0;
        String conditionType = nameParts[index++];
        LinkedHashMap<QualityGateProperty, String> properties = new LinkedHashMap<QualityGateProperty, String>();
        properties.put(QualityGateProperty.ISSUE_TYPE, nameParts[index++]);
        properties.put(QualityGateProperty.SEVERITY, nameParts[index++]);
        properties.put(QualityGateProperty.RESOLUTION, nameParts[index++]);
        if (isThresholdCondition) {
            String metricId = nameParts[index++];
            properties.put(QualityGateProperty.METRIC_ID, metricId);
            properties.put(QualityGateProperty.OPERATOR, Operator.fromStandardName(nameParts[index++]).getPresentationName());
            properties.put(QualityGateProperty.DIFF_THRESHOLD_ABSOLUTE, this.b(nameParts[index++]));
            properties.put(QualityGateProperty.DIFF_THRESHOLD_RELATIVE, this.b(nameParts[index++]));
        }
        if (nameParts.length > index) {
            String check = QualityGateDiffCheck.fromStandardName(nameParts[index++]).getPresentationName();
            properties.put(QualityGateProperty.CHECK, check);
        }
        return new a(condition, conditionType, conditionName, properties);
    }

    private String[] a(String conditionName) {
        assert (conditionName != null) : "Parameter 'conditionName' of method 'splitConditionIntoParts' must not be null";
        return conditionName.split("\\" + AbstractQualityGateElement.INNER_NAME_PARTS_SEPARATOR);
    }

    private Map<a, AbstractQualityGateElement> b(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'computeCurrentRecords' must not be null";
        LinkedHashMap<a, AbstractQualityGateElement> currentRecords = new LinkedHashMap<a, AbstractQualityGateElement>();
        for (AbstractCurrentIssueQualityGateCondition nextCondition : parent.getChildren(AbstractCurrentIssueQualityGateCondition.class)) {
            boolean isThresholdCondition = nextCondition instanceof ThresholdIssueQualityGateCondition;
            String conditionName = nextCondition.getName();
            a record = this.c(nextCondition, conditionName, isThresholdCondition);
            currentRecords.put(record, nextCondition);
        }
        for (QualityGateExcludeFilter nextExcludeFilter : parent.getChildren(QualityGateExcludeFilter.class)) {
            String excludeFilterName = nextExcludeFilter.getName();
            a record = this.b(nextExcludeFilter, excludeFilterName);
            currentRecords.put(record, nextExcludeFilter);
        }
        return currentRecords;
    }

    private Map<a, AbstractQualityGateElement> c(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'computeCurrentRecords' must not be null";
        LinkedHashMap<a, AbstractQualityGateElement> currentRecords = new LinkedHashMap<a, AbstractQualityGateElement>();
        for (AbstractIssueDiffAgainstBaselineCondition abstractIssueDiffAgainstBaselineCondition : parent.getChildren(AbstractIssueDiffAgainstBaselineCondition.class)) {
            boolean isThresholdCondition = abstractIssueDiffAgainstBaselineCondition instanceof ThresholdIssueDiffAgainstBaselineCondition;
            a record = this.b(abstractIssueDiffAgainstBaselineCondition, abstractIssueDiffAgainstBaselineCondition.getName(), isThresholdCondition);
            currentRecords.put(record, abstractIssueDiffAgainstBaselineCondition);
        }
        for (MetricValueDiffQualityGateCondition metricValueDiffQualityGateCondition : parent.getChildren(MetricValueDiffQualityGateCondition.class)) {
            a record = this.a((Object)metricValueDiffQualityGateCondition, metricValueDiffQualityGateCondition.getName());
            currentRecords.put(record, metricValueDiffQualityGateCondition);
        }
        for (QualityGateExcludeFilter qualityGateExcludeFilter : parent.getChildren(QualityGateExcludeFilter.class)) {
            a record = this.b(qualityGateExcludeFilter, qualityGateExcludeFilter.getName());
            currentRecords.put(record, qualityGateExcludeFilter);
        }
        return currentRecords;
    }

    private a a(Object condition, String conditionName) {
        assert (condition != null) : "Parameter 'condition' of method 'createBaselineMetricConditionRecordOfBaseline' must not be null";
        assert (conditionName != null && conditionName.length() > 0) : "Parameter 'conditionName' of method 'createBaselineMetricConditionRecordOfBaseline' must not be empty";
        String[] nameParts = this.a(conditionName);
        int index = 0;
        String conditionType = nameParts[index++];
        LinkedHashMap<QualityGateProperty, String> properties = new LinkedHashMap<QualityGateProperty, String>();
        properties.put(QualityGateProperty.METRIC_ID, nameParts[index++]);
        properties.put(QualityGateProperty.OPERATOR, Operator.fromStandardName(nameParts[index++]).getPresentationName());
        properties.put(QualityGateProperty.DIFF_THRESHOLD_ABSOLUTE, this.b(nameParts[index++]));
        properties.put(QualityGateProperty.DIFF_THRESHOLD_RELATIVE, this.b(nameParts[index++]));
        return new a(condition, conditionType, conditionName, properties);
    }

    private String b(String value) {
        assert (value != null) : "Parameter 'value' of method 'convertNumberProperty' must not be null";
        if (value.equals("n/a")) {
            return value;
        }
        Number number = NumberUtility.parseLocaleIndependently((String)value, (boolean)false);
        if (number == null) {
            return value;
        }
        return NumberUtility.format((Number)number, (boolean)false);
    }

    private a c(Object condition, String conditionName, boolean isThresholdCondition) {
        assert (condition != null) : "Parameter 'condition' of method 'createCurrentConditionRecord' must not be null";
        assert (conditionName != null && conditionName.length() > 0) : "Parameter 'conditionName' of method 'createCurrentConditionRecord' must not be empty";
        String[] nameParts = this.a(conditionName);
        int index = 0;
        String conditionType = nameParts[index++];
        LinkedHashMap<QualityGateProperty, String> properties = new LinkedHashMap<QualityGateProperty, String>();
        properties.put(QualityGateProperty.ISSUE_TYPE, nameParts[index++]);
        properties.put(QualityGateProperty.SEVERITY, nameParts[index++]);
        properties.put(QualityGateProperty.RESOLUTION, nameParts[index++]);
        if (isThresholdCondition) {
            String metricId = nameParts[index++];
            properties.put(QualityGateProperty.METRIC_ID, metricId);
        }
        String operator = Operator.fromStandardName(nameParts[index++]).getPresentationName();
        properties.put(QualityGateProperty.OPERATOR, operator);
        properties.put(QualityGateProperty.LIMIT, nameParts[index++]);
        a record = new a(condition, conditionType, conditionName, properties);
        return record;
    }

    private a b(Object excludeFilter, String excludeFilterName) {
        assert (excludeFilter != null) : "Parameter 'excludeFilter' of method 'createExcludeFilter' must not be null";
        assert (excludeFilterName != null && excludeFilterName.length() > 0) : "Parameter 'excludeFilterName' of method 'createExcludeFilter' must not be empty";
        String[] nameParts = this.a(excludeFilterName);
        int index = 0;
        String conditionType = nameParts[index++];
        HashMap<QualityGateProperty, String> properties = new HashMap<QualityGateProperty, String>();
        properties.put(QualityGateProperty.ISSUE_TYPE, nameParts[index++]);
        properties.put(QualityGateProperty.SEVERITY, nameParts[index++]);
        properties.put(QualityGateProperty.RESOLUTION, nameParts[index++]);
        if (nameParts.length > index) {
            String metricId = nameParts[index++];
            properties.put(QualityGateProperty.METRIC_ID, metricId);
        }
        a record = new a(excludeFilter, conditionType, excludeFilterName, properties);
        return record;
    }

    private void a(QualityGatesDiff qualityGatesDiff, IQualityGate baseline) {
        assert (qualityGatesDiff != null) : "Parameter 'qualityGatesDiff' of method 'processRemoved' must not be null";
        assert (baseline != null) : "Parameter 'baseline' of method 'processRemoved' must not be null";
        QualityGateDiff removedDiff = new QualityGateDiff((NamedElement)qualityGatesDiff, baseline, null, IDiffElement.Change.REMOVED);
        QualityGateCurrentConditionsDiff currentConditionsDiff = new QualityGateCurrentConditionsDiff((NamedElement)removedDiff, null, QualityGateCurrentConditionsDiff.getShortNameString(), QualityGateCurrentConditionsDiff.getPresentationNameString(true), IDiffElement.Change.REMOVED);
        for (IQualityGateIssueCondition currentCondition : baseline.getCurrentSystemConditions().getCurrentSystemConditions()) {
            QualityGateElementDiff currentDiff = new QualityGateElementDiff(currentConditionsDiff, (IQualityGateElement)currentCondition, null, IDiffElement.Change.REMOVED, currentCondition.getImageResourceName());
            currentConditionsDiff.addChild(currentDiff);
        }
        for (IQualityGateExcludeFilter nextExclude : baseline.getCurrentSystemConditions().getExcludeFilters()) {
            QualityGateElementDiff filterDiff = new QualityGateElementDiff(currentConditionsDiff, (IQualityGateElement)nextExclude, null, IDiffElement.Change.REMOVED, nextExclude.getImageResourceName());
            currentConditionsDiff.addChild(filterDiff);
        }
        removedDiff.addChild(currentConditionsDiff);
        QualityGateBaselineConditionsDiff baselineConditionDiffs = new QualityGateBaselineConditionsDiff((NamedElement)removedDiff, null, QualityGateBaselineConditionsDiff.getShortNameString(), QualityGateBaselineConditionsDiff.getPresentationNameString(false), IDiffElement.Change.REMOVED);
        for (IQualityGateElement baselineCondition : baseline.getDiffAgainstBaselineConditions().getDiffConditions()) {
            QualityGateElementDiff diff = new QualityGateElementDiff(baselineConditionDiffs, baselineCondition, null, IDiffElement.Change.REMOVED, baselineCondition.getImageResourceName());
            baselineConditionDiffs.addChild(diff);
        }
        for (IQualityGateExcludeFilter nextExclude : baseline.getDiffAgainstBaselineConditions().getExcludeFilters()) {
            QualityGateElementDiff filterDiff = new QualityGateElementDiff(baselineConditionDiffs, (IQualityGateElement)nextExclude, null, IDiffElement.Change.REMOVED, nextExclude.getImageResourceName());
            baselineConditionDiffs.addChild(filterDiff);
        }
        removedDiff.addChild(baselineConditionDiffs);
        qualityGatesDiff.addChild(removedDiff);
    }

    private static class a {
        private final Object b;
        private final Map<QualityGateProperty, String> c;
        private final String d;
        private final String e;

        public a(Object element, String type, String conditionText, Map<QualityGateProperty, String> properties) {
            assert (element != null) : "Parameter 'element' of method 'QualityGateElementRecord' must not be null";
            assert (type != null && type.length() > 0) : "Parameter 'type' of method 'QualityGateElementRecord' must not be empty";
            assert (conditionText != null && conditionText.length() > 0) : "Parameter 'conditionText' of method 'QualityGateConditionRecord' must not be empty";
            assert (properties != null && !properties.isEmpty()) : "Parameter 'properties' of method 'QualityGateConditionRecord' must not be empty";
            this.b = element;
            this.e = type;
            this.d = conditionText;
            this.c = properties;
        }

        public String toString() {
            return this.d;
        }

        public int hashCode() {
            return Objects.hash(this.d, this.c, this.e);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            a other = (a)obj;
            return Objects.equals(this.d, other.d) && Objects.equals(this.c, other.c) && Objects.equals(this.e, other.e);
        }
    }

    private static enum QualityGateProperty implements IStandardEnumeration
    {
        ISSUE_TYPE("Issue Type"),
        SEVERITY("Severity"),
        RESOLUTION("Resolution"),
        METRIC_ID("Metric Id"),
        OPERATOR("Operator"),
        LIMIT("Limit"),
        DIFF_THRESHOLD_ABSOLUTE("Absolute Threshold"),
        DIFF_THRESHOLD_RELATIVE("Relative Threshold"),
        CHECK("Check");

        private final String m_presentationName;

        private QualityGateProperty(String presentationName) {
            this.m_presentationName = presentationName;
        }

        public String getPresentationName() {
            return this.m_presentationName;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }
    }

    private static class b {
        private final a b;
        private final a c;
        private final int d;

        public b(a baseline, a current, int score) {
            assert (baseline != null) : "Parameter 'baseline' of method 'RecordMatch' must not be null";
            assert (current != null) : "Parameter 'current' of method 'RecordMatch' must not be null";
            this.b = baseline;
            this.c = current;
            this.d = score;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RecordMatch [m_baseline=");
            builder.append(this.b);
            builder.append(", m_current=");
            builder.append(this.c);
            builder.append(", m_score=");
            builder.append(this.d);
            builder.append("]");
            return builder.toString();
        }
    }

    private static class c
    implements Comparator<b> {
        private c() {
        }

        public int a(b o1, b o2) {
            return Integer.compare(o2.d, o1.d);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((b)object, (b)object2);
        }
    }
}

